/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class SwampTreeMutated
extends AbstractTreeFeature<TreeFeatureConfig> {
    private static final BlockState TRUNK = Blocks.field_196617_K.func_176223_P();
    private static final BlockState LEAF = Blocks.field_196642_W.func_176223_P();

    public SwampTreeMutated(Function<Dynamic<?>, ? extends TreeFeatureConfig> p_i225808_1_) {
        super(p_i225808_1_);
    }

    public boolean func_225557_a_(IWorldGenerationReader worldIn, Random rand, BlockPos position, Set<BlockPos> p_225557_4_, Set<BlockPos> p_225557_5_, MutableBoundingBox boundingBox, TreeFeatureConfig p_225557_7_) {
        int height = rand.nextInt(4) + 6;
        IWorld world = (IWorld)worldIn;
        if (!this.isSpaceAt((IWorldGenerationBaseReader)worldIn, position, height)) {
            return false;
        }
        while (world.func_180495_p(position.func_177977_b()).func_185904_a() == Material.field_151586_h) {
            position = position.func_177977_b();
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            int x;
            for (int y = position.func_177956_o(); y <= position.func_177956_o() + 1 + height; ++y) {
                int k = 1;
                if (y == position.func_177956_o()) {
                    k = 0;
                }
                if (y >= position.func_177956_o() + 1 + height - 2) {
                    k = 3;
                }
                BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
                for (x = position.func_177958_n() - k; x <= position.func_177958_n() + k && flag; ++x) {
                    for (int z = position.func_177952_p() - k; z <= position.func_177952_p() + k && flag; ++z) {
                        if (y >= 0 && y < 256) {
                            blockpos$Mutable.func_181079_c(x, y, z);
                            if (SwampTreeMutated.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$Mutable)) continue;
                            if (SwampTreeMutated.func_214571_e((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$Mutable)) {
                                flag = false;
                                continue;
                            }
                            if (y <= position.func_177956_o()) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (SwampTreeMutated.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)p_225557_7_.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - height - 1) {
                int z;
                int heightDiff;
                int currentHeight;
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                for (currentHeight = position.func_177956_o() - 4 + height; currentHeight <= position.func_177956_o() + height; ++currentHeight) {
                    heightDiff = currentHeight - (position.func_177956_o() + height);
                    int l2 = 2 - heightDiff / 2;
                    for (x = position.func_177958_n() - l2 - 1; x <= position.func_177958_n() + l2; ++x) {
                        int xPos = x - position.func_177958_n();
                        for (z = position.func_177952_p() - l2 - 1; z <= position.func_177952_p() + l2; ++z) {
                            BlockPos blockpos;
                            int zPos = z - position.func_177952_p();
                            int isCornerIfThisIsTwo = 0;
                            if (xPos == l2) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (zPos == l2) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (xPos == -l2 - 1) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (zPos == -l2 - 1) {
                                ++isCornerIfThisIsTwo;
                            }
                            if (isCornerIfThisIsTwo != 2 && (rand.nextInt(3) >= 2 || heightDiff == 0) || !SwampTreeMutated.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)(blockpos = new BlockPos(x, currentHeight, z))) && !SwampTreeMutated.func_214576_j((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) continue;
                            this.func_202278_a((IWorldWriter)worldIn, blockpos, LEAF);
                        }
                    }
                }
                this.genTrunk(world, position, height);
                this.genTrunk(world, position.func_177976_e(), height);
                this.genTrunk(world, position.func_177978_c(), height);
                this.genTrunk(world, position.func_177976_e().func_177978_c(), height);
                for (currentHeight = position.func_177956_o() - 3 + height; currentHeight <= position.func_177956_o() + height; ++currentHeight) {
                    heightDiff = currentHeight - (position.func_177956_o() + height);
                    int i3 = 2 - heightDiff / 2;
                    BlockPos.Mutable blockpos$Mutable1 = new BlockPos.Mutable();
                    for (int x2 = position.func_177958_n() - i3 - 1; x2 <= position.func_177958_n() + i3; ++x2) {
                        for (z = position.func_177952_p() - i3 - 1; z <= position.func_177952_p() + i3; ++z) {
                            blockpos$Mutable1.func_181079_c(x2, currentHeight, z);
                            if (world.func_180495_p((BlockPos)blockpos$Mutable1).func_185904_a() != Material.field_151584_j) continue;
                            BlockPos blockpos3 = blockpos$Mutable1.func_177976_e();
                            BlockPos blockpos4 = blockpos$Mutable1.func_177974_f();
                            BlockPos blockpos1 = blockpos$Mutable1.func_177978_c();
                            BlockPos blockpos2 = blockpos$Mutable1.func_177968_d();
                            if (rand.nextInt(4) == 0 && world.func_175623_d(blockpos3)) {
                                this.addVine(world, blockpos3, VineBlock.field_176278_M);
                            }
                            if (rand.nextInt(4) == 0 && world.func_175623_d(blockpos4)) {
                                this.addVine(world, blockpos4, VineBlock.field_176280_O);
                            }
                            if (rand.nextInt(4) == 0 && world.func_175623_d(blockpos1)) {
                                this.addVine(world, blockpos1, VineBlock.field_176279_N);
                            }
                            if (rand.nextInt(4) != 0 || !world.func_175623_d(blockpos2)) continue;
                            this.addVine(world, blockpos2, VineBlock.field_176273_b);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void addVine(IWorld worldIn, BlockPos pos, BooleanProperty prop) {
        BlockState iblockstate = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)prop, (Comparable)Boolean.valueOf(true));
        this.func_202278_a((IWorldWriter)worldIn, pos, iblockstate);
        BlockPos blockpos = pos.func_177977_b();
        for (int i = 4; worldIn.func_175623_d(blockpos) && i > 0; --i) {
            this.func_202278_a((IWorldWriter)worldIn, blockpos, iblockstate);
            blockpos = blockpos.func_177977_b();
        }
    }

    private void genTrunk(IWorld worldIn, BlockPos position, int height) {
        for (int currentHeight = 0; currentHeight < height; ++currentHeight) {
            BlockPos upN = position.func_177981_b(currentHeight);
            BlockState iblockstate1 = worldIn.func_180495_p(upN);
            Block block2 = iblockstate1.func_177230_c();
            if (currentHeight != height - 1 && (block2.isAir(iblockstate1, (IBlockReader)worldIn, upN) || iblockstate1.func_203425_a(BlockTags.field_206952_E) || block2 == Blocks.field_150355_j || block2 == Blocks.field_196651_dG)) {
                this.func_202278_a((IWorldWriter)worldIn, upN, TRUNK);
                continue;
            }
            this.func_202278_a((IWorldWriter)worldIn, upN, LEAF);
        }
    }

    private boolean isSpaceAt(IWorldGenerationBaseReader worldIn, BlockPos leavesPos, int height) {
        boolean flag = true;
        if (leavesPos.func_177956_o() >= 1 && leavesPos.func_177956_o() + height + 1 <= worldIn.getMaxHeight()) {
            for (int i = 0; i <= 1 + height; ++i) {
                int j = 2;
                if (i == 0) {
                    j = 1;
                } else if (i >= 1 + height - 2) {
                    j = 2;
                }
                for (int k = -j; k <= j && flag; ++k) {
                    for (int l = -j; l <= j && flag; ++l) {
                        if (leavesPos.func_177956_o() + i >= 0 && leavesPos.func_177956_o() + i < worldIn.getMaxHeight() && SwampTreeMutated.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)leavesPos.func_177982_a(k, i, l))) continue;
                        flag = false;
                    }
                }
            }
            return flag;
        }
        return false;
    }
}

