/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.carver;

import com.mojang.datafixers.Dynamic;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.telepathicgrunt.ultraamplified.world.biome.BiomeInit;

public class ContainUndergroundLiquids
extends Feature<NoFeatureConfig> {
    protected BlockState replacementBlock = Blocks.field_150348_b.func_176223_P();
    protected static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static Map<Biome, BlockState> fillerBiomeMap;

    public ContainUndergroundLiquids(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public void setFillerMap() {
        if (fillerBiomeMap == null) {
            fillerBiomeMap = new HashMap<Biome, BlockState>();
            fillerBiomeMap.put(BiomeInit.NETHERLAND, Blocks.field_150424_aL.func_176223_P());
            fillerBiomeMap.put(BiomeInit.ICED_TERRAIN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(BiomeInit.ICE_SPIKES, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(BiomeInit.DEEP_FROZEN_OCEAN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(BiomeInit.FROZEN_OCEAN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(BiomeInit.BARREN_END_FIELD, Blocks.field_150377_bs.func_176223_P());
            fillerBiomeMap.put(BiomeInit.END_FIELD, Blocks.field_150377_bs.func_176223_P());
        }
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> chunkSettings, Random random, BlockPos pos, NoFeatureConfig configBlock) {
        this.setFillerMap();
        pos.func_177979_c(pos.func_177956_o());
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(pos);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 61; y >= 10; --y) {
                    blockpos$Mutable.func_181079_c(pos.func_177958_n() + x, 0, pos.func_177952_p() + z);
                    BlockState currentblock = worldIn.func_180495_p(blockpos$Mutable.func_177981_b(y));
                    while (currentblock != Blocks.field_150350_a.func_176223_P() && y > 11) {
                        currentblock = worldIn.func_180495_p(blockpos$Mutable.func_177981_b(--y));
                    }
                    if (y <= 11 && currentblock != Blocks.field_150350_a.func_176223_P()) continue;
                    blockpos$Mutable.func_181079_c(pos.func_177958_n() + x, y, pos.func_177952_p() + z);
                    boolean notContainedFlag = false;
                    for (Direction face : Direction.Plane.HORIZONTAL) {
                        currentblock = worldIn.func_180495_p(blockpos$Mutable.func_177972_a(face));
                        if (currentblock.func_204520_s().func_206888_e()) continue;
                        notContainedFlag = true;
                    }
                    currentblock = worldIn.func_180495_p(blockpos$Mutable.func_177984_a());
                    if (!currentblock.func_204520_s().func_206888_e()) {
                        notContainedFlag = true;
                    }
                    currentblock = worldIn.func_180495_p(blockpos$Mutable.func_177977_b());
                    if (blockpos$Mutable.func_177977_b().func_177956_o() > 10 && !currentblock.func_204520_s().func_206888_e()) {
                        notContainedFlag = true;
                    }
                    if (!notContainedFlag) continue;
                    this.replacementBlock = fillerBiomeMap.get(worldIn.func_226691_t_((BlockPos)blockpos$Mutable));
                    if (this.replacementBlock == null) {
                        this.replacementBlock = STONE;
                    }
                    worldIn.func_180501_a((BlockPos)blockpos$Mutable, this.replacementBlock, 2);
                }
            }
        }
        return true;
    }
}

