/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.carver;

import com.mojang.datafixers.Dynamic;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.biome.BiomeInit;

public class SuperLongRavineCarver
extends WorldCarver<ProbabilityConfig> {
    private final float[] field_202536_i = new float[1024];
    protected static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    protected static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final BlockState LAVA = Blocks.field_150353_l.func_176223_P();
    protected BlockState fillerBlock = Blocks.field_150348_b.func_176223_P();
    private static Map<BlockState, BlockState> canReplaceMap = SuperLongRavineCarver.createMap();
    private static Map<Biome, BlockState> fillerBiomeMap;

    public SuperLongRavineCarver(Function<Dynamic<?>, ? extends ProbabilityConfig> p_i49921_1_, int p_i49921_2_) {
        super(p_i49921_1_, p_i49921_2_);
    }

    private static final Map<BlockState, BlockState> createMap() {
        HashMap<BlockState, BlockState> result = new HashMap<BlockState, BlockState>();
        result.put(Blocks.field_150424_aL.func_176223_P(), Blocks.field_150424_aL.func_176223_P());
        result.put(Blocks.field_150432_aD.func_176223_P(), Blocks.field_150432_aD.func_176223_P());
        result.put(Blocks.field_196604_cC.func_176223_P(), Blocks.field_150432_aD.func_176223_P());
        result.put(Blocks.field_150377_bs.func_176223_P(), Blocks.field_150377_bs.func_176223_P());
        return Collections.unmodifiableMap(result);
    }

    public static void setFillerMap() {
        if (fillerBiomeMap == null) {
            fillerBiomeMap = new HashMap<Biome, BlockState>();
            fillerBiomeMap.put(BiomeInit.NETHERLAND, Blocks.field_150424_aL.func_176223_P());
            fillerBiomeMap.put(BiomeInit.ICED_TERRAIN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(BiomeInit.ICE_SPIKES, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(BiomeInit.DEEP_FROZEN_OCEAN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(BiomeInit.FROZEN_OCEAN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(BiomeInit.BARREN_END_FIELD, Blocks.field_150377_bs.func_176223_P());
            fillerBiomeMap.put(BiomeInit.END_FIELD, Blocks.field_150377_bs.func_176223_P());
        }
    }

    public boolean shouldCarve(Random p_212246_2_, int chunkX, int chunkZ, ProbabilityConfig config) {
        return p_212246_2_.nextFloat() <= (float)ConfigUA.ravineSpawnrate / 850.0f;
    }

    public boolean func_225555_a_(IChunk region, Function<BlockPos, Biome> biomeBlockPos, Random random, int seaLevel, int chunkX, int chunkZ, int originalX, int originalZ, BitSet mask, ProbabilityConfig config) {
        int i = (this.func_222704_c() * 2 - 1) * 16;
        double xpos = chunkX * 16 + random.nextInt(16);
        double height = random.nextInt(random.nextInt(4) + 3) + 17;
        double zpos = chunkZ * 16 + random.nextInt(16);
        float f = random.nextFloat() * ((float)Math.PI * 2);
        float f1 = (random.nextFloat() - 0.5f) / 8.0f;
        float f2 = (random.nextFloat() * 1.3f + random.nextFloat()) * 1.3f;
        int j = i + 12;
        this.func_202535_a(region, biomeBlockPos, random.nextLong(), originalX, originalZ, xpos, height, zpos, f2, f, f1, 0, j, random.nextDouble() / 2.0 + 0.9, mask);
        return true;
    }

    private void func_202535_a(IChunk worldIn, Function<BlockPos, Biome> biomeBlockPos, long randomSeed, int mainChunkX, int mainChunkZ, double randomBlockX, double randomBlockY, double randomBlockZ, float p_202535_12_, float p_202535_13_, float p_202535_14_, int p_202535_15_, int p_202535_16_, double heightMultiplier, BitSet mask) {
        Random random = new Random(randomSeed);
        float f = 1.0f;
        for (int i = 0; i < 256; ++i) {
            if (i == 0 || random.nextInt(3) == 0) {
                f = 1.0f + random.nextFloat() * random.nextFloat();
            }
            this.field_202536_i[i] = f * f;
        }
        float f4 = 0.0f;
        float f1 = 0.0f;
        for (int j = p_202535_15_; j < p_202535_16_; ++j) {
            double placementXZBound = 6.0 + (double)(MathHelper.func_76126_a((float)((float)j * (float)Math.PI / (float)p_202535_16_)) * p_202535_12_);
            double placementYBound = placementXZBound * heightMultiplier;
            placementXZBound *= (double)random.nextFloat() * 0.1 + 0.4;
            placementYBound *= 0.8;
            float f2 = MathHelper.func_76134_b((float)p_202535_14_);
            randomBlockX += (double)(MathHelper.func_76134_b((float)p_202535_13_) * f2);
            randomBlockZ += (double)(MathHelper.func_76126_a((float)p_202535_13_) * f2);
            p_202535_14_ *= 0.5f;
            p_202535_14_ += f1 * 0.03f;
            p_202535_13_ += f4 * 0.1f;
            f1 *= 0.8f;
            f4 *= 0.5f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 1.5f;
            f4 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 3.0f;
            if (random.nextInt(4) == 0) continue;
            if (!this.func_222702_a(mainChunkX, mainChunkZ, randomBlockX, randomBlockZ, j, p_202535_16_, p_202535_12_)) {
                return;
            }
            this.carveAtTarget(worldIn, biomeBlockPos, randomSeed, mainChunkX, mainChunkZ, randomBlockX, randomBlockY, randomBlockZ, placementXZBound, placementYBound, mask);
        }
    }

    protected boolean carveAtTarget(IChunk worldIn, Function<BlockPos, Biome> biomeBlockPos, long seed, int mainChunkX, int mainChunkZ, double xRange, double yRange, double zRange, double placementXZBound, double placementYBound, BitSet mask) {
        double d0 = mainChunkX * 16 + 8;
        double d1 = mainChunkZ * 16 + 8;
        if (!(xRange < d0 - 16.0 - placementXZBound * 2.0 || zRange < d1 - 16.0 - placementXZBound * 2.0 || xRange > d0 + 16.0 + placementXZBound * 2.0 || zRange > d1 + 16.0 + placementXZBound * 2.0)) {
            int i = Math.max(MathHelper.func_76128_c((double)(xRange - placementXZBound)) - mainChunkX * 16 - 1, 0);
            int j = Math.min(MathHelper.func_76128_c((double)(xRange + placementXZBound)) - mainChunkX * 16 + 1, 16);
            int k = Math.max(MathHelper.func_76128_c((double)(yRange - placementYBound)) - 1, 6);
            int l = Math.min(MathHelper.func_76128_c((double)(yRange + placementYBound)) + 1, this.field_222720_l);
            int i1 = Math.max(MathHelper.func_76128_c((double)(zRange - placementXZBound)) - mainChunkZ * 16 - 1, 0);
            int j1 = Math.min(MathHelper.func_76128_c((double)(zRange + placementXZBound)) - mainChunkZ * 16 + 1, 16);
            if (i <= j && k <= l && i1 <= j1) {
                boolean flag = false;
                BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
                BlockPos.Mutable blockpos$Mutableup = new BlockPos.Mutable();
                BlockPos.Mutable blockpos$Mutabledown = new BlockPos.Mutable();
                for (int k1 = i; k1 < j; ++k1) {
                    int x = k1 + mainChunkX * 16;
                    double xSquaringModified = ((double)x + 0.5 - xRange) / placementXZBound;
                    for (int i2 = i1; i2 < j1; ++i2) {
                        int z = i2 + mainChunkZ * 16;
                        double zSquaringModified = ((double)z + 0.5 - zRange) / placementXZBound;
                        double xzSquaredModified = xSquaringModified * xSquaringModified + zSquaringModified * zSquaringModified;
                        if (!(xzSquaredModified < 1.0)) continue;
                        blockpos$Mutable.func_181079_c(x, 60, z);
                        this.fillerBlock = fillerBiomeMap.get(biomeBlockPos.apply((BlockPos)blockpos$Mutable));
                        if (this.fillerBlock == null) {
                            this.fillerBlock = STONE;
                        }
                        for (int y = l; y > k; --y) {
                            double d4 = ((double)(y - 1) + 0.5 - yRange) / placementYBound;
                            if (!(xzSquaredModified * (double)this.field_202536_i[y - 1] + d4 * d4 / 6.0 < 1.0)) continue;
                            blockpos$Mutable.func_181079_c(x, y, z);
                            BlockState currentBlockstate = worldIn.func_180495_p((BlockPos)blockpos$Mutable);
                            blockpos$Mutableup.func_189533_g((Vec3i)blockpos$Mutable).func_189536_c(Direction.UP);
                            blockpos$Mutabledown.func_189533_g((Vec3i)blockpos$Mutable).func_189536_c(Direction.DOWN);
                            BlockState aboveBlockstate = worldIn.func_180495_p((BlockPos)blockpos$Mutableup);
                            if (!this.func_222707_a(currentBlockstate, aboveBlockstate) && !canReplaceMap.containsKey(currentBlockstate)) continue;
                            if (y - 1 < 10) {
                                worldIn.func_177436_a((BlockPos)blockpos$Mutable, LAVA.getBlockState(), false);
                            } else {
                                worldIn.func_177436_a((BlockPos)blockpos$Mutable, field_222714_f.getBlockState(), false);
                            }
                            flag = true;
                        }
                    }
                }
                return flag;
            }
            return false;
        }
        return false;
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return true;
    }
}

