/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.CaveWorldCarver;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.biome.BiomeInit;

public class UnderwaterCaveCarver
extends CaveWorldCarver {
    protected static final Set<BlockState> CARVABLE_BLOCKS = ImmutableSet.of((Object)Blocks.field_150348_b.func_176223_P(), (Object)Blocks.field_196650_c.func_176223_P(), (Object)Blocks.field_196654_e.func_176223_P(), (Object)Blocks.field_196656_g.func_176223_P(), (Object)Blocks.field_150346_d.func_176223_P(), (Object)Blocks.field_196660_k.func_176223_P(), (Object[])new BlockState[]{Blocks.field_196661_l.func_176223_P(), Blocks.field_196658_i.func_176223_P(), Blocks.field_150405_ch.func_176223_P(), Blocks.field_196777_fo.func_176223_P(), Blocks.field_196778_fp.func_176223_P(), Blocks.field_196780_fq.func_176223_P(), Blocks.field_196782_fr.func_176223_P(), Blocks.field_196783_fs.func_176223_P(), Blocks.field_196785_ft.func_176223_P(), Blocks.field_196787_fu.func_176223_P(), Blocks.field_196789_fv.func_176223_P(), Blocks.field_196791_fw.func_176223_P(), Blocks.field_196793_fx.func_176223_P(), Blocks.field_196795_fy.func_176223_P(), Blocks.field_196797_fz.func_176223_P(), Blocks.field_196719_fA.func_176223_P(), Blocks.field_196720_fB.func_176223_P(), Blocks.field_196721_fC.func_176223_P(), Blocks.field_196722_fD.func_176223_P(), Blocks.field_150322_A.func_176223_P(), Blocks.field_180395_cM.func_176223_P(), Blocks.field_150391_bh.func_176223_P(), Blocks.field_150433_aE.func_176223_P(), Blocks.field_150354_m.func_176223_P(), Blocks.field_150351_n.func_176223_P(), Blocks.field_150355_j.func_176223_P(), Blocks.field_150353_l.func_176223_P(), Blocks.field_150343_Z.func_176223_P(), Blocks.field_150350_a.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), Blocks.field_150403_cj.func_176223_P()});
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static Map<Biome, BlockState> fillerBiomeMap;

    public static void setFillerMap() {
        if (fillerBiomeMap == null) {
            fillerBiomeMap = new HashMap<Biome, BlockState>();
            fillerBiomeMap.put(BiomeInit.NETHERLAND, Blocks.field_150424_aL.func_176223_P());
            fillerBiomeMap.put(BiomeInit.ICED_TERRAIN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(BiomeInit.ICE_SPIKES, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(BiomeInit.DEEP_FROZEN_OCEAN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(BiomeInit.FROZEN_OCEAN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(BiomeInit.BARREN_END_FIELD, Blocks.field_150377_bs.func_176223_P());
            fillerBiomeMap.put(BiomeInit.END_FIELD, Blocks.field_150377_bs.func_176223_P());
        }
    }

    public UnderwaterCaveCarver(Function<Dynamic<?>, ? extends ProbabilityConfig> probabilityConfig) {
        super(probabilityConfig, 73);
    }

    public boolean func_212868_a_(Random randomIn, int chunkX, int chunkZ, ProbabilityConfig config) {
        return randomIn.nextFloat() <= (float)ConfigUA.oceanCaveSpawnrate / 100.0f;
    }

    protected boolean func_222700_a(IChunk chunkIn, int chunkX, int chunkZ, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        return false;
    }

    protected boolean func_225556_a_(IChunk chunkIn, Function<BlockPos, Biome> biomeBlockPos, BitSet carvingMask, Random randomIn, BlockPos.Mutable MutableIn, BlockPos.Mutable p_222703_5_, BlockPos.Mutable p_222703_6_, int minHeight, int chunkX, int chunkZ, int x, int z, int maskY, int y, int atomicBoolean, AtomicBoolean p_222703_15_) {
        return UnderwaterCaveCarver.carvingBlock(this, biomeBlockPos, chunkIn, carvingMask, randomIn, MutableIn, minHeight, chunkX, chunkZ, x, z, maskY, y, atomicBoolean);
    }

    protected static boolean carvingBlock(WorldCarver<?> worldCarver, Function<BlockPos, Biome> biomeBlockPos, IChunk chunkIn, BitSet carvingMask, Random randomIn, BlockPos.Mutable MutableIn, int minHeight, int chunkX, int chunkZ, int xStart, int zStart, int maskY, int y, int atomicBoolean) {
        BlockState blockstate;
        if (y >= minHeight) {
            return false;
        }
        MutableIn.func_181079_c(xStart, y, zStart);
        BlockState fillerBlock = fillerBiomeMap.get(biomeBlockPos.apply((BlockPos)MutableIn));
        if (fillerBlock == null) {
            fillerBlock = STONE;
        }
        if (!CARVABLE_BLOCKS.contains(blockstate = chunkIn.func_180495_p((BlockPos)MutableIn))) {
            return false;
        }
        if (y == 10) {
            float f = randomIn.nextFloat();
            if ((double)f < 0.25) {
                chunkIn.func_177436_a((BlockPos)MutableIn, Blocks.field_196814_hQ.func_176223_P(), false);
                chunkIn.func_205218_i_().func_205360_a((BlockPos)MutableIn, (Object)Blocks.field_196814_hQ, 0);
            } else {
                chunkIn.func_177436_a((BlockPos)MutableIn, Blocks.field_150343_Z.func_176223_P(), false);
            }
            return true;
        }
        if (y < 10) {
            chunkIn.func_177436_a((BlockPos)MutableIn, Blocks.field_150353_l.func_176223_P(), false);
            return false;
        }
        MutableIn.func_181079_c(xStart, y, zStart);
        chunkIn.func_177436_a((BlockPos)MutableIn, field_222716_h.func_206883_i(), false);
        return true;
    }
}

