/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.placement;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.placement.SimplePlacement;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.config.CountRangeAndTypeConfig;

public class GeneralPlacement
extends SimplePlacement<CountRangeAndTypeConfig> {
    public GeneralPlacement(Function<Dynamic<?>, ? extends CountRangeAndTypeConfig> config) {
        super(config);
    }

    public Stream<BlockPos> getPositions(Random rand, CountRangeAndTypeConfig config, BlockPos pos) {
        int count;
        switch (config.type) {
            case GLOWSTONE_VARIANT_PATCH: {
                float result = (float)ConfigUA.glowstoneVariantsSpawnrate * config.countModifier;
                if (result < 1.0f && rand.nextFloat() < (float)ConfigUA.glowstoneVariantsSpawnrate * config.countModifier) {
                    count = 1;
                    break;
                }
                count = (int)result;
                break;
            }
            case GLOWSTONE: {
                count = (int)((float)ConfigUA.glowstoneSpawnrate * config.countModifier);
                break;
            }
            case MAGMA: {
                count = (int)((float)ConfigUA.magmaSpawnrate * config.countModifier);
                break;
            }
            case QUARTZ: {
                count = (int)((float)ConfigUA.quartzOreSpawnrate * config.countModifier);
                break;
            }
            case EMERALD: {
                count = (int)((double)(20 + rand.nextInt(35)) * ((double)((float)ConfigUA.emeraldOreSpawnrate * config.countModifier) / 100.0));
                break;
            }
            case SILVERFISH: {
                count = (int)((float)ConfigUA.silverfishSpawnrate * config.countModifier);
                break;
            }
            case COAL: {
                count = (int)((float)ConfigUA.coalOreSpawnrate * config.countModifier);
                break;
            }
            case IRON: {
                count = (int)((float)ConfigUA.ironOreSpawnrate * config.countModifier);
                break;
            }
            case GOLD: {
                count = (int)((float)ConfigUA.goldOreSpawnrate * config.countModifier);
                break;
            }
            case REDSTONE: {
                count = (int)((float)ConfigUA.redstoneOreSpawnrate * config.countModifier);
                break;
            }
            case DIAMOND: {
                count = (int)((float)ConfigUA.diamondOreSpawnrate * config.countModifier);
                break;
            }
            default: {
                count = (int)config.countModifier;
            }
        }
        return IntStream.range(0, count).mapToObj(p_215061_3_ -> {
            int x = rand.nextInt(16);
            int y = rand.nextInt(config.maximum - config.topOffset) + (config.sealevelBased ? ConfigUA.seaLevel - config.bottomOffset : config.bottomOffset);
            int z = rand.nextInt(16);
            return pos.func_177982_a(x, y, z);
        });
    }
}

