/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.placement;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.placement.Placement;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.config.ChanceAndTypeConfig;

public class LedgeUndersideMiniFeature
extends Placement<ChanceAndTypeConfig> {
    public LedgeUndersideMiniFeature(Function<Dynamic<?>, ? extends ChanceAndTypeConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public Stream<BlockPos> getPositions(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, ChanceAndTypeConfig placementConfig, BlockPos pos) {
        float chance;
        switch (placementConfig.type) {
            case HANGING_RUINS: {
                chance = (int)((float)ConfigUA.hangingRuinsSpawnrate * placementConfig.chanceModifier);
                break;
            }
            default: {
                chance = 0.0f;
            }
        }
        if (random.nextFloat() * 100.0f >= chance) {
            return Stream.empty();
        }
        int x = random.nextInt(16);
        int z = random.nextInt(16);
        int topYLayer = this.YPositionOfBottomOfLayer(worldIn, random.nextInt(174) + 74, random, pos.func_177982_a(x, 0, z));
        if (topYLayer < 75 || topYLayer > 248) {
            return Stream.empty();
        }
        return Stream.of(pos.func_177982_a(x - 4, topYLayer - 1, z - 4));
    }

    private int YPositionOfBottomOfLayer(IWorld worldIn, int height, Random random, BlockPos pos) {
        while (height < 255 && !worldIn.func_175623_d(pos.func_177982_a(0, height, 0))) {
            ++height;
        }
        while (height < 255 && worldIn.func_175623_d(pos.func_177982_a(0, height, 0))) {
            ++height;
        }
        return height > 255 ? 255 : height;
    }
}

