/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.generation;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.ultraamplified.world.biome.BiomeInit;

public enum BiomeGenHelper {
    instance;

    public static ForgeRegistry<Biome> BiomeRegistry;
    public static final int PLAINS;
    public static final int SWAMP;
    public static final int FOREST;
    public static final int DESERT;
    public static final int WOODED_ROCKY_FIELD;
    public static final int RELIC_FOREST;
    public static final int SNOWY_TUNDRA;
    public static final int ICED_TERRAIN;
    public static final int BAMBOO_JUNGLE;
    public static final int JUNGLE;
    public static final int JUNGLE_EDGE;
    public static final int BADLANDS;
    public static final int WOODED_BADLANDS;
    public static final int SANDLESS_BADLANDS;
    public static final int MUSHROOM_FIELDS;
    public static final int GIANT_TREE_TAIGA;
    public static final int DARK_FOREST;
    public static final int SAVANNA;
    public static final int TAIGA;
    public static final int SNOWY_TAIGA;
    public static final int WARM_OCEAN;
    public static final int LUKEWARM_OCEAN;
    public static final int OCEAN;
    public static final int COLD_OCEAN;
    public static final int FROZEN_OCEAN;
    public static final int DEEP_WARM_OCEAN;
    public static final int DEEP_LUKEWARM_OCEAN;
    public static final int DEEP_OCEAN;
    public static final int DEEP_COLD_OCEAN;
    public static final int DEEP_FROZEN_OCEAN;
    public static final int SUNFLOWER_PLAINS;
    public static final int NETHERLAND;
    public static final int END_FIELD;
    public static final int BARREN_END_FIELD;
    public static final int FROZEN_DESERT;
    public static final int STONE_PLAINS;
    public static final int VANILLA_OCEAN;
    public static final int VANILLA_DEEP_OCEAN;
    public static Set<Biome> frozenBiomes;
    public static Set<Biome> coldOceanBiomes;
    private static final Set<Biome> OCEAN_LIST;

    public static boolean isOcean(Biome biomeIn) {
        return OCEAN_LIST.contains(biomeIn);
    }

    public static boolean isOcean(int biomeIn) {
        return biomeIn == VANILLA_OCEAN || biomeIn == VANILLA_DEEP_OCEAN || biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN || biomeIn == DEEP_WARM_OCEAN || biomeIn == DEEP_LUKEWARM_OCEAN || biomeIn == DEEP_OCEAN || biomeIn == DEEP_COLD_OCEAN || biomeIn == DEEP_FROZEN_OCEAN;
    }

    public static boolean isShallowOcean(int biomeIn) {
        return biomeIn == VANILLA_OCEAN || biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN;
    }

    public static boolean areUABiomesSimilar(int biome1ID, int biome2ID) {
        if (biome1ID == biome2ID) {
            return true;
        }
        Biome biome1 = (Biome)BiomeRegistry.getValue(biome1ID);
        Biome biome2 = (Biome)BiomeRegistry.getValue(biome2ID);
        if (biome1 != null && biome2 != null) {
            if (biome1 != BiomeInit.WOODED_BADLANDS && biome1 != BiomeInit.SANDLESS_BADLANDS) {
                if (biome1.func_201856_r() != Biome.Category.NONE && biome2.func_201856_r() != Biome.Category.NONE && biome1.func_201856_r() == biome2.func_201856_r()) {
                    return true;
                }
                return biome1 == biome2;
            }
            return biome2 == BiomeInit.WOODED_BADLANDS || biome2 == BiomeInit.SANDLESS_BADLANDS;
        }
        return false;
    }

    static {
        BiomeRegistry = (ForgeRegistry)ForgeRegistries.BIOMES;
        PLAINS = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.PLAINS);
        SWAMP = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.SWAMP);
        FOREST = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.FOREST);
        DESERT = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.DESERT);
        WOODED_ROCKY_FIELD = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.WOODED_ROCKY_FIELD);
        RELIC_FOREST = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.RELIC_FOREST);
        SNOWY_TUNDRA = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.SNOWY_TUNDRA);
        ICED_TERRAIN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.ICED_TERRAIN);
        BAMBOO_JUNGLE = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.BAMBOO_JUNGLE);
        JUNGLE = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.JUNGLE);
        JUNGLE_EDGE = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.JUNGLE_EDGE);
        BADLANDS = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.BADLANDS);
        WOODED_BADLANDS = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.WOODED_BADLANDS);
        SANDLESS_BADLANDS = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.SANDLESS_BADLANDS);
        MUSHROOM_FIELDS = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.MUSHROOM_FIELDS);
        GIANT_TREE_TAIGA = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.GIANT_TREE_TAIGA);
        DARK_FOREST = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.DARK_FOREST);
        SAVANNA = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.SAVANNA);
        TAIGA = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.TAIGA);
        SNOWY_TAIGA = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.SNOWY_TAIGA);
        WARM_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.WARM_OCEAN);
        LUKEWARM_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.LUKEWARM_OCEAN);
        OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.OCEAN);
        COLD_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.COLD_OCEAN);
        FROZEN_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.FROZEN_OCEAN);
        DEEP_WARM_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.DEEP_WARM_OCEAN);
        DEEP_LUKEWARM_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.DEEP_LUKEWARM_OCEAN);
        DEEP_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.DEEP_OCEAN);
        DEEP_COLD_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.DEEP_COLD_OCEAN);
        DEEP_FROZEN_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.DEEP_FROZEN_OCEAN);
        SUNFLOWER_PLAINS = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.SUNFLOWER_PLAINS);
        NETHERLAND = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.NETHERLAND);
        END_FIELD = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.END_FIELD);
        BARREN_END_FIELD = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.BARREN_END_FIELD);
        FROZEN_DESERT = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.FROZEN_DESERT);
        STONE_PLAINS = BiomeRegistry.getID((IForgeRegistryEntry)BiomeInit.STONE_PLAINS);
        VANILLA_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)Biomes.field_76771_b);
        VANILLA_DEEP_OCEAN = BiomeRegistry.getID((IForgeRegistryEntry)Biomes.field_150575_M);
        frozenBiomes = ImmutableSet.of((Object)BiomeInit.DEEP_FROZEN_OCEAN, (Object)BiomeInit.FROZEN_OCEAN, (Object)BiomeInit.ICE_SPIKES, (Object)BiomeInit.FROZEN_DESERT, (Object)BiomeInit.SNOWY_TAIGA, (Object)BiomeInit.RELIC_SNOWY_TAIGA, (Object[])new Biome[]{BiomeInit.SNOWY_ROCKY_TAIGA, BiomeInit.SNOWY_TUNDRA});
        coldOceanBiomes = ImmutableSet.of((Object)BiomeInit.DEEP_COLD_OCEAN, (Object)BiomeInit.COLD_OCEAN);
        OCEAN_LIST = ImmutableSet.of((Object)BiomeInit.WARM_OCEAN, (Object)BiomeInit.LUKEWARM_OCEAN, (Object)BiomeInit.OCEAN, (Object)BiomeInit.COLD_OCEAN, (Object)BiomeInit.FROZEN_OCEAN, (Object)BiomeInit.DEEP_WARM_OCEAN, (Object[])new Biome[]{BiomeInit.DEEP_LUKEWARM_OCEAN, BiomeInit.DEEP_OCEAN, BiomeInit.DEEP_COLD_OCEAN, BiomeInit.DEEP_FROZEN_OCEAN});
    }
}

