/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.generation.layers;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.biome.BiomeInit;

@Mod.EventBusSubscriber(modid="ultra_amplified_dimension", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BiomeLayerSetupUA {
    public static List<BiomeManager.BiomeEntry>[] biomeListsByTemperature;
    public static List<BiomeManager.BiomeEntry> jungleReplacedBiomes;
    public static List<BiomeManager.BiomeEntry> megaTaigaReplacedBiomes;
    public static List<BiomeManager.BiomeEntry> mesaReplacedBiomes;
    public static List<BiomeManager.BiomeEntry> oceanReplacedBiomes;
    public static boolean noOcean;
    private static ForgeRegistry<Biome> BiomeRegistry;

    public BiomeLayerSetupUA() {
        BiomeLayerSetupUA.setupBiomeEntries();
    }

    private static void setupBiomeEntries() {
        biomeListsByTemperature = new ArrayList[BiomeManager.BiomeType.values().length];
        jungleReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
        megaTaigaReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
        mesaReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
        oceanReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
        noOcean = false;
        ArrayList<String> blacklistedMods = new ArrayList<String>();
        LinkedList<String> blacklistedResourceLocations = new LinkedList<String>(Arrays.asList(ConfigUA.blacklistedBiomeList.split(",")));
        for (int i = 0; i < blacklistedResourceLocations.size(); ++i) {
            blacklistedResourceLocations.set(i, ((String)blacklistedResourceLocations.get(i)).trim());
        }
        for (String entry : blacklistedResourceLocations) {
            if (!entry.contains(":*")) continue;
            blacklistedMods.add(entry.split(":")[0]);
        }
        int desertIdx = BiomeManager.BiomeType.DESERT.ordinal();
        int warmIdx = BiomeManager.BiomeType.WARM.ordinal();
        int coolIdx = BiomeManager.BiomeType.COOL.ordinal();
        int icyIdx = BiomeManager.BiomeType.ICY.ordinal();
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            int idx = type.ordinal();
            if (biomeListsByTemperature[idx] != null) continue;
            BiomeLayerSetupUA.biomeListsByTemperature[idx] = new ArrayList<BiomeManager.BiomeEntry>();
        }
        int index = 0;
        if (ConfigUA.importAllModdedBiomes) {
            for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
                String namespace;
                ResourceLocation rl = BiomeRegistry.getKey((IForgeRegistryEntry)biome);
                if (rl == null || blacklistedMods.contains(namespace = rl.func_110624_b()) || ConfigUA.blacklistedBiomeList.contains(rl.toString()) || namespace.equals("minecraft") || namespace.equals("ultra_amplified_dimension")) continue;
                BiomeManager.BiomeEntry addedBiome = new BiomeManager.BiomeEntry(biome, 20);
                float biomeTemperature = biome.func_185353_n();
                index = biomeTemperature < 0.1f ? icyIdx : (biomeTemperature >= 0.1f && biomeTemperature < 0.5f ? coolIdx : (biomeTemperature >= 0.5f && biomeTemperature < 1.0f ? warmIdx : desertIdx));
                biomeListsByTemperature[index].add(addedBiome);
            }
        } else if (ConfigUA.importModdedBiomes) {
            for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
                ImmutableList biomesToAdd = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
                int idx = type.ordinal();
                if (!ConfigUA.importModdedBiomes || biomesToAdd == null) continue;
                biomeListsByTemperature[idx].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
            }
        }
        for (int tempIndex = 0; tempIndex < biomeListsByTemperature.length; ++tempIndex) {
            for (int biomeIndex = biomeListsByTemperature[tempIndex].size() - 1; biomeIndex >= 0; --biomeIndex) {
                String namespace;
                ResourceLocation rl = BiomeRegistry.getKey((IForgeRegistryEntry)BiomeLayerSetupUA.biomeListsByTemperature[tempIndex].get((int)biomeIndex).biome);
                if (rl == null || !(namespace = rl.func_110624_b()).equals("minecraft") && !namespace.equals("ultra_amplified_dimension")) continue;
                biomeListsByTemperature[tempIndex].remove(biomeListsByTemperature[tempIndex].get(biomeIndex));
            }
        }
        for (int indexOfList = 0; indexOfList < biomeListsByTemperature.length; ++indexOfList) {
            for (int indexOfEntry = 0; indexOfEntry < biomeListsByTemperature[indexOfList].size(); ++indexOfEntry) {
                if (BiomeLayerSetupUA.biomeListsByTemperature[indexOfList].get((int)indexOfEntry).field_76292_a >= 10) continue;
                BiomeManager.BiomeEntry biomeEntry = biomeListsByTemperature[indexOfList].get(indexOfEntry);
                biomeListsByTemperature[indexOfList].remove(indexOfEntry);
                if (biomeEntry.field_76292_a <= 0) {
                    biomeListsByTemperature[indexOfList].add(indexOfEntry, new BiomeManager.BiomeEntry(biomeEntry.biome, 10));
                    continue;
                }
                biomeListsByTemperature[indexOfList].add(indexOfEntry, new BiomeManager.BiomeEntry(biomeEntry.biome, biomeEntry.field_76292_a * 10));
            }
        }
        if (ConfigUA.desert) {
            biomeListsByTemperature[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.DESERT, 40));
        }
        if (ConfigUA.savanna) {
            biomeListsByTemperature[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.SAVANNA, 40));
        }
        if (ConfigUA.plains) {
            biomeListsByTemperature[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.PLAINS, 20));
        }
        if (ConfigUA.nether) {
            biomeListsByTemperature[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.NETHERLAND, 30));
        }
        if (ConfigUA.forest) {
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.FOREST, 26));
        }
        if (ConfigUA.darkForest) {
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.DARK_FOREST, 26));
        }
        if (ConfigUA.rockyField) {
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.ROCKY_FIELD, 26));
        }
        if (ConfigUA.plains) {
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.PLAINS, 26));
        }
        if (ConfigUA.birchForest) {
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BIRCH_FOREST, 26));
        }
        if (ConfigUA.swamplands) {
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.SWAMP, 26));
        }
        if (ConfigUA.mushroom) {
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.MUSHROOM_FIELDS, 12));
        }
        if (ConfigUA.forest) {
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.FOREST, 30));
        }
        if (ConfigUA.rockyField) {
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.ROCKY_FIELD, 30));
        }
        if (ConfigUA.taiga) {
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.TAIGA, 30));
        }
        if (ConfigUA.plains) {
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.PLAINS, 10));
        }
        if (ConfigUA.stonePlains) {
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.STONE_PLAINS, 15));
        }
        if (ConfigUA.end) {
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.END_FIELD, 30));
        }
        if (ConfigUA.mushroom) {
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.MUSHROOM_FIELDS, 12));
        }
        if (ConfigUA.snowyTundra) {
            biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.SNOWY_TUNDRA, 45));
        } else {
            if (ConfigUA.iceSpike) {
                biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.ICE_SPIKES, 26));
            }
            if (ConfigUA.icedTerrain) {
                biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.ICED_TERRAIN, 26));
            }
        }
        if (ConfigUA.icedTerrain) {
            biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.ICED_TERRAIN, 17));
        }
        if (ConfigUA.snowyTaiga) {
            biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.SNOWY_TAIGA, 26));
        }
        if (ConfigUA.frozenDesert) {
            biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.FROZEN_DESERT, 10));
        }
        if (ConfigUA.jungle) {
            jungleReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.JUNGLE, 70));
        }
        if (ConfigUA.bambooJungle) {
            jungleReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BAMBOO_JUNGLE, 30));
        }
        if (ConfigUA.giantTreeTaiga) {
            megaTaigaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.GIANT_TREE_TAIGA, 10));
        }
        if (ConfigUA.badlands) {
            mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.SANDLESS_BADLANDS, 20));
            mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.WOODED_BADLANDS, 10));
        } else if (ConfigUA.spikyBadlands) {
            mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.SPIKY_BADLANDS, 10));
        }
        ArrayList<BiomeManager.BiomeEntry> temporaryBiomeList = new ArrayList<BiomeManager.BiomeEntry>();
        for (List<BiomeManager.BiomeEntry> biomeList : biomeListsByTemperature) {
            for (BiomeManager.BiomeEntry biomeEntry : biomeList) {
                boolean alreadyInTemp = false;
                for (BiomeManager.BiomeEntry tempBiomeEntry : temporaryBiomeList) {
                    if (tempBiomeEntry.biome != biomeEntry.biome) continue;
                    alreadyInTemp = true;
                }
                if (alreadyInTemp) continue;
                temporaryBiomeList.add(biomeEntry);
            }
        }
        if (jungleReplacedBiomes.size() != 0) {
            temporaryBiomeList.addAll(jungleReplacedBiomes);
        }
        if (megaTaigaReplacedBiomes.size() != 0) {
            temporaryBiomeList.addAll(megaTaigaReplacedBiomes);
        }
        if (mesaReplacedBiomes.size() != 0) {
            temporaryBiomeList.addAll(mesaReplacedBiomes);
        }
        oceanReplacedBiomes.addAll(temporaryBiomeList);
        while (temporaryBiomeList.size() > 6) {
            temporaryBiomeList.remove(temporaryBiomeList.size() - 1);
        }
        if (temporaryBiomeList.size() == 0) {
            biomeListsByTemperature[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            biomeListsByTemperature[warmIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            biomeListsByTemperature[coolIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            biomeListsByTemperature[icyIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            jungleReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            megaTaigaReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            oceanReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
        } else {
            if (biomeListsByTemperature[desertIdx].size() == 0 || temporaryBiomeList.size() < 6) {
                BiomeLayerSetupUA.biomeListsByTemperature[desertIdx] = temporaryBiomeList;
            }
            if (biomeListsByTemperature[warmIdx].size() == 0 || temporaryBiomeList.size() < 6) {
                BiomeLayerSetupUA.biomeListsByTemperature[warmIdx] = temporaryBiomeList;
            }
            if (biomeListsByTemperature[coolIdx].size() == 0 || temporaryBiomeList.size() < 6) {
                BiomeLayerSetupUA.biomeListsByTemperature[coolIdx] = temporaryBiomeList;
            }
            if (biomeListsByTemperature[icyIdx].size() == 0 || temporaryBiomeList.size() < 6) {
                BiomeLayerSetupUA.biomeListsByTemperature[icyIdx] = temporaryBiomeList;
            }
            if (jungleReplacedBiomes.size() == 0 || temporaryBiomeList.size() < 6) {
                jungleReplacedBiomes = temporaryBiomeList;
            }
            if (megaTaigaReplacedBiomes.size() == 0 || temporaryBiomeList.size() < 6) {
                megaTaigaReplacedBiomes = temporaryBiomeList;
            }
            if (mesaReplacedBiomes.size() == 0 || temporaryBiomeList.size() < 6) {
                mesaReplacedBiomes = temporaryBiomeList;
            }
        }
        if (!(ConfigUA.ocean || ConfigUA.coldOcean || ConfigUA.frozenOcean || ConfigUA.lukewarmOcean || ConfigUA.warmOcean)) {
            noOcean = true;
        }
    }

    static {
        noOcean = false;
        BiomeRegistry = (ForgeRegistry)ForgeRegistries.BIOMES;
    }

    @Mod.EventBusSubscriber(modid="ultra_amplified_dimension")
    private static class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void Load(WorldEvent.Load event) {
            BiomeLayerSetupUA.setupBiomeEntries();
        }
    }
}

