/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.EndPortalTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.blocks.UABlocks;
import net.telepathicgrunt.ultraamplified.capabilities.IPlayerPosAndDim;
import net.telepathicgrunt.ultraamplified.capabilities.PlayerPositionAndDimension;
import net.telepathicgrunt.ultraamplified.extrabehavior.AmplifiedPortalCreation;
import net.telepathicgrunt.ultraamplified.world.dimension.UADimensionRegistration;

public class AmplifiedPortalBlock
extends Block {
    @CapabilityInject(value=IPlayerPosAndDim.class)
    public static Capability<IPlayerPosAndDim> PAST_POS_AND_DIM = null;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public AmplifiedPortalBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151646_E).func_200951_a(15).func_200948_a(5.0f, 3600000.0f));
        this.setRegistryName("amplified_portal");
    }

    public TileEntity createNewTileEntity(IBlockReader world) {
        return new EndPortalTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState thisBlockState, World world, BlockPos position, PlayerEntity playerEntity, Hand playerHand, BlockRayTraceResult raytraceResult) {
        MinecraftServer minecraftserver = playerEntity.func_184102_h();
        if (!(world.field_72995_K || playerEntity.func_184218_aH() || playerEntity.func_184207_aI() || !playerEntity.func_184222_aU() || playerEntity.func_213453_ef())) {
            ChunkPos playerChunkPos;
            DimensionType destination;
            PlayerPositionAndDimension cap = (PlayerPositionAndDimension)playerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
            float pitch = 3.75f;
            float yaw = 0.0f;
            boolean enteringUA = false;
            if (playerEntity.field_71093_bK == UADimensionRegistration.ultraamplified()) {
                if (UltraAmplified.UADimensionConfig.forceExitToOverworld.get().booleanValue()) {
                    destination = DimensionType.field_223227_a_;
                } else {
                    destination = cap.getNonUADim();
                    if (destination == null) {
                        destination = DimensionType.field_223227_a_;
                    }
                }
                pitch = cap.getNonUAPitch();
                yaw = cap.getNonUAYaw();
                cap.setUAPos(playerEntity.func_213303_ch());
                cap.setUAPitch(playerEntity.field_70125_A);
                cap.setUAYaw(playerEntity.field_70177_z);
            } else {
                destination = UADimensionRegistration.ultraamplified();
                pitch = cap.getUAPitch();
                yaw = cap.getUAYaw();
                enteringUA = true;
                cap.setNonUAPos(playerEntity.func_213303_ch());
                cap.setNonUADim(playerEntity.field_71093_bK);
                cap.setNonUAPitch(playerEntity.field_70125_A);
                cap.setNonUAYaw(playerEntity.field_70177_z);
            }
            ServerWorld serverworld = minecraftserver.func_71218_a(destination);
            if (destination == UADimensionRegistration.ultraamplified() && !AmplifiedPortalCreation.checkForGeneratedPortal((IWorld)serverworld)) {
                AmplifiedPortalCreation.generatePortal((IWorld)serverworld);
            }
            Vec3d playerVec3Pos = new Vec3d(8.5, 0.0, 8.5);
            if (enteringUA && cap.getUAPos() == null) {
                int portalY;
                BlockPos worldOriginBlockPos = new BlockPos(10, 0, 8);
                playerChunkPos = new ChunkPos(worldOriginBlockPos);
                for (portalY = world.getMaxHeight(); portalY > 0 && serverworld.func_180495_p(worldOriginBlockPos.func_177981_b(portalY)) != ((Block)UABlocks.AMPLIFIEDPORTAL.get()).func_176223_P(); --portalY) {
                }
                if (portalY == 0) {
                    playerVec3Pos = new Vec3d((Vec3i)serverworld.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, worldOriginBlockPos)).func_72441_c(0.5, 1.0, 0.5);
                } else {
                    worldOriginBlockPos = worldOriginBlockPos.func_177981_b(portalY - 1);
                    boolean validSpaceFound = false;
                    for (int x = -2; x < 3; ++x) {
                        for (int z = -2; z < 3; ++z) {
                            if (x != -2 && x != 2 && z != -2 && z != 2 || serverworld.func_180495_p(worldOriginBlockPos.func_177982_a(x, 0, z)).func_185904_a() != Material.field_151579_a || serverworld.func_180495_p(worldOriginBlockPos.func_177982_a(x, 1, z)).func_185904_a() != Material.field_151579_a) continue;
                            worldOriginBlockPos = worldOriginBlockPos.func_177982_a(x, 0, z);
                            validSpaceFound = true;
                            z = 3;
                            x = 3;
                        }
                    }
                    if (!validSpaceFound) {
                        worldOriginBlockPos = serverworld.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(10, world.getMaxHeight(), 8));
                    }
                    playerVec3Pos = new Vec3d((Vec3i)worldOriginBlockPos).func_72441_c(0.5, 0.2, 0.5);
                }
            } else {
                if (enteringUA) {
                    playerVec3Pos = cap.getUAPos();
                } else if (cap.getNonUAPos() == null || UltraAmplified.UADimensionConfig.forceExitToOverworld.get().booleanValue()) {
                    BlockPos playerBlockPos = serverworld.func_205770_a(Heightmap.Type.MOTION_BLOCKING, serverworld.func_175694_M());
                    BlockState blockState = serverworld.func_180495_p(playerBlockPos);
                    while (blockState.func_185904_a() != Material.field_151579_a && playerBlockPos.func_177956_o() < serverworld.func_72940_L() - 2) {
                        playerBlockPos = playerBlockPos.func_177984_a();
                        blockState = serverworld.func_180495_p(playerBlockPos);
                    }
                    serverworld.func_175656_a(playerBlockPos, ((Block)UABlocks.AMPLIFIEDPORTAL.get()).func_176223_P());
                    playerVec3Pos = new Vec3d((Vec3i)playerBlockPos).func_72441_c(0.5, 1.0, 0.5);
                } else {
                    playerVec3Pos = cap.getNonUAPos();
                }
                playerChunkPos = new ChunkPos(new BlockPos(playerVec3Pos));
            }
            serverworld.func_72863_F().func_217228_a(TicketType.field_223185_g, playerChunkPos, 1, (Object)playerEntity.func_145782_y());
            if (((ServerPlayerEntity)playerEntity).func_70608_bn()) {
                ((ServerPlayerEntity)playerEntity).func_213366_dy();
            }
            playerEntity.field_70143_R = 0.0f;
            ((ServerPlayerEntity)playerEntity).func_200619_a(minecraftserver.func_71218_a(destination), playerVec3Pos.func_82615_a(), playerVec3Pos.func_82617_b() + 0.2, playerVec3Pos.func_82616_c(), yaw, pitch);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(thisBlockState, world, position, playerEntity, playerHand, raytraceResult);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        if (player != null && player.func_184812_l_()) {
            this.getBlock().func_176208_a(world, pos, state, player);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        if (world.func_201675_m().func_186058_p() == UADimensionRegistration.ultraamplified() && pos.func_177958_n() == 8 && pos.func_177952_p() == 8) {
            Block blockToCheck;
            BlockPos posOfHighestPortal = new BlockPos(pos.func_177958_n(), world.getMaxHeight(), pos.func_177952_p());
            while (posOfHighestPortal.func_177956_o() >= 0 && (blockToCheck = world.func_180495_p(posOfHighestPortal).func_177230_c()) != UABlocks.AMPLIFIEDPORTAL.get()) {
                posOfHighestPortal = posOfHighestPortal.func_177977_b();
            }
            if (posOfHighestPortal.func_177956_o() == pos.func_177956_o()) {
                return false;
            }
        }
        this.getBlock().func_176208_a(world, pos, state, player);
        return world.func_217377_a(pos, false);
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.createLotsOfParticles(state, (ServerWorld)world, pos, world.field_73012_v);
    }

    public void createLotsOfParticles(BlockState blockState, ServerWorld world, BlockPos position, Random random) {
        double xPos = (double)position.func_177958_n() + 0.5;
        double yPos = (double)position.func_177956_o() + 0.5;
        double zPos = (double)position.func_177952_p() + 0.5;
        double xOffset = ((double)random.nextFloat() - 0.4) * 0.8;
        double zOffset = ((double)random.nextFloat() - 0.4) * 0.8;
        world.func_195598_a((IParticleData)ParticleTypes.field_197631_x, xPos, yPos, zPos, 50, xOffset, 0.0, zOffset, (double)random.nextFloat() * 0.1 + 0.05);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World world, BlockPos pos, Random rand) {
        double d0 = (float)pos.func_177958_n() + (rand.nextFloat() * 3.0f - 1.0f);
        double d1 = (float)pos.func_177956_o() + (rand.nextFloat() * 3.0f - 1.0f);
        double d2 = (float)pos.func_177952_p() + (rand.nextFloat() * 3.0f - 1.0f);
        world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0);
    }
}

