/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.capabilities;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.dimension.DimensionType;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.capabilities.IPlayerPosAndDim;
import net.telepathicgrunt.ultraamplified.world.dimension.UADimensionRegistration;
import org.apache.logging.log4j.Level;

public class PlayerPositionAndDimension
implements IPlayerPosAndDim {
    public DimensionType nonUADimension = DimensionType.field_223227_a_;
    public Vec3d nonUABlockPos = null;
    public float nonUAPitch = 0.0f;
    public float nonUAYaw = 0.0f;
    public Vec3d UABlockPos = null;
    public float UAPitch = 3.75f;
    public float UAYaw = 90.0f;

    @Override
    public void setNonUADim(DimensionType incomingDim) {
        if (incomingDim == UADimensionRegistration.ultraamplified()) {
            this.nonUADimension = DimensionType.field_223227_a_;
            UltraAmplified.LOGGER.log(Level.ERROR, "Tried to set the NonUADimension variable to UA dimension. Please contact mod owner to report this!");
        } else {
            this.nonUADimension = incomingDim;
        }
    }

    @Override
    public DimensionType getNonUADim() {
        return this.nonUADimension;
    }

    @Override
    public void setNonUAPitch(float incomingPitch) {
        this.nonUAPitch = incomingPitch;
    }

    @Override
    public float getNonUAPitch() {
        return this.nonUAPitch;
    }

    @Override
    public void setNonUAYaw(float incomingYaw) {
        this.nonUAYaw = incomingYaw;
    }

    @Override
    public float getNonUAYaw() {
        return this.nonUAYaw;
    }

    @Override
    public void setNonUAPos(Vec3d incomingPos) {
        this.nonUABlockPos = incomingPos;
    }

    @Override
    public Vec3d getNonUAPos() {
        return this.nonUABlockPos;
    }

    @Override
    public void setUAPos(Vec3d incomingPos) {
        this.UABlockPos = incomingPos;
    }

    @Override
    public Vec3d getUAPos() {
        return this.UABlockPos;
    }

    @Override
    public void setUAPitch(float incomingPitch) {
        this.UAPitch = incomingPitch;
    }

    @Override
    public float getUAPitch() {
        return this.UAPitch;
    }

    @Override
    public void setUAYaw(float incomingYaw) {
        this.UAYaw = incomingYaw;
    }

    @Override
    public float getUAYaw() {
        return this.UAYaw;
    }

    @Override
    public CompoundNBT saveNBTData() {
        CompoundNBT data = new CompoundNBT();
        if (this.getNonUAPos() != null) {
            data.func_74780_a("NonUA_X", this.getNonUAPos().func_82615_a());
            data.func_74780_a("NonUA_Y", this.getNonUAPos().func_82617_b());
            data.func_74780_a("NonUA_Z", this.getNonUAPos().func_82616_c());
        }
        data.func_74776_a("NonUAPitch", this.nonUAPitch);
        data.func_74776_a("NonUAYaw", this.nonUAYaw);
        if (this.getUAPos() != null) {
            data.func_74780_a("UA_X", this.getUAPos().func_82615_a());
            data.func_74780_a("UA_Y", this.getUAPos().func_82617_b());
            data.func_74780_a("UA_Z", this.getUAPos().func_82616_c());
        }
        data.func_74776_a("UAPitch", this.UAPitch);
        data.func_74776_a("UAYaw", this.UAYaw);
        if (this.getNonUADim() != null) {
            data.func_74778_a("NonUADimensionNamespace", this.getNonUADim().getRegistryName().func_110624_b());
            data.func_74778_a("NonUADimensionPath", this.getNonUADim().getRegistryName().func_110623_a());
        }
        return data;
    }

    @Override
    public void loadNBTData(CompoundNBT nbtTag) {
        CompoundNBT data = nbtTag;
        data = PlayerPositionAndDimension.fixData(data);
        Vec3d storedPositionNonUA = null;
        float storedNonUAPitch = 3.75f;
        float storedNonUAYaw = 0.0f;
        Vec3d storePositionUA = null;
        float storedUAPitch = 3.75f;
        float storedUAYaw = 0.0f;
        DimensionType storedDimension = null;
        storedDimension = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(data.func_74779_i("NonUADimensionNamespace"), data.func_74779_i("NonUADimensionPath")));
        if (data.func_74764_b("NonUA_X") && data.func_74764_b("NonUA_Y") && data.func_74764_b("NonUA_Z")) {
            storedPositionNonUA = new Vec3d((double)data.func_74760_g("NonUA_X"), (double)data.func_74760_g("NonUA_Y"), (double)data.func_74760_g("NonUA_Z"));
        }
        storedNonUAPitch = data.func_74760_g("NonUAPitch");
        storedNonUAYaw = data.func_74760_g("NonUAYaw");
        if (data.func_74764_b("UA_X") && data.func_74764_b("UA_Y") && data.func_74764_b("UA_Z")) {
            storePositionUA = new Vec3d((double)data.func_74760_g("UA_X"), (double)data.func_74760_g("UA_Y"), (double)data.func_74760_g("UA_Z"));
        }
        storedUAPitch = data.func_74760_g("UAPitch");
        storedUAYaw = data.func_74760_g("UAYaw");
        this.setNonUADim(storedDimension);
        this.setNonUAPitch(storedNonUAPitch);
        this.setNonUAYaw(storedNonUAYaw);
        this.setNonUAPos(storedPositionNonUA);
        this.setUAPitch(storedUAPitch);
        this.setUAYaw(storedUAYaw);
        this.setUAPos(storePositionUA);
    }

    public static CompoundNBT fixData(CompoundNBT data) {
        if (PlayerPositionAndDimension.isOldData(data)) {
            return PlayerPositionAndDimension.getConvertedData(data);
        }
        return data;
    }

    private static boolean isOldData(CompoundNBT data) {
        return data.func_74764_b("PrevX");
    }

    private static CompoundNBT getConvertedData(CompoundNBT oldData) {
        BlockPos storedOldBlockPos = new BlockPos(oldData.func_74762_e("PrevX"), oldData.func_74762_e("PrevY"), oldData.func_74762_e("PrevZ"));
        DimensionType storedOldDimension = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(oldData.func_74779_i("PreviousDimensionNamespace"), oldData.func_74779_i("PreviousDimensionPath")));
        CompoundNBT newData = new CompoundNBT();
        if (storedOldDimension == null || storedOldDimension == UADimensionRegistration.ultraamplified()) {
            newData.func_74768_a("UA_X", storedOldBlockPos.func_177958_n());
            newData.func_74768_a("UA_Y", storedOldBlockPos.func_177956_o());
            newData.func_74768_a("UA_Z", storedOldBlockPos.func_177952_p());
            newData.func_74778_a("NonUADimensionNamespace", DimensionType.field_223227_a_.getRegistryName().func_110624_b());
            newData.func_74778_a("NonUADimensionPath", DimensionType.field_223227_a_.getRegistryName().func_110623_a());
        } else {
            newData.func_74768_a("NonUA_X", storedOldBlockPos.func_177958_n());
            newData.func_74768_a("NonUA_Y", storedOldBlockPos.func_177956_o());
            newData.func_74768_a("NonUA_Z", storedOldBlockPos.func_177952_p());
            newData.func_74778_a("NonUADimensionNamespace", storedOldDimension.getRegistryName().func_110624_b());
            newData.func_74778_a("NonUADimensionPath", storedOldDimension.getRegistryName().func_110623_a());
        }
        return newData;
    }
}

