/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.telepathicgrunt.ultraamplified.utils.ConfigHelper;

@Mod.EventBusSubscriber
public class UADimensionConfig {

    public static class UADimensionConfigValues {
        public ConfigHelper.ConfigValueListener<Boolean> bedExplodes;
        public ConfigHelper.ConfigValueListener<Boolean> heavyFog;
        public ConfigHelper.ConfigValueListener<Boolean> forceExitToOverworld;
        public ConfigHelper.ConfigValueListener<Boolean> allowNetherPortal;
        public ConfigHelper.ConfigValueListener<String> portalActivationItem;
        public ConfigHelper.ConfigValueListener<String> portalCornerBlocks;
        public ConfigHelper.ConfigValueListener<String> portalCeilingBlocks;
        public ConfigHelper.ConfigValueListener<String> portalFloorBlocks;

        public UADimensionConfigValues(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
            builder.push("General Dimension Options");
            this.heavyFog = subscriber.subscribe(builder.comment("\r\n Adds very heavy fog to make the world look more spoky and limit visibility.\n This is not the same as distance fog which does not make chunks near you foggy.").translation("ultraamplified.config.dimension.heavyfog").define("heavyFog", false));
            this.bedExplodes = subscriber.subscribe(builder.comment("\r\n Should beds explode in the Ultra Amplified Dimension?").translation("ultraamplified.config.dimension.bedexplodes").define("bedExplodes", false));
            this.allowNetherPortal = subscriber.subscribe(builder.comment("\r\n Lets Nether Portals be able to be created in Ultra Amplified DImension.\n Using the portal in this dimension will take you to the Nether but Nether \n Portals in the Nether will take you to the Overworld instead. So this option \n is good if you want a second way of escaping the Ultra Amplified Dimension.").translation("ultraamplified.config.dimension.allownetherportal").define("allowNetherPortal", false));
            this.forceExitToOverworld = subscriber.subscribe(builder.comment("\r\n Should beds explode in the Ultra Amplified Dimension? Makes leaving the Ultra Amplified dimension always places you back\r\n in the Overworld regardless of which dimension you originally \r\n came from. Use this option if this dimension becomes locked in  \r\n with another dimension so you are stuck teleporting between the \r\n two and cannot get back to the Overworld\r\n").translation("ultraamplified.config.dimension.forceexittooverworld").define("forceExitToOverworld", false));
            this.portalActivationItem = subscriber.subscribe(builder.comment("\r\n What item the player needs to hold and right click on the\r\n Polished Diorite to create the portal?\r\n The default entry is minecraft:flint_and_steel\r\n Note: set this to \"\" to disable portal creation completely.").translation("ultraamplified.config.dimension.portalactivationitem").define("portalActivationItem", (Object)"minecraft:flint_and_steel"));
            this.portalCornerBlocks = subscriber.subscribe(builder.comment("\r\n What corner blocks should we use to make a portal frame instead of Polish Granite?\r\n The default entry is minecraft:polish_granite").translation("ultraamplified.config.dimension.portalcornerblocks").define("portalCornerBlocks", (Object)"minecraft:polished_granite"));
            this.portalCeilingBlocks = subscriber.subscribe(builder.comment("\r\n What ceiling blocks should we use to make a portal frame instead of Polish Andesite Slab?\r\n The default entry is minecraft:polish_andesite").translation("ultraamplified.config.dimension.portalceilingblocks").define("portalCeilingBlocks", (Object)"minecraft:polished_andesite_slab"));
            this.portalFloorBlocks = subscriber.subscribe(builder.comment("\r\n What floor blocks should we use to make a portal frame instead of Polish Andesite Slab?\r\n The default entry is minecraft:polish_andesite").translation("ultraamplified.config.dimension.portalfloorblocks").define("portalFloorBlocks", (Object)"minecraft:polished_andesite_slab"));
            builder.pop();
        }
    }
}

