/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.telepathicgrunt.ultraamplified.utils.ConfigHelper;

@Mod.EventBusSubscriber
public class UAFeaturesConfig {

    public static class UAFeaturesConfigValues {
        public ConfigHelper.ConfigValueListener<Integer> coalOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> ironOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> redstoneOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> lapisOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> diamondOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> goldOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> emeraldOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> silverfishSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> quartzOreSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> glowstoneSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> magmaSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> lavaSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> glowstoneVariantsSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> rootGen;
        public ConfigHelper.ConfigValueListener<Integer> dungeonSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> ravineSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> caveCavitySpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> oceanCaveSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> columnGen;
        public ConfigHelper.ConfigValueListener<Integer> columnSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> rampSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> rampGen;
        public ConfigHelper.ConfigValueListener<Integer> honeyLakeGen;
        public ConfigHelper.ConfigValueListener<Integer> slimeLakeGen;
        public ConfigHelper.ConfigValueListener<Integer> waterLakeGen;
        public ConfigHelper.ConfigValueListener<Integer> lavaLakeGen;
        public ConfigHelper.ConfigValueListener<Integer> waterfallSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> lavafallSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> endIslandSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> endIslandMaxHeight;

        public UAFeaturesConfigValues(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
            builder.push("Feature Options");
            builder.push("General Feature Options");
            this.dungeonSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Dungeons will spawn.\r\n 0 for no Dungeons and 1000 for max spawnrate.").translation("ultraamplified.config.feature.dungeonspawnrate").defineInRange("dungeonSpawnrate", 30, 0, 1000));
            this.ravineSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Ravines will spawn.\r\n 0 for no Ravines and 100 for max spawnrate.").translation("ultraamplified.config.feature.ravinespawnrate").defineInRange("ravineSpawnrate", 25, 0, 100));
            this.caveCavitySpawnrate = subscriber.subscribe(builder.comment("\r\n How often Cave Cavity will spawn.\r\n 0 for no Cave Cavity and 22 for max spawnrate.").translation("ultraamplified.config.feature.cavecavityspawnrate").defineInRange("caveCavitySpawnrate", 5, 0, 22));
            this.oceanCaveSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Underwater Caves will spawn in ocean biomes.\r\n 0 for no Underwater Caves and 100 for max spawnrate.").translation("ultraamplified.config.feature.oceancavespawnrate").defineInRange("oceanCaveSpawnrate", 20, 0, 100));
            this.columnGen = subscriber.subscribe(builder.comment("\r\n Controls whether columns/pillars features spawn or not.\r\n Note: You need to close and reopen world for changes to take effect.").translation("ultraamplified.config.feature.columngen").define("columnGen", true));
            this.columnSpawnrate = subscriber.subscribe(builder.comment("\r\n How often will column/pillars spawn.\r\n Default is 2 with 40 being an insane amount of columns.\r\n Note: You need to close and reopen world for changes to take effect.").translation("ultraamplified.config.feature.columnspawnrate").defineInRange("columnSpawnrate", 2, 1, 40));
            this.rampGen = subscriber.subscribe(builder.comment("\r\n Controls whether ramp features spawn or not.\r\n Note: You need to close and reopen world for changes to take effect.").translation("ultraamplified.config.feature.rampgen").define("rampGen", true));
            this.rampSpawnrate = subscriber.subscribe(builder.comment("\r\n How often will ramps spawn.\r\n Default is 2 with 40 being an insane amount of ramps.\r\n Note: You need to close and reopen world for changes to take effect.").translation("ultraamplified.config.feature.rampspawnrate").defineInRange("rampSpawnrate", 2, 1, 40));
            this.honeyLakeGen = subscriber.subscribe(builder.comment("\r\n Controls whether Honey Lakes spawn or not.\r\n 1 for maximum spawnrate and 1000 for no lakes").translation("ultraamplified.config.feature.honeylakegen").defineInRange("honeyLakeGen", 16, 1, 1000));
            this.slimeLakeGen = subscriber.subscribe(builder.comment("\r\n Controls whether Slime Lakes spawn or not.\r\n 1 for maximum spawnrate and 1000 for no lakes").translation("ultraamplified.config.feature.slimelakegen").defineInRange("slimeLakeGen", 7, 1, 1000));
            this.waterLakeGen = subscriber.subscribe(builder.comment("\r\n Controls whether Water Lakes spawn or not.\r\n 1 for maximum spawnrate and 1000 for no lakes").translation("ultraamplified.config.feature.waterlakegen").defineInRange("waterLakeGen", 4, 1, 1000));
            this.lavaLakeGen = subscriber.subscribe(builder.comment("\r\n Controls whether Lava Lakes spawn or not.\r\n 1 for maximum spawnrate and 1000 for no lakes").translation("ultraamplified.config.feature.lavalakegen").defineInRange("lavaLakeGen", 10, 1, 1000));
            this.glowstoneVariantsSpawnrate = subscriber.subscribe(builder.comment("\r\n Controls how often patches of Glowdirt and other modded Glowstone variants spawn.\r\n 0 for no patches and 1000 for max amount of patches.").translation("ultraamplified.config.feature.glowstonevariantsspawnrate").defineInRange("glowstoneVariantsSpawnrate", 50, 0, 1000));
            this.rootGen = subscriber.subscribe(builder.comment("\r\n Controls whether roots and short vines spawn or not on the underside of the floating land.").translation("ultraamplified.config.feature.rootgen").define("rootGen", true));
            this.waterfallSpawnrate = subscriber.subscribe(builder.comment("\r\n How often waterfalls will spawn.\n 0 for no waterfalls and 1000 for max spawnrate.").translation("ultraamplified.config.terrain.waterfallspawnrate").defineInRange("waterfallSpawnrate", 35, 0, 1000));
            this.lavafallSpawnrate = subscriber.subscribe(builder.comment("\r\n How often lavafalls will spawn.\n 0 for no lavafalls and 1000 for max spawnrate.").translation("ultraamplified.config.terrain.lavafallspawnrate").defineInRange("lavafallSpawnrate", 14, 0, 1000));
            builder.pop();
            builder.push("End Fields Islands Options");
            this.endIslandSpawnrate = subscriber.subscribe(builder.comment("\r\n How often End Islands will spawn in the End Biome.\n 0 for no End Islands and 100 for max spawnrate.").translation("ultraamplified.config.terrain.endislandspawnrate").defineInRange("endIslandSpawnrate", 6, 0, 100));
            this.endIslandMaxHeight = subscriber.subscribe(builder.comment("\r\n The maximum height that End Islands can spawn at in the End Field Biome.").translation("ultraamplified.config.terrain.endislandmaxheight").defineInRange("endIslandMaxHeight", 254, 0, 256));
            builder.pop();
            builder.push("Main Ores Options");
            this.coalOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Coal Ores will spawn.\n 0 for no Coal Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.coalorespawnrate").defineInRange("coalOreSpawnrate", 35, 0, 1000));
            this.ironOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Iron Ores will spawn.\n 0 for no Iron Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.ironorespawnrate").defineInRange("ironOreSpawnrate", 50, 0, 1000));
            this.redstoneOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Redstone Ores will spawn.\n 0 for no Redstone Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.redstoneorespawnrate").defineInRange("redstoneOreSpawnrate", 12, 0, 1000));
            this.lapisOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Lapis Lazuli Ores will spawn.\n 0 for no Lapis Lazuli Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.lapisorespawnrate").defineInRange("lapisOreSpawnrate", 2, 0, 1000));
            this.diamondOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Diamond Ores will spawn.\n 0 for no Diamond Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.diamondorespawnrate").defineInRange("diamondOreSpawnrate", 1, 0, 1000));
            this.goldOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Gold Ores will spawn.\n 0 for no Gold Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.goldorespawnrate").defineInRange("goldOreSpawnrate", 2, 0, 1000));
            builder.push("Rocky Fields Ores and Features Options");
            this.emeraldOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Emerald Ores will spawn in all Rocky Fields variant biomes in the form of a percentage.\n 0 for no Emerald Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.emeraldorespawnrate").defineInRange("emeraldOreSpawnrate", 100, 0, 1000));
            this.silverfishSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Silverfish Blocks will spawn in all Rocky Fields variant biomes.\n 0 for no Silverfish Blocks and 1000 for max spawnrate.").translation("ultraamplified.config.ore.silverfishspawnrate").defineInRange("silverfishSpawnrate", 18, 0, 1000));
            builder.pop();
            builder.push("Netherland Ores and Features Options");
            this.quartzOreSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Quartz Ores will spawn.\n 0 for no Quartz Ores and 1000 for max spawnrate.").translation("ultraamplified.config.ore.quartzorespawnrate").defineInRange("quartzOreSpawnrate", 14, 0, 1000));
            this.glowstoneSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Glowstone will spawn in Netherland biome.\n 0 for no Glowstone and 1000 for max spawnrate.").translation("ultraamplified.config.ore.glowstonespawnrate").defineInRange("glowstoneSpawnrate", 20, 0, 1000));
            this.magmaSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Magma Blocks will spawn below Y = 100 in Netherland biome.\n 0 for no Magma Blocks and 1000 for max spawnrate.\n Note: Will not affect the flat Magma layer separating water from lava below sealevel.").translation("ultraamplified.config.ore.magmaspawnrate").defineInRange("magmaSpawnrate", 5, 0, 1000));
            this.lavaSpawnrate = subscriber.subscribe(builder.comment("\r\n How often single Lava Blocks will spawn in Netherland biome.\n 0 for no single Lava Blocks and 1000 for max spawnrate.").translation("ultraamplified.config.ore.lavaspawnrate").defineInRange("lavaSpawnrate", 70, 0, 1000));
            builder.pop();
            builder.pop();
        }
    }
}

