/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.telepathicgrunt.ultraamplified.utils.ConfigHelper;

@Mod.EventBusSubscriber
public class UAStructuresConfig {

    public static class UAStructuresConfigValues {
        public ConfigHelper.ConfigValueListener<Boolean> chestGeneration;
        public ConfigHelper.ConfigValueListener<Integer> sunShrineSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> stonehengeSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> hangingRuinsSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> miniStructureGeneration;
        public ConfigHelper.ConfigValueListener<Integer> villageSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> villageZombieSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> mineshaftSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> mineshaftAbovegroundAllowed;
        public ConfigHelper.ConfigValueListener<Boolean> mineshaftUndergroundAllowed;
        public ConfigHelper.ConfigValueListener<Integer> mansionSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> desertTempleSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> jungleTempleSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> iglooSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> mushroomTempleSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> iceSpikeTempleSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> witchHutSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> oceanMonumentSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> oceanRuinsSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> shipwreckSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> strongholdSpawnrate;
        public ConfigHelper.ConfigValueListener<Double> silverfishStrongholdSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> allowSilverfishSpawnerStronghold;
        public ConfigHelper.ConfigValueListener<Double> strongholdSizeSH;
        public ConfigHelper.ConfigValueListener<Integer> netherFortressSpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> stoneFortressSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> allowSilverfishSpawnerFortress;
        public ConfigHelper.ConfigValueListener<Boolean> allowNaturalSilverfishFortress;
        public ConfigHelper.ConfigValueListener<Integer> endCitySpawnrate;
        public ConfigHelper.ConfigValueListener<Integer> pillageOutpostRarity;

        public UAStructuresConfigValues(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
            builder.push("Structure/Feature Options");
            builder.push("Mini-structure Options");
            this.miniStructureGeneration = subscriber.subscribe(builder.comment("\r\n Controls whether Desert Wells, Hay Piles, Sun Shrines, Stonehenges, and Crosses spawn or not.").translation("ultraamplified.config.structure.ministructuregeneration").define("miniStructureGeneration", true));
            this.sunShrineSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Sun Shrines.\r\n 1 for Sun Shrines spawning in most chunks and 1000 for very rare spawn.\r\n Spawns mainly in relic variant of biomes.").translation("ultraamplified.config.structure.sunshrinespawnrate").defineInRange("sunShrineSpawnrate", 130, 1, 1000));
            this.stonehengeSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Stonehenges.\r\n 1 for Stonehenges spawning in most chunks and 1000 for very rare spawn.\r\n Spawns mainly in relic variant of biomes.").translation("ultraamplified.config.structure.stonehengespawnrate").defineInRange("stonehengeSpawnrate", 15, 1, 1000));
            this.hangingRuinsSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Hanging Ruins.\r\n 1000 for Hanging Ruins spawning in most chunks and 0 for no spawn.\r\n NOTE: this is backwards than other spawnrates.\r\n This is because other structures need have finer control on chances less than 1%.\r\n Spawns in most biomes except for oceans, Netherland, and Iced Terrain Biomes and more often in Rocky Fields variants and Stone Fields biomes.").translation("ultraamplified.config.structure.hangingruinsspawnrate").defineInRange("hangingRuinsSpawnrate", 60, 0, 1000));
            builder.pop();
            builder.push("Structure Options");
            this.chestGeneration = subscriber.subscribe(builder.comment("\r\n Controls whether loot chests spawn or not in all structures.").translation("ultraamplified.config.structure.chestgeneration").define("chestGeneration", true));
            builder.push("Villages");
            this.villageSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Villages.\r\n 1 for Village spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.villagespawnrate").defineInRange("villageSpawnrate", 16, 1, 101));
            this.villageZombieSpawnrate = subscriber.subscribe(builder.comment("\r\n What percentage of Classic Styled Villages are Zombie Villages.\r\n 0 for no Zombie Village spawning and 100 for all Villages being zombified.").translation("ultraamplified.config.structure.villagezombiespawnrate").defineInRange("villageZombieSpawnrate", 10, 0, 100));
            builder.pop();
            builder.push("Mineshaft");
            this.mineshaftSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Mineshafts will spawn.\r\n 0 for no Mineshafts and 1000 for max spawnrate.").translation("ultraamplified.config.structure.mineshaftspawnrate").defineInRange("mineshaftSpawnrate", 22, 0, 1000));
            this.mineshaftAbovegroundAllowed = subscriber.subscribe(builder.comment("\r\n Can aboveground floating Mineshafts spawn?").translation("ultraamplified.config.structure.mineshaftabovegroundallowed").define("mineshaftAbovegroundAllowed", true));
            this.mineshaftUndergroundAllowed = subscriber.subscribe(builder.comment("\r\n Can undergound giant pit Mineshafts spawn?").translation("ultraamplified.config.structure.mineshaftundergroundallowed").define("mineshaftUndergroundAllowed", true));
            builder.pop();
            builder.push("Woodland Mansion");
            this.mansionSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Woodland Mansion.\n 1 for Woodland Mansion spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.mansionspawnrate").defineInRange("mansionSpawnrate", 18, 1, 101));
            builder.pop();
            builder.push("Desert Temple");
            this.desertTempleSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Desert Temples.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.deserttemplespawnrate").defineInRange("desertTempleSpawnrate", 20, 1, 101));
            builder.pop();
            builder.push("Jungle Temple");
            this.jungleTempleSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Jungle Temples.\n 1 for a spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.jungletemplespawnrate").defineInRange("jungleTempleSpawnrate", 20, 1, 101));
            builder.pop();
            builder.push("Igloo");
            this.iglooSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are igloos.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.igloospawnrate").defineInRange("iglooSpawnrate", 14, 1, 101));
            builder.pop();
            builder.push("Mushroom Temple");
            this.mushroomTempleSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Mushroom Temples.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.mushroomtemplespawnrate").defineInRange("mushroomTempleSpawnrate", 12, 1, 101));
            builder.pop();
            builder.push("Ice Spike Temple");
            this.iceSpikeTempleSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Ice Spike Temples.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.icespiketemplespawnrate").defineInRange("iceSpikeTempleSpawnrate", 20, 1, 101));
            builder.pop();
            builder.push("Witch Hut");
            this.witchHutSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Witch Huts.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.witchhutspawnrate").defineInRange("witchHutSpawnrate", 14, 1, 101));
            builder.pop();
            builder.push("Ocean Monument");
            this.oceanMonumentSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Ocean Monuments.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.oceanmonumentspawnrate").defineInRange("oceanMonumentSpawnrate", 22, 1, 101));
            builder.pop();
            builder.push("Ocean Ruins");
            this.oceanRuinsSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Ocean Ruins.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.oceanruinsspawnrate").defineInRange("oceanRuinsSpawnrate", 7, 1, 101));
            builder.pop();
            builder.push("Shipwreck");
            this.shipwreckSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Shipwrecks.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.shipwreckspawnrate").defineInRange("shipwreckSpawnrate", 7, 1, 101));
            builder.pop();
            builder.push("Stronghold");
            this.strongholdSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Strongholds.\n 1 for spawning in most chunks and 501 for no spawn.").translation("ultraamplified.config.structure.strongholdspawnrate").defineInRange("strongholdSpawnrate", 62, 1, 501));
            this.silverfishStrongholdSpawnrate = subscriber.subscribe(builder.comment("\r\n How often Silverfish Blocks will generate in Strongholds.\n 0 for no Silverfish Blocks and 100 for max spawnrate.").translation("ultraamplified.config.structure.silverfishstrongholdspawnrate").defineInRange("silverfishStrongholdSpawnrate", 4.0, 0.0, 100.0));
            this.allowSilverfishSpawnerStronghold = subscriber.subscribe(builder.comment("\r\n Can Silverfish Mob Spawners generate in Stronghold?.").translation("ultraamplified.config.structure.allowsilverfishspawnerstronghold").define("allowSilverfishSpawnerStronghold", true));
            this.strongholdSizeSH = subscriber.subscribe(builder.comment("\r\n How large the Stronghold is on average as a percentage.\r\n Note: The Stonghold is much larger by default. To get something \r\n closer to vanilla stronghold size, use the value of 60.\n 10 for supertiny Strongholds and 2000 for supermassive Strongholds.").translation("repurposedstructures.config.structure.stronghold.strongholdsizesh").defineInRange("strongholdSizeSH", 100.0, 10.0, 2000.0));
            builder.pop();
            builder.push("Nether Fortress");
            this.netherFortressSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Nether Fortresses that spawn \r\n aboveground in the Netherland biome (between y = 85 and 130).\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.netherfortressspawnrate").defineInRange("netherFortressSpawnrate", 6, 1, 101));
            builder.pop();
            builder.push("Stone Fortress");
            this.stoneFortressSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Stone Fortresses that spawn underground (below y = 65).\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.stonefortressspawnrate").defineInRange("stoneFortressSpawnrate", 14, 1, 101));
            this.allowSilverfishSpawnerFortress = subscriber.subscribe(builder.comment("\r\n Can Silverfish Mob Spawners generate in Stone Fortresses?").translation("ultraamplified.config.structure.allowsilverfishspawnerfortress").define("allowSilverfishSpawnerFortress", true));
            this.allowNaturalSilverfishFortress = subscriber.subscribe(builder.comment("\r\n Can Silverfish spawn naturally over time in Stone Fortresses?").translation("ultraamplified.config.structure.allownaturalsilverfishfortress").define("allowNaturalSilverfishFortress", true));
            builder.pop();
            builder.push("End City");
            this.endCitySpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are End Cities.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.endcityspawnrate").defineInRange("endCitySpawnrate", 22, 1, 101));
            builder.pop();
            builder.push("Outpost");
            this.pillageOutpostRarity = subscriber.subscribe(builder.comment("\r\n How rare are Pillager Outposts.\n 1 for spawning in most chunks and 101 for no spawn.").translation("ultraamplified.config.structure.pillageoutpostrarity").defineInRange("pillageOutpostRarity", 20, 1, 101));
            builder.pop();
            builder.pop();
            builder.pop();
        }
    }
}

