/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.biome;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.utils.RegUtil;
import net.telepathicgrunt.ultraamplified.world.biomes.BadlandsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BadlandsDensedWoodedBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BadlandsDissectedPlateauBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BadlandsSandlessBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BadlandsSpikyBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BadlandsWoodedBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BambooJungleBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BambooJungleRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BirchForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DarkForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DarkForestRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DesertBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DesertLakesBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DesertRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.EndBarrenFieldBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.EndFieldBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.FlowerForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.FlowerJungleBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.FlowerJungleEdgeBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ForestRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.FrozenDesertBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GiantSpruceTaigaPillarsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GiantSpruceTaigaRelicPillarsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GiantTreeTaigaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GiantTreeTaigaRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GravellyColumnsFieldBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GravellyFieldBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.IceSpikesBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.IcedTerrainBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.JungleBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.JungleEdgeBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.JungleRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.MushroomFieldsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.NetherlandBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanColdBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanDeepBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanDeepColdBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanDeepFrozenBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanDeepLukewarmBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanDeepWarmBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanFrozenBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanLukewarmBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanWarmBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.PlainsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.RockyFieldBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.RockyFieldWoodedBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SavannaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SavannaTerraceBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ShatteredSavannaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ShatteredSavannaTerraceBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SnowyTaigaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SnowyTaigaRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SnowyTaigaRockyBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SnowyTundraBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.StonePlainsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SunflowerPlainsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SwampBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SwampSpookyBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TaigaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TaigaRelicBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TaigaRockyBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TallBirchForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TallBirchForestRelicBiomeUA;

public class UABiomes {
    private static ForgeRegistry<Biome> BiomeRegistry = (ForgeRegistry)ForgeRegistries.BIOMES;
    private static Set<Biome> allRegisteredBiomes;
    public static Biome PLAINS;
    public static Biome DESERT;
    public static Biome FOREST;
    public static Biome TAIGA;
    public static Biome ROCKY_FIELD;
    public static Biome SWAMP;
    public static Biome NETHERLAND;
    public static Biome END_FIELD;
    public static Biome SNOWY_TUNDRA;
    public static Biome ICED_TERRAIN;
    public static Biome MUSHROOM_FIELDS;
    public static Biome RELIC_DESERT;
    public static Biome RELIC_FOREST;
    public static Biome RELIC_TAIGA;
    public static Biome BAMBOO_JUNGLE;
    public static Biome RELIC_BAMBOO_JUNGLE;
    public static Biome JUNGLE;
    public static Biome RELIC_JUNGLE;
    public static Biome JUNGLE_EDGE;
    public static Biome STONE_PLAINS;
    public static Biome FROZEN_DESERT;
    public static Biome BIRCH_FOREST;
    public static Biome RELIC_BIRCH_FOREST;
    public static Biome DARK_FOREST;
    public static Biome SNOWY_TAIGA;
    public static Biome RELIC_SNOWY_TAIGA;
    public static Biome GIANT_TREE_TAIGA;
    public static Biome RELIC_GIANT_TREE_TAIGA;
    public static Biome WOODED_ROCKY_FIELD;
    public static Biome SAVANNA;
    public static Biome SAVANNA_TERRACE;
    public static Biome BADLANDS;
    public static Biome WOODED_BADLANDS;
    public static Biome SANDLESS_BADLANDS;
    public static Biome SUNFLOWER_PLAINS;
    public static Biome DESERT_LAKES;
    public static Biome GRAVELLY_FIELD;
    public static Biome FLOWER_FOREST;
    public static Biome ROCKY_TAIGA;
    public static Biome SPOOKY_SWAMP;
    public static Biome ICE_SPIKES;
    public static Biome FLOWER_JUNGLE;
    public static Biome FLOWER_JUNGLE_EDGE;
    public static Biome TALL_BIRCH_FOREST;
    public static Biome RELIC_TALL_BIRCH_FOREST;
    public static Biome RELIC_DARK_FOREST;
    public static Biome SNOWY_ROCKY_TAIGA;
    public static Biome GIANT_SPRUCE_TAIGA_PILLARS;
    public static Biome RELIC_GIANT_SPRUCE_TAIGA_PILLARS;
    public static Biome GRAVELLY_COLUMNS_FIELD;
    public static Biome SHATTERED_SAVANNA;
    public static Biome SHATTERED_SAVANNA_TERRACE;
    public static Biome SPIKY_BADLANDS;
    public static Biome DENSED_WOODED_BADLANDS;
    public static Biome DISSECTED_PLATEAU_BADLANDS;
    public static Biome COLD_OCEAN;
    public static Biome DEEP_COLD_OCEAN;
    public static Biome DEEP_FROZEN_OCEAN;
    public static Biome DEEP_LUKEWARM_OCEAN;
    public static Biome DEEP_OCEAN;
    public static Biome DEEP_WARM_OCEAN;
    public static Biome FROZEN_OCEAN;
    public static Biome LUKEWARM_OCEAN;
    public static Biome OCEAN;
    public static Biome WARM_OCEAN;
    public static Biome BARREN_END_FIELD;
    public static final Map<Biome, Biome> BASE_TO_MUTATION_MAP;
    public static Map<Integer, Integer> BASE_TO_HILLS_MAP;

    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        IForgeRegistry registry = event.getRegistry();
        PLAINS = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new PlainsBiomeUA(), "plains", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.PLAINS);
        DESERT = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new DesertBiomeUA(), "desert", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY);
        FOREST = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new ForestBiomeUA(), "forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST);
        TAIGA = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new TaigaBiomeUA(), "taiga", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        ROCKY_FIELD = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new RockyFieldBiomeUA(), "rocky_field", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS);
        SWAMP = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new SwampBiomeUA(), "swamp", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        NETHERLAND = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new NetherlandBiomeUA(), "netherland", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        END_FIELD = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new EndFieldBiomeUA(), "end_field", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.END, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY);
        SNOWY_TUNDRA = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new SnowyTundraBiomeUA(), "snowy_tundra", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SNOWY);
        ICED_TERRAIN = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new IcedTerrainBiomeUA(), "iced_terrain", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY);
        MUSHROOM_FIELDS = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new MushroomFieldsBiomeUA(), "mushroom_field", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.RARE);
        RELIC_DESERT = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new DesertRelicBiomeUA(), "relic_desert", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HILLS);
        RELIC_FOREST = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new ForestRelicBiomeUA(), "relic_forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.HILLS);
        RELIC_TAIGA = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new TaigaRelicBiomeUA(), "relic_taiga", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.CONIFEROUS);
        BAMBOO_JUNGLE = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new BambooJungleBiomeUA(), "bamboo_jungle", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE);
        RELIC_BAMBOO_JUNGLE = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new BambooJungleRelicBiomeUA(), "relic_bamboo_jungle", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE);
        JUNGLE = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new JungleBiomeUA(), "jungle", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE);
        RELIC_JUNGLE = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new JungleRelicBiomeUA(), "relic_jungle", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HILLS);
        JUNGLE_EDGE = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new JungleEdgeBiomeUA(), "jungle_edge", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.RARE);
        STONE_PLAINS = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new StonePlainsBiomeUA(), "stone_plains", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.BEACH);
        FROZEN_DESERT = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new FrozenDesertBiomeUA(), "frozen_desert", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD);
        BIRCH_FOREST = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new BirchForestBiomeUA(), "birch_forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST);
        RELIC_BIRCH_FOREST = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new BirchForestBiomeUA(), "relic_birch_forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        DARK_FOREST = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new DarkForestBiomeUA(), "dark_forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY);
        SNOWY_TAIGA = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new SnowyTaigaBiomeUA(), "snowy_taiga", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD);
        RELIC_SNOWY_TAIGA = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new SnowyTaigaRelicBiomeUA(), "relic_snowy_taiga", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.HILLS);
        GIANT_TREE_TAIGA = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new GiantTreeTaigaBiomeUA(), "giant_tree_taiga", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        RELIC_GIANT_TREE_TAIGA = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new GiantTreeTaigaRelicBiomeUA(), "relic_giant_tree_taiga", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        WOODED_ROCKY_FIELD = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new RockyFieldWoodedBiomeUA(), "wooden_rocky_field", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPARSE);
        SAVANNA = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new SavannaBiomeUA(), "savanna", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE);
        SAVANNA_TERRACE = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new SavannaTerraceBiomeUA(), "savanna_terrace", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.RARE);
        BADLANDS = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new BadlandsBiomeUA(), "badlands", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SANDY);
        WOODED_BADLANDS = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new BadlandsWoodedBiomeUA(), "wooded_badlands", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SPARSE);
        SANDLESS_BADLANDS = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new BadlandsSandlessBiomeUA(), "sandless_badlands", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SANDY);
        SUNFLOWER_PLAINS = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new SunflowerPlainsBiomeUA(), "sunflower_plains", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.RARE);
        DESERT_LAKES = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new DesertLakesBiomeUA(), "desert_lakes", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.RARE);
        GRAVELLY_FIELD = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new GravellyFieldBiomeUA(), "gravelly_field", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.RARE);
        FLOWER_FOREST = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new FlowerForestBiomeUA(), "flower_forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        ROCKY_TAIGA = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new TaigaRockyBiomeUA(), "rocky_taiga", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        SPOOKY_SWAMP = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new SwampSpookyBiomeUA(), "spooky_swampland", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        ICE_SPIKES = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new IceSpikesBiomeUA(), "ice_spikes", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        FLOWER_JUNGLE = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new FlowerJungleBiomeUA(), "flower_jungle", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE, BiomeDictionary.Type.DENSE);
        FLOWER_JUNGLE_EDGE = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new FlowerJungleEdgeBiomeUA(), "flower_jungle_edge", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.RARE);
        TALL_BIRCH_FOREST = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new TallBirchForestBiomeUA(), "tall_birch_forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        RELIC_TALL_BIRCH_FOREST = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new TallBirchForestRelicBiomeUA(), "relic_tall_birch_forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        RELIC_DARK_FOREST = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new DarkForestRelicBiomeUA(), "relic_dark_forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        SNOWY_ROCKY_TAIGA = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new SnowyTaigaRockyBiomeUA(), "snowy_rocky_taiga", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE);
        GIANT_SPRUCE_TAIGA_PILLARS = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new GiantSpruceTaigaPillarsBiomeUA(), "giant_spruce_taiga_pillars", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE);
        RELIC_GIANT_SPRUCE_TAIGA_PILLARS = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new GiantSpruceTaigaRelicPillarsBiomeUA(), "relic_giant_spruce_taiga_pillars", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        GRAVELLY_COLUMNS_FIELD = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new GravellyColumnsFieldBiomeUA(), "gravelly_columns_field", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.RARE);
        SHATTERED_SAVANNA = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new ShatteredSavannaBiomeUA(), "shattered_savanna", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        SHATTERED_SAVANNA_TERRACE = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new ShatteredSavannaTerraceBiomeUA(), "shattered_savanna_terrace", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        SPIKY_BADLANDS = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new BadlandsSpikyBiomeUA(), "spiky_badlands", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MESA, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        DENSED_WOODED_BADLANDS = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new BadlandsDensedWoodedBiomeUA(), "densed_wooded_badlands", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MESA, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        DISSECTED_PLATEAU_BADLANDS = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new BadlandsDissectedPlateauBiomeUA(), "dissected_plateau_badlands", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MESA, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        COLD_OCEAN = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new OceanColdBiomeUA(), "cold_ocean", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OCEAN);
        DEEP_COLD_OCEAN = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new OceanDeepColdBiomeUA(), "deep_cold_ocean", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.COLD);
        DEEP_FROZEN_OCEAN = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new OceanDeepFrozenBiomeUA(), "deep_frozen_ocean", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.COLD);
        DEEP_LUKEWARM_OCEAN = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new OceanDeepLukewarmBiomeUA(), "deep_lukewarm_ocean", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OCEAN);
        DEEP_OCEAN = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new OceanDeepBiomeUA(), "deep_ocean", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OCEAN);
        DEEP_WARM_OCEAN = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new OceanDeepWarmBiomeUA(), "deep_warm_ocean", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.HOT);
        FROZEN_OCEAN = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new OceanFrozenBiomeUA(), "frozen_ocean", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.COLD);
        LUKEWARM_OCEAN = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new OceanLukewarmBiomeUA(), "lukewarm_ocean", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OCEAN);
        OCEAN = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new OceanBiomeUA(), "ocean", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OCEAN);
        WARM_OCEAN = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new OceanWarmBiomeUA(), "warm_ocean", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.HOT);
        BARREN_END_FIELD = UABiomes.initBiome((IForgeRegistry<Biome>)registry, new EndBarrenFieldBiomeUA(), "barren_end_field", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.END, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY);
        UABiomes.mapHillsBiomes();
        UABiomes.mapMBiomes();
        allRegisteredBiomes = ImmutableSet.of((Object)PLAINS, (Object)DESERT, (Object)ROCKY_FIELD, (Object)FOREST, (Object)TAIGA, (Object)SWAMP, (Object[])new Biome[]{NETHERLAND, END_FIELD, SNOWY_TUNDRA, ICED_TERRAIN, MUSHROOM_FIELDS, RELIC_DESERT, RELIC_FOREST, RELIC_TAIGA, BAMBOO_JUNGLE, RELIC_BAMBOO_JUNGLE, JUNGLE, RELIC_JUNGLE, JUNGLE_EDGE, STONE_PLAINS, FROZEN_DESERT, BIRCH_FOREST, RELIC_BIRCH_FOREST, DARK_FOREST, SNOWY_TAIGA, RELIC_SNOWY_TAIGA, GIANT_TREE_TAIGA, RELIC_GIANT_TREE_TAIGA, WOODED_ROCKY_FIELD, SAVANNA, SAVANNA_TERRACE, BADLANDS, WOODED_BADLANDS, SANDLESS_BADLANDS, SUNFLOWER_PLAINS, DESERT_LAKES, GRAVELLY_FIELD, FLOWER_FOREST, ROCKY_TAIGA, SPOOKY_SWAMP, ICE_SPIKES, FLOWER_JUNGLE, FLOWER_JUNGLE_EDGE, TALL_BIRCH_FOREST, RELIC_TALL_BIRCH_FOREST, RELIC_DARK_FOREST, SNOWY_ROCKY_TAIGA, GIANT_SPRUCE_TAIGA_PILLARS, RELIC_GIANT_SPRUCE_TAIGA_PILLARS, GRAVELLY_COLUMNS_FIELD, SHATTERED_SAVANNA, SHATTERED_SAVANNA_TERRACE, SPIKY_BADLANDS, DENSED_WOODED_BADLANDS, DISSECTED_PLATEAU_BADLANDS, FROZEN_OCEAN, COLD_OCEAN, OCEAN, LUKEWARM_OCEAN, WARM_OCEAN, DEEP_FROZEN_OCEAN, DEEP_COLD_OCEAN, DEEP_OCEAN, DEEP_LUKEWARM_OCEAN, DEEP_WARM_OCEAN, BARREN_END_FIELD});
    }

    private static Biome initBiome(IForgeRegistry<Biome> registry, Biome biome, String name, BiomeManager.BiomeType biomeType, BiomeDictionary.Type ... types) {
        RegUtil.register(registry, biome, name);
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        return biome;
    }

    public static Set<Biome> getRegisteredBiomeArray() {
        return allRegisteredBiomes;
    }

    public static void mapMBiomes() {
        BASE_TO_MUTATION_MAP.clear();
        BASE_TO_MUTATION_MAP.put(PLAINS, SUNFLOWER_PLAINS);
        BASE_TO_MUTATION_MAP.put(DESERT, DESERT_LAKES);
        BASE_TO_MUTATION_MAP.put(BIRCH_FOREST, TALL_BIRCH_FOREST);
        BASE_TO_MUTATION_MAP.put(RELIC_BIRCH_FOREST, RELIC_TALL_BIRCH_FOREST);
        BASE_TO_MUTATION_MAP.put(SNOWY_TAIGA, SNOWY_ROCKY_TAIGA);
        BASE_TO_MUTATION_MAP.put(ROCKY_FIELD, GRAVELLY_FIELD);
        BASE_TO_MUTATION_MAP.put(WOODED_ROCKY_FIELD, GRAVELLY_COLUMNS_FIELD);
        BASE_TO_MUTATION_MAP.put(FOREST, FLOWER_FOREST);
        BASE_TO_MUTATION_MAP.put(JUNGLE, FLOWER_JUNGLE);
        BASE_TO_MUTATION_MAP.put(JUNGLE_EDGE, FLOWER_JUNGLE_EDGE);
        BASE_TO_MUTATION_MAP.put(WOODED_BADLANDS, DENSED_WOODED_BADLANDS);
        BASE_TO_MUTATION_MAP.put(GIANT_TREE_TAIGA, GIANT_SPRUCE_TAIGA_PILLARS);
        BASE_TO_MUTATION_MAP.put(RELIC_GIANT_TREE_TAIGA, RELIC_GIANT_SPRUCE_TAIGA_PILLARS);
        BASE_TO_MUTATION_MAP.put(DARK_FOREST, RELIC_DARK_FOREST);
        BASE_TO_MUTATION_MAP.put(SAVANNA, SHATTERED_SAVANNA);
        BASE_TO_MUTATION_MAP.put(SAVANNA_TERRACE, SHATTERED_SAVANNA_TERRACE);
        BASE_TO_MUTATION_MAP.put(SWAMP, SPOOKY_SWAMP);
        BASE_TO_MUTATION_MAP.put(TAIGA, ROCKY_TAIGA);
        if (UltraAmplified.UABiomesConfig.iceSpike.get().booleanValue()) {
            BASE_TO_MUTATION_MAP.put(SNOWY_TUNDRA, ICE_SPIKES);
        }
        if (UltraAmplified.UABiomesConfig.spikyBadlands.get().booleanValue()) {
            BASE_TO_MUTATION_MAP.put(SANDLESS_BADLANDS, DISSECTED_PLATEAU_BADLANDS);
            BASE_TO_MUTATION_MAP.put(BADLANDS, SPIKY_BADLANDS);
        }
    }

    private static void mapHillsBiomes() {
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)DESERT), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_DESERT));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)FOREST), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_FOREST));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)TAIGA), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_TAIGA));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)BAMBOO_JUNGLE), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_BAMBOO_JUNGLE));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)JUNGLE), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_JUNGLE));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)BIRCH_FOREST), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_BIRCH_FOREST));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)SNOWY_TAIGA), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_SNOWY_TAIGA));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)GIANT_TREE_TAIGA), BiomeRegistry.getID((IForgeRegistryEntry)RELIC_GIANT_TREE_TAIGA));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)ROCKY_FIELD), BiomeRegistry.getID((IForgeRegistryEntry)WOODED_ROCKY_FIELD));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)SAVANNA), BiomeRegistry.getID((IForgeRegistryEntry)SAVANNA_TERRACE));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_OCEAN));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)COLD_OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_COLD_OCEAN));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)FROZEN_OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_FROZEN_OCEAN));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)LUKEWARM_OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_LUKEWARM_OCEAN));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)WARM_OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_WARM_OCEAN));
    }

    static {
        BASE_TO_MUTATION_MAP = new HashMap<Biome, Biome>();
        BASE_TO_HILLS_MAP = new HashMap<Integer, Integer>();
    }
}

