/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.biome.surfacebuilder;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class SandSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final BlockState ICE = Blocks.field_150432_aD.func_176223_P();
    private static final BlockState RED_SANDSTONE = Blocks.field_180395_cM.func_176223_P();
    private static final BlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();

    public SandSurfaceBuilder(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> p_i51310_1_) {
        super(p_i51310_1_);
    }

    public void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        this.buildSurface(random, chunk, biome, x, z, startHeight, noise, defaultBlock, defaultFluid, config.func_204108_a(), config.func_204109_b(), config.func_204110_c(), seaLevel);
    }

    protected void buildSurface(Random random, IChunk chunk, Biome biome, int xStart, int zStart, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, BlockState topBlock, BlockState middleBlock, BlockState bottomBlock, int seaLevel) {
        BlockState topBlockstate = topBlock;
        BlockState bottomBlockstate = middleBlock;
        int bottomLayerNoise = -1;
        int noiseModified = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        int x = xStart & 0xF;
        int z = zStart & 0xF;
        BlockPos.Mutable blockPosMutable = new BlockPos.Mutable(x, startHeight, z);
        while (blockPosMutable.func_177956_o() >= 0) {
            BlockState currentBlock = chunk.func_180495_p((BlockPos)blockPosMutable);
            if (bottomLayerNoise != -1 && currentBlock.func_185904_a() == Material.field_151579_a) {
                bottomLayerNoise = -1;
            } else if (currentBlock.func_177230_c() == defaultBlock.func_177230_c()) {
                if (bottomLayerNoise == -1) {
                    if (noiseModified <= 0) {
                        topBlockstate = AIR;
                        bottomBlockstate = defaultBlock;
                    } else if (blockPosMutable.func_177956_o() >= seaLevel - 4 && blockPosMutable.func_177956_o() <= seaLevel + 1) {
                        topBlockstate = topBlock;
                        bottomBlockstate = middleBlock;
                    }
                    if (blockPosMutable.func_177956_o() < seaLevel && topBlockstate.func_185904_a() == Material.field_151579_a) {
                        topBlockstate = biome.func_225486_c((BlockPos)blockPosMutable.func_181079_c(xStart, blockPosMutable.func_177956_o(), zStart)) < 0.15f ? ICE : defaultFluid;
                        blockPosMutable.func_181079_c(x, blockPosMutable.func_177956_o(), z);
                    }
                    bottomLayerNoise = noiseModified;
                    if (blockPosMutable.func_177956_o() >= seaLevel - 1) {
                        chunk.func_177436_a((BlockPos)blockPosMutable, topBlockstate, false);
                        SandSurfaceBuilder.reinforceLedges(chunk, blockPosMutable, bottomBlock);
                    } else if (blockPosMutable.func_177956_o() < seaLevel - 7 - noiseModified) {
                        topBlockstate = AIR;
                        bottomBlockstate = defaultBlock;
                        chunk.func_177436_a((BlockPos)blockPosMutable, bottomBlock, false);
                    } else {
                        chunk.func_177436_a((BlockPos)blockPosMutable, bottomBlockstate, false);
                        SandSurfaceBuilder.reinforceLedges(chunk, blockPosMutable, bottomBlock);
                    }
                } else if (bottomLayerNoise > 0) {
                    chunk.func_177436_a((BlockPos)blockPosMutable, bottomBlockstate, false);
                    SandSurfaceBuilder.reinforceLedges(chunk, blockPosMutable, bottomBlock);
                    if (--bottomLayerNoise == 0 && bottomBlockstate.func_177230_c() == Blocks.field_150354_m && noiseModified > 1) {
                        bottomLayerNoise = random.nextInt(4) + Math.max(0, blockPosMutable.func_177956_o() - seaLevel);
                        bottomBlockstate = bottomBlockstate.func_177230_c() == Blocks.field_196611_F ? RED_SANDSTONE : SANDSTONE;
                    }
                }
            }
            blockPosMutable.func_189536_c(Direction.DOWN);
        }
    }

    private static void reinforceLedges(IChunk chunk, BlockPos.Mutable blockPosMutable, BlockState bottomBlock) {
        if (blockPosMutable.func_177956_o() < 256 && blockPosMutable.func_177956_o() > 0) {
            Material materialAbove = chunk.func_180495_p(blockPosMutable.func_177984_a()).func_185904_a();
            Material materialBelow = chunk.func_180495_p(blockPosMutable.func_177977_b()).func_185904_a();
            if (materialBelow == Material.field_151579_a) {
                if (materialAbove == Material.field_151595_p) {
                    chunk.func_177436_a((BlockPos)blockPosMutable, bottomBlock, false);
                } else if (materialAbove == Material.field_151579_a) {
                    chunk.func_177436_a((BlockPos)blockPosMutable, AIR, false);
                }
            }
        }
    }
}

