/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.dimension;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.telepathicgrunt.ultraamplified.world.dimension.UADimension;
import net.telepathicgrunt.ultraamplified.world.dimension.UADimensionRegistration;

public class TimeSyncNetworkPacket {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel DEFAULT_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("ultra_amplified_dimension", "networking"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        int channelID = -1;
        DEFAULT_CHANNEL.registerMessage(++channelID, UpdateTimePacket.class, UpdateTimePacket::compose, UpdateTimePacket::parse, UpdateTimePacket.Handler::handle);
    }

    public static class UpdateTimePacket {
        private long time = 0L;

        public static void sendToClient(long timeIn) {
            DEFAULT_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateTimePacket(timeIn));
        }

        public UpdateTimePacket(long timeIn) {
            this.time = timeIn;
        }

        public static UpdateTimePacket parse(PacketBuffer buf) {
            return new UpdateTimePacket(buf.readLong());
        }

        public static void compose(UpdateTimePacket pkt, PacketBuffer buf) {
            buf.writeLong(pkt.time);
        }

        public static class Handler {
            public static void handle(UpdateTimePacket pkt, Supplier<NetworkEvent.Context> ctx) {
                Minecraft.func_71410_x().func_213165_a(() -> {
                    ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                    if (world.func_201675_m().func_186058_p() == UADimensionRegistration.ultraamplified()) {
                        ((UADimension)world.func_201675_m()).setWorldTimeClientSided(pkt.time);
                    }
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }
}

