/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.telepathicgrunt.ultraamplified.blocks.CactusBodyBlockUA;
import net.telepathicgrunt.ultraamplified.blocks.CactusCornerBlockUA;
import net.telepathicgrunt.ultraamplified.blocks.CactusMainBlockUA;
import net.telepathicgrunt.ultraamplified.blocks.UABlocks;

public class BetterCactus
extends Feature<NoFeatureConfig> {
    private final int height = 9;

    public BetterCactus(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> p_212245_2_, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        BlockPos blockpos = position.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
        if (world.func_175623_d(blockpos) && world.func_180495_p(blockpos.func_177977_b()).func_203425_a(BlockTags.field_203436_u)) {
            int maxHeight = 9 + rand.nextInt(2);
            int frontSideHeight = 2 + rand.nextInt(maxHeight - 4);
            int backSideHeight = 2 + rand.nextInt(maxHeight - 4);
            Direction cactusFacing = Direction.func_176731_b((int)rand.nextInt(4));
            for (int currentHeight = 0; currentHeight < maxHeight && world.func_175623_d(blockpos.func_177981_b(currentHeight)); ++currentHeight) {
                if (blockpos.func_177981_b(currentHeight).func_177956_o() <= 254 && (currentHeight == frontSideHeight || currentHeight == backSideHeight)) {
                    if (frontSideHeight == backSideHeight) {
                        world.func_180501_a(blockpos.func_177981_b(currentHeight), (BlockState)((Block)UABlocks.CACTUSBODYBLOCKUA.get()).func_176223_P().func_206870_a((IProperty)CactusBodyBlockUA.FACING, (Comparable)cactusFacing), 18);
                    } else {
                        world.func_180501_a(blockpos.func_177981_b(currentHeight), (BlockState)((Block)UABlocks.CACTUSCORNERBLOCKUA.get()).func_176223_P().func_206870_a((IProperty)CactusCornerBlockUA.FACING, (Comparable)(currentHeight == frontSideHeight ? cactusFacing.func_176734_d() : cactusFacing)), 18);
                    }
                    if (currentHeight == frontSideHeight) {
                        this.createBranch(world, rand, blockpos.func_177981_b(currentHeight), cactusFacing, rand.nextInt(maxHeight - frontSideHeight - 2) + 2);
                    }
                    if (currentHeight != backSideHeight) continue;
                    this.createBranch(world, rand, blockpos.func_177981_b(currentHeight), cactusFacing.func_176734_d(), rand.nextInt(maxHeight - backSideHeight - 2) + 2);
                    continue;
                }
                world.func_180501_a(blockpos.func_177981_b(currentHeight), (BlockState)((Block)UABlocks.CACTUSMAINBLOCKUA.get()).func_176223_P().func_206870_a((IProperty)CactusMainBlockUA.FACING, (Comparable)Direction.UP), 18);
            }
        }
        return true;
    }

    private void createBranch(IWorld world, Random rand, BlockPos position, Direction branchDirection, int maxHeightUp) {
        if (!world.func_175623_d(position = position.func_177972_a(branchDirection))) {
            return;
        }
        world.func_180501_a(position, (BlockState)((Block)UABlocks.CACTUSMAINBLOCKUA.get()).func_176223_P().func_206870_a((IProperty)CactusMainBlockUA.FACING, (Comparable)branchDirection), 18);
        position = position.func_177972_a(branchDirection);
        if (!world.func_175623_d(position)) {
            return;
        }
        world.func_180501_a(position, (BlockState)((Block)UABlocks.CACTUSCORNERBLOCKUA.get()).func_176223_P().func_206870_a((IProperty)CactusCornerBlockUA.FACING, (Comparable)branchDirection), 18);
        for (int currentHeight = 1; currentHeight < maxHeightUp && position.func_177981_b(currentHeight).func_177956_o() <= world.getMaxHeight(); ++currentHeight) {
            if (!world.func_175623_d(position.func_177981_b(currentHeight))) {
                return;
            }
            world.func_180501_a(position.func_177981_b(currentHeight), (BlockState)((Block)UABlocks.CACTUSMAINBLOCKUA.get()).func_176223_P().func_206870_a((IProperty)CactusMainBlockUA.FACING, (Comparable)Direction.UP), 18);
        }
    }
}

