/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.telepathicgrunt.ultraamplified.world.biome.UABiomes;

public class ContainUndergroundLiquids
extends Feature<NoFeatureConfig> {
    protected BlockState replacementBlock = Blocks.field_150348_b.func_176223_P();
    protected static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    protected static final Block CAVE_AIR = Blocks.field_201941_jj;
    private static Map<Biome, BlockState> fillerBiomeMap;

    public ContainUndergroundLiquids(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public static void setFillerMap() {
        if (fillerBiomeMap == null) {
            fillerBiomeMap = new HashMap<Biome, BlockState>();
            fillerBiomeMap.put(UABiomes.NETHERLAND, Blocks.field_150424_aL.func_176223_P());
            fillerBiomeMap.put(UABiomes.ICED_TERRAIN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(UABiomes.ICE_SPIKES, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(UABiomes.DEEP_FROZEN_OCEAN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(UABiomes.FROZEN_OCEAN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(UABiomes.BARREN_END_FIELD, Blocks.field_150377_bs.func_176223_P());
            fillerBiomeMap.put(UABiomes.END_FIELD, Blocks.field_150377_bs.func_176223_P());
        }
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkSettings, Random random, BlockPos position, NoFeatureConfig configBlock) {
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position.func_177958_n(), 0, position.func_177952_p());
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                blockpos$Mutable.func_181079_c(position.func_177958_n() + x, 61, position.func_177952_p() + z);
                while (blockpos$Mutable.func_177956_o() > 10) {
                    BlockState currentblock = world.func_180495_p((BlockPos)blockpos$Mutable);
                    while (currentblock.func_204520_s().func_206888_e() && blockpos$Mutable.func_177956_o() > 10) {
                        currentblock = world.func_180495_p((BlockPos)blockpos$Mutable.func_189536_c(Direction.DOWN));
                    }
                    if (blockpos$Mutable.func_177956_o() <= 10) continue block1;
                    for (Direction face : Direction.Plane.HORIZONTAL) {
                        blockpos$Mutable.func_189536_c(face);
                        currentblock = world.func_180495_p((BlockPos)blockpos$Mutable);
                        if (currentblock.func_177230_c() == CAVE_AIR) {
                            this.replacementBlock = fillerBiomeMap.get(world.func_226691_t_((BlockPos)blockpos$Mutable));
                            if (this.replacementBlock == null) {
                                this.replacementBlock = STONE;
                            }
                            world.func_180501_a((BlockPos)blockpos$Mutable, this.replacementBlock, 2);
                        }
                        blockpos$Mutable.func_189536_c(face.func_176734_d());
                    }
                    for (Direction face : Direction.Plane.VERTICAL) {
                        blockpos$Mutable.func_189536_c(face);
                        currentblock = world.func_180495_p((BlockPos)blockpos$Mutable);
                        if (currentblock.func_177230_c() == CAVE_AIR) {
                            this.replacementBlock = fillerBiomeMap.get(world.func_226691_t_((BlockPos)blockpos$Mutable));
                            if (this.replacementBlock == null) {
                                this.replacementBlock = STONE;
                            }
                            world.func_180501_a((BlockPos)blockpos$Mutable, this.replacementBlock, 2);
                        }
                        blockpos$Mutable.func_189536_c(face.func_176734_d());
                    }
                    blockpos$Mutable.func_189536_c(Direction.DOWN);
                }
            }
        }
        return true;
    }
}

