/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.storage.loot.LootTables;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DungeonNether
extends Feature<NoFeatureConfig> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();

    public DungeonNether(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        int z;
        int y;
        int x;
        int randXRange = rand.nextInt(2) + 2;
        int xMin = -randXRange - 1;
        int xMax = randXRange + 1;
        int randZRange = rand.nextInt(2) + 2;
        int zMin = -randZRange - 1;
        int zMax = randZRange + 1;
        int validOpenings = 0;
        int ceilingOpenings = 0;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position);
        for (x = xMin; x <= xMax; ++x) {
            for (y = -1; y <= 4; ++y) {
                for (z = zMin; z <= zMax; ++z) {
                    blockpos$Mutable.func_189533_g((Vec3i)position).func_196234_d(x, y, z);
                    Material material = world.func_180495_p((BlockPos)blockpos$Mutable).func_185904_a();
                    boolean flag = material.func_76220_a();
                    if (y == -1 && !flag) {
                        return false;
                    }
                    if (y == 4 && !flag) {
                        ++ceilingOpenings;
                    }
                    if (x != xMin && x != xMax && z != zMin && z != zMax || y != 0 || !world.func_175623_d((BlockPos)blockpos$Mutable) && world.func_180495_p((BlockPos)blockpos$Mutable).func_185904_a() != Material.field_151587_i || !world.func_175623_d(blockpos$Mutable.func_177984_a()) && world.func_180495_p(blockpos$Mutable.func_177984_a()).func_185904_a() != Material.field_151587_i) continue;
                    ++validOpenings;
                }
            }
        }
        if (validOpenings >= 1 && validOpenings <= 14 && ceilingOpenings < 14) {
            for (x = xMin; x <= xMax; ++x) {
                for (y = 3; y >= -1; --y) {
                    for (z = zMin; z <= zMax; ++z) {
                        blockpos$Mutable.func_189533_g((Vec3i)position).func_196234_d(x, y, z);
                        if (x != xMin && y != -1 && z != zMin && x != xMax && y != 4 && z != zMax) {
                            if (world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150486_ae || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150474_ac) continue;
                            world.func_180501_a((BlockPos)blockpos$Mutable, CAVE_AIR, 2);
                            continue;
                        }
                        if (blockpos$Mutable.func_177956_o() >= 0 && !world.func_180495_p(blockpos$Mutable.func_177977_b()).func_185904_a().func_76220_a()) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, CAVE_AIR, 2);
                            continue;
                        }
                        if (x == xMin || z == zMin || x == xMax || y == 4 || !world.func_180495_p((BlockPos)blockpos$Mutable).func_185904_a().func_76220_a() || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150486_ae || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150474_ac) continue;
                        if (y == -1 && rand.nextInt(4) != 0) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_196575_bC.func_176223_P(), 2);
                            continue;
                        }
                        world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_196653_dH.func_176223_P(), 2);
                    }
                }
            }
            block6: for (int l3 = rand.nextInt(3); l3 < 3; ++l3) {
                for (int j4 = 0; j4 < 3; ++j4) {
                    int x2 = position.func_177958_n() + rand.nextInt(randXRange * 2 + 1) - randXRange;
                    int y2 = position.func_177956_o();
                    int z2 = position.func_177952_p() + rand.nextInt(randZRange * 2 + 1) - randZRange;
                    blockpos$Mutable.func_181079_c(x2, y2, z2);
                    if (!world.func_175623_d((BlockPos)blockpos$Mutable)) continue;
                    int j3 = 0;
                    for (Direction Direction2 : Direction.Plane.HORIZONTAL) {
                        if (!world.func_180495_p(blockpos$Mutable.func_177972_a(Direction2)).func_185904_a().func_76220_a()) continue;
                        ++j3;
                    }
                    if (j3 != true) continue;
                    world.func_180501_a((BlockPos)blockpos$Mutable, StructurePiece.func_197528_a((IBlockReader)world, (BlockPos)blockpos$Mutable, (BlockState)Blocks.field_150486_ae.func_176223_P()), 2);
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)blockpos$Mutable, (ResourceLocation)LootTables.field_186421_c);
                    world.func_180501_a(blockpos$Mutable.func_177977_b(), Blocks.field_196653_dH.func_176223_P(), 2);
                    continue block6;
                }
            }
            world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 2);
            world.func_180501_a(position, Blocks.field_150474_ac.func_176223_P(), 2);
            world.func_180501_a(position.func_177977_b(), Blocks.field_196653_dH.func_176223_P(), 2);
            TileEntity tileentity = world.func_175625_s(position);
            if (tileentity instanceof MobSpawnerTileEntity) {
                ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(this.pickMobSpawner(world, rand, position));
            } else {
                LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
            }
            return true;
        }
        return false;
    }

    private EntityType<?> pickMobSpawner(IWorld world, Random rand, BlockPos position) {
        int roll = rand.nextInt(100);
        if (roll < 48) {
            return EntityType.field_200785_Y;
        }
        if (roll < 73) {
            return EntityType.field_200792_f;
        }
        if (roll < 98) {
            return EntityType.field_200771_K;
        }
        return EntityType.field_200722_aA;
    }
}

