/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.telepathicgrunt.ultraamplified.UltraAmplified;

public class HangingRuins
extends Feature<NoFeatureConfig> {
    public HangingRuins(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        TemplateManager templatemanager;
        Template template;
        if (!UltraAmplified.UAStructuresConfig.miniStructureGeneration.get().booleanValue() || position.func_177956_o() < UltraAmplified.UATerrainConfig.seaLevel.get() + 5) {
            return false;
        }
        Rotation rot = Rotation.values()[rand.nextInt(Rotation.values().length)];
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position);
        BlockPos.Mutable offset = new BlockPos.Mutable();
        BlockState currentBlock = world.func_180495_p((BlockPos)blockpos$Mutable);
        while ((BlockTags.field_200031_h.func_199685_a_((Object)currentBlock.func_177230_c()) || !currentBlock.func_200132_m()) && blockpos$Mutable.func_177956_o() < world.getMaxHeight()) {
            blockpos$Mutable.func_189536_c(Direction.UP);
            currentBlock = world.func_180495_p((BlockPos)blockpos$Mutable);
        }
        if (blockpos$Mutable.func_177956_o() == world.getMaxHeight()) {
            return false;
        }
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                if (Math.abs(x * z) <= 9 || Math.abs(x * z) >= 20) continue;
                offset.func_181079_c(x - 4, 0, z - 4).func_189533_g((Vec3i)offset.func_190942_a(rot));
                if (world.func_180495_p(blockpos$Mutable.func_177982_a(-offset.func_177958_n() + 4, 1, -offset.func_177952_p() + 4)).func_200132_m()) continue;
                return false;
            }
        }
        if (this.shouldMoveDownOne(world, blockpos$Mutable, offset, rot)) {
            blockpos$Mutable.func_189536_c(Direction.DOWN);
        }
        if ((template = (templatemanager = ((ServerWorld)world.func_201672_e()).func_217485_w().func_186340_h()).func_200219_b(new ResourceLocation("ultra_amplified_dimension:hanging_ruins"))) == null) {
            UltraAmplified.LOGGER.warn("hanging ruins NTB does not exist!");
            return false;
        }
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(rot).func_186222_a(false).func_186218_a((ChunkPos)null);
        template.func_189962_a(world, (BlockPos)blockpos$Mutable.func_196234_d(4, -8, 4), placementsettings, 2);
        return true;
    }

    private boolean shouldMoveDownOne(IWorld world, BlockPos.Mutable blockpos$Mutable, BlockPos.Mutable offset, Rotation rot) {
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                offset.func_181079_c(x - 4, 0, z - 4).func_189533_g((Vec3i)offset.func_190942_a(rot));
                if (Math.abs(x * z) >= 20 || world.func_180495_p(blockpos$Mutable.func_177982_a(-offset.func_177958_n() + 4, 2, -offset.func_177952_p() + 4)).func_200132_m()) continue;
                return true;
            }
        }
        return false;
    }
}

