/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.telepathicgrunt.ultraamplified.UltraAmplified;

public class IceSpike
extends Feature<NoFeatureConfig> {
    protected static final Set<BlockState> ALLOWED_BLOCKS = ImmutableSet.of((Object)Blocks.field_150350_a.func_176223_P(), (Object)Blocks.field_201941_jj.func_176223_P(), (Object)Blocks.field_150432_aD.func_176223_P(), (Object)Blocks.field_150403_cj.func_176223_P(), (Object)Blocks.field_150433_aE.func_176223_P(), (Object)Blocks.field_196604_cC.func_176223_P(), (Object[])new BlockState[]{Blocks.field_150346_d.func_176223_P(), Blocks.field_196660_k.func_176223_P(), Blocks.field_150355_j.func_176223_P()});
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final BlockState ICE = Blocks.field_150432_aD.func_176223_P();
    private static final BlockState PACKED_ICE = Blocks.field_150403_cj.func_176223_P();

    public IceSpike(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        if (world.func_180495_p(position).func_177230_c() != Blocks.field_196604_cC) {
            return false;
        }
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable(position);
        mutableBlockPos.func_189534_c(Direction.UP, rand.nextInt(4));
        int headHeightOffset = rand.nextInt(4) + 7;
        int tailWidthOffset = headHeightOffset / 4 + rand.nextInt(2);
        int finalHeight = 0;
        if (tailWidthOffset > 1 && rand.nextInt(40) == 0) {
            if (mutableBlockPos.func_177956_o() + 130 > 245) {
                mutableBlockPos.func_189534_c(Direction.UP, 245 - mutableBlockPos.func_177956_o());
            } else {
                mutableBlockPos.func_189534_c(Direction.UP, 30 + rand.nextInt(100));
            }
        }
        finalHeight = mutableBlockPos.func_177956_o();
        for (int y = 0; y < headHeightOffset; ++y) {
            float maxWidth = (1.0f - (float)y / (float)headHeightOffset) * (float)tailWidthOffset;
            int range = MathHelper.func_76123_f((float)maxWidth);
            for (int x = -range; x <= range; ++x) {
                float xWidth = (float)MathHelper.func_76130_a((int)x) - 0.25f;
                for (int z = -range; z <= range; ++z) {
                    float zWidth = (float)MathHelper.func_76130_a((int)z) - 0.25f;
                    if ((x != 0 || z != 0) && !(xWidth * xWidth + zWidth * zWidth <= maxWidth * maxWidth) || (x == -range || x == range || z == -range || z == range) && !(rand.nextFloat() <= 0.75f)) continue;
                    BlockPos topPos = mutableBlockPos.func_177982_a(x, y, z);
                    BlockPos bottomPos = mutableBlockPos.func_177982_a(x, -y, z);
                    BlockState iblockstate = world.func_180495_p(topPos);
                    if (ALLOWED_BLOCKS.contains(iblockstate) && topPos.func_177956_o() > UltraAmplified.UATerrainConfig.seaLevel.get() - 2) {
                        this.func_202278_a((IWorldWriter)world, topPos, PACKED_ICE);
                    } else if (iblockstate == WATER) {
                        this.func_202278_a((IWorldWriter)world, topPos, ICE);
                    }
                    if (y == 0 || range <= 1) continue;
                    iblockstate = world.func_180495_p(bottomPos);
                    if (ALLOWED_BLOCKS.contains(iblockstate) && bottomPos.func_177956_o() > UltraAmplified.UATerrainConfig.seaLevel.get() - 2) {
                        this.func_202278_a((IWorldWriter)world, bottomPos, PACKED_ICE);
                        continue;
                    }
                    if (iblockstate != WATER) continue;
                    this.func_202278_a((IWorldWriter)world, bottomPos, ICE);
                }
            }
        }
        int maxWidth = tailWidthOffset - 1;
        if (maxWidth < 0) {
            maxWidth = 0;
        } else if (maxWidth > 1) {
            maxWidth = 1;
        }
        for (int x = -maxWidth; x <= maxWidth; ++x) {
            for (int z = -maxWidth; z <= maxWidth; ++z) {
                BlockState iblockstate1;
                mutableBlockPos.func_181079_c(position.func_177958_n() + x, finalHeight - 1, position.func_177952_p() + z);
                int randomSkippingHeightValue = 50;
                if (Math.abs(x) == 1 && Math.abs(z) == 1) {
                    randomSkippingHeightValue = rand.nextInt(5);
                }
                while (mutableBlockPos.func_177956_o() > 5 && ALLOWED_BLOCKS.contains(iblockstate1 = world.func_180495_p((BlockPos)mutableBlockPos))) {
                    if (iblockstate1 == WATER || iblockstate1 == ICE) {
                        this.func_202278_a((IWorldWriter)world, (BlockPos)mutableBlockPos, Blocks.field_150432_aD.func_176223_P());
                    } else {
                        this.func_202278_a((IWorldWriter)world, (BlockPos)mutableBlockPos, Blocks.field_150403_cj.func_176223_P());
                    }
                    mutableBlockPos.func_189536_c(Direction.DOWN);
                    if (--randomSkippingHeightValue > 0) continue;
                    mutableBlockPos.func_189534_c(Direction.DOWN, rand.nextInt(5) + 1);
                    randomSkippingHeightValue = rand.nextInt(5);
                }
            }
        }
        return true;
    }
}

