/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class LakeWideShallow
extends Feature<BlockStateFeatureConfig> {
    protected static final Set<Material> unacceptableSolidMaterials = ImmutableSet.of((Object)Material.field_215713_z, (Object)Material.field_215712_y, (Object)Material.field_151584_j, (Object)Material.field_151569_G, (Object)Material.field_151570_A, (Object)Material.field_151574_g, (Object[])new Material[]{Material.field_151572_C, Material.field_151568_F, Material.field_151566_D, Material.field_175972_I, Material.field_151568_F});

    public LakeWideShallow(Function<Dynamic<?>, ? extends BlockStateFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkSettings, Random random, BlockPos position, BlockStateFeatureConfig configBlock) {
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position.func_177979_c(2));
        boolean[] lakeMask = new boolean[2048];
        int maxInterations = random.nextInt(4) + 4;
        for (int currentMaskInteration = 0; currentMaskInteration < maxInterations; ++currentMaskInteration) {
            double rawRandX = random.nextDouble() * 6.0 + 3.0;
            double rawRandZ = random.nextDouble() * 6.0 + 3.0;
            double randX = random.nextDouble() * (16.0 - rawRandX - 2.0) + 1.0 + rawRandX / 2.0;
            double randZ = random.nextDouble() * (16.0 - rawRandZ - 2.0) + 1.0 + rawRandZ / 2.0;
            for (int x = 1; x < 15; ++x) {
                for (int z = 1; z < 15; ++z) {
                    for (int y = 0; y < 5; ++y) {
                        double xMagnetude = ((double)x - randX) / (rawRandX / 2.0);
                        double zMagnetude = ((double)z - randZ) / (rawRandZ / 2.0);
                        double squaredMagnetude = xMagnetude * xMagnetude + zMagnetude * zMagnetude;
                        if (!(squaredMagnetude < 1.2)) continue;
                        lakeMask[(x * 16 + z) * 8 + y] = true;
                    }
                }
            }
        }
        boolean containedFlag = true;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                blockpos$Mutable.func_189533_g((Vec3i)position).func_196234_d(x, y, z);
                BlockState blockState = world.func_180495_p((BlockPos)blockpos$Mutable);
                Material material = blockState.func_185904_a();
                for (y = 5; (!material.func_76220_a() || unacceptableSolidMaterials.contains(material) || BlockTags.field_199898_b.func_199685_a_((Object)blockState.func_177230_c())) && y > 0; --y) {
                    material = world.func_180495_p((BlockPos)blockpos$Mutable.func_189536_c(Direction.DOWN)).func_185904_a();
                }
                containedFlag = this.checkIfValidSpot(world, blockpos$Mutable);
                if (!lakeMask[(x * 16 + z) * 8 + y] || !containedFlag) continue;
                blockState = world.func_180495_p(blockpos$Mutable.func_177977_b());
                if (LakeWideShallow.func_227250_b_((Block)blockState.func_177230_c()) && random.nextInt(5) == 0) {
                    world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_203198_aQ.func_176223_P(), 2);
                } else {
                    world.func_180501_a((BlockPos)blockpos$Mutable, configBlock.field_227270_a_, 2);
                }
                blockState = world.func_180495_p((BlockPos)blockpos$Mutable.func_189536_c(Direction.UP));
                material = blockState.func_185904_a();
                if (material == Material.field_151585_k && blockState.func_177230_c() != Blocks.field_196651_dG) {
                    world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_150350_a.func_176223_P(), 2);
                    while (blockpos$Mutable.func_177956_o() < world.getMaxHeight() && world.func_180495_p((BlockPos)blockpos$Mutable.func_189536_c(Direction.UP)) == Blocks.field_196608_cF.func_176223_P()) {
                        world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
                if (material != Material.field_151582_l || blockState.func_177230_c() == Blocks.field_150395_bd) continue;
                world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_150350_a.func_176223_P(), 2);
                world.func_180501_a(blockpos$Mutable.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
            }
        }
        return true;
    }

    private boolean checkIfValidSpot(IWorld world, BlockPos.Mutable blockpos$Mutable) {
        Material material;
        BlockState blockState;
        for (int x2 = -1; x2 < 2; ++x2) {
            for (int z2 = -1; z2 < 2; ++z2) {
                blockState = world.func_180495_p(blockpos$Mutable.func_177982_a(x2, 0, z2));
                material = blockState.func_185904_a();
                if (material.func_76220_a() && !unacceptableSolidMaterials.contains(material) && !BlockTags.field_199898_b.func_199685_a_((Object)blockState.func_177230_c()) || !blockState.func_204520_s().func_206888_e() || blockState.func_204520_s() == Fluids.field_204546_a) continue;
                return false;
            }
        }
        blockState = world.func_180495_p(blockpos$Mutable.func_177977_b());
        material = blockState.func_185904_a();
        if ((!material.func_76220_a() || unacceptableSolidMaterials.contains(material) || BlockTags.field_199898_b.func_199685_a_((Object)blockState.func_177230_c())) && blockState.func_204520_s().func_206888_e() && blockState.func_204520_s() != Fluids.field_204546_a) {
            return false;
        }
        blockState = world.func_180495_p(blockpos$Mutable.func_177984_a());
        material = blockState.func_185904_a();
        return !material.func_76220_a() && blockState.func_204520_s().func_206888_e() && blockState.func_177230_c() != Blocks.field_150448_aq;
    }
}

