/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.telepathicgrunt.ultraamplified.UltraAmplified;

public class Stonehenge
extends Feature<NoFeatureConfig> {
    private static int perfectStoneCount = 0;
    private static boolean markedForPerfection = false;
    protected static final Set<BlockState> unAcceptableBlocks = ImmutableSet.of((Object)Blocks.field_150350_a.func_176223_P(), (Object)Blocks.field_150355_j.func_176223_P(), (Object)Blocks.field_150353_l.func_176223_P(), (Object)Blocks.field_180399_cE.func_176223_P(), (Object)Blocks.field_201941_jj.func_176223_P());

    public Stonehenge(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        if (!UltraAmplified.UAStructuresConfig.miniStructureGeneration.get().booleanValue() || position.func_177956_o() > 248) {
            return false;
        }
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position);
        if (!this.validatePosition(world, (BlockPos)blockpos$Mutable)) {
            while (blockpos$Mutable.func_177956_o() > UltraAmplified.UATerrainConfig.seaLevel.get()) {
                blockpos$Mutable.func_189536_c(Direction.DOWN);
                if (!world.func_175623_d((BlockPos)blockpos$Mutable)) continue;
            }
            while (blockpos$Mutable.func_177956_o() > UltraAmplified.UATerrainConfig.seaLevel.get()) {
                blockpos$Mutable.func_189536_c(Direction.DOWN);
                if (!world.func_180495_p((BlockPos)blockpos$Mutable).func_200132_m()) continue;
            }
            if (blockpos$Mutable.func_177956_o() <= UltraAmplified.UATerrainConfig.seaLevel.get()) {
                return false;
            }
            if (!this.validatePosition(world, (BlockPos)blockpos$Mutable.func_189536_c(Direction.UP))) {
                return false;
            }
        }
        markedForPerfection = rand.nextInt(15) == 0;
        perfectStoneCount = 0;
        TemplateManager templatemanager = ((ServerWorld)world.func_201672_e()).func_217485_w().func_186340_h();
        BlockState iblockstate = world.func_180495_p((BlockPos)blockpos$Mutable);
        world.func_180501_a((BlockPos)blockpos$Mutable, iblockstate, 3);
        Template template = this.pickStonehengeStyle(StoneHengeType.SIDE, rand, templatemanager);
        if (template == null) {
            UltraAmplified.LOGGER.warn("a side stonehenge NTB does not exist!");
            return false;
        }
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null);
        template.func_186253_b(world, blockpos$Mutable.func_177979_c(2).func_177964_d(11).func_177985_f(2), placementsettings);
        template = this.pickStonehengeStyle(StoneHengeType.SIDE, rand, templatemanager);
        if (template == null) {
            UltraAmplified.LOGGER.warn("a side stonehenge NTB does not exist!");
            return false;
        }
        placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.CLOCKWISE_90).func_186222_a(false).func_186218_a((ChunkPos)null);
        template.func_186253_b(world, blockpos$Mutable.func_177979_c(2).func_177964_d(2).func_177965_g(11), placementsettings);
        template = this.pickStonehengeStyle(StoneHengeType.SIDE, rand, templatemanager);
        if (template == null) {
            UltraAmplified.LOGGER.warn("a side stonehenge NTB does not exist!");
            return false;
        }
        placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.CLOCKWISE_180).func_186222_a(false).func_186218_a((ChunkPos)null);
        template.func_186253_b(world, blockpos$Mutable.func_177979_c(2).func_177970_e(11).func_177965_g(2), placementsettings);
        template = this.pickStonehengeStyle(StoneHengeType.SIDE, rand, templatemanager);
        if (template == null) {
            UltraAmplified.LOGGER.warn("a side stonehenge NTB does not exist!");
            return false;
        }
        placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.COUNTERCLOCKWISE_90).func_186222_a(false).func_186218_a((ChunkPos)null);
        template.func_186253_b(world, blockpos$Mutable.func_177979_c(2).func_177970_e(2).func_177985_f(11), placementsettings);
        template = this.pickStonehengeStyle(StoneHengeType.CORNER, rand, templatemanager);
        if (template == null) {
            UltraAmplified.LOGGER.warn("a corner stonehenge NTB does not exist!");
            return false;
        }
        placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null);
        template.func_186253_b(world, blockpos$Mutable.func_177979_c(2).func_177964_d(9).func_177985_f(9), placementsettings);
        template = this.pickStonehengeStyle(StoneHengeType.CORNER, rand, templatemanager);
        if (template == null) {
            UltraAmplified.LOGGER.warn("a corner stonehenge NTB does not exist!");
            return false;
        }
        placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.CLOCKWISE_90).func_186222_a(false).func_186218_a((ChunkPos)null);
        template.func_186253_b(world, blockpos$Mutable.func_177979_c(2).func_177964_d(9).func_177965_g(9), placementsettings);
        template = this.pickStonehengeStyle(StoneHengeType.CORNER, rand, templatemanager);
        if (template == null) {
            UltraAmplified.LOGGER.warn("a corner stonehenge NTB does not exist!");
            return false;
        }
        placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.CLOCKWISE_180).func_186222_a(false).func_186218_a((ChunkPos)null);
        template.func_186253_b(world, blockpos$Mutable.func_177979_c(2).func_177970_e(9).func_177965_g(9), placementsettings);
        template = this.pickStonehengeStyle(StoneHengeType.CORNER, rand, templatemanager);
        if (template == null) {
            UltraAmplified.LOGGER.warn("a corner stonehenge NTB does not exist!");
            return false;
        }
        placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.COUNTERCLOCKWISE_90).func_186222_a(false).func_186218_a((ChunkPos)null);
        template.func_186253_b(world, blockpos$Mutable.func_177979_c(2).func_177970_e(9).func_177985_f(9), placementsettings);
        template = perfectStoneCount == 8 ? templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_dimension:stonehengeperfectcenter")) : templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_dimension:stonehengecenter"));
        if (template == null) {
            UltraAmplified.LOGGER.warn("a center stonehenge NTB does not exist!");
            return false;
        }
        placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null);
        template.func_186253_b(world, blockpos$Mutable.func_177977_b().func_177964_d(2).func_177985_f(2), placementsettings);
        return true;
    }

    private boolean validatePosition(IWorld world, BlockPos position) {
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position);
        for (int x = -10; x <= 10; x += 5) {
            for (int z = -10; z <= 10; z += 5) {
                blockpos$Mutable.func_189533_g((Vec3i)position).func_196234_d(x, 0, z);
                if (Math.abs(x * z) == 100 || !unAcceptableBlocks.contains(world.func_180495_p(blockpos$Mutable.func_177979_c(2))) || !unAcceptableBlocks.contains(world.func_180495_p(blockpos$Mutable.func_177979_c(1))) || !unAcceptableBlocks.contains(world.func_180495_p((BlockPos)blockpos$Mutable))) continue;
                return false;
            }
        }
        return true;
    }

    private Template pickStonehengeStyle(StoneHengeType type, Random rand, TemplateManager templatemanager) {
        int hengeType;
        if (markedForPerfection || rand.nextInt(8 - (perfectStoneCount / 2 + 3)) == 0) {
            ++perfectStoneCount;
            hengeType = 0;
        } else {
            hengeType = rand.nextInt(3) + 1;
        }
        if (type == StoneHengeType.SIDE) {
            if (hengeType == 0) {
                return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_dimension:stonehenge1"));
            }
            if (hengeType == 1) {
                return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_dimension:stonehenge2"));
            }
            if (hengeType == 2) {
                return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_dimension:stonehenge3"));
            }
            return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_dimension:stonehenge4"));
        }
        if (hengeType == 0) {
            return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_dimension:stonehenge5"));
        }
        if (hengeType == 1) {
            return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_dimension:stonehenge6"));
        }
        if (hengeType == 2) {
            return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_dimension:stonehenge7"));
        }
        return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_dimension:stonehenge8"));
    }

    private static enum StoneHengeType {
        SIDE,
        CORNER;

    }
}

