/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.carver;

import com.mojang.datafixers.Dynamic;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.biome.UABiomes;

public class SuperLongRavineCarver
extends WorldCarver<ProbabilityConfig> {
    private final float[] field_202536_i = new float[1024];
    protected static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    protected static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final BlockState LAVA = Blocks.field_150353_l.func_176223_P();
    protected static final BlockState MAGMA = Blocks.field_196814_hQ.func_176223_P();
    protected static final BlockState OBSIDIAN = Blocks.field_150343_Z.func_176223_P();
    protected BlockState fillerBlock = Blocks.field_150348_b.func_176223_P();
    private static Map<BlockState, BlockState> canReplaceMap;
    private static Map<Biome, BlockState> fillerBiomeMap;
    private static Map<Biome, BlockState> lavaFloorBiomeMap;

    public SuperLongRavineCarver(Function<Dynamic<?>, ? extends ProbabilityConfig> p_i49921_1_, int p_i49921_2_) {
        super(p_i49921_1_, p_i49921_2_);
    }

    public static void setFillerMap() {
        if (fillerBiomeMap == null) {
            fillerBiomeMap = new HashMap<Biome, BlockState>();
            fillerBiomeMap.put(UABiomes.NETHERLAND, Blocks.field_150424_aL.func_176223_P());
            fillerBiomeMap.put(UABiomes.ICED_TERRAIN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(UABiomes.ICE_SPIKES, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(UABiomes.DEEP_FROZEN_OCEAN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(UABiomes.FROZEN_OCEAN, Blocks.field_150432_aD.func_176223_P());
            fillerBiomeMap.put(UABiomes.BARREN_END_FIELD, Blocks.field_150377_bs.func_176223_P());
            fillerBiomeMap.put(UABiomes.END_FIELD, Blocks.field_150377_bs.func_176223_P());
        }
    }

    public static void setLavaFloorMap() {
        if (lavaFloorBiomeMap == null) {
            lavaFloorBiomeMap = new HashMap<Biome, BlockState>();
            lavaFloorBiomeMap.put(UABiomes.ICED_TERRAIN, Blocks.field_150343_Z.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.ICE_SPIKES, Blocks.field_196814_hQ.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.RELIC_SNOWY_TAIGA, Blocks.field_196814_hQ.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.SNOWY_ROCKY_TAIGA, Blocks.field_196814_hQ.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.SNOWY_TAIGA, Blocks.field_196814_hQ.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.SNOWY_TUNDRA, Blocks.field_196814_hQ.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.FROZEN_DESERT, Blocks.field_196814_hQ.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.DEEP_FROZEN_OCEAN, Blocks.field_196814_hQ.func_176223_P());
            lavaFloorBiomeMap.put(UABiomes.FROZEN_OCEAN, Blocks.field_196814_hQ.func_176223_P());
        }
    }

    public boolean shouldCarve(Random p_212246_2_, int chunkX, int chunkZ, ProbabilityConfig config) {
        return p_212246_2_.nextFloat() <= (float)UltraAmplified.UAFeaturesConfig.ravineSpawnrate.get().intValue() / 850.0f;
    }

    public boolean func_225555_a_(IChunk region, Function<BlockPos, Biome> biomeBlockPos, Random random, int seaLevel, int chunkX, int chunkZ, int originalX, int originalZ, BitSet mask, ProbabilityConfig config) {
        int i = (this.func_222704_c() * 3 - 1) * 16;
        double xpos = chunkX * 16 + random.nextInt(16);
        double height = random.nextInt(random.nextInt(3) + 3) + 15;
        double zpos = chunkZ * 16 + random.nextInt(16);
        float xzNoise2 = random.nextFloat() * ((float)Math.PI * 2);
        float xzCosNoise = (random.nextFloat() - 0.5f) / 8.0f;
        float widthHeightBase = (random.nextFloat() * 1.3f + random.nextFloat()) * 1.3f;
        int maxIteration = i + random.nextInt(i / 4);
        this.func_202535_a(region, biomeBlockPos, random.nextLong(), random, originalX, originalZ, xpos, height, zpos, widthHeightBase, xzNoise2, xzCosNoise, 0, maxIteration, random.nextDouble() / 2.0 + 0.9, mask);
        return true;
    }

    private void func_202535_a(IChunk world, Function<BlockPos, Biome> biomeBlockPos, long randomSeed, Random random, int mainChunkX, int mainChunkZ, double randomBlockX, double randomBlockY, double randomBlockZ, float widthHeightBase, float xzNoise2, float xzCosNoise, int startIteration, int maxIteration, double heightMultiplier, BitSet mask) {
        float f = 1.0f;
        for (int i = 0; i < 256; ++i) {
            if (i == 0 || random.nextInt(3) == 0) {
                f = 1.0f + random.nextFloat() * random.nextFloat();
            }
            this.field_202536_i[i] = f * f;
        }
        float f4 = 0.0f;
        float f1 = 0.0f;
        for (int j = startIteration; j < maxIteration; ++j) {
            double placementXZBound = 6.0 + (double)(MathHelper.func_76126_a((float)((float)j * (float)Math.PI / (float)maxIteration)) * widthHeightBase);
            double placementYBound = placementXZBound * heightMultiplier;
            placementXZBound *= (double)random.nextFloat() * 0.1 + 0.4;
            placementYBound *= 0.8;
            float f2 = MathHelper.func_76134_b((float)xzCosNoise);
            randomBlockX += (double)(MathHelper.func_76134_b((float)xzNoise2) * f2);
            randomBlockZ += (double)(MathHelper.func_76126_a((float)xzNoise2) * f2);
            xzCosNoise *= 0.5f;
            xzCosNoise += f1 * 0.03f;
            xzNoise2 += f4 * 0.1f;
            f1 *= 0.8f;
            f4 *= 0.5f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 1.5f;
            f4 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 3.0f;
            if (random.nextInt(4) == 0) continue;
            if (!this.func_222702_a(mainChunkX, mainChunkZ, randomBlockX, randomBlockZ, j, maxIteration, widthHeightBase)) {
                return;
            }
            this.carveAtTarget(world, biomeBlockPos, random, mainChunkX, mainChunkZ, randomBlockX, randomBlockY, randomBlockZ, placementXZBound, placementYBound, mask);
        }
    }

    protected boolean carveAtTarget(IChunk world, Function<BlockPos, Biome> biomeBlockPos, Random random, int mainChunkX, int mainChunkZ, double xRange, double yRange, double zRange, double placementXZBound, double placementYBound, BitSet mask) {
        double d0 = mainChunkX * 16 + 8;
        double d1 = mainChunkZ * 16 + 8;
        if (!(xRange < d0 - 16.0 - placementXZBound * 2.0 || zRange < d1 - 16.0 - placementXZBound * 2.0 || xRange > d0 + 16.0 + placementXZBound * 2.0 || zRange > d1 + 16.0 + placementXZBound * 2.0)) {
            int i = Math.max(MathHelper.func_76128_c((double)(xRange - placementXZBound)) - mainChunkX * 16 - 1, 0);
            int j = Math.min(MathHelper.func_76128_c((double)(xRange + placementXZBound)) - mainChunkX * 16 + 1, 16);
            int k = Math.max(MathHelper.func_76128_c((double)(yRange - placementYBound)) - 1, 6);
            int l = Math.min(MathHelper.func_76128_c((double)(yRange + placementYBound)) + 1, this.field_222720_l);
            int i1 = Math.max(MathHelper.func_76128_c((double)(zRange - placementXZBound)) - mainChunkZ * 16 - 1, 0);
            int j1 = Math.min(MathHelper.func_76128_c((double)(zRange + placementXZBound)) - mainChunkZ * 16 + 1, 16);
            if (i <= j && k <= l && i1 <= j1) {
                boolean flag = false;
                BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
                BlockPos.Mutable blockpos$Mutableup = new BlockPos.Mutable();
                BlockPos.Mutable blockpos$Mutabledown = new BlockPos.Mutable();
                for (int k1 = i; k1 < j; ++k1) {
                    int x = k1 + mainChunkX * 16;
                    double xSquaringModified = ((double)x + 0.5 - xRange) / placementXZBound;
                    for (int i2 = i1; i2 < j1; ++i2) {
                        int z = i2 + mainChunkZ * 16;
                        double zSquaringModified = ((double)z + 0.5 - zRange) / placementXZBound;
                        double xzSquaredModified = xSquaringModified * xSquaringModified + zSquaringModified * zSquaringModified;
                        if (!(xzSquaredModified < 1.0)) continue;
                        blockpos$Mutable.func_181079_c(x, 60, z);
                        Biome biome = biomeBlockPos.apply((BlockPos)blockpos$Mutable);
                        this.fillerBlock = fillerBiomeMap.get(biome);
                        if (this.fillerBlock == null) {
                            this.fillerBlock = STONE;
                        }
                        BlockState secondaryFloorBlockstate = lavaFloorBiomeMap.get(biome);
                        for (int y = l; y > k; --y) {
                            double d4 = ((double)(y - 1) + 0.5 - yRange) / placementYBound;
                            if (!(xzSquaredModified * (double)this.field_202536_i[y - 1] + d4 * d4 / 6.0 < 1.0)) continue;
                            blockpos$Mutable.func_181079_c(x, y, z);
                            BlockState currentBlockstate = world.func_180495_p((BlockPos)blockpos$Mutable);
                            blockpos$Mutableup.func_189533_g((Vec3i)blockpos$Mutable).func_189536_c(Direction.UP);
                            blockpos$Mutabledown.func_189533_g((Vec3i)blockpos$Mutable).func_189536_c(Direction.DOWN);
                            BlockState aboveBlockstate = world.func_180495_p((BlockPos)blockpos$Mutableup);
                            if (!this.func_222707_a(currentBlockstate, aboveBlockstate) && !canReplaceMap.containsKey(currentBlockstate)) continue;
                            if (y < 11) {
                                currentBlockstate = LAVA;
                                if (secondaryFloorBlockstate != null) {
                                    if (secondaryFloorBlockstate == OBSIDIAN) {
                                        currentBlockstate = MAGMA;
                                    }
                                    if (random.nextFloat() > 0.35f) {
                                        if (y == 10) {
                                            currentBlockstate = secondaryFloorBlockstate;
                                        } else if (y == 9 && random.nextFloat() < 0.35f) {
                                            currentBlockstate = secondaryFloorBlockstate;
                                        }
                                    }
                                }
                                world.func_177436_a((BlockPos)blockpos$Mutable, currentBlockstate, false);
                            } else {
                                world.func_177436_a((BlockPos)blockpos$Mutable, field_222715_g, false);
                            }
                            flag = true;
                        }
                    }
                }
                return flag;
            }
            return false;
        }
        return false;
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return true;
    }

    static {
        HashMap<BlockState, BlockState> result = new HashMap<BlockState, BlockState>();
        result.put(Blocks.field_150424_aL.func_176223_P(), Blocks.field_150424_aL.func_176223_P());
        result.put(Blocks.field_150432_aD.func_176223_P(), Blocks.field_150432_aD.func_176223_P());
        result.put(Blocks.field_196604_cC.func_176223_P(), Blocks.field_150432_aD.func_176223_P());
        result.put(Blocks.field_150377_bs.func_176223_P(), Blocks.field_150377_bs.func_176223_P());
        canReplaceMap = result;
    }
}

