/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.placement;

import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.Placement;
import net.telepathicgrunt.ultraamplified.utils.PlacingUtils;

public class AtSurfaceBelowTopLayerWithExtra
extends Placement<AtSurfaceWithExtraConfig> {
    public AtSurfaceBelowTopLayerWithExtra(Function<Dynamic<?>, ? extends AtSurfaceWithExtraConfig> configFactory) {
        super(configFactory);
    }

    public Stream<BlockPos> getPositions(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, AtSurfaceWithExtraConfig chancesConfig, BlockPos position) {
        int maxAttempt = chancesConfig.field_202478_a;
        if (random.nextFloat() < chancesConfig.field_202479_b) {
            maxAttempt += chancesConfig.field_202480_c;
        }
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(0, 0, 0);
        for (int currentAttempt = 0; currentAttempt < maxAttempt; ++currentAttempt) {
            int x = random.nextInt(16);
            int z = random.nextInt(16);
            int startHeight = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, position.func_177982_a(x, 0, z)).func_177956_o();
            blockpos$Mutable.func_189533_g((Vec3i)position.func_177982_a(x, startHeight, z));
            while (blockpos$Mutable.func_177956_o() > 74) {
                x = random.nextInt(16);
                z = random.nextInt(16);
                blockpos$Mutable = new BlockPos.Mutable(position.func_177958_n() + x, blockpos$Mutable.func_177956_o(), position.func_177952_p() + z);
                int yPosOfSurface = PlacingUtils.topOfSurfaceBelowHeight(world, blockpos$Mutable.func_177956_o() - 1, 74, position.func_177982_a(x, 0, z));
                blockPosList.add(new BlockPos((Vec3i)blockpos$Mutable.func_189534_c(Direction.DOWN, blockpos$Mutable.func_177956_o() - yPosOfSurface - 1)));
                blockpos$Mutable.func_189536_c(Direction.DOWN);
            }
        }
        return IntStream.range(0, blockPosList.size()).mapToObj(p_215051_3_ -> (BlockPos)blockPosList.remove(0)).filter(Objects::nonNull);
    }
}

