/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.placement;

import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.Placement;
import net.telepathicgrunt.ultraamplified.utils.PlacingUtils;

public class AtSurfaceRoofedForest
extends Placement<AtSurfaceWithExtraConfig> {
    public AtSurfaceRoofedForest(Function<Dynamic<?>, ? extends AtSurfaceWithExtraConfig> configFactory) {
        super(configFactory);
    }

    public Stream<BlockPos> getPositions(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, AtSurfaceWithExtraConfig chancesConfig, BlockPos position) {
        int maxAttempt = chancesConfig.field_202478_a;
        if (random.nextFloat() < chancesConfig.field_202479_b) {
            maxAttempt += chancesConfig.field_202480_c;
        }
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(position);
        for (int currentAttempt = 0; currentAttempt < maxAttempt; ++currentAttempt) {
            int xOffset = random.nextInt(16);
            int zOffset = random.nextInt(16);
            blockpos$Mutable.func_181079_c(position.func_177958_n() + xOffset, 250, position.func_177952_p() + zOffset);
            while (blockpos$Mutable.func_177956_o() > 74) {
                int yPosOfSurface = PlacingUtils.topOfSurfaceBelowHeight(world, blockpos$Mutable.func_177956_o(), 74, (BlockPos)blockpos$Mutable);
                blockPosList.add(new BlockPos((Vec3i)blockpos$Mutable.func_189534_c(Direction.DOWN, blockpos$Mutable.func_177956_o() - yPosOfSurface + 1)));
                blockpos$Mutable.func_189536_c(Direction.DOWN);
            }
        }
        return IntStream.range(0, blockPosList.size()).mapToObj(p_215051_3_ -> (BlockPos)blockPosList.remove(0)).filter(Objects::nonNull);
    }
}

