/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.placement;

import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.Placement;
import net.telepathicgrunt.ultraamplified.utils.PlacingUtils;

public class AtSurfaceThroughWaterWithExtra
extends Placement<AtSurfaceWithExtraConfig> {
    public AtSurfaceThroughWaterWithExtra(Function<Dynamic<?>, ? extends AtSurfaceWithExtraConfig> configFactory) {
        super(configFactory);
    }

    public Stream<BlockPos> getPositions(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, AtSurfaceWithExtraConfig chancesConfig, BlockPos pos) {
        int maxAttempts = chancesConfig.field_202478_a;
        if (random.nextFloat() < chancesConfig.field_202479_b) {
            maxAttempts += chancesConfig.field_202480_c;
        }
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(pos);
        int minHeight = 60;
        for (int currentAttempt = 0; currentAttempt < maxAttempts; ++currentAttempt) {
            int xOffset = random.nextInt(16);
            int zOffset = random.nextInt(16);
            blockpos$Mutable.func_181079_c(pos.func_177958_n() + xOffset, 250, pos.func_177952_p() + zOffset);
            while (blockpos$Mutable.func_177956_o() > minHeight) {
                int yPosOfSurface = PlacingUtils.topOfUnderwaterSurfaceBelowHeight(world, blockpos$Mutable.func_177956_o(), minHeight, (BlockPos)blockpos$Mutable);
                blockPosList.add(new BlockPos((Vec3i)blockpos$Mutable.func_189534_c(Direction.DOWN, blockpos$Mutable.func_177956_o() - yPosOfSurface)));
            }
        }
        return IntStream.range(0, blockPosList.size()).mapToObj(p_215051_3_ -> (BlockPos)blockPosList.remove(0)).filter(Objects::nonNull);
    }
}

