/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.placement;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.placement.Placement;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.feature.config.ChanceAndTypeConfig;

public class LedgeUndersideMiniFeature
extends Placement<ChanceAndTypeConfig> {
    public LedgeUndersideMiniFeature(Function<Dynamic<?>, ? extends ChanceAndTypeConfig> configFactory) {
        super(configFactory);
    }

    public Stream<BlockPos> getPositions(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, ChanceAndTypeConfig placementConfig, BlockPos pos) {
        float chance;
        switch (placementConfig.type) {
            case HANGING_RUINS: {
                chance = (int)((float)UltraAmplified.UAStructuresConfig.hangingRuinsSpawnrate.get().intValue() * placementConfig.chanceModifier);
                break;
            }
            default: {
                chance = 0.0f;
            }
        }
        if (random.nextFloat() * 100.0f < chance) {
            int x = random.nextInt(16);
            int z = random.nextInt(16);
            int yPosOfSurface = this.YPositionOfBottomOfLayer(world, random, pos.func_177982_a(x, random.nextInt(174) + 74, z));
            if (yPosOfSurface < 75 || yPosOfSurface > 248) {
                return Stream.empty();
            }
            return Stream.of(pos.func_177982_a(x - 4, yPosOfSurface - 1, z - 4));
        }
        return Stream.empty();
    }

    private int YPositionOfBottomOfLayer(IWorld world, Random random, BlockPos pos) {
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(pos);
        while (blockpos$Mutable.func_177956_o() < world.getMaxHeight() && !world.func_175623_d((BlockPos)blockpos$Mutable)) {
            blockpos$Mutable.func_189536_c(Direction.UP);
        }
        while (blockpos$Mutable.func_177956_o() < world.getMaxHeight() && world.func_175623_d((BlockPos)blockpos$Mutable)) {
            blockpos$Mutable.func_189536_c(Direction.UP);
        }
        return blockpos$Mutable.func_177956_o() > world.getMaxHeight() ? world.getMaxHeight() : blockpos$Mutable.func_177956_o();
    }
}

