/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;
import net.telepathicgrunt.ultraamplified.world.feature.structure.StructureInitUA;

public class EndCityPiecesUA {
    private static final PlacementSettings OVERWRITE = new PlacementSettings().func_186222_a(true).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
    private static final PlacementSettings INSERT = new PlacementSettings().func_186222_a(true).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
    private static final IGenerator HOUSE_TOWER_GENERATOR = new IGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(TemplateManager p_191086_1_, int p_191086_2_, CityTemplate p_191086_3_, BlockPos p_191086_4_, List<StructurePiece> p_191086_5_, Random p_191086_6_) {
            if (p_191086_2_ > 10) {
                return false;
            }
            Rotation rotation = p_191086_3_.field_186177_b.func_186215_c();
            CityTemplate StructureEndCityPiecesUA$citytemplate = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, p_191086_3_, p_191086_4_, "base_floor", rotation, true));
            StructureEndCityPiecesUA$citytemplate = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, StructureEndCityPiecesUA$citytemplate, new BlockPos(-1, 0, -1), "second_floor_2", rotation, false));
            StructureEndCityPiecesUA$citytemplate = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, StructureEndCityPiecesUA$citytemplate, new BlockPos(-1, 4, -1), "third_floor_2", rotation, false));
            StructureEndCityPiecesUA$citytemplate = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, StructureEndCityPiecesUA$citytemplate, new BlockPos(-1, 8, -1), "third_roof", rotation, true));
            EndCityPiecesUA.recursiveChildren(p_191086_1_, TOWER_GENERATOR, p_191086_2_ + 1, StructureEndCityPiecesUA$citytemplate, null, p_191086_5_, p_191086_6_);
            return true;
        }
    };
    private static final List<Tuple<Rotation, BlockPos>> TOWER_BRIDGES = Lists.newArrayList((Object[])new Tuple[]{new Tuple((Object)Rotation.NONE, (Object)new BlockPos(1, -1, 0)), new Tuple((Object)Rotation.CLOCKWISE_90, (Object)new BlockPos(6, -1, 1)), new Tuple((Object)Rotation.COUNTERCLOCKWISE_90, (Object)new BlockPos(0, -1, 5)), new Tuple((Object)Rotation.CLOCKWISE_180, (Object)new BlockPos(5, -1, 6))});
    private static final IGenerator TOWER_GENERATOR = new IGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(TemplateManager p_191086_1_, int p_191086_2_, CityTemplate p_191086_3_, BlockPos p_191086_4_, List<StructurePiece> p_191086_5_, Random p_191086_6_) {
            Rotation rotation = p_191086_3_.field_186177_b.func_186215_c();
            CityTemplate lvt_8_1_ = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, p_191086_3_, new BlockPos(3 + p_191086_6_.nextInt(2), -3, 3 + p_191086_6_.nextInt(2)), "tower_base", rotation, true));
            lvt_8_1_ = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, lvt_8_1_, new BlockPos(0, 7, 0), "tower_piece", rotation, true));
            CityTemplate StructureEndCityPiecesUA$citytemplate1 = p_191086_6_.nextInt(3) == 0 ? lvt_8_1_ : null;
            int i = 3;
            for (int j = 0; j < i; ++j) {
                lvt_8_1_ = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, lvt_8_1_, new BlockPos(0, 4, 0), "tower_piece", rotation, true));
                if (j >= i - 1) continue;
                StructureEndCityPiecesUA$citytemplate1 = lvt_8_1_;
            }
            if (StructureEndCityPiecesUA$citytemplate1 != null) {
                for (Tuple tuple : TOWER_BRIDGES) {
                    CityTemplate StructureEndCityPiecesUA$citytemplate2 = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, StructureEndCityPiecesUA$citytemplate1, (BlockPos)tuple.func_76340_b(), "bridge_end", rotation.func_185830_a((Rotation)tuple.func_76341_a()), true));
                    EndCityPiecesUA.recursiveChildren(p_191086_1_, TOWER_BRIDGE_GENERATOR, p_191086_2_ + 1, StructureEndCityPiecesUA$citytemplate2, null, p_191086_5_, p_191086_6_);
                }
                EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, lvt_8_1_, new BlockPos(-1, 4, -1), "tower_top", rotation, true));
            } else {
                if (p_191086_2_ != 7) {
                    return EndCityPiecesUA.recursiveChildren(p_191086_1_, FAT_TOWER_GENERATOR, p_191086_2_ + 1, lvt_8_1_, null, p_191086_5_, p_191086_6_);
                }
                EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, lvt_8_1_, new BlockPos(-1, 4, -1), "tower_top", rotation, true));
            }
            return true;
        }
    };
    private static final IGenerator TOWER_BRIDGE_GENERATOR = new IGenerator(){
        public boolean shipCreated;

        @Override
        public void init() {
            this.shipCreated = false;
        }

        @Override
        public boolean generate(TemplateManager p_191086_1_, int p_191086_2_, CityTemplate p_191086_3_, BlockPos p_191086_4_, List<StructurePiece> p_191086_5_, Random p_191086_6_) {
            Rotation rotation = p_191086_3_.field_186177_b.func_186215_c();
            int i = 4;
            CityTemplate StructureEndCityPiecesUA$citytemplate = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, p_191086_3_, new BlockPos(0, 0, -4), "bridge_piece", rotation, true));
            StructureEndCityPiecesUA$citytemplate.field_74886_g = -1;
            int j = 0;
            for (int k = 0; k < i; ++k) {
                if (p_191086_6_.nextBoolean()) {
                    StructureEndCityPiecesUA$citytemplate = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, StructureEndCityPiecesUA$citytemplate, new BlockPos(0, j, -4), "bridge_piece", rotation, true));
                    j = 0;
                    continue;
                }
                StructureEndCityPiecesUA$citytemplate = p_191086_6_.nextBoolean() ? EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, StructureEndCityPiecesUA$citytemplate, new BlockPos(0, j, -4), "bridge_steep_stairs", rotation, true)) : EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, StructureEndCityPiecesUA$citytemplate, new BlockPos(0, j, -8), "bridge_gentle_stairs", rotation, true));
                j = 4;
            }
            if (!this.shipCreated) {
                EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, StructureEndCityPiecesUA$citytemplate, new BlockPos(-8 + p_191086_6_.nextInt(8), j, -70 + p_191086_6_.nextInt(10)), "ship", rotation, true));
                this.shipCreated = true;
            } else if (!EndCityPiecesUA.recursiveChildren(p_191086_1_, HOUSE_TOWER_GENERATOR, p_191086_2_ + 1, StructureEndCityPiecesUA$citytemplate, new BlockPos(-3, j + 1, -11), p_191086_5_, p_191086_6_)) {
                return false;
            }
            StructureEndCityPiecesUA$citytemplate = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, StructureEndCityPiecesUA$citytemplate, new BlockPos(4, j, 0), "bridge_end", rotation.func_185830_a(Rotation.CLOCKWISE_180), true));
            StructureEndCityPiecesUA$citytemplate.field_74886_g = -1;
            return true;
        }
    };
    private static final List<Tuple<Rotation, BlockPos>> FAT_TOWER_BRIDGES = Lists.newArrayList((Object[])new Tuple[]{new Tuple((Object)Rotation.NONE, (Object)new BlockPos(4, -1, 0)), new Tuple((Object)Rotation.CLOCKWISE_90, (Object)new BlockPos(12, -1, 4)), new Tuple((Object)Rotation.COUNTERCLOCKWISE_90, (Object)new BlockPos(0, -1, 8)), new Tuple((Object)Rotation.CLOCKWISE_180, (Object)new BlockPos(8, -1, 12))});
    private static final IGenerator FAT_TOWER_GENERATOR = new IGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(TemplateManager p_191086_1_, int p_191086_2_, CityTemplate p_191086_3_, BlockPos p_191086_4_, List<StructurePiece> p_191086_5_, Random p_191086_6_) {
            Rotation rotation = p_191086_3_.field_186177_b.func_186215_c();
            CityTemplate StructureEndCityPiecesUA$citytemplate = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, p_191086_3_, new BlockPos(-3, 4, -3), "fat_tower_base", rotation, true));
            StructureEndCityPiecesUA$citytemplate = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, StructureEndCityPiecesUA$citytemplate, new BlockPos(0, 4, 0), "fat_tower_middle", rotation, true));
            for (int i = 0; i < 2; ++i) {
                StructureEndCityPiecesUA$citytemplate = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, StructureEndCityPiecesUA$citytemplate, new BlockPos(0, 8, 0), "fat_tower_middle", rotation, true));
                for (Tuple tuple : FAT_TOWER_BRIDGES) {
                    CityTemplate StructureEndCityPiecesUA$citytemplate1 = EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, StructureEndCityPiecesUA$citytemplate, (BlockPos)tuple.func_76340_b(), "bridge_end", rotation.func_185830_a((Rotation)tuple.func_76341_a()), true));
                    EndCityPiecesUA.recursiveChildren(p_191086_1_, TOWER_BRIDGE_GENERATOR, p_191086_2_ + 1, StructureEndCityPiecesUA$citytemplate1, null, p_191086_5_, p_191086_6_);
                }
            }
            EndCityPiecesUA.addHelper(p_191086_5_, EndCityPiecesUA.addPiece(p_191086_1_, StructureEndCityPiecesUA$citytemplate, new BlockPos(-2, 8, -2), "fat_tower_top", rotation, true));
            return true;
        }
    };

    private static CityTemplate addPiece(TemplateManager p_191090_0_, CityTemplate p_191090_1_, BlockPos p_191090_2_, String p_191090_3_, Rotation p_191090_4_, boolean owerwrite) {
        CityTemplate StructureEndCityPiecesUA$citytemplate = new CityTemplate(p_191090_0_, p_191090_3_, p_191090_1_.field_186178_c, p_191090_4_, owerwrite);
        BlockPos blockpos = p_191090_1_.field_186176_a.func_186262_a(p_191090_1_.field_186177_b, p_191090_2_, StructureEndCityPiecesUA$citytemplate.field_186177_b, BlockPos.field_177992_a);
        StructureEndCityPiecesUA$citytemplate.func_181138_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
        return StructureEndCityPiecesUA$citytemplate;
    }

    public static void startHouseTower(TemplateManager p_191087_0_, BlockPos p_191087_1_, Rotation p_191087_2_, List<StructurePiece> p_191087_3_, Random p_191087_4_) {
        FAT_TOWER_GENERATOR.init();
        HOUSE_TOWER_GENERATOR.init();
        TOWER_BRIDGE_GENERATOR.init();
        TOWER_GENERATOR.init();
        CityTemplate StructureEndCityPiecesUA$citytemplate = EndCityPiecesUA.addHelper(p_191087_3_, new CityTemplate(p_191087_0_, "base_floor", p_191087_1_, p_191087_2_, true));
        StructureEndCityPiecesUA$citytemplate = EndCityPiecesUA.addHelper(p_191087_3_, EndCityPiecesUA.addPiece(p_191087_0_, StructureEndCityPiecesUA$citytemplate, new BlockPos(-1, 0, -1), "second_floor_1", p_191087_2_, false));
        StructureEndCityPiecesUA$citytemplate = EndCityPiecesUA.addHelper(p_191087_3_, EndCityPiecesUA.addPiece(p_191087_0_, StructureEndCityPiecesUA$citytemplate, new BlockPos(-1, 4, -1), "third_floor_1", p_191087_2_, false));
        StructureEndCityPiecesUA$citytemplate = EndCityPiecesUA.addHelper(p_191087_3_, EndCityPiecesUA.addPiece(p_191087_0_, StructureEndCityPiecesUA$citytemplate, new BlockPos(-1, 8, -1), "third_roof", p_191087_2_, true));
        EndCityPiecesUA.recursiveChildren(p_191087_0_, TOWER_GENERATOR, 1, StructureEndCityPiecesUA$citytemplate, null, p_191087_3_, p_191087_4_);
    }

    private static CityTemplate addHelper(List<StructurePiece> p_189935_0_, CityTemplate p_189935_1_) {
        p_189935_0_.add((StructurePiece)p_189935_1_);
        return p_189935_1_;
    }

    private static boolean recursiveChildren(TemplateManager p_191088_0_, IGenerator p_191088_1_, int p_191088_2_, CityTemplate p_191088_3_, BlockPos p_191088_4_, List<StructurePiece> p_191088_5_, Random p_191088_6_) {
        if (p_191088_2_ > 10) {
            return false;
        }
        ArrayList list = Lists.newArrayList();
        if (p_191088_1_.generate(p_191088_0_, p_191088_2_, p_191088_3_, p_191088_4_, list, p_191088_6_)) {
            boolean flag = false;
            int i = p_191088_6_.nextInt();
            for (StructurePiece structurepiece : list) {
                structurepiece.field_74886_g = i;
                StructurePiece structurepiece1 = StructurePiece.func_74883_a(p_191088_5_, (MutableBoundingBox)structurepiece.func_74874_b());
                if (structurepiece1 == null || structurepiece1.field_74886_g == p_191088_3_.field_74886_g) continue;
                flag = true;
                break;
            }
            if (!flag) {
                p_191088_5_.addAll(list);
                return true;
            }
        }
        return false;
    }

    static interface IGenerator {
        public void init();

        public boolean generate(TemplateManager var1, int var2, CityTemplate var3, BlockPos var4, List<StructurePiece> var5, Random var6);
    }

    public static class CityTemplate
    extends TemplateStructurePiece {
        private String pieceName;
        private Rotation rotation;
        private boolean overwrite;

        public CityTemplate(TemplateManager p_i47214_1_, String p_i47214_2_, BlockPos p_i47214_3_, Rotation p_i47214_4_, boolean overwriteIn) {
            super(StructureInitUA.ECPUA, 0);
            this.pieceName = p_i47214_2_;
            this.field_186178_c = p_i47214_3_;
            this.rotation = p_i47214_4_;
            this.overwrite = overwriteIn;
            this.loadTemplate(p_i47214_1_);
        }

        public CityTemplate(TemplateManager p_i50598_1_, CompoundNBT p_i50598_2_) {
            super(StructureInitUA.ECPUA, p_i50598_2_);
            this.pieceName = p_i50598_2_.func_74779_i("Template");
            this.rotation = Rotation.valueOf((String)p_i50598_2_.func_74779_i("Rot"));
            this.overwrite = p_i50598_2_.func_74767_n("OW");
            this.loadTemplate(p_i50598_1_);
        }

        private void loadTemplate(TemplateManager p_191085_1_) {
            Template template = p_191085_1_.func_200220_a(new ResourceLocation("end_city/" + this.pieceName));
            PlacementSettings placementsettings = (this.overwrite ? OVERWRITE : INSERT).func_186217_a().func_186220_a(this.rotation);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.pieceName);
            tagCompound.func_74778_a("Rot", this.rotation.name());
            tagCompound.func_74757_a("OW", this.overwrite);
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld world, Random rand, MutableBoundingBox sbb) {
            if (function.startsWith("Chest")) {
                BlockPos blockpos = pos.func_177977_b();
                if (sbb.func_175898_b((Vec3i)blockpos)) {
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)blockpos, (ResourceLocation)LootTables.field_186421_c);
                }
            } else if (function.startsWith("Sentry")) {
                ShulkerEntity entityshulker = (ShulkerEntity)EntityType.field_200738_ad.func_200721_a(world.func_201672_e());
                entityshulker.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                entityshulker.func_184694_g(pos);
                world.func_217376_c((Entity)entityshulker);
            } else if (function.startsWith("Elytra")) {
                ItemFrameEntity itemframeentity = new ItemFrameEntity(world.func_201672_e(), pos, this.rotation.func_185831_a(Direction.SOUTH));
                itemframeentity.func_174864_a(new ItemStack((IItemProvider)Items.field_185160_cR), false);
                world.func_217376_c((Entity)itemframeentity);
            }
        }
    }
}

