/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.feature.UAFeatures;
import net.telepathicgrunt.ultraamplified.world.feature.structure.FortressPiecesUA;

public class FortressNetherStructureUA
extends Structure<NoFeatureConfig> {
    private static final List<Biome.SpawnListEntry> NETHER_FORTRESS_ENEMIES = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_200792_f, 10, 2, 3), new Biome.SpawnListEntry(EntityType.field_200785_Y, 5, 4, 4), new Biome.SpawnListEntry(EntityType.field_200722_aA, 8, 5, 5), new Biome.SpawnListEntry(EntityType.field_200741_ag, 2, 5, 5), new Biome.SpawnListEntry(EntityType.field_200771_K, 3, 4, 4)});

    public FortressNetherStructureUA(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int maxDistance = UltraAmplified.UAStructuresConfig.netherFortressSpawnrate.get();
        int minDistance = 8;
        if (maxDistance < 9) {
            minDistance = maxDistance - 1;
        }
        int k = x + maxDistance * spacingOffsetsX;
        int l = z + maxDistance * spacingOffsetsZ;
        int i1 = k < 0 ? k - maxDistance + 1 : k;
        int j1 = l < 0 ? l - maxDistance + 1 : l;
        int k1 = i1 / maxDistance;
        int l1 = j1 / maxDistance;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), k1, l1, 14357654);
        k1 *= maxDistance;
        l1 *= maxDistance;
        return new ChunkPos(k1 += random.nextInt(maxDistance - minDistance), l1 += random.nextInt(maxDistance - minDistance));
    }

    public boolean func_225558_a_(BiomeManager biomeManager, ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ, Biome biome) {
        if (UltraAmplified.UAStructuresConfig.netherFortressSpawnrate.get() != 101) {
            int i = chunkPosX >> 4;
            int j = chunkPosZ >> 4;
            rand.setSeed((long)(i ^ j << 4) ^ chunkGen.func_202089_c());
            ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
            if (chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b) {
                return chunkGen.func_202094_a(biome, UAFeatures.NETHER_FORTRESS);
            }
        }
        return false;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return "ultra_amplified_dimension:fortress_nether";
    }

    public int func_202367_b() {
        return 8;
    }

    public List<Biome.SpawnListEntry> getNetherFortressSpawnList() {
        return NETHER_FORTRESS_ENEMIES;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            FortressPiecesUA.Start fortresspieces$start = new FortressPiecesUA.Start((Random)this.field_214631_d, (chunkX << 4) + 2, (chunkZ << 4) + 2, false);
            this.field_75075_a.add(fortresspieces$start);
            fortresspieces$start.func_74861_a(fortresspieces$start, this.field_75075_a, (Random)this.field_214631_d);
            List<StructurePiece> list = fortresspieces$start.pendingChildren;
            while (!list.isEmpty()) {
                int i = this.field_214631_d.nextInt(list.size());
                StructurePiece structurepiece = list.remove(i);
                structurepiece.func_74861_a((StructurePiece)fortresspieces$start, this.field_75075_a, (Random)this.field_214631_d);
            }
            this.func_202500_a();
            this.func_214626_a((Random)this.field_214631_d, 85, 130);
        }
    }
}

