/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.feature.UAFeatures;
import net.telepathicgrunt.ultraamplified.world.feature.structure.StructureInitUA;

public class FortressPiecesUA {
    private static final Map<BlockState, BlockState> INFESTED_STONE_LOOKUP = new HashMap<BlockState, BlockState>();
    public static final Set<Block> STONE_FORTRESS_BLOCKS;
    private static final PieceWeight[] PRIMARY_COMPONENTS;
    private static final PieceWeight[] SECONDARY_COMPONENTS;

    private static Piece findAndCreateBridgePieceFactory(PieceWeight p_175887_0_, List<StructurePiece> p_175887_1_, Random p_175887_2_, int p_175887_3_, int p_175887_4_, int p_175887_5_, Direction p_175887_6_, int p_175887_7_, boolean isStone) {
        Class<? extends Piece> oclass = p_175887_0_.weightClass;
        Piece structurenetherbridgepieces$piece = null;
        if (oclass == Straight.class) {
            structurenetherbridgepieces$piece = Straight.createPiece(p_175887_1_, p_175887_2_, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_6_, p_175887_7_, isStone);
        } else if (oclass == Crossing3.class) {
            structurenetherbridgepieces$piece = Crossing3.createPiece(p_175887_1_, p_175887_2_, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_6_, p_175887_7_, isStone);
        } else if (oclass == Crossing.class) {
            structurenetherbridgepieces$piece = Crossing.createPiece(p_175887_1_, p_175887_2_, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_6_, p_175887_7_, isStone);
        } else if (oclass == Stairs.class) {
            structurenetherbridgepieces$piece = Stairs.createPiece(p_175887_1_, p_175887_2_, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_7_, p_175887_6_, isStone);
        } else if (oclass == Throne.class) {
            structurenetherbridgepieces$piece = Throne.createPiece(p_175887_1_, p_175887_2_, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_7_, p_175887_6_, isStone);
        } else if (oclass == Entrance.class) {
            structurenetherbridgepieces$piece = Entrance.createPiece(p_175887_1_, p_175887_2_, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_6_, p_175887_7_, isStone);
        } else if (oclass == Corridor5.class) {
            structurenetherbridgepieces$piece = Corridor5.createPiece(p_175887_1_, p_175887_2_, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_6_, p_175887_7_, isStone);
        } else if (oclass == Corridor2.class) {
            structurenetherbridgepieces$piece = Corridor2.createPiece(p_175887_1_, p_175887_2_, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_6_, p_175887_7_, isStone);
        } else if (oclass == Corridor.class) {
            structurenetherbridgepieces$piece = Corridor.createPiece(p_175887_1_, p_175887_2_, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_6_, p_175887_7_, isStone);
        } else if (oclass == Corridor3.class) {
            structurenetherbridgepieces$piece = Corridor3.createPiece(p_175887_1_, p_175887_2_, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_6_, p_175887_7_, isStone);
        } else if (oclass == Corridor4.class) {
            structurenetherbridgepieces$piece = Corridor4.createPiece(p_175887_1_, p_175887_2_, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_6_, p_175887_7_, isStone);
        } else if (oclass == Crossing2.class) {
            structurenetherbridgepieces$piece = Crossing2.createPiece(p_175887_1_, p_175887_2_, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_6_, p_175887_7_, isStone);
        } else if (oclass == NetherStalkRoom.class) {
            structurenetherbridgepieces$piece = NetherStalkRoom.createPiece(p_175887_1_, p_175887_2_, p_175887_3_, p_175887_4_, p_175887_5_, p_175887_6_, p_175887_7_, isStone);
        }
        return structurenetherbridgepieces$piece;
    }

    private static ResourceLocation pickRandomLoot(Random random) {
        ResourceLocation lootTable = null;
        float chance = random.nextFloat();
        lootTable = chance < 0.38f ? LootTables.field_215814_e : (chance < 0.76f ? LootTables.field_215816_g : LootTables.field_186430_l);
        return lootTable;
    }

    private static void attemptToAddVines(IWorld world, ChunkGenerator<?> chunkGenerator, Random random, StructurePiece piece, MutableBoundingBox structureBoundingBoxIn, boolean stoneVariant) {
        if (stoneVariant) {
            BlockPos.Mutable mutablePos = new BlockPos.Mutable();
            for (int x = structureBoundingBoxIn.field_78897_a; x <= structureBoundingBoxIn.field_78893_d; ++x) {
                for (int z = structureBoundingBoxIn.field_78896_c; z <= structureBoundingBoxIn.field_78892_f; ++z) {
                    for (int y = piece.func_74862_a(-10); y <= piece.func_74862_a(15); ++y) {
                        if (random.nextInt(500) != 0) continue;
                        UAFeatures.SHORT_VINES.func_212245_a(world, chunkGenerator, random, (BlockPos)mutablePos.func_181079_c(x, y, z), (IFeatureConfig)NoFeatureConfig.field_202429_e);
                    }
                }
            }
        }
    }

    static {
        INFESTED_STONE_LOOKUP.put(Blocks.field_196696_di.func_176223_P(), Blocks.field_196688_de.func_176223_P());
        INFESTED_STONE_LOOKUP.put(Blocks.field_150348_b.func_176223_P(), Blocks.field_196686_dc.func_176223_P());
        INFESTED_STONE_LOOKUP.put(Blocks.field_150341_Y.func_176223_P(), Blocks.field_196690_df.func_176223_P());
        INFESTED_STONE_LOOKUP.put(Blocks.field_196700_dk.func_176223_P(), Blocks.field_196692_dg.func_176223_P());
        INFESTED_STONE_LOOKUP.put(Blocks.field_150347_e.func_176223_P(), Blocks.field_196687_dd.func_176223_P());
        INFESTED_STONE_LOOKUP.put(Blocks.field_196702_dl.func_176223_P(), Blocks.field_196694_dh.func_176223_P());
        INFESTED_STONE_LOOKUP.put(Blocks.field_196698_dj.func_176223_P(), Blocks.field_196698_dj.func_176223_P());
        STONE_FORTRESS_BLOCKS = Stream.of(Blocks.field_196700_dk, Blocks.field_196702_dl, Blocks.field_196698_dj, Blocks.field_196696_di, Blocks.field_196694_dh, Blocks.field_196692_dg, Blocks.field_196690_df, Blocks.field_196688_de).collect(Collectors.toCollection(HashSet::new));
        PRIMARY_COMPONENTS = new PieceWeight[]{new PieceWeight(Straight.class, 30, 0, true), new PieceWeight(Crossing3.class, 10, 4), new PieceWeight(Crossing.class, 10, 4), new PieceWeight(Stairs.class, 10, 3), new PieceWeight(Throne.class, 5, 2), new PieceWeight(Entrance.class, 5, 1)};
        SECONDARY_COMPONENTS = new PieceWeight[]{new PieceWeight(Corridor5.class, 25, 0, true), new PieceWeight(Crossing2.class, 15, 5), new PieceWeight(Corridor2.class, 5, 10), new PieceWeight(Corridor.class, 5, 10), new PieceWeight(Corridor3.class, 10, 3, true), new PieceWeight(Corridor4.class, 7, 2), new PieceWeight(NetherStalkRoom.class, 5, 2)};
    }

    public static class Throne
    extends Piece {
        private boolean hasSpawner;

        public Throne(int p_i50262_1_, Random rand, MutableBoundingBox p_i50262_2_, Direction p_i50262_3_, boolean isStone) {
            super(StructureInitUA.NEMTUA, p_i50262_1_, isStone);
            this.func_186164_a(p_i50262_3_);
            this.field_74887_e = p_i50262_2_;
        }

        public Throne(TemplateManager p_i50263_1_, CompoundNBT p_i50263_2_) {
            super(StructureInitUA.NEMTUA, p_i50263_2_);
            this.hasSpawner = p_i50263_2_.func_74767_n("Mob");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("Mob", this.hasSpawner);
        }

        public static Throne createPiece(List<StructurePiece> p_175874_0_, Random p_175874_1_, int p_175874_2_, int p_175874_3_, int p_175874_4_, int p_175874_5_, Direction p_175874_6_, boolean isStone) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175874_2_, (int)p_175874_3_, (int)p_175874_4_, (int)-2, (int)0, (int)0, (int)7, (int)8, (int)9, (Direction)p_175874_6_);
            return Throne.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175874_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new Throne(p_175874_5_, p_175874_1_, mutableBoundingBox, p_175874_6_, isStone) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            BlockPos blockpos;
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 6, 7, 7, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 0, 0, 5, 1, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 2, 1, 5, 2, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 3, 2, 5, 3, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 4, 3, 5, 4, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 2, 0, 1, 4, 2, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 2, 0, 5, 4, 2, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 5, 2, 1, 5, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 5, 2, 5, 5, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 5, 3, 0, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 6, 5, 3, 6, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 5, 8, 5, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), random), 1, 6, 3, structureBoundingBoxIn);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random), 5, 6, 3, structureBoundingBoxIn);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), random), 0, 6, 3, structureBoundingBoxIn);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), random), 6, 6, 3, structureBoundingBoxIn);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 6, 4, 0, 6, 7, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 6, 6, 4, 6, 6, 7, iblockstate1, iblockstate1, false, random);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random), 0, 6, 8, structureBoundingBoxIn);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random), 6, 6, 8, structureBoundingBoxIn);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 6, 8, 5, 6, 8, iblockstate, iblockstate, false, random);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random), 1, 7, 8, structureBoundingBoxIn);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 7, 8, 4, 7, 8, iblockstate, iblockstate, false, random);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), random), 5, 7, 8, structureBoundingBoxIn);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random), 2, 8, 8, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate, 3, 8, 8, structureBoundingBoxIn);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), random), 4, 8, 8, structureBoundingBoxIn);
            if (!this.hasSpawner && structureBoundingBoxIn.func_175898_b((Vec3i)(blockpos = new BlockPos(this.func_74865_a(3, 5), this.func_74862_a(5), this.func_74873_b(3, 5))))) {
                TileEntity tileentity;
                if (this.stoneVariant) {
                    this.hasSpawner = true;
                    world.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                    tileentity = world.func_175625_s(blockpos);
                    if (tileentity instanceof MobSpawnerTileEntity) {
                        ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(EntityType.field_200741_ag);
                    }
                    if (UltraAmplified.UAStructuresConfig.allowSilverfishSpawnerFortress.get().booleanValue()) {
                        world.func_180501_a(blockpos.func_177977_b(), Blocks.field_150474_ac.func_176223_P(), 2);
                        TileEntity tileentity2 = world.func_175625_s(blockpos.func_177977_b());
                        if (tileentity2 instanceof MobSpawnerTileEntity) {
                            ((MobSpawnerTileEntity)tileentity2).func_145881_a().func_200876_a(EntityType.field_200740_af);
                        }
                    } else {
                        world.func_180501_a(blockpos.func_177977_b(), Blocks.field_196696_di.func_176223_P(), 2);
                    }
                } else {
                    this.hasSpawner = true;
                    world.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                    tileentity = world.func_175625_s(blockpos);
                    if (tileentity instanceof MobSpawnerTileEntity) {
                        ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(EntityType.field_200792_f);
                    }
                }
            }
            for (int i = 0; i <= 6; ++i) {
                for (int j = 0; j <= 6; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, structureBoundingBoxIn, random);
                }
            }
            if (UltraAmplified.UAStructuresConfig.chestGeneration.get().booleanValue()) {
                this.func_186167_a(world, structureBoundingBoxIn, random, 3, 5, 7, LootTables.field_186421_c);
            }
            FortressPiecesUA.attemptToAddVines(world, p_225577_2_, random, this, structureBoundingBoxIn, this.stoneVariant);
            return true;
        }
    }

    public static class Straight
    extends Piece {
        public Straight(int p_i45620_1_, Random p_i45620_2_, MutableBoundingBox p_i45620_3_, Direction p_i45620_4_, boolean isStone) {
            super(StructureInitUA.NEBSUA, p_i45620_1_, isStone);
            this.func_186164_a(p_i45620_4_);
            this.field_74887_e = p_i45620_3_;
        }

        public Straight(TemplateManager p_i50283_1_, CompoundNBT p_i50283_2_) {
            super(StructureInitUA.NEBSUA, p_i50283_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 1, 3, false);
        }

        public static Straight createPiece(List<StructurePiece> p_175882_0_, Random p_175882_1_, int p_175882_2_, int p_175882_3_, int p_175882_4_, Direction p_175882_5_, int p_175882_6_, boolean isStone) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175882_2_, (int)p_175882_3_, (int)p_175882_4_, (int)-1, (int)-3, (int)0, (int)5, (int)10, (int)19, (Direction)p_175882_5_);
            return Straight.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175882_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new Straight(p_175882_6_, p_175882_1_, mutableBoundingBox, p_175882_5_, isStone) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 3, 0, 4, 4, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 5, 0, 3, 7, 18, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 5, 0, 0, 5, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 5, 0, 4, 5, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 4, 2, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 13, 4, 2, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 0, 0, 4, 1, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 0, 15, 4, 1, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 2; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, structureBoundingBoxIn, random);
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, 18 - j, structureBoundingBoxIn, random);
                }
            }
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate2 = (BlockState)iblockstate1.func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            BlockState iblockstate3 = (BlockState)iblockstate1.func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true));
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 1, 1, 0, 4, 1, iblockstate2, iblockstate2, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 3, 4, 0, 4, 4, iblockstate2, iblockstate2, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 3, 14, 0, 4, 14, iblockstate2, iblockstate2, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 1, 17, 0, 4, 17, iblockstate2, iblockstate2, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 1, 1, 4, 4, 1, iblockstate3, iblockstate3, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 3, 4, 4, 4, 4, iblockstate3, iblockstate3, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 3, 14, 4, 4, 14, iblockstate3, iblockstate3, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 1, 17, 4, 4, 17, iblockstate3, iblockstate3, false, random);
            FortressPiecesUA.attemptToAddVines(world, p_225577_2_, random, this, structureBoundingBoxIn, this.stoneVariant);
            return true;
        }
    }

    public static class Start
    extends Crossing3 {
        public PieceWeight theNetherBridgePieceWeight;
        public List<PieceWeight> primaryWeights;
        public List<PieceWeight> secondaryWeights;
        public List<StructurePiece> pendingChildren = Lists.newArrayList();

        public Start(Random p_i2059_1_, int p_i2059_2_, int p_i2059_3_, boolean isStone) {
            super(p_i2059_1_, p_i2059_2_, p_i2059_3_, isStone);
            this.primaryWeights = Lists.newArrayList();
            this.stoneVariant = isStone;
            this.setVariant(isStone);
            for (PieceWeight structurenetherbridgepieces$pieceweight : PRIMARY_COMPONENTS) {
                structurenetherbridgepieces$pieceweight.placeCount = 0;
                this.primaryWeights.add(structurenetherbridgepieces$pieceweight);
            }
            this.secondaryWeights = Lists.newArrayList();
            for (PieceWeight structurenetherbridgepieces$pieceweight1 : SECONDARY_COMPONENTS) {
                structurenetherbridgepieces$pieceweight1.placeCount = 0;
                this.secondaryWeights.add(structurenetherbridgepieces$pieceweight1);
            }
        }

        public Start(TemplateManager p_i50253_1_, CompoundNBT p_i50253_2_) {
            super(StructureInitUA.NESTARTUA, p_i50253_2_);
        }
    }

    public static class Stairs
    extends Piece {
        public Stairs(int p_i50255_1_, MutableBoundingBox p_i50255_2_, Direction p_i50255_3_, boolean isStone) {
            super(StructureInitUA.NESRUA, p_i50255_1_, isStone);
            this.func_186164_a(p_i50255_3_);
            this.field_74887_e = p_i50255_2_;
        }

        public Stairs(TemplateManager p_i50256_1_, CompoundNBT p_i50256_2_) {
            super(StructureInitUA.NESRUA, p_i50256_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentZ((Start)componentIn, listIn, rand, 6, 2, false);
        }

        public static Stairs createPiece(List<StructurePiece> p_175872_0_, Random p_175872_1_, int p_175872_2_, int p_175872_3_, int p_175872_4_, int p_175872_5_, Direction p_175872_6_, boolean isStone) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175872_2_, (int)p_175872_3_, (int)p_175872_4_, (int)-2, (int)0, (int)0, (int)7, (int)11, (int)7, (Direction)p_175872_6_);
            return Stairs.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175872_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new Stairs(p_175872_5_, mutableBoundingBox, p_175872_6_, isStone) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 0, 0, 6, 1, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 6, 10, 6, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 1, 8, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 2, 0, 6, 8, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 1, 0, 8, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 6, 2, 1, 6, 8, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 2, 6, 5, 8, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 3, 2, 0, 5, 4, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 6, 3, 2, 6, 5, 2, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 6, 3, 4, 6, 5, 4, iblockstate1, iblockstate1, false, random);
            this.func_175811_a(world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), 5, 2, 5, structureBoundingBoxIn);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 2, 5, 4, 3, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 3, 2, 5, 3, 4, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 2, 5, 2, 5, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 2, 5, 1, 6, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 7, 1, 5, 7, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 6, 8, 2, 6, 8, 4, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 6, 0, 4, 8, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 5, 0, 4, 5, 0, iblockstate, iblockstate, false, random);
            for (int i = 0; i <= 6; ++i) {
                for (int j = 0; j <= 6; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, structureBoundingBoxIn, random);
                }
            }
            FortressPiecesUA.attemptToAddVines(world, p_225577_2_, random, this, structureBoundingBoxIn, this.stoneVariant);
            return true;
        }
    }

    static class PieceWeight {
        public Class<? extends Piece> weightClass;
        public final int weight;
        public int placeCount;
        public int maxPlaceCount;
        public boolean allowInRow;

        public PieceWeight(Class<? extends Piece> weightClass, int weight, int maximumCount, boolean allowMultipleInRow) {
            this.weightClass = weightClass;
            this.weight = weight;
            this.maxPlaceCount = maximumCount;
            this.allowInRow = allowMultipleInRow;
        }

        public PieceWeight(Class<? extends Piece> weightClass, int weight, int maximumCount) {
            this(weightClass, weight, maximumCount, false);
        }

        public boolean doPlace(int p_78822_1_) {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }

        public boolean isValid() {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }
    }

    static abstract class Piece
    extends StructurePiece {
        protected boolean stoneVariant;

        protected Piece(IStructurePieceType p_i50260_1_, int p_i50260_2_, boolean isStone) {
            super(p_i50260_1_, p_i50260_2_);
            this.stoneVariant = isStone;
        }

        public Piece(IStructurePieceType p_i50261_1_, CompoundNBT p_i50261_2_) {
            super(p_i50261_1_, p_i50261_2_);
            this.stoneVariant = p_i50261_2_.func_74767_n("stonevariant");
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            tagCompound.func_74757_a("stonevariant", this.stoneVariant);
        }

        private int getTotalWeight(List<PieceWeight> p_74960_1_) {
            boolean flag = false;
            int i = 0;
            for (PieceWeight structurenetherbridgepieces$pieceweight : p_74960_1_) {
                if (structurenetherbridgepieces$pieceweight.maxPlaceCount > 0 && structurenetherbridgepieces$pieceweight.placeCount < structurenetherbridgepieces$pieceweight.maxPlaceCount) {
                    flag = true;
                }
                i += structurenetherbridgepieces$pieceweight.weight;
            }
            return flag ? i : -1;
        }

        private Piece generatePiece(Start startPiece, List<PieceWeight> p_175871_2_, List<StructurePiece> p_175871_3_, Random p_175871_4_, int p_175871_5_, int p_175871_6_, int p_175871_7_, Direction p_175871_8_, int p_175871_9_) {
            int i = this.getTotalWeight(p_175871_2_);
            boolean flag = i > 0 && p_175871_9_ <= 30;
            int j = 0;
            block0: while (j < 5 && flag) {
                ++j;
                int k = p_175871_4_.nextInt(i);
                for (PieceWeight structurenetherbridgepieces$pieceweight : p_175871_2_) {
                    if ((k -= structurenetherbridgepieces$pieceweight.weight) >= 0) continue;
                    if (!structurenetherbridgepieces$pieceweight.doPlace(p_175871_9_) || structurenetherbridgepieces$pieceweight == startPiece.theNetherBridgePieceWeight && !structurenetherbridgepieces$pieceweight.allowInRow) continue block0;
                    Piece structurenetherbridgepieces$piece = FortressPiecesUA.findAndCreateBridgePieceFactory(structurenetherbridgepieces$pieceweight, p_175871_3_, p_175871_4_, p_175871_5_, p_175871_6_, p_175871_7_, p_175871_8_, p_175871_9_, startPiece.stoneVariant);
                    if (structurenetherbridgepieces$piece == null) continue;
                    ++structurenetherbridgepieces$pieceweight.placeCount;
                    startPiece.theNetherBridgePieceWeight = structurenetherbridgepieces$pieceweight;
                    if (!structurenetherbridgepieces$pieceweight.isValid()) {
                        p_175871_2_.remove(structurenetherbridgepieces$pieceweight);
                    }
                    return structurenetherbridgepieces$piece;
                }
            }
            return End.createPiece(p_175871_3_, p_175871_4_, p_175871_5_, p_175871_6_, p_175871_7_, p_175871_8_, p_175871_9_, startPiece.stoneVariant);
        }

        private StructurePiece generateAndAddPiece(Start startPiece, List<StructurePiece> p_175870_2_, Random p_175870_3_, int p_175870_4_, int p_175870_5_, int p_175870_6_, @Nullable Direction p_175870_7_, int p_175870_8_, boolean p_175870_9_) {
            if (Math.abs(p_175870_4_ - startPiece.func_74874_b().field_78897_a) <= 112 && Math.abs(p_175870_6_ - startPiece.func_74874_b().field_78896_c) <= 112) {
                Piece StructurePiece2;
                List<PieceWeight> list = startPiece.primaryWeights;
                if (p_175870_9_) {
                    list = startPiece.secondaryWeights;
                }
                if ((StructurePiece2 = this.generatePiece(startPiece, list, p_175870_2_, p_175870_3_, p_175870_4_, p_175870_5_, p_175870_6_, p_175870_7_, p_175870_8_ + 1)) != null) {
                    p_175870_2_.add(StructurePiece2);
                    startPiece.pendingChildren.add(StructurePiece2);
                }
                return StructurePiece2;
            }
            return End.createPiece(p_175870_2_, p_175870_3_, p_175870_4_, p_175870_5_, p_175870_6_, p_175870_7_, p_175870_8_, startPiece.stoneVariant);
        }

        @Nullable
        protected StructurePiece getNextComponentNormal(Start p_74963_1_, List<StructurePiece> p_74963_2_, Random p_74963_3_, int p_74963_4_, int p_74963_5_, boolean p_74963_6_) {
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case NORTH: {
                        return this.generateAndAddPiece(p_74963_1_, p_74963_2_, p_74963_3_, this.field_74887_e.field_78897_a + p_74963_4_, this.field_74887_e.field_78895_b + p_74963_5_, this.field_74887_e.field_78896_c - 1, enumfacing, this.func_74877_c(), p_74963_6_);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(p_74963_1_, p_74963_2_, p_74963_3_, this.field_74887_e.field_78897_a + p_74963_4_, this.field_74887_e.field_78895_b + p_74963_5_, this.field_74887_e.field_78892_f + 1, enumfacing, this.func_74877_c(), p_74963_6_);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(p_74963_1_, p_74963_2_, p_74963_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74963_5_, this.field_74887_e.field_78896_c + p_74963_4_, enumfacing, this.func_74877_c(), p_74963_6_);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(p_74963_1_, p_74963_2_, p_74963_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74963_5_, this.field_74887_e.field_78896_c + p_74963_4_, enumfacing, this.func_74877_c(), p_74963_6_);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece getNextComponentX(Start p_74961_1_, List<StructurePiece> p_74961_2_, Random p_74961_3_, int p_74961_4_, int p_74961_5_, boolean p_74961_6_) {
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case NORTH: {
                        return this.generateAndAddPiece(p_74961_1_, p_74961_2_, p_74961_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74961_4_, this.field_74887_e.field_78896_c + p_74961_5_, Direction.WEST, this.func_74877_c(), p_74961_6_);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(p_74961_1_, p_74961_2_, p_74961_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74961_4_, this.field_74887_e.field_78896_c + p_74961_5_, Direction.WEST, this.func_74877_c(), p_74961_6_);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(p_74961_1_, p_74961_2_, p_74961_3_, this.field_74887_e.field_78897_a + p_74961_5_, this.field_74887_e.field_78895_b + p_74961_4_, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c(), p_74961_6_);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(p_74961_1_, p_74961_2_, p_74961_3_, this.field_74887_e.field_78897_a + p_74961_5_, this.field_74887_e.field_78895_b + p_74961_4_, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c(), p_74961_6_);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece getNextComponentZ(Start p_74965_1_, List<StructurePiece> p_74965_2_, Random p_74965_3_, int p_74965_4_, int p_74965_5_, boolean p_74965_6_) {
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case NORTH: {
                        return this.generateAndAddPiece(p_74965_1_, p_74965_2_, p_74965_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74965_4_, this.field_74887_e.field_78896_c + p_74965_5_, Direction.EAST, this.func_74877_c(), p_74965_6_);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(p_74965_1_, p_74965_2_, p_74965_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74965_4_, this.field_74887_e.field_78896_c + p_74965_5_, Direction.EAST, this.func_74877_c(), p_74965_6_);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(p_74965_1_, p_74965_2_, p_74965_3_, this.field_74887_e.field_78897_a + p_74965_5_, this.field_74887_e.field_78895_b + p_74965_4_, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c(), p_74965_6_);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(p_74965_1_, p_74965_2_, p_74965_3_, this.field_74887_e.field_78897_a + p_74965_5_, this.field_74887_e.field_78895_b + p_74965_4_, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c(), p_74965_6_);
                    }
                }
            }
            return null;
        }

        protected static boolean isAboveGround(MutableBoundingBox p_74964_0_) {
            return p_74964_0_ != null && p_74964_0_.field_78895_b > 10;
        }

        protected BlockState getStoneVariantBlockState(BlockState blockstateIn, Random rand) {
            Block block = blockstateIn.func_177230_c();
            if (this.stoneVariant) {
                if (block == Blocks.field_196653_dH) {
                    float silverfishThreshold;
                    float chance = rand.nextFloat();
                    BlockState newBlockState = chance < 0.6f ? Blocks.field_196696_di.func_176223_P() : (chance < 0.7f ? Blocks.field_196700_dk.func_176223_P() : (chance < 0.85f ? Blocks.field_196698_dj.func_176223_P() : Blocks.field_196702_dl.func_176223_P()));
                    chance = rand.nextFloat();
                    if (chance < (silverfishThreshold = (float)(UltraAmplified.UAStructuresConfig.silverfishStrongholdSpawnrate.get() / 100.0))) {
                        newBlockState = (BlockState)INFESTED_STONE_LOOKUP.get(newBlockState);
                    }
                    return newBlockState;
                }
                if (block == Blocks.field_150386_bk) {
                    return (BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)((Boolean)blockstateIn.func_177229_b((IProperty)FourWayBlock.field_196409_a)))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)((Boolean)blockstateIn.func_177229_b((IProperty)FourWayBlock.field_196411_b)))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)((Boolean)blockstateIn.func_177229_b((IProperty)FourWayBlock.field_196413_c)))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)((Boolean)blockstateIn.func_177229_b((IProperty)FourWayBlock.field_196414_y)));
                }
                if (block == Blocks.field_150387_bl) {
                    float chance = rand.nextFloat();
                    if (chance < 0.8f) {
                        return (BlockState)Blocks.field_150390_bg.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)((Direction)blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a)));
                    }
                    return (BlockState)Blocks.field_222409_kX.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)((Direction)blockstateIn.func_177229_b((IProperty)StairsBlock.field_176309_a)));
                }
                if (block == Blocks.field_150425_aM) {
                    return Blocks.field_196660_k.func_176223_P();
                }
                if (block == Blocks.field_150388_bm) {
                    float chance = rand.nextFloat();
                    if (chance < 0.25f) {
                        return Blocks.field_150337_Q.func_176223_P();
                    }
                    if (chance < 0.4f) {
                        return Blocks.field_150338_P.func_176223_P();
                    }
                    return Blocks.field_201941_jj.func_176223_P();
                }
                if (block == Blocks.field_150353_l) {
                    return Blocks.field_150355_j.func_176223_P();
                }
            }
            return block.func_176223_P();
        }

        protected void setVariant(boolean isStone) {
            this.stoneVariant = isStone;
        }

        protected void fillWithRandomBlocks(IWorld world, MutableBoundingBox boundingboxIn, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockState boundaryBlockState, BlockState insideBlockState, boolean existingOnly, Random rand) {
            for (int i = yMin; i <= yMax; ++i) {
                for (int j = xMin; j <= xMax; ++j) {
                    for (int k = zMin; k <= zMax; ++k) {
                        if (existingOnly && this.func_175807_a((IBlockReader)world, j, i, k, boundingboxIn).func_185904_a() == Material.field_151579_a) continue;
                        if (i != yMin && i != yMax && j != xMin && j != xMax && k != zMin && k != zMax) {
                            this.func_175811_a(world, insideBlockState, j, i, k, boundingboxIn);
                            continue;
                        }
                        this.func_175811_a(world, this.getStoneVariantBlockState(boundaryBlockState.func_177230_c().func_176223_P(), rand), j, i, k, boundingboxIn);
                    }
                }
            }
        }

        protected void replaceAirAndLiquidDownwardsRandomBlocks(IWorld world, BlockState blockstateIn, int x, int y, int z, MutableBoundingBox boundingboxIn, Random rand) {
            int k;
            int j;
            int i = this.func_74865_a(x, z);
            if (boundingboxIn.func_175898_b((Vec3i)new BlockPos(i, j = this.func_74862_a(y), k = this.func_74873_b(x, z)))) {
                while ((world.func_175623_d(new BlockPos(i, j, k)) || world.func_180495_p(new BlockPos(i, j, k)).func_185904_a().func_76224_d()) && j > 1) {
                    world.func_180501_a(new BlockPos(i, j, k), this.getStoneVariantBlockState(blockstateIn.func_177230_c().func_176223_P(), rand), 2);
                    --j;
                }
            }
        }
    }

    public static class NetherStalkRoom
    extends Piece {
        public NetherStalkRoom(int p_i50264_1_, MutableBoundingBox p_i50264_2_, Direction p_i50264_3_, boolean isStone) {
            super(StructureInitUA.NECSRUA, p_i50264_1_, isStone);
            this.func_186164_a(p_i50264_3_);
            this.field_74887_e = p_i50264_2_;
        }

        public NetherStalkRoom(TemplateManager p_i50265_1_, CompoundNBT p_i50265_2_) {
            super(StructureInitUA.NECSRUA, p_i50265_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 5, 3, true);
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 5, 11, true);
        }

        public static NetherStalkRoom createPiece(List<StructurePiece> p_175875_0_, Random p_175875_1_, int p_175875_2_, int p_175875_3_, int p_175875_4_, Direction p_175875_5_, int p_175875_6_, boolean isStone) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175875_2_, (int)p_175875_3_, (int)p_175875_4_, (int)-5, (int)-3, (int)0, (int)13, (int)14, (int)13, (Direction)p_175875_5_);
            return NetherStalkRoom.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175875_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new NetherStalkRoom(p_175875_6_, mutableBoundingBox, p_175875_5_, isStone) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 3, 0, 12, 4, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 5, 0, 12, 13, 12, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 5, 0, 1, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 11, 5, 0, 12, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 5, 11, 4, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 8, 5, 11, 10, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 9, 11, 7, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 5, 0, 4, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 8, 5, 0, 10, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 9, 0, 7, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 11, 2, 10, 12, 10, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate2 = (BlockState)iblockstate1.func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true));
            BlockState iblockstate3 = (BlockState)iblockstate1.func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            for (int i = 1; i <= 11; i += 2) {
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, i, 10, 0, i, 11, 0, iblockstate, iblockstate, false, random);
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, i, 10, 12, i, 11, 12, iblockstate, iblockstate, false, random);
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 10, i, 0, 11, i, iblockstate1, iblockstate1, false, random);
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, 12, 10, i, 12, 11, i, iblockstate1, iblockstate1, false, random);
                this.func_175811_a(world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), i, 13, 0, structureBoundingBoxIn);
                this.func_175811_a(world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), i, 13, 12, structureBoundingBoxIn);
                this.func_175811_a(world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), 0, 13, i, structureBoundingBoxIn);
                this.func_175811_a(world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), 12, 13, i, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate, i + 1, 13, 0, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate, i + 1, 13, 12, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate1, 0, 13, i + 1, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate1, 12, 13, i + 1, structureBoundingBoxIn);
            }
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random), 0, 13, 0, structureBoundingBoxIn);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random), 0, 13, 12, structureBoundingBoxIn);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), random), 12, 13, 12, structureBoundingBoxIn);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), random), 12, 13, 0, structureBoundingBoxIn);
            for (int j1 = 3; j1 <= 9; j1 += 2) {
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 7, j1, 1, 8, j1, iblockstate2, iblockstate2, false, random);
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, 11, 7, j1, 11, 8, j1, iblockstate3, iblockstate3, false, random);
            }
            BlockState iblockstate4 = this.getStoneVariantBlockState((BlockState)Blocks.field_150387_bl.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH), random);
            for (int j = 0; j <= 6; ++j) {
                int k = j + 4;
                for (int l = 5; l <= 7; ++l) {
                    this.func_175811_a(world, iblockstate4, l, 5 + j, k, structureBoundingBoxIn);
                }
                if (k >= 5 && k <= 8) {
                    this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 5, k, 7, j + 4, k, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                } else if (k >= 9 && k <= 10) {
                    this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 8, k, 7, j + 4, k, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                }
                if (j < 1) continue;
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 6 + j, k, 7, 9 + j, k, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            }
            for (int k1 = 5; k1 <= 7; ++k1) {
                this.func_175811_a(world, iblockstate4, k1, 12, 11, structureBoundingBoxIn);
            }
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 6, 7, 5, 7, 7, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 7, 6, 7, 7, 7, 7, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 13, 12, 7, 13, 12, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 5, 2, 3, 5, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 5, 9, 3, 5, 10, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 5, 4, 2, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 9, 5, 2, 10, 5, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 9, 5, 9, 10, 5, 10, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 10, 5, 4, 10, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            BlockState iblockstate5 = (BlockState)iblockstate4.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            BlockState iblockstate6 = (BlockState)iblockstate4.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST);
            this.func_175811_a(world, iblockstate6, 4, 5, 2, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 4, 5, 3, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 4, 5, 9, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate6, 4, 5, 10, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate5, 8, 5, 2, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate5, 8, 5, 3, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate5, 8, 5, 9, structureBoundingBoxIn);
            this.func_175811_a(world, iblockstate5, 8, 5, 10, structureBoundingBoxIn);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 3, 4, 4, 4, 4, 8, Blocks.field_150425_aM.func_176223_P(), Blocks.field_150425_aM.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 8, 4, 4, 9, 4, 8, Blocks.field_150425_aM.func_176223_P(), Blocks.field_150425_aM.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 3, 5, 4, 4, 5, 8, Blocks.field_150388_bm.func_176223_P(), Blocks.field_150388_bm.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 8, 5, 4, 9, 5, 8, Blocks.field_150388_bm.func_176223_P(), Blocks.field_150388_bm.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 2, 0, 8, 2, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 4, 12, 2, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 0, 0, 8, 1, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 0, 9, 8, 1, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 0, 4, 3, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 9, 0, 4, 12, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int l1 = 4; l1 <= 8; ++l1) {
                for (int i1 = 0; i1 <= 2; ++i1) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), l1, -1, i1, structureBoundingBoxIn, random);
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), l1, -1, 12 - i1, structureBoundingBoxIn, random);
                }
            }
            for (int i2 = 0; i2 <= 2; ++i2) {
                for (int j2 = 4; j2 <= 8; ++j2) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i2, -1, j2, structureBoundingBoxIn, random);
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), 12 - i2, -1, j2, structureBoundingBoxIn, random);
                }
            }
            FortressPiecesUA.attemptToAddVines(world, p_225577_2_, random, this, structureBoundingBoxIn, this.stoneVariant);
            return true;
        }
    }

    public static class Entrance
    extends Piece {
        public Entrance(int p_i45617_1_, Random rand, MutableBoundingBox p_i45617_3_, Direction p_i45617_4_, boolean isStone) {
            super(StructureInitUA.NECEUA, p_i45617_1_, isStone);
            this.func_186164_a(p_i45617_4_);
            this.field_74887_e = p_i45617_3_;
        }

        public Entrance(TemplateManager p_i50276_1_, CompoundNBT p_i50276_2_) {
            super(StructureInitUA.NECEUA, p_i50276_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 5, 3, true);
        }

        public static Entrance createPiece(List<StructurePiece> p_175881_0_, Random p_175881_1_, int p_175881_2_, int p_175881_3_, int p_175881_4_, Direction p_175881_5_, int p_175881_6_, boolean isStone) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175881_2_, (int)p_175881_3_, (int)p_175881_4_, (int)-5, (int)-3, (int)0, (int)13, (int)14, (int)13, (Direction)p_175881_5_);
            return Entrance.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175881_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new Entrance(p_175881_6_, p_175881_1_, mutableBoundingBox, p_175881_5_, isStone) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 3, 0, 12, 4, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 5, 0, 12, 13, 12, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 5, 0, 1, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 11, 5, 0, 12, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 5, 11, 4, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 8, 5, 11, 10, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 9, 11, 7, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 5, 0, 4, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 8, 5, 0, 10, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 9, 0, 7, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 11, 2, 10, 12, 10, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 8, 0, 7, 8, 0, this.getStoneVariantBlockState(Blocks.field_150386_bk.func_176223_P(), random), this.getStoneVariantBlockState(Blocks.field_150386_bk.func_176223_P(), random), false, random);
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            for (int i = 1; i <= 11; i += 2) {
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, i, 10, 0, i, 11, 0, iblockstate, iblockstate, false, random);
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, i, 10, 12, i, 11, 12, iblockstate, iblockstate, false, random);
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 10, i, 0, 11, i, iblockstate1, iblockstate1, false, random);
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, 12, 10, i, 12, 11, i, iblockstate1, iblockstate1, false, random);
                this.func_175811_a(world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), i, 13, 0, structureBoundingBoxIn);
                this.func_175811_a(world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), i, 13, 12, structureBoundingBoxIn);
                this.func_175811_a(world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), 0, 13, i, structureBoundingBoxIn);
                this.func_175811_a(world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), 12, 13, i, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate, i + 1, 13, 0, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate, i + 1, 13, 12, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate1, 0, 13, i + 1, structureBoundingBoxIn);
                this.func_175811_a(world, iblockstate1, 12, 13, i + 1, structureBoundingBoxIn);
            }
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random), 0, 13, 0, structureBoundingBoxIn);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random), 0, 13, 12, structureBoundingBoxIn);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), random), 12, 13, 12, structureBoundingBoxIn);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), random), 12, 13, 0, structureBoundingBoxIn);
            for (int k = 3; k <= 9; k += 2) {
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 7, k, 1, 8, k, (BlockState)iblockstate.func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), (BlockState)iblockstate.func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), false, random);
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, 11, 7, k, 11, 8, k, (BlockState)iblockstate.func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), (BlockState)iblockstate.func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), false, random);
            }
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 2, 0, 8, 2, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 4, 12, 2, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 0, 0, 8, 1, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 0, 9, 8, 1, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 0, 4, 3, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 9, 0, 4, 12, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int l = 4; l <= 8; ++l) {
                for (int j = 0; j <= 2; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), l, -1, j, structureBoundingBoxIn, random);
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), l, -1, 12 - j, structureBoundingBoxIn, random);
                }
            }
            for (int i1 = 0; i1 <= 2; ++i1) {
                for (int j1 = 4; j1 <= 8; ++j1) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i1, -1, j1, structureBoundingBoxIn, random);
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), 12 - i1, -1, j1, structureBoundingBoxIn, random);
                }
            }
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 5, 5, 7, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 6, 1, 6, 6, 4, 6, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.func_175811_a(world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), 6, 0, 6, structureBoundingBoxIn);
            this.func_175811_a(world, this.getStoneVariantBlockState(Blocks.field_150353_l.func_176223_P(), random), 6, 5, 6, structureBoundingBoxIn);
            BlockPos blockpos = new BlockPos(this.func_74865_a(6, 6), this.func_74862_a(5), this.func_74873_b(6, 6));
            if (UltraAmplified.UAStructuresConfig.chestGeneration.get().booleanValue()) {
                this.func_186167_a(world, structureBoundingBoxIn, random, 6, 5, 8, this.stoneVariant ? FortressPiecesUA.pickRandomLoot(random) : LootTables.field_186425_g);
            }
            if (structureBoundingBoxIn.func_175898_b((Vec3i)blockpos)) {
                world.func_205219_F_().func_205360_a(blockpos, (Object)Fluids.field_204547_b, 0);
            }
            FortressPiecesUA.attemptToAddVines(world, p_225577_2_, random, this, structureBoundingBoxIn, this.stoneVariant);
            return true;
        }
    }

    public static class End
    extends Piece {
        private int fillSeed;

        public End(int p_i45621_1_, Random p_i45621_2_, MutableBoundingBox p_i45621_3_, Direction p_i45621_4_, boolean isStone) {
            super(StructureInitUA.NEBEFUA, p_i45621_1_, isStone);
            this.func_186164_a(p_i45621_4_);
            this.field_74887_e = p_i45621_3_;
            this.fillSeed = p_i45621_2_.nextInt();
        }

        public End(TemplateManager p_i50285_1_, CompoundNBT p_i50285_2_) {
            super(StructureInitUA.NEBEFUA, p_i50285_2_);
            this.fillSeed = p_i50285_2_.func_74762_e("Seed");
        }

        public static End createPiece(List<StructurePiece> p_175884_0_, Random p_175884_1_, int p_175884_2_, int p_175884_3_, int p_175884_4_, Direction p_175884_5_, int p_175884_6_, boolean isStone) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175884_2_, (int)p_175884_3_, (int)p_175884_4_, (int)-1, (int)-3, (int)0, (int)5, (int)10, (int)8, (Direction)p_175884_5_);
            return End.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175884_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new End(p_175884_6_, p_175884_1_, mutableBoundingBox, p_175884_5_, isStone) : null;
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("Seed", this.fillSeed);
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            Random seededRandom = new Random(this.fillSeed);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 3; j <= 4; ++j) {
                    int k = seededRandom.nextInt(8);
                    this.fillWithRandomBlocks(world, structureBoundingBoxIn, i, j, 0, i, j, k, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                }
            }
            int l = seededRandom.nextInt(8);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 5, 0, 0, 5, l, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            l = seededRandom.nextInt(8);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 5, 0, 4, 5, l, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (l = 0; l <= 4; ++l) {
                int i1 = seededRandom.nextInt(5);
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, l, 2, 0, l, 2, i1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            }
            for (l = 0; l <= 4; ++l) {
                for (int j1 = 0; j1 <= 1; ++j1) {
                    int k1 = seededRandom.nextInt(3);
                    this.fillWithRandomBlocks(world, structureBoundingBoxIn, l, j1, 0, l, j1, k1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                }
            }
            return true;
        }
    }

    public static class Crossing3
    extends Piece {
        protected Crossing3(IStructurePieceType p_i50287_1_, CompoundNBT p_i50287_2_) {
            super(p_i50287_1_, p_i50287_2_);
        }

        public Crossing3(TemplateManager p_i50288_1_, CompoundNBT p_i50288_2_) {
            this(StructureInitUA.NEBCRUA, p_i50288_2_);
        }

        public Crossing3(int p_i50286_1_, MutableBoundingBox p_i50286_2_, Direction p_i50286_3_, boolean isStone) {
            super(StructureInitUA.NEBCRUA, p_i50286_1_, isStone);
            this.func_186164_a(p_i50286_3_);
            this.field_74887_e = p_i50286_2_;
        }

        protected Crossing3(Random p_i2042_1_, int p_i2042_2_, int p_i2042_3_, boolean isStone) {
            super(StructureInitUA.NEBCRUA, 0, isStone);
            this.func_186164_a(Direction.Plane.HORIZONTAL.func_179518_a(p_i2042_1_));
            this.field_74887_e = this.func_186165_e().func_176740_k() == Direction.Axis.Z ? new MutableBoundingBox(p_i2042_2_, 64, p_i2042_3_, p_i2042_2_ + 19 - 1, 73, p_i2042_3_ + 19 - 1) : new MutableBoundingBox(p_i2042_2_, 64, p_i2042_3_, p_i2042_2_ + 19 - 1, 73, p_i2042_3_ + 19 - 1);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 8, 3, false);
            this.getNextComponentX((Start)componentIn, listIn, rand, 3, 8, false);
            this.getNextComponentZ((Start)componentIn, listIn, rand, 3, 8, false);
        }

        public static Crossing3 createPiece(List<StructurePiece> p_175885_0_, Random p_175885_1_, int p_175885_2_, int p_175885_3_, int p_175885_4_, Direction p_175885_5_, int p_175885_6_, boolean isStone) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175885_2_, (int)p_175885_3_, (int)p_175885_4_, (int)-8, (int)-3, (int)0, (int)19, (int)10, (int)19, (Direction)p_175885_5_);
            return Crossing3.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175885_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new Crossing3(p_175885_6_, mutableBoundingBox, p_175885_5_, isStone) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 7, 3, 0, 11, 4, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 3, 7, 18, 4, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 8, 5, 0, 10, 7, 18, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 5, 8, 18, 7, 10, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 7, 5, 0, 7, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 7, 5, 11, 7, 5, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 11, 5, 0, 11, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 11, 5, 11, 11, 5, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 5, 7, 7, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 11, 5, 7, 18, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 5, 11, 7, 5, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 11, 5, 11, 18, 5, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 7, 2, 0, 11, 2, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 7, 2, 13, 11, 2, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 7, 0, 0, 11, 1, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 7, 0, 15, 11, 1, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int i = 7; i <= 11; ++i) {
                for (int j = 0; j <= 2; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, structureBoundingBoxIn, random);
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, 18 - j, structureBoundingBoxIn, random);
                }
            }
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 7, 5, 2, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 13, 2, 7, 18, 2, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 0, 7, 3, 1, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 15, 0, 7, 18, 1, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int k = 0; k <= 2; ++k) {
                for (int l = 7; l <= 11; ++l) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), k, -1, l, structureBoundingBoxIn, random);
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), 18 - k, -1, l, structureBoundingBoxIn, random);
                }
            }
            FortressPiecesUA.attemptToAddVines(world, p_225577_2_, random, this, structureBoundingBoxIn, this.stoneVariant);
            return true;
        }
    }

    public static class Crossing2
    extends Piece {
        public Crossing2(int p_i50273_1_, MutableBoundingBox p_i50273_2_, Direction p_i50273_3_, boolean isStone) {
            super(StructureInitUA.NESCSCUA, p_i50273_1_, isStone);
            this.func_186164_a(p_i50273_3_);
            this.field_74887_e = p_i50273_2_;
        }

        public Crossing2(TemplateManager p_i50274_1_, CompoundNBT p_i50274_2_) {
            super(StructureInitUA.NESCSCUA, p_i50274_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 1, 0, true);
            this.getNextComponentX((Start)componentIn, listIn, rand, 0, 1, true);
            this.getNextComponentZ((Start)componentIn, listIn, rand, 0, 1, true);
        }

        public static Crossing2 createPiece(List<StructurePiece> p_175878_0_, Random p_175878_1_, int p_175878_2_, int p_175878_3_, int p_175878_4_, Direction p_175878_5_, int p_175878_6_, boolean isStone) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175878_2_, (int)p_175878_3_, (int)p_175878_4_, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (Direction)p_175878_5_);
            return Crossing2.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175878_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new Crossing2(p_175878_6_, mutableBoundingBox, p_175878_5_, isStone) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 0, 0, 4, 1, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 4, 5, 4, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 0, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 2, 0, 4, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 4, 0, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 2, 4, 4, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 6, 0, 4, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, structureBoundingBoxIn, random);
                }
            }
            FortressPiecesUA.attemptToAddVines(world, p_225577_2_, random, this, structureBoundingBoxIn, this.stoneVariant);
            return true;
        }
    }

    public static class Crossing
    extends Piece {
        public Crossing(int p_i50258_1_, MutableBoundingBox p_i50258_2_, Direction p_i50258_3_, boolean isStone) {
            super(StructureInitUA.NERCUA, p_i50258_1_, isStone);
            this.func_186164_a(p_i50258_3_);
            this.field_74887_e = p_i50258_2_;
        }

        public Crossing(TemplateManager p_i50259_1_, CompoundNBT p_i50259_2_) {
            super(StructureInitUA.NERCUA, p_i50259_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 2, 0, false);
            this.getNextComponentX((Start)componentIn, listIn, rand, 0, 2, false);
            this.getNextComponentZ((Start)componentIn, listIn, rand, 0, 2, false);
        }

        public static Crossing createPiece(List<StructurePiece> p_175873_0_, Random p_175873_1_, int p_175873_2_, int p_175873_3_, int p_175873_4_, Direction p_175873_5_, int p_175873_6_, boolean isStone) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175873_2_, (int)p_175873_3_, (int)p_175873_4_, (int)-2, (int)0, (int)0, (int)7, (int)9, (int)7, (Direction)p_175873_5_);
            return Crossing.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175873_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new Crossing(p_175873_6_, mutableBoundingBox, p_175873_5_, isStone) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 0, 0, 6, 1, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 6, 7, 6, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 1, 6, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 6, 1, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 2, 0, 6, 6, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 5, 2, 6, 6, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 0, 6, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 5, 0, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 6, 2, 0, 6, 6, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 6, 2, 5, 6, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 6, 0, 4, 6, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 5, 0, 4, 5, 0, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 6, 6, 4, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 2, 5, 6, 4, 5, 6, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 6, 2, 0, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 5, 2, 0, 5, 4, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 6, 6, 2, 6, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 6, 5, 2, 6, 5, 4, iblockstate1, iblockstate1, false, random);
            for (int i = 0; i <= 6; ++i) {
                for (int j = 0; j <= 6; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, structureBoundingBoxIn, random);
                }
            }
            FortressPiecesUA.attemptToAddVines(world, p_225577_2_, random, this, structureBoundingBoxIn, this.stoneVariant);
            return true;
        }
    }

    public static class Corridor5
    extends Piece {
        public Corridor5(int p_i50268_1_, MutableBoundingBox p_i50268_2_, Direction p_i50268_3_, boolean isStone) {
            super(StructureInitUA.NESCUA, p_i50268_1_, isStone);
            this.func_186164_a(p_i50268_3_);
            this.field_74887_e = p_i50268_2_;
        }

        public Corridor5(TemplateManager p_i50269_1_, CompoundNBT p_i50269_2_) {
            super(StructureInitUA.NESCUA, p_i50269_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 1, 0, true);
        }

        public static Corridor5 createPiece(List<StructurePiece> p_175877_0_, Random p_175877_1_, int p_175877_2_, int p_175877_3_, int p_175877_4_, Direction p_175877_5_, int p_175877_6_, boolean isStone) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175877_2_, (int)p_175877_3_, (int)p_175877_4_, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (Direction)p_175877_5_);
            return Corridor5.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175877_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new Corridor5(p_175877_6_, mutableBoundingBox, p_175877_5_, isStone) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 0, 0, 4, 1, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 4, 5, 4, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 0, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 2, 0, 4, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 3, 1, 0, 4, 1, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 3, 3, 0, 4, 3, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 3, 1, 4, 4, 1, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 3, 3, 4, 4, 3, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 6, 0, 4, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, structureBoundingBoxIn, random);
                }
            }
            FortressPiecesUA.attemptToAddVines(world, p_225577_2_, random, this, structureBoundingBoxIn, this.stoneVariant);
            return true;
        }
    }

    public static class Corridor4
    extends Piece {
        public Corridor4(int p_i50277_1_, MutableBoundingBox p_i50277_2_, Direction p_i50277_3_, boolean isStone) {
            super(StructureInitUA.NECTBUA, p_i50277_1_, isStone);
            this.func_186164_a(p_i50277_3_);
            this.field_74887_e = p_i50277_2_;
        }

        public Corridor4(TemplateManager p_i50278_1_, CompoundNBT p_i50278_2_) {
            super(StructureInitUA.NECTBUA, p_i50278_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int i = 1;
            Direction enumfacing = this.func_186165_e();
            if (enumfacing == Direction.WEST || enumfacing == Direction.NORTH) {
                i = 5;
            }
            this.getNextComponentX((Start)componentIn, listIn, rand, 0, i, rand.nextInt(8) > 0);
            this.getNextComponentZ((Start)componentIn, listIn, rand, 0, i, rand.nextInt(8) > 0);
        }

        public static Corridor4 createPiece(List<StructurePiece> p_175880_0_, Random p_175880_1_, int p_175880_2_, int p_175880_3_, int p_175880_4_, Direction p_175880_5_, int p_175880_6_, boolean isStone) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175880_2_, (int)p_175880_3_, (int)p_175880_4_, (int)-3, (int)0, (int)0, (int)9, (int)7, (int)9, (Direction)p_175880_5_);
            return Corridor4.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175880_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new Corridor4(p_175880_6_, mutableBoundingBox, p_175880_5_, isStone) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 0, 0, 8, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 8, 5, 8, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 6, 0, 8, 6, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 2, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 6, 2, 0, 8, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 3, 0, 1, 4, 0, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 7, 3, 0, 7, 4, 0, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 4, 8, 2, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 1, 4, 2, 2, 4, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 6, 1, 4, 7, 2, 4, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 3, 8, 7, 3, 8, iblockstate1, iblockstate1, false, random);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random), 0, 3, 8, structureBoundingBoxIn);
            this.func_175811_a(world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random), 8, 3, 8, structureBoundingBoxIn);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 3, 6, 0, 3, 7, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 8, 3, 6, 8, 3, 7, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 3, 4, 0, 5, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 8, 3, 4, 8, 5, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 3, 5, 2, 5, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 6, 3, 5, 7, 5, 5, Blocks.field_196653_dH.func_176223_P(), this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 4, 5, 1, 5, 5, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 7, 4, 5, 7, 5, 5, iblockstate1, iblockstate1, false, random);
            for (int i = 0; i <= 5; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), j, -1, i, structureBoundingBoxIn, random);
                }
            }
            FortressPiecesUA.attemptToAddVines(world, p_225577_2_, random, this, structureBoundingBoxIn, this.stoneVariant);
            return true;
        }
    }

    public static class Corridor3
    extends Piece {
        public Corridor3(int p_i50280_1_, MutableBoundingBox p_i50280_2_, Direction p_i50280_3_, boolean isStone) {
            super(StructureInitUA.NECCSUA, p_i50280_1_, isStone);
            this.func_186164_a(p_i50280_3_);
            this.field_74887_e = p_i50280_2_;
        }

        public Corridor3(TemplateManager p_i50281_1_, CompoundNBT p_i50281_2_) {
            super(StructureInitUA.NECCSUA, p_i50281_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 1, 0, true);
        }

        public static Corridor3 createPiece(List<StructurePiece> p_175883_0_, Random p_175883_1_, int p_175883_2_, int p_175883_3_, int p_175883_4_, Direction p_175883_5_, int p_175883_6_, boolean isStone) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175883_2_, (int)p_175883_3_, (int)p_175883_4_, (int)-1, (int)-7, (int)0, (int)5, (int)14, (int)10, (Direction)p_175883_5_);
            return Corridor3.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175883_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new Corridor3(p_175883_6_, mutableBoundingBox, p_175883_5_, isStone) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)Blocks.field_150387_bl.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            for (int i = 0; i <= 9; ++i) {
                int j = Math.max(1, 7 - i);
                int k = Math.min(Math.max(j + 5, 14 - i), 13);
                int l = i;
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 0, i, 4, j, i, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, j + 1, i, 3, k - 1, i, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
                if (i <= 6) {
                    this.func_175811_a(world, iblockstate, 1, j + 1, i, structureBoundingBoxIn);
                    this.func_175811_a(world, iblockstate, 2, j + 1, i, structureBoundingBoxIn);
                    this.func_175811_a(world, iblockstate, 3, j + 1, i, structureBoundingBoxIn);
                }
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, k, i, 4, k, i, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, j + 1, i, 0, k - 1, i, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, j + 1, i, 4, k - 1, i, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                if ((i & 1) == 0) {
                    this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, j + 2, i, 0, j + 3, i, iblockstate1, iblockstate1, false, random);
                    this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, j + 2, i, 4, j + 3, i, iblockstate1, iblockstate1, false, random);
                }
                for (int i1 = 0; i1 <= 4; ++i1) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i1, -1, l, structureBoundingBoxIn, random);
                }
            }
            FortressPiecesUA.attemptToAddVines(world, p_225577_2_, random, this, structureBoundingBoxIn, this.stoneVariant);
            return true;
        }
    }

    public static class Corridor2
    extends Piece {
        public Corridor2(int p_i45613_1_, Random rand, MutableBoundingBox p_i45613_3_, Direction p_i45613_4_, boolean isStone) {
            super(StructureInitUA.NESCRTUA, p_i45613_1_, isStone);
            this.func_186164_a(p_i45613_4_);
            this.field_74887_e = p_i45613_3_;
        }

        public Corridor2(TemplateManager p_i50266_1_, CompoundNBT p_i50266_2_) {
            super(StructureInitUA.NESCRTUA, p_i50266_2_);
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentZ((Start)componentIn, listIn, rand, 0, 1, true);
        }

        public static Corridor2 createPiece(List<StructurePiece> p_175876_0_, Random p_175876_1_, int p_175876_2_, int p_175876_3_, int p_175876_4_, Direction p_175876_5_, int p_175876_6_, boolean isStone) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175876_2_, (int)p_175876_3_, (int)p_175876_4_, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (Direction)p_175876_5_);
            return Corridor2.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175876_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new Corridor2(p_175876_6_, p_175876_1_, mutableBoundingBox, p_175876_5_, isStone) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 0, 0, 4, 1, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 4, 5, 4, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            BlockState iblockstate = (BlockState)((BlockState)this.getStoneVariantBlockState(Blocks.field_150386_bk.func_176223_P(), random).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            BlockState iblockstate1 = (BlockState)((BlockState)this.getStoneVariantBlockState(Blocks.field_150386_bk.func_176223_P(), random).func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 0, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 3, 1, 0, 4, 1, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 3, 3, 0, 4, 3, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 2, 0, 4, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 2, 4, 4, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 3, 4, 1, 4, 4, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 3, 3, 4, 3, 4, 4, iblockstate, iblockstate, false, random);
            if (UltraAmplified.UAStructuresConfig.chestGeneration.get().booleanValue() && (this.stoneVariant ? random.nextInt(9) == 0 : random.nextInt(6) == 0) && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(1, 3), this.func_74862_a(2), this.func_74873_b(1, 3)))) {
                this.func_186167_a(world, structureBoundingBoxIn, random, 1, 2, 3, this.stoneVariant ? FortressPiecesUA.pickRandomLoot(random) : LootTables.field_186425_g);
            }
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 6, 0, 4, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, structureBoundingBoxIn, random);
                }
            }
            FortressPiecesUA.attemptToAddVines(world, p_225577_2_, random, this, structureBoundingBoxIn, this.stoneVariant);
            return true;
        }
    }

    public static class Corridor
    extends Piece {
        public Corridor(int p_i45615_1_, Random rand, MutableBoundingBox p_i45615_3_, Direction p_i45615_4_, boolean isStone) {
            super(StructureInitUA.NESCLTUA, p_i45615_1_, isStone);
            this.func_186164_a(p_i45615_4_);
            this.field_74887_e = p_i45615_3_;
        }

        public Corridor(TemplateManager p_i50272_1_, CompoundNBT p_i50272_2_) {
            super(StructureInitUA.NESCLTUA, p_i50272_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentX((Start)componentIn, listIn, rand, 0, 1, true);
        }

        public static Corridor createPiece(List<StructurePiece> p_175879_0_, Random p_175879_1_, int p_175879_2_, int p_175879_3_, int p_175879_4_, Direction p_175879_5_, int p_175879_6_, boolean isStone) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175879_2_, (int)p_175879_3_, (int)p_175879_4_, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (Direction)p_175879_5_);
            return Corridor.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175879_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new Corridor(p_175879_6_, p_175879_1_, mutableBoundingBox, p_175879_5_, isStone) : null;
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 0, 0, 4, 1, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 4, 5, 4, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 2, 0, 4, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 3, 1, 4, 4, 1, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 4, 3, 3, 4, 4, 3, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 0, 0, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 2, 4, 3, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 1, 3, 4, 1, 4, 4, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 3, 3, 4, 3, 4, 4, iblockstate, iblockstate, false, random);
            if (UltraAmplified.UAStructuresConfig.chestGeneration.get().booleanValue() && (this.stoneVariant ? random.nextInt(9) == 0 : random.nextInt(6) == 0) && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(3, 3), this.func_74862_a(2), this.func_74873_b(3, 3)))) {
                this.func_186167_a(world, structureBoundingBoxIn, random, 3, 2, 3, this.stoneVariant ? FortressPiecesUA.pickRandomLoot(random) : LootTables.field_186425_g);
            }
            this.fillWithRandomBlocks(world, structureBoundingBoxIn, 0, 6, 0, 4, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, structureBoundingBoxIn, random);
                }
            }
            FortressPiecesUA.attemptToAddVines(world, p_225577_2_, random, this, structureBoundingBoxIn, this.stoneVariant);
            return true;
        }
    }
}

