/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.feature.structure.StructureInitUA;

public class IceSpikeTemplePiecesUA {
    private static final ResourceLocation CENTER = new ResourceLocation("ultra_amplified_dimension:ice_spike_temple_center");
    private static final ResourceLocation CENTER_TOP = new ResourceLocation("ultra_amplified_dimension:ice_spike_temple_center_top");
    private static final ResourceLocation LEFT_BODY = new ResourceLocation("ultra_amplified_dimension:ice_spike_temple_left_body");
    private static final ResourceLocation RIGHT_BODY = new ResourceLocation("ultra_amplified_dimension:ice_spike_temple_right_body");
    private static final ResourceLocation CHESTS_1_ICE_SPIKE_TEMPLE_UA = new ResourceLocation("ultra_amplified_dimension:chests/ice_spike_temple_1_ua");
    private static final ResourceLocation CHESTS_2_ICE_SPIKE_TEMPLE_UA = new ResourceLocation("ultra_amplified_dimension:chests/ice_spike_temple_2_ua");
    private static final Map<ResourceLocation, BlockPos> OFFSET = ImmutableMap.of((Object)CENTER, (Object)new BlockPos(0, -7, 0), (Object)CENTER_TOP, (Object)new BlockPos(0, 10, 0), (Object)LEFT_BODY, (Object)new BlockPos(0, -7, 0), (Object)RIGHT_BODY, (Object)new BlockPos(0, -7, 0));

    public static void start(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList, Random random) {
        IceSpikeTemplePiecesUA.addPartToList(templateManager, pos, rotation, pieceList, random, CENTER);
        IceSpikeTemplePiecesUA.addPartToList(templateManager, pos, rotation, pieceList, random, CENTER_TOP);
        IceSpikeTemplePiecesUA.addSideSpikes(templateManager, random, rotation, pos, pieceList);
    }

    private static void addSideSpikes(TemplateManager templateManager, Random random, Rotation rotationIn, BlockPos pos, List<StructurePiece> pieceList) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        BlockPos offSet = new BlockPos(-9, 4, 5).func_190942_a(rotationIn);
        BlockPos blockpos2 = offSet.func_177982_a(x, pos.func_177956_o(), z);
        IceSpikeTemplePiecesUA.addPartToList(templateManager, blockpos2, rotationIn, pieceList, random, LEFT_BODY);
        offSet = new BlockPos(19, 4, 0).func_190942_a(rotationIn);
        BlockPos blockpos3 = offSet.func_177982_a(x, pos.func_177956_o(), z);
        IceSpikeTemplePiecesUA.addPartToList(templateManager, blockpos3, rotationIn, pieceList, random, RIGHT_BODY);
    }

    private static void addPartToList(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList, Random random, ResourceLocation rl) {
        pieceList.add((StructurePiece)new Piece(templateManager, rl, pos, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation resourceLocation;
        private Rotation rotation;

        public Piece(TemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotationIn) {
            super(StructureInitUA.ISTUA, 0);
            this.resourceLocation = resourceLocationIn;
            BlockPos blockpos = (BlockPos)OFFSET.get(this.resourceLocation);
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            this.rotation = rotationIn;
            this.setupPiece(templateManagerIn);
        }

        public Piece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(StructureInitUA.ISTUA, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.setupPiece(templateManagerIn);
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld world, Random rand, MutableBoundingBox sbb) {
            if ("chest".equals(function)) {
                TileEntity tileentity;
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                if (UltraAmplified.UAStructuresConfig.chestGeneration.get().booleanValue() && (tileentity = world.func_175625_s(pos.func_177977_b())) instanceof ChestTileEntity) {
                    if (UltraAmplified.UAStructuresConfig.chestGeneration.get().booleanValue()) {
                        ((ChestTileEntity)tileentity).func_189404_a(CHESTS_1_ICE_SPIKE_TEMPLE_UA, rand.nextLong());
                    } else {
                        world.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            } else if ("chest2".equals(function)) {
                TileEntity tileentity;
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                if (UltraAmplified.UAStructuresConfig.chestGeneration.get().booleanValue() && (tileentity = world.func_175625_s(pos.func_177977_b())) instanceof ChestTileEntity) {
                    if (UltraAmplified.UAStructuresConfig.chestGeneration.get().booleanValue()) {
                        ((ChestTileEntity)tileentity).func_189404_a(CHESTS_2_ICE_SPIKE_TEMPLE_UA, rand.nextLong());
                    } else {
                        world.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            }
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            BlockPos blockpos = (BlockPos)OFFSET.get(this.resourceLocation);
            this.field_186178_c.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(3 - blockpos.func_177958_n(), 0, 0 - blockpos.func_177952_p())));
            return super.func_225577_a_(world, p_225577_2_, random, structureBoundingBoxIn, chunkPos);
        }
    }
}

