/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.OceanRuinConfig;
import net.minecraft.world.gen.feature.structure.OceanRuinStructure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.feature.structure.StructureInitUA;

public class OceanRuinsPiecesUA {
    private static final ResourceLocation[] WARM_RUINS = new ResourceLocation[]{new ResourceLocation("underwater_ruin/warm_1"), new ResourceLocation("underwater_ruin/warm_2"), new ResourceLocation("underwater_ruin/warm_3"), new ResourceLocation("underwater_ruin/warm_4"), new ResourceLocation("underwater_ruin/warm_5"), new ResourceLocation("underwater_ruin/warm_6"), new ResourceLocation("underwater_ruin/warm_7"), new ResourceLocation("underwater_ruin/warm_8")};
    private static final ResourceLocation[] BRICK_RUINS = new ResourceLocation[]{new ResourceLocation("underwater_ruin/brick_1"), new ResourceLocation("underwater_ruin/brick_2"), new ResourceLocation("underwater_ruin/brick_3"), new ResourceLocation("underwater_ruin/brick_4"), new ResourceLocation("underwater_ruin/brick_5"), new ResourceLocation("underwater_ruin/brick_6"), new ResourceLocation("underwater_ruin/brick_7"), new ResourceLocation("underwater_ruin/brick_8")};
    private static final ResourceLocation[] CRACKED_RUINS = new ResourceLocation[]{new ResourceLocation("underwater_ruin/cracked_1"), new ResourceLocation("underwater_ruin/cracked_2"), new ResourceLocation("underwater_ruin/cracked_3"), new ResourceLocation("underwater_ruin/cracked_4"), new ResourceLocation("underwater_ruin/cracked_5"), new ResourceLocation("underwater_ruin/cracked_6"), new ResourceLocation("underwater_ruin/cracked_7"), new ResourceLocation("underwater_ruin/cracked_8")};
    private static final ResourceLocation[] MOSSY_RUINS = new ResourceLocation[]{new ResourceLocation("underwater_ruin/mossy_1"), new ResourceLocation("underwater_ruin/mossy_2"), new ResourceLocation("underwater_ruin/mossy_3"), new ResourceLocation("underwater_ruin/mossy_4"), new ResourceLocation("underwater_ruin/mossy_5"), new ResourceLocation("underwater_ruin/mossy_6"), new ResourceLocation("underwater_ruin/mossy_7"), new ResourceLocation("underwater_ruin/mossy_8")};
    private static final ResourceLocation[] BIG_BRICK_RUINS = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_brick_1"), new ResourceLocation("underwater_ruin/big_brick_2"), new ResourceLocation("underwater_ruin/big_brick_3"), new ResourceLocation("underwater_ruin/big_brick_8")};
    private static final ResourceLocation[] BIG_MOSSY_RUINS = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_mossy_1"), new ResourceLocation("underwater_ruin/big_mossy_2"), new ResourceLocation("underwater_ruin/big_mossy_3"), new ResourceLocation("underwater_ruin/big_mossy_8")};
    private static final ResourceLocation[] BIG_CRACKED_RUINS = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_cracked_1"), new ResourceLocation("underwater_ruin/big_cracked_2"), new ResourceLocation("underwater_ruin/big_cracked_3"), new ResourceLocation("underwater_ruin/big_cracked_8")};
    private static final ResourceLocation[] BIG_WARM_RUINS = new ResourceLocation[]{new ResourceLocation("underwater_ruin/big_warm_4"), new ResourceLocation("underwater_ruin/big_warm_5"), new ResourceLocation("underwater_ruin/big_warm_6"), new ResourceLocation("underwater_ruin/big_warm_7")};

    private static ResourceLocation getSmallRuins(Random random) {
        return WARM_RUINS[random.nextInt(WARM_RUINS.length)];
    }

    private static ResourceLocation getLargeRuins(Random random) {
        return BIG_WARM_RUINS[random.nextInt(BIG_WARM_RUINS.length)];
    }

    public static void start(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList, Random random, OceanRuinConfig ruinsConfig) {
        boolean flag = random.nextFloat() <= ruinsConfig.field_204032_b;
        float f = flag ? 0.9f : 0.8f;
        OceanRuinsPiecesUA.addRuinsToList(templateManager, pos, rotation, pieceList, random, ruinsConfig, flag, f);
        if (flag && random.nextFloat() <= ruinsConfig.field_204033_c) {
            OceanRuinsPiecesUA.addChildRuins(templateManager, random, rotation, pos, ruinsConfig, pieceList);
        }
    }

    private static void addChildRuins(TemplateManager templateManager, Random random, Rotation rotationIn, BlockPos pos, OceanRuinConfig ruinsConfig, List<StructurePiece> pieceList) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        BlockPos blockpos = Template.func_207669_a((BlockPos)new BlockPos(15, 0, 15), (Mirror)Mirror.NONE, (Rotation)rotationIn, (BlockPos)new BlockPos(0, 0, 0)).func_177982_a(x, 0, z);
        MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_175899_a((int)x, (int)0, (int)z, (int)blockpos.func_177958_n(), (int)0, (int)blockpos.func_177952_p());
        BlockPos blockpos1 = new BlockPos(Math.min(x, blockpos.func_177958_n()), 0, Math.min(z, blockpos.func_177952_p()));
        List<BlockPos> list = OceanRuinsPiecesUA.getPlacements(random, blockpos1.func_177958_n(), blockpos1.func_177952_p());
        int maximumRuinsCount = MathHelper.func_76136_a((Random)random, (int)4, (int)8);
        for (int ruinsCount = 0; ruinsCount < maximumRuinsCount; ++ruinsCount) {
            Rotation rotation;
            BlockPos blockpos3;
            int zPos;
            int randomPlacement;
            BlockPos blockpos2;
            int xPos;
            MutableBoundingBox mutableboundingbox1;
            if (list.isEmpty() || (mutableboundingbox1 = MutableBoundingBox.func_175899_a((int)(xPos = (blockpos2 = list.remove(randomPlacement = random.nextInt(list.size()))).func_177958_n()), (int)0, (int)(zPos = blockpos2.func_177952_p()), (int)(blockpos3 = Template.func_207669_a((BlockPos)new BlockPos(5, 0, 6), (Mirror)Mirror.NONE, (Rotation)(rotation = Rotation.values()[random.nextInt(Rotation.values().length)]), (BlockPos)new BlockPos(0, 0, 0)).func_177982_a(xPos, 0, zPos)).func_177958_n(), (int)0, (int)blockpos3.func_177952_p())).func_78884_a(mutableboundingbox)) continue;
            OceanRuinsPiecesUA.addRuinsToList(templateManager, blockpos2, rotation, pieceList, random, ruinsConfig, false, 0.8f);
        }
    }

    private static List<BlockPos> getPlacements(Random random, int x, int z) {
        ArrayList list = Lists.newArrayList();
        list.add(new BlockPos(x - 16 + MathHelper.func_76136_a((Random)random, (int)1, (int)8), 90, z + 16 + MathHelper.func_76136_a((Random)random, (int)1, (int)7)));
        list.add(new BlockPos(x - 16 + MathHelper.func_76136_a((Random)random, (int)1, (int)8), 90, z + MathHelper.func_76136_a((Random)random, (int)1, (int)7)));
        list.add(new BlockPos(x - 16 + MathHelper.func_76136_a((Random)random, (int)1, (int)8), 90, z - 16 + MathHelper.func_76136_a((Random)random, (int)4, (int)8)));
        list.add(new BlockPos(x + MathHelper.func_76136_a((Random)random, (int)1, (int)7), 90, z + 16 + MathHelper.func_76136_a((Random)random, (int)1, (int)7)));
        list.add(new BlockPos(x + MathHelper.func_76136_a((Random)random, (int)1, (int)7), 90, z - 16 + MathHelper.func_76136_a((Random)random, (int)4, (int)6)));
        list.add(new BlockPos(x + 16 + MathHelper.func_76136_a((Random)random, (int)1, (int)7), 90, z + 16 + MathHelper.func_76136_a((Random)random, (int)3, (int)8)));
        list.add(new BlockPos(x + 16 + MathHelper.func_76136_a((Random)random, (int)1, (int)7), 90, z + MathHelper.func_76136_a((Random)random, (int)1, (int)7)));
        list.add(new BlockPos(x + 16 + MathHelper.func_76136_a((Random)random, (int)1, (int)7), 90, z - 16 + MathHelper.func_76136_a((Random)random, (int)4, (int)8)));
        return list;
    }

    private static void addRuinsToList(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList, Random random, OceanRuinConfig ruinsConfig, boolean isLarge, float integrity) {
        if (ruinsConfig.field_204031_a == OceanRuinStructure.Type.WARM) {
            ResourceLocation resourcelocation = isLarge ? OceanRuinsPiecesUA.getLargeRuins(random) : OceanRuinsPiecesUA.getSmallRuins(random);
            pieceList.add((StructurePiece)new Piece(templateManager, resourcelocation, pos, rotation, integrity, ruinsConfig.field_204031_a, isLarge));
        } else if (ruinsConfig.field_204031_a == OceanRuinStructure.Type.COLD) {
            ResourceLocation[] aresourcelocation2 = isLarge ? BIG_BRICK_RUINS : BRICK_RUINS;
            ResourceLocation[] aresourcelocation = isLarge ? BIG_CRACKED_RUINS : CRACKED_RUINS;
            ResourceLocation[] aresourcelocation1 = isLarge ? BIG_MOSSY_RUINS : MOSSY_RUINS;
            int i = random.nextInt(aresourcelocation2.length);
            pieceList.add((StructurePiece)new Piece(templateManager, aresourcelocation2[i], pos, rotation, integrity, ruinsConfig.field_204031_a, isLarge));
            pieceList.add((StructurePiece)new Piece(templateManager, aresourcelocation[i], pos, rotation, 0.7f, ruinsConfig.field_204031_a, isLarge));
            pieceList.add((StructurePiece)new Piece(templateManager, aresourcelocation1[i], pos, rotation, 0.5f, ruinsConfig.field_204031_a, isLarge));
        }
    }

    public static class Piece
    extends TemplateStructurePiece {
        private OceanRuinStructure.Type ruinsType;
        private float integrity;
        private ResourceLocation ruinsTemplate;
        private Rotation rotation;
        private boolean isLarge;

        public Piece(TemplateManager p_i48868_1_, ResourceLocation p_i48868_2_, BlockPos p_i48868_3_, Rotation p_i48868_4_, float p_i48868_5_, OceanRuinStructure.Type p_i48868_6_, boolean p_i48868_7_) {
            super(StructureInitUA.ORPUA, 0);
            this.ruinsTemplate = p_i48868_2_;
            this.field_186178_c = p_i48868_3_;
            this.rotation = p_i48868_4_;
            this.integrity = p_i48868_5_;
            this.ruinsType = p_i48868_6_;
            this.isLarge = p_i48868_7_;
            this.startSetup(p_i48868_1_);
        }

        public Piece(TemplateManager p_i50592_1_, CompoundNBT p_i50592_2_) {
            super(StructureInitUA.ORPUA, p_i50592_2_);
            this.ruinsTemplate = new ResourceLocation(p_i50592_2_.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)p_i50592_2_.func_74779_i("Rot"));
            this.integrity = p_i50592_2_.func_74760_g("Integrity");
            this.ruinsType = OceanRuinStructure.Type.valueOf((String)p_i50592_2_.func_74779_i("BiomeType"));
            this.isLarge = p_i50592_2_.func_74767_n("IsLarge");
            this.startSetup(p_i50592_1_);
        }

        private void startSetup(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.ruinsTemplate);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.ruinsTemplate.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
            tagCompound.func_74776_a("Integrity", this.integrity);
            tagCompound.func_74778_a("BiomeType", this.ruinsType.toString());
            tagCompound.func_74757_a("IsLarge", this.isLarge);
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld world, Random rand, MutableBoundingBox sbb) {
            if ("chest".equals(function)) {
                if (UltraAmplified.UAStructuresConfig.chestGeneration.get().booleanValue()) {
                    world.func_180501_a(pos, (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_204511_c, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a))), 2);
                    TileEntity tileentity = world.func_175625_s(pos);
                    if (tileentity instanceof ChestTileEntity) {
                        ((ChestTileEntity)tileentity).func_189404_a(this.isLarge ? LootTables.field_204115_q : LootTables.field_204114_p, rand.nextLong());
                    }
                }
            } else if ("drowned".equals(function)) {
                DrownedEntity entitydrowned = (DrownedEntity)EntityType.field_204724_o.func_200721_a(world.func_201672_e());
                entitydrowned.func_110163_bv();
                entitydrowned.func_174828_a(pos, 0.0f, 0.0f);
                entitydrowned.func_213386_a(world, world.func_175649_E(pos), SpawnReason.STRUCTURE, (ILivingEntityData)null, (CompoundNBT)null);
                world.func_217376_c((Entity)entitydrowned);
                if (pos.func_177956_o() > world.func_181545_F()) {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                } else {
                    world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 2);
                }
            }
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGen, Random random, MutableBoundingBox structureBoundingBox, ChunkPos chunkPos) {
            this.field_186177_b.func_215219_b().func_215222_a((StructureProcessor)new IntegrityProcessor(this.integrity)).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
            int highestHeight = 0;
            BlockPos blockpos = this.field_186178_c;
            int halfSizeX = this.field_186176_a.func_186259_a().func_177958_n() / 2;
            int halfSizeZ = this.field_186176_a.func_186259_a().func_177952_p() / 2;
            blockpos = Template.func_207669_a((BlockPos)new BlockPos(this.field_186176_a.func_186259_a().func_177958_n() / 2 - 1, 0, this.field_186176_a.func_186259_a().func_177952_p() / 2 - 1), (Mirror)Mirror.NONE, (Rotation)this.rotation, (BlockPos)new BlockPos(0, 0, 0)).func_177971_a((Vec3i)this.field_186178_c);
            highestHeight = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, blockpos.func_177958_n(), blockpos.func_177952_p());
            blockpos = blockpos.func_177981_b(highestHeight - blockpos.func_177956_o());
            boolean validPosition = true;
            block0: for (int x = -halfSizeX; x <= halfSizeX; x += halfSizeX) {
                for (int z = -halfSizeZ; z <= halfSizeZ; z += halfSizeZ) {
                    if (world.func_180495_p(blockpos.func_177982_a(x, 0, z)) != Blocks.field_150350_a.func_176223_P()) continue;
                    validPosition = false;
                    x = halfSizeX;
                    continue block0;
                }
            }
            if (!validPosition) {
                highestHeight = 64;
            }
            this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), highestHeight - 1, this.field_186178_c.func_177952_p());
            blockpos = Template.func_207669_a((BlockPos)new BlockPos(this.field_186176_a.func_186259_a().func_177958_n() - 1, 2, this.field_186176_a.func_186259_a().func_177952_p() - 1), (Mirror)Mirror.NONE, (Rotation)this.rotation, (BlockPos)BlockPos.field_177992_a).func_177971_a((Vec3i)this.field_186178_c);
            this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), this.setWaterloggedBlocks(this.field_186178_c, (IBlockReader)world, blockpos), this.field_186178_c.func_177952_p());
            return super.func_225577_a_(world, chunkGen, random, structureBoundingBox, chunkPos);
        }

        private int setWaterloggedBlocks(BlockPos pos1, IBlockReader blockReader, BlockPos pos2) {
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos1, (BlockPos)pos2)) {
                int x = blockpos.func_177958_n();
                int z = blockpos.func_177952_p();
                int y = pos1.func_177956_o() - 1;
                BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable(x, y, z);
                BlockState iblockstate = blockReader.func_180495_p((BlockPos)blockpos$Mutable);
                IFluidState ifluidstate = blockReader.func_204610_c((BlockPos)blockpos$Mutable);
                while ((iblockstate.func_185904_a() == Material.field_151579_a || ifluidstate.func_206884_a(FluidTags.field_206959_a) || iblockstate.func_177230_c().func_203417_a(BlockTags.field_205213_E)) && y > 1) {
                    blockpos$Mutable.func_181079_c(x, --y, z);
                    iblockstate = blockReader.func_180495_p((BlockPos)blockpos$Mutable);
                    ifluidstate = blockReader.func_204610_c((BlockPos)blockpos$Mutable);
                }
            }
            return pos1.func_177956_o();
        }
    }
}

