/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.generation;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.PatrolSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.feature.UAFeatures;
import net.telepathicgrunt.ultraamplified.world.feature.structure.FortressNetherStructureUA;
import net.telepathicgrunt.ultraamplified.world.feature.structure.FortressPiecesUA;
import net.telepathicgrunt.ultraamplified.world.feature.structure.FortressStoneStructureUA;
import net.telepathicgrunt.ultraamplified.world.generation.UANoiseChunkGenerator;
import net.telepathicgrunt.ultraamplified.world.spawner.UACatSpawner;

public class UAChunkGenerator
extends UANoiseChunkGenerator<OverworldGenSettings> {
    private static final float[] BIOME_WEIGHTING_KERNEL = (float[])Util.func_200696_a((Object)new float[25], p_222575_0_ -> {
        for (int xRelative = -2; xRelative <= 2; ++xRelative) {
            for (int zRelative = -2; zRelative <= 2; ++zRelative) {
                float biomeWeighting;
                p_222575_0_[xRelative + 2 + (zRelative + 2) * 5] = biomeWeighting = 10.0f / MathHelper.func_76129_c((float)((float)(xRelative * xRelative + zRelative * zRelative) + 0.2f));
            }
        }
    });
    private final OctavesNoiseGenerator depthNoise;
    private final PhantomSpawner phantomSpawner = new PhantomSpawner();
    private final PatrolSpawner patrolSpawner = new PatrolSpawner();
    private final UACatSpawner catSpawner = new UACatSpawner();

    public UAChunkGenerator(IWorld world, BiomeProvider provider, OverworldGenSettings settingsIn) {
        super(world, provider, 4, 8, UltraAmplified.UATerrainConfig.yMaximum.get(), settingsIn);
        this.field_222558_e.func_202423_a(2620);
        this.depthNoise = new OctavesNoiseGenerator(this.field_222558_e, 15, 0);
    }

    public void func_202093_c(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        Biome biome = region.func_226691_t_(new ChunkPos(i, j).func_206849_h());
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202424_a(region.func_72905_C(), i << 4, j << 4);
        WorldEntitySpawner.func_77191_a((IWorld)region, (Biome)biome, (int)i, (int)j, (Random)sharedseedrandom);
    }

    protected void func_222548_a(double[] areaArrayIn, int x, int z) {
        this.setupPerlinNoiseGenerators(areaArrayIn, x, z, UltraAmplified.UATerrainConfig.secretSetting.get() != false ? 117104.946 : UltraAmplified.UATerrainConfig.xzTerrainModifier.get(), UltraAmplified.UATerrainConfig.secretSetting.get() != false ? 468419.786 : UltraAmplified.UATerrainConfig.yTerrainModifier.get(), UltraAmplified.UATerrainConfig.xzScaleModifier.get(), UltraAmplified.UATerrainConfig.secretSetting.get() != false ? 73.1905915 : UltraAmplified.UATerrainConfig.yScaleModifier.get(), 8.555149841308594, 4.277574920654297, 3, -10);
    }

    protected double func_222545_a(double p_222545_1_, double p_222545_3_, int p_222545_5_) {
        double d1 = ((double)p_222545_5_ - (8.5 + p_222545_1_ * 8.5 / 8.0 * 4.0)) * 12.0 * 128.0 / 256.0 / p_222545_3_;
        if (d1 < 0.0) {
            d1 *= 4.0;
        }
        return d1;
    }

    protected double[] func_222549_a(int noiseX, int noiseZ) {
        double[] adouble = new double[2];
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int y = this.func_222530_f();
        float f3 = this.field_222542_c.func_225526_b_(noiseX, y, noiseZ).func_185355_j();
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                Biome biome = this.field_222542_c.func_225526_b_(noiseX + xOffset, y, noiseZ + zOffset);
                float depthWeight = 0.0f;
                float scaleWeight = 0.0f;
                depthWeight = 1.8f;
                scaleWeight = 4.6000004f;
                float f6 = BIOME_WEIGHTING_KERNEL[xOffset + 2 + (zOffset + 2) * 5] / (depthWeight + 2.0f);
                if (biome.func_185355_j() > f3) {
                    f6 /= 2.0f;
                }
                f += scaleWeight * f6;
                f1 += depthWeight * f6;
                f2 += f6;
            }
        }
        f /= f2;
        f1 /= f2;
        f = f * 0.9f + 0.1f;
        f1 = (f1 * 4.0f - 1.0f) / 8.0f;
        adouble[0] = (double)f1 + this.getNoiseDepthAt(noiseX, noiseZ);
        adouble[1] = f;
        return adouble;
    }

    private double getNoiseDepthAt(int x, int z) {
        double noise = this.depthNoise.func_215462_a((double)(x * 200), 10.0, (double)(z * 200), 1.0, 0.0, true) * 65535.0 / 8000.0;
        if (noise < 0.0) {
            noise = -noise * 0.3;
        }
        if ((noise = noise * 3.0 - 2.0) < 0.0) {
            noise /= 28.0;
        } else {
            if (noise > 1.0) {
                noise = 1.0;
            }
            noise /= 40.0;
        }
        return noise;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification creatureType, BlockPos pos) {
        Block belowBlock = this.field_222540_a.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (UAFeatures.WITCH_HUT.func_202383_b(this.field_222540_a, pos)) {
            if (creatureType == EntityClassification.MONSTER) {
                return UAFeatures.WITCH_HUT.func_202279_e();
            }
            if (creatureType == EntityClassification.CREATURE) {
                return UAFeatures.WITCH_HUT.func_214469_f();
            }
        } else if (creatureType == EntityClassification.MONSTER) {
            if (FortressPiecesUA.STONE_FORTRESS_BLOCKS.contains(belowBlock)) {
                if (UAFeatures.STONE_FORTRESS.func_202366_b(this.field_222540_a, pos)) {
                    return ((FortressStoneStructureUA)UAFeatures.STONE_FORTRESS).getStoneFortressSpawnList();
                }
                if (UAFeatures.STONE_FORTRESS.func_175796_a(this.field_222540_a, pos)) {
                    return ((FortressStoneStructureUA)UAFeatures.STONE_FORTRESS).getStoneFortressSpawnList();
                }
            } else if (belowBlock == Blocks.field_196653_dH) {
                if (UAFeatures.NETHER_FORTRESS.func_202366_b(this.field_222540_a, pos)) {
                    return ((FortressNetherStructureUA)UAFeatures.NETHER_FORTRESS).getNetherFortressSpawnList();
                }
                if (UAFeatures.NETHER_FORTRESS.func_175796_a(this.field_222540_a, pos)) {
                    return ((FortressNetherStructureUA)UAFeatures.NETHER_FORTRESS).getNetherFortressSpawnList();
                }
            }
            if (UAFeatures.PILLAGER_OUTPOST.func_175796_a(this.field_222540_a, pos)) {
                return UAFeatures.PILLAGER_OUTPOST.func_202279_e();
            }
            if (UAFeatures.OCEAN_MONUMENT.func_175796_a(this.field_222540_a, pos)) {
                return UAFeatures.OCEAN_MONUMENT.func_202279_e();
            }
            if (belowBlock == Blocks.field_185767_cT) {
                if (UAFeatures.END_CITY.func_175796_a(this.field_222540_a, pos)) {
                    return UAFeatures.END_CITY.func_202279_e();
                }
                if (UAFeatures.END_CITY.func_175796_a(this.field_222540_a, pos)) {
                    return UAFeatures.END_CITY.func_202279_e();
                }
            }
        } else if (creatureType == EntityClassification.CREATURE && belowBlock == Blocks.field_185767_cT) {
            if (UAFeatures.END_CITY.func_175796_a(this.field_222540_a, pos)) {
                return UAFeatures.END_CITY.func_202279_e();
            }
            if (UAFeatures.END_CITY.func_175796_a(this.field_222540_a, pos)) {
                return UAFeatures.END_CITY.func_202279_e();
            }
        }
        return super.func_177458_a(creatureType, pos);
    }

    public void func_203222_a(ServerWorld world, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        this.phantomSpawner.func_203232_a(world, spawnHostileMobs, spawnPeacefulMobs);
        this.patrolSpawner.func_222696_a(world, spawnHostileMobs, spawnPeacefulMobs);
        this.catSpawner.func_221124_a(world, spawnHostileMobs, spawnPeacefulMobs);
    }

    public int func_205470_d() {
        return UltraAmplified.UATerrainConfig.seaLevel.get() + 1;
    }

    public int func_222530_f() {
        return UltraAmplified.UATerrainConfig.seaLevel.get();
    }
}

