/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.generation.layers;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.ultraamplified.UltraAmplified;
import net.telepathicgrunt.ultraamplified.world.biome.UABiomes;
import net.telepathicgrunt.ultraamplified.world.generation.BiomeGenHelper;
import net.telepathicgrunt.ultraamplified.world.generation.layers.AddOceansLayerUA;

@Mod.EventBusSubscriber(modid="ultra_amplified_dimension", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BiomeLayerSetupUA {
    public static List<BiomeManager.BiomeEntry> icyBiomesList;
    public static List<BiomeManager.BiomeEntry> coolBiomesList;
    public static List<BiomeManager.BiomeEntry> warmBiomesList;
    public static List<BiomeManager.BiomeEntry> hotBiomesList;
    public static List<BiomeManager.BiomeEntry> jungleBiomesList;
    public static List<BiomeManager.BiomeEntry> giantTreeTaigaBiomesList;
    public static List<BiomeManager.BiomeEntry> badlandsBiomesList;
    public static List<BiomeManager.BiomeEntry> oceanBiomesList;
    public static boolean noOcean;
    private static ForgeRegistry<Biome> BiomeRegistry;
    private static Set<Biome> allSpawnableBiomes;

    public static Set<Biome> getSpawnableBiomes() {
        return allSpawnableBiomes;
    }

    public BiomeLayerSetupUA() {
        UABiomes.mapMBiomes();
        BiomeLayerSetupUA.setupBiomeEntries();
        BiomeGenHelper.setBiomeEdgeMap();
        AddOceansLayerUA.syncOceanList();
        BiomeLayerSetupUA.setSpawnableBiomeSet();
    }

    private static void setupBiomeEntries() {
        BiomeLayerSetupUA.resetBiomeLists();
        BiomeLayerSetupUA.importModdedBiomes();
        BiomeLayerSetupUA.addUABiomeEntriesToLists();
        BiomeLayerSetupUA.fillSparceBiomeLists();
        BiomeLayerSetupUA.isUAOceanPresent();
    }

    private static void resetBiomeLists() {
        icyBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        coolBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        warmBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        hotBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        jungleBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        giantTreeTaigaBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        badlandsBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        oceanBiomesList = new ArrayList<BiomeManager.BiomeEntry>();
        noOcean = false;
    }

    private static void importModdedBiomes() {
        block14: {
            block13: {
                ArrayList<String> blacklistedMods = new ArrayList<String>();
                LinkedList<String> blacklistedTempList = new LinkedList<String>(Arrays.asList(UltraAmplified.UAModCompatConfig.blacklistedBiomeList.get().split(",")));
                for (int i = 0; i < blacklistedTempList.size(); ++i) {
                    blacklistedTempList.set(i, ((String)blacklistedTempList.get(i)).trim());
                }
                for (String entry : blacklistedTempList) {
                    if (!entry.contains(":*")) continue;
                    blacklistedMods.add(entry.split(":")[0]);
                }
                if (!UltraAmplified.UAModCompatConfig.importAllModdedBiomes.get().booleanValue()) break block13;
                for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
                    String namespace;
                    ResourceLocation rl = BiomeRegistry.getKey((IForgeRegistryEntry)biome);
                    if (rl == null || (namespace = rl.func_110624_b()).equals("minecraft") || namespace.equals("ultra_amplified_dimension") || blacklistedMods.contains(namespace) || UltraAmplified.UAModCompatConfig.blacklistedBiomeList.get().contains(rl.toString())) continue;
                    BiomeManager.BiomeEntry addedBiome = new BiomeManager.BiomeEntry(biome, 20);
                    float biomeTemperature = biome.func_185353_n();
                    if (biomeTemperature < 0.1f) {
                        icyBiomesList.add(addedBiome);
                        continue;
                    }
                    if (biomeTemperature >= 0.1f && biomeTemperature < 0.5f) {
                        coolBiomesList.add(addedBiome);
                        continue;
                    }
                    if (biomeTemperature >= 0.5f && biomeTemperature < 1.0f) {
                        warmBiomesList.add(addedBiome);
                        continue;
                    }
                    hotBiomesList.add(addedBiome);
                }
                break block14;
            }
            if (!UltraAmplified.UAModCompatConfig.importOverworldModdedBiomes.get().booleanValue()) break block14;
            block9: for (BiomeManager.BiomeType tempRange : BiomeManager.BiomeType.values()) {
                List biomesInTempRange = BiomeManager.getBiomes((BiomeManager.BiomeType)tempRange).stream().filter(biomeEntry -> !biomeEntry.biome.getRegistryName().func_110624_b().equals("minecraft")).map(biomeEntry -> biomeEntry.field_76292_a < 10 ? new BiomeManager.BiomeEntry(biomeEntry.biome, 10) : biomeEntry).collect(Collectors.toList());
                if (biomesInTempRange == null) continue;
                switch (tempRange) {
                    case ICY: {
                        icyBiomesList.addAll(biomesInTempRange);
                        continue block9;
                    }
                    case COOL: {
                        coolBiomesList.addAll(biomesInTempRange);
                        continue block9;
                    }
                    case WARM: {
                        warmBiomesList.addAll(biomesInTempRange);
                        continue block9;
                    }
                    case DESERT: {
                        hotBiomesList.addAll(biomesInTempRange);
                    }
                }
            }
        }
    }

    private static void addUABiomeEntriesToLists() {
        if (UltraAmplified.UABiomesConfig.desert.get().booleanValue()) {
            hotBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.DESERT, 40));
        }
        if (UltraAmplified.UABiomesConfig.savanna.get().booleanValue()) {
            hotBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.SAVANNA, 40));
        }
        if (UltraAmplified.UABiomesConfig.plains.get().booleanValue()) {
            hotBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.PLAINS, 20));
        }
        if (UltraAmplified.UABiomesConfig.netherland.get().booleanValue()) {
            hotBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.NETHERLAND, 30));
        }
        if (UltraAmplified.UABiomesConfig.forest.get().booleanValue()) {
            warmBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.FOREST, 28));
        }
        if (UltraAmplified.UABiomesConfig.darkForest.get().booleanValue()) {
            warmBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.DARK_FOREST, 28));
        }
        if (UltraAmplified.UABiomesConfig.rockyField.get().booleanValue()) {
            warmBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.ROCKY_FIELD, 28));
        }
        if (UltraAmplified.UABiomesConfig.plains.get().booleanValue()) {
            warmBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.PLAINS, 28));
        }
        if (UltraAmplified.UABiomesConfig.birchForest.get().booleanValue()) {
            warmBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.BIRCH_FOREST, 28));
        }
        if (UltraAmplified.UABiomesConfig.swamplands.get().booleanValue()) {
            warmBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.SWAMP, 28));
        }
        if (UltraAmplified.UABiomesConfig.mushroom.get().booleanValue()) {
            warmBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.MUSHROOM_FIELDS, 8));
        }
        if (UltraAmplified.UABiomesConfig.forest.get().booleanValue()) {
            coolBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.FOREST, 32));
        }
        if (UltraAmplified.UABiomesConfig.rockyField.get().booleanValue()) {
            coolBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.ROCKY_FIELD, 32));
        }
        if (UltraAmplified.UABiomesConfig.taiga.get().booleanValue()) {
            coolBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.TAIGA, 32));
        }
        if (UltraAmplified.UABiomesConfig.plains.get().booleanValue()) {
            coolBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.PLAINS, 12));
        }
        if (UltraAmplified.UABiomesConfig.stonePlains.get().booleanValue()) {
            coolBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.STONE_PLAINS, 17));
        }
        if (UltraAmplified.UABiomesConfig.endField.get().booleanValue()) {
            coolBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.END_FIELD, 32));
        }
        if (UltraAmplified.UABiomesConfig.mushroom.get().booleanValue()) {
            coolBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.MUSHROOM_FIELDS, 8));
        }
        if (UltraAmplified.UABiomesConfig.snowyTundra.get().booleanValue()) {
            icyBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.SNOWY_TUNDRA, 45));
        } else {
            if (UltraAmplified.UABiomesConfig.iceSpike.get().booleanValue()) {
                icyBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.ICE_SPIKES, 26));
            }
            if (UltraAmplified.UABiomesConfig.icedTerrain.get().booleanValue()) {
                icyBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.ICED_TERRAIN, 26));
            }
        }
        if (UltraAmplified.UABiomesConfig.icedTerrain.get().booleanValue()) {
            icyBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.ICED_TERRAIN, 17));
        }
        if (UltraAmplified.UABiomesConfig.snowyTaiga.get().booleanValue()) {
            icyBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.SNOWY_TAIGA, 26));
        }
        if (UltraAmplified.UABiomesConfig.frozenDesert.get().booleanValue()) {
            icyBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.FROZEN_DESERT, 6));
        }
        if (UltraAmplified.UABiomesConfig.jungle.get().booleanValue()) {
            jungleBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.JUNGLE, 70));
        }
        if (UltraAmplified.UABiomesConfig.bambooJungle.get().booleanValue()) {
            jungleBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.BAMBOO_JUNGLE, 30));
        }
        if (UltraAmplified.UABiomesConfig.giantTreeTaiga.get().booleanValue()) {
            giantTreeTaigaBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.GIANT_TREE_TAIGA, 10));
        }
        if (UltraAmplified.UABiomesConfig.badlands.get().booleanValue()) {
            badlandsBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.SANDLESS_BADLANDS, 20));
            badlandsBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.WOODED_BADLANDS, 10));
        } else if (UltraAmplified.UABiomesConfig.spikyBadlands.get().booleanValue()) {
            badlandsBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.SPIKY_BADLANDS, 10));
            badlandsBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.DISSECTED_PLATEAU_BADLANDS, 10));
        }
        if (UltraAmplified.UABiomesConfig.warmOcean.get().booleanValue()) {
            oceanBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.WARM_OCEAN, 10));
        }
        if (UltraAmplified.UABiomesConfig.lukewarmOcean.get().booleanValue()) {
            oceanBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.LUKEWARM_OCEAN, 10));
        }
        if (UltraAmplified.UABiomesConfig.ocean.get().booleanValue()) {
            oceanBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.OCEAN, 10));
        }
        if (UltraAmplified.UABiomesConfig.coldOcean.get().booleanValue()) {
            oceanBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.COLD_OCEAN, 10));
        }
        if (UltraAmplified.UABiomesConfig.frozenOcean.get().booleanValue()) {
            oceanBiomesList.add(new BiomeManager.BiomeEntry(UABiomes.FROZEN_OCEAN, 10));
        }
    }

    private static void fillSparceBiomeLists() {
        ArrayList<List<BiomeManager.BiomeEntry>> listOfBiomeLists = new ArrayList<List<BiomeManager.BiomeEntry>>();
        listOfBiomeLists.add(badlandsBiomesList);
        listOfBiomeLists.add(jungleBiomesList);
        listOfBiomeLists.add(hotBiomesList);
        if (oceanBiomesList.size() == 0) {
            listOfBiomeLists.add(oceanBiomesList);
        }
        listOfBiomeLists.add(warmBiomesList);
        listOfBiomeLists.add(coolBiomesList);
        listOfBiomeLists.add(giantTreeTaigaBiomesList);
        listOfBiomeLists.add(icyBiomesList);
        int direction = 1;
        for (int listIndex = 0; listIndex < listOfBiomeLists.size(); ++listIndex) {
            if (!((List)listOfBiomeLists.get(listIndex)).isEmpty()) continue;
            boolean checkedBothSides = false;
            int offsetIndex = 1;
            while (offsetIndex <= listOfBiomeLists.size()) {
                int n = Ints.constrainToRange((int)(listIndex + offsetIndex * (direction *= -1)), (int)0, (int)(listOfBiomeLists.size() - 1));
                if (!((List)listOfBiomeLists.get(n)).isEmpty()) {
                    ((List)listOfBiomeLists.get(listIndex)).addAll(((List)listOfBiomeLists.get(n)).subList(0, Ints.constrainToRange((int)((List)listOfBiomeLists.get(n)).size(), (int)1, (int)4)));
                    break;
                }
                if (checkedBothSides) {
                    ++offsetIndex;
                    checkedBothSides = false;
                    continue;
                }
                checkedBothSides = true;
            }
            if (((List)listOfBiomeLists.get(listIndex)).size() != 0) continue;
            if (oceanBiomesList.size() == 0) {
                oceanBiomesList.add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            }
            for (List list : listOfBiomeLists) {
                list.addAll(oceanBiomesList);
            }
        }
    }

    private static void setSpawnableBiomeSet() {
        allSpawnableBiomes = new HashSet<Biome>();
        ArrayList<List<BiomeManager.BiomeEntry>> listOfBiomeLists = new ArrayList<List<BiomeManager.BiomeEntry>>();
        listOfBiomeLists.add(badlandsBiomesList);
        listOfBiomeLists.add(jungleBiomesList);
        listOfBiomeLists.add(hotBiomesList);
        listOfBiomeLists.add(oceanBiomesList);
        listOfBiomeLists.add(warmBiomesList);
        listOfBiomeLists.add(coolBiomesList);
        listOfBiomeLists.add(giantTreeTaigaBiomesList);
        listOfBiomeLists.add(icyBiomesList);
        for (int listIndex = 0; listIndex < listOfBiomeLists.size(); ++listIndex) {
            for (int biomeIndex = 0; biomeIndex < ((List)listOfBiomeLists.get(listIndex)).size(); ++biomeIndex) {
                Biome hillsBiome;
                allSpawnableBiomes.add(((BiomeManager.BiomeEntry)((List)listOfBiomeLists.get((int)listIndex)).get((int)biomeIndex)).biome);
                Biome mutatedBiome = UABiomes.BASE_TO_MUTATION_MAP.get(((BiomeManager.BiomeEntry)((List)listOfBiomeLists.get((int)listIndex)).get((int)biomeIndex)).biome);
                if (mutatedBiome != null) {
                    allSpawnableBiomes.add(mutatedBiome);
                }
                if (!UABiomes.BASE_TO_HILLS_MAP.containsKey(BiomeRegistry.getID((IForgeRegistryEntry)((BiomeManager.BiomeEntry)((List)listOfBiomeLists.get((int)listIndex)).get((int)biomeIndex)).biome)) || (hillsBiome = (Biome)BiomeRegistry.getValue(UABiomes.BASE_TO_HILLS_MAP.get(BiomeRegistry.getID((IForgeRegistryEntry)((BiomeManager.BiomeEntry)((List)listOfBiomeLists.get((int)listIndex)).get((int)biomeIndex)).biome)).intValue())) == null) continue;
                allSpawnableBiomes.add(hillsBiome);
            }
        }
    }

    private static void isUAOceanPresent() {
        if (!(UltraAmplified.UABiomesConfig.ocean.get().booleanValue() || UltraAmplified.UABiomesConfig.coldOcean.get().booleanValue() || UltraAmplified.UABiomesConfig.frozenOcean.get().booleanValue() || UltraAmplified.UABiomesConfig.lukewarmOcean.get().booleanValue() || UltraAmplified.UABiomesConfig.warmOcean.get().booleanValue())) {
            noOcean = true;
        }
    }

    static {
        noOcean = false;
        BiomeRegistry = (ForgeRegistry)ForgeRegistries.BIOMES;
    }

    @Mod.EventBusSubscriber(modid="ultra_amplified_dimension")
    private static class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void updateBiomeLayouts(ModConfig.Reloading event) {
            UABiomes.mapMBiomes();
            BiomeLayerSetupUA.setupBiomeEntries();
            BiomeGenHelper.setBiomeEdgeMap();
            AddOceansLayerUA.syncOceanList();
            BiomeLayerSetupUA.setSpawnableBiomeSet();
        }
    }
}

