/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.Config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config.LangKey(value="ultra_amplified.config.title")
@Config(modid="ultra_amplified_mod", type=Config.Type.INSTANCE, name="ultra_amplified_mod_types")
public class UAConfig {
    @Config.Name(value="Structure Options")
    @Config.Comment(value={"Control generation of structures (Warning: Takes effect right away for all unloaded chunks in all Ultra Amplified worlds!)"})
    public static StructureSubCategory StructuresOptions = new StructureSubCategory();
    @Config.Name(value="Biome and Terrain Options")
    @Config.Comment(value={"Control generation of biomes and terrain. (Warning: Takes effect right away for all unloaded chunks in all Ultra Amplified worlds!)"})
    public static BiomeSubCategory biomeOptions = new BiomeSubCategory();
    @Config.Name(value="Ores and Similar Generations")
    @Config.Comment(value={"Control spawnrate of ores and other similar generations.  (Warning: Takes effect right away for all unloaded chunks in all Ultra Amplified worlds!)"})
    public static OreSubCategory oreAndFeatures = new OreSubCategory();

    @Mod.EventBusSubscriber
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("ultra_amplified_mod")) {
                ConfigManager.sync((String)"ultra_amplified_mod", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class OreSubCategory {
        @Config.Comment(value={"How often ores will spawn.", "0 for no ores and 100 for default spawnrate."})
        @Config.RangeDouble(min=0.0, max=500.0)
        public double oreSpawnrate = 100.0;
        @Config.Comment(value={"How often Glowstone will spawn in Nether biome.", "0 for no Glowstone and 100 for default spawnrate."})
        @Config.RangeDouble(min=0.0, max=500.0)
        public double glowstoneSpawnrate = 100.0;
        @Config.Comment(value={"How often Silverfish Blocks will spawn in Extreme Hills and Strongholds.", "0 for no ores and 100 for default spawnrate."})
        @Config.RangeDouble(min=0.0, max=500.0)
        public double silverfishSpawnrate = 100.0;
    }

    public static class BiomeSubCategory {
        @Config.Name(value="Biome Size")
        @Config.Comment(value={"How large the biomes are. Bigger number means bigger biomes."})
        @Config.RangeInt(min=2, max=8)
        public int biomeSize = 4;
        @Config.Name(value="Sea Level")
        @Config.Comment(value={"Height at which air is replace with water aboveground."})
        @Config.RangeInt(min=65, max=250)
        public int seaLevel = 75;
        @Config.Name(value="Replace Sea Level with Lava?")
        @Config.Comment(value={"Replace the water at sea leve with lava instead."})
        public boolean lavaOcean = false;
        @Config.Name(value="Replace Sea Level with Lava?")
        @Config.Comment(value={"How often waterfalls will spawn.", "0 for no waterfalls and 100 for default spawnrate."})
        @Config.RangeDouble(min=0.0, max=500.0)
        public double waterfallSpawnrate = 100.0;
        @Config.Name(value="Replace Sea Level with Lava?")
        @Config.Comment(value={"How often lavafalls will spawn. (Does not affect Nether Biome)", "0 for no lavafalls and 100 for default spawnrate."})
        @Config.RangeDouble(min=0.0, max=500.0)
        public double lavafallSpawnrate = 100.0;
        @Config.Name(value="End Islands")
        @Config.Comment(value={"How often End Islands will spawn in the End Biome.", "0 for no End Islands and 100 for default spawnrate."})
        @Config.RangeDouble(min=0.0, max=500.0)
        public double endIslandSpawnrate = 100.0;
        @Config.Name(value="Biome Selection Options")
        @Config.Comment(value={"Control what biomes to generate. (Warning: Takes effect at start when entering any Ultra Amplified world for all unloaded chunks!)"})
        public MainStructureSubCategory biomeSelectionOptions = new MainStructureSubCategory();

        public class MainStructureSubCategory {
            @Config.Name(value="Bamboo Forest")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean bambooForest = true;
            @Config.Name(value="Plains")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean plains = true;
            @Config.Name(value="Desert")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean desert = true;
            @Config.Name(value="Forest")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean forest = true;
            @Config.Name(value="Taiga")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean taiga = true;
            @Config.Name(value="Extreme Hills")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean extremeHills = true;
            @Config.Name(value="Swamplands")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean swamplands = true;
            @Config.Name(value="Nether")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean nether = true;
            @Config.Name(value="End")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean end = true;
            @Config.Name(value="Ice Flats")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean iceFlats = true;
            @Config.Name(value="Ice Mountain")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean iceMountain = true;
            @Config.Name(value="Mushroom")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean mushroom = true;
            @Config.Name(value="Stone Beach")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean stoneBeach = true;
            @Config.Name(value="Jungle")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean jungle = true;
            @Config.Name(value="Cold Beach")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean coldBeach = true;
            @Config.Name(value="Birch Forest")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean birchForest = true;
            @Config.Name(value="Roofed Forest")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean roofedForest = true;
            @Config.Name(value="Cold Taiga")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean coldTaiga = true;
            @Config.Name(value="Mega Taiga")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean megaTaiga = true;
            @Config.Name(value="Savanna")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean savanna = true;
            @Config.Name(value="Mesa")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean mesa = true;
            @Config.Name(value="Mesa Bryce")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean mesaBryce = true;
            @Config.Name(value="Ice Spike")
            @Config.Comment(value={"Should this biome be allowed to spawn?"})
            public boolean iceSpike = true;
        }
    }

    public static class StructureSubCategory {
        @Config.Name(value="Biome-Based Structure Options")
        @Config.Comment(value={"Control generation of biome-based structures"})
        public MainStructureSubCategory biomeBasedStructuresOptions = new MainStructureSubCategory();
        @Config.Name(value="Dungeon Spawnrate")
        @Config.Comment(value={"How often Dungeons will spawn.", "0 for no Dungeons and 650 for default spawnrate."})
        @Config.RangeInt(min=0, max=1200)
        public int dungeonSpawnrate = 650;
        @Config.Name(value="Ravine Spawnrate")
        @Config.Comment(value={"How often Ravines will spawn.", "0 for no Ravines and 5 for default spawnrate."})
        @Config.RangeInt(min=0, max=8)
        public int ravineSpawnrate = 5;
        @Config.Name(value="Cave Cavity Spawnrate")
        @Config.Comment(value={"How often Cave Cavity will spawn.", "0 for no Cave Cavity and 350 for default spawnrate."})
        @Config.RangeInt(min=0, max=700)
        public int caveCavitySpawnrate = 350;
        @Config.Name(value="Slime Lakes Allowed?")
        @Config.Comment(value={"Controls whether Slime Lakes spawn or not."})
        public boolean slimeLakeGen = true;
        @Config.Name(value="Water Lakes Allowed?")
        @Config.Comment(value={"Controls whether Water Lakes spawn or not."})
        public boolean waterLakeGen = true;
        @Config.Name(value="Lava Lakes Allowed?")
        @Config.Comment(value={"Controls whether Lava Lakes spawn or not. (DOES NOT AFFECT NETHER BIOME)"})
        public boolean lavaLakeGen = true;

        public class MainStructureSubCategory {
            @Config.Name(value="Loot Chests Allowed?")
            @Config.Comment(value={"Controls whether loot chests spawn or not in all structures."})
            public boolean chestGeneration = true;
            @Config.Name(value="Village Rarity")
            @Config.Comment(value={"How rare are Villages.", "9 for Village spawning in most chunk and 12 for default spawnrate."})
            @Config.RangeInt(min=1, max=100)
            public int villageSpawnrate = 12;
            @Config.Name(value="Village Allowed?")
            @Config.Comment(value={"Controls whether Villages spawn or not."})
            public boolean villageGeneration = true;
            @Config.Name(value="Mineshaft Spawnrate")
            @Config.Comment(value={"How often Mineshafts will spawn.", "0 for no Mineshafts and 25 for default spawnrate."})
            @Config.RangeDouble(min=0.0, max=1000.0)
            public double mineshaftSpawnrate = 25.0;
            @Config.Name(value="Mineshaft Allowed?")
            @Config.Comment(value={"Controls whether Mineshafts spawn or not."})
            public boolean mineshaftGeneration = true;
            @Config.Name(value="Woodland Mansion Rarity")
            @Config.Comment(value={"How rare are Woodland Mansion.", "9 for Woodland Mansion spawning in most chunk and 16 for default spawnrate."})
            @Config.RangeInt(min=1, max=100)
            public int mansionSpawnrate = 16;
            @Config.Name(value="Woodland Mansion Allowed?")
            @Config.Comment(value={"Controls whether Woodland Mansion spawn or not."})
            public boolean mansionGeneration = true;
            @Config.Name(value="Scattered Structure Rarity")
            @Config.Comment(value={"How rare are Temples, End Cities, Nether Fortresses, Igloos, and Witch Huts.", "9 for a Scattered Structure spawning in most chunk and 16 for default spawnrate."})
            @Config.RangeInt(min=1, max=100)
            public int scatteredSpawnrate = 16;
            @Config.Name(value="Scattered Structure Allowed?")
            @Config.Comment(value={"Controls whether Temples, End Cities, Nether Fortresses, Igloos, and Witch Huts spawn or not."})
            public boolean scatteredGeneration = true;
            @Config.Name(value="Strongholds Distance")
            @Config.Comment(value={"Minimum closest distance Strongholds can spawn to each other.", "1 for clostest distance and 10 for default distance between Strongholds."})
            @Config.RangeDouble(min=1.0, max=1000.0)
            public float strongholdDistance = 10.0f;
            @Config.Name(value="Strongholds Count")
            @Config.Comment(value={"How many Strongholds spawn in a world.", "1 for 1 Strongholds to spawn and 128 for default number of Strongholds."})
            @Config.RangeInt(min=1, max=10000)
            public int strongholdNumberPerWorld = 128;
            @Config.Name(value="Strongholds Spread")
            @Config.Comment(value={"How clustered towards spawn the Strongholds will be.", "1 for Strongholds to be farthest from spawn and 4 for default spawn distance."})
            @Config.RangeInt(min=1, max=100)
            public int strongholdSpread = 4;
            @Config.Name(value="Strongholds Allowed?")
            @Config.Comment(value={"Controls whether Strongholds spawn or not."})
            public boolean strongholdGeneration = true;
            @Config.Name(value="Ocean Monument Rarity")
            @Config.Comment(value={"How rare are Ocean Monuments.", "9 for a Ocean Monument spawning in most Jungle chunks and 18 for default spawnrate."})
            @Config.RangeInt(min=1, max=100)
            public int monumentRarity = 10;
            @Config.Name(value="Ocean Monuments Allowed?")
            @Config.Comment(value={"Controls whether Ocean Monuments spawn or not. (These spawn in Jungle biomes)"})
            public boolean monumentGeneration = true;
        }
    }
}

