/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.Biomes;

import java.util.Arrays;
import java.util.Random;
import net.TelepathicGrunt.UltraAmplified.World.Biome.BiomeExtendedUA;
import net.TelepathicGrunt.UltraAmplified.World.Biomes.BiomeMesaDecoratorUA;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeMesaUA
extends BiomeExtendedUA {
    protected static final IBlockState COARSE_DIRT = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
    protected static final IBlockState GRASS = Blocks.field_150349_c.func_176223_P();
    protected static final IBlockState HARDENED_CLAY = Blocks.field_150405_ch.func_176223_P();
    protected static final IBlockState STAINED_HARDENED_CLAY = Blocks.field_150406_ce.func_176223_P();
    protected static final IBlockState ORANGE_STAINED_HARDENED_CLAY = STAINED_HARDENED_CLAY.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE);
    protected static final IBlockState RED_SAND = Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND);
    private IBlockState[] clayBands;
    private long worldSeed;
    private NoiseGeneratorPerlin pillarNoise;
    private NoiseGeneratorPerlin pillarRoofNoise;
    private NoiseGeneratorPerlin clayBandsOffsetNoise;
    private final boolean brycePillars;
    private final boolean hasForest;

    public BiomeMesaUA(boolean p_i46704_1_, boolean p_i46704_2_, Biome.BiomeProperties properties) {
        super(properties);
        this.brycePillars = p_i46704_1_;
        this.hasForest = p_i46704_2_;
        this.field_76762_K.clear();
        this.field_76752_A = RED_SAND;
        this.field_76753_B = STAINED_HARDENED_CLAY;
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76804_C = 10;
        this.field_76760_I.field_76799_E = 3;
        this.field_76760_I.field_76800_F = 10;
        this.field_76760_I.field_76802_A = 0;
        this.field_76762_K.clear();
        if (p_i46704_2_) {
            this.field_76760_I.field_76832_z = 5;
        }
    }

    public BiomeDecorator func_76729_a() {
        return this.getModdedBiomeDecorator(new BiomeMesaDecoratorUA());
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return field_76757_N;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return 10387789;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 9470285;
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        if (this.clayBands == null || this.worldSeed != worldIn.func_72905_C()) {
            this.generateBands(worldIn.func_72905_C());
        }
        if (this.pillarNoise == null || this.pillarRoofNoise == null || this.worldSeed != worldIn.func_72905_C()) {
            Random random = new Random(this.worldSeed);
            this.pillarNoise = new NoiseGeneratorPerlin(random, 4);
            this.pillarRoofNoise = new NoiseGeneratorPerlin(random, 1);
        }
        this.worldSeed = worldIn.func_72905_C();
        double d4 = 0.0;
        if (this.brycePillars) {
            int i = (x & 0xFFFFFFF0) + (z & 0xF);
            int j = (z & 0xFFFFFFF0) + (x & 0xF);
            double d0 = Math.min(Math.abs(noiseVal), this.pillarNoise.func_151601_a((double)i * 0.25, (double)j * 0.25));
            if (d0 > -2.5) {
                double d1 = 0.001953125;
                d4 = d0 * d0 * 8.5;
                double d2 = Math.abs(this.pillarRoofNoise.func_151601_a((double)i * 1500.001953125, (double)j * 1500.001953125));
                double d3 = Math.ceil(d2 * 1200.0) + 1000.0;
                if (d4 > d3) {
                    d4 = d3;
                }
                d4 += 70.0;
            }
        }
        int k1 = x & 0xF;
        int l1 = z & 0xF;
        int i2 = worldIn.func_181545_F();
        IBlockState iblockstate = STAINED_HARDENED_CLAY;
        IBlockState iblockstate3 = this.field_76753_B;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        boolean flag = Math.cos(noiseVal / 3.0 * Math.PI) > 0.0;
        int l = -1;
        boolean flag1 = false;
        int i1 = 0;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (chunkPrimerIn.func_177856_a(l1, j1, k1).func_185904_a() == Material.field_151579_a && j1 < (int)d4) {
                chunkPrimerIn.func_177855_a(l1, j1, k1, field_185365_a);
            }
            if (j1 <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(l1, j1, k1, field_185367_c);
                continue;
            }
            if (i1 >= 15 && !this.brycePillars) continue;
            IBlockState iblockstate1 = chunkPrimerIn.func_177856_a(l1, j1, k1);
            if (iblockstate1.func_185904_a() == Material.field_151579_a) {
                l = -1;
                continue;
            }
            if (iblockstate1.func_177230_c() != Blocks.field_150348_b && iblockstate1.func_177230_c() != Blocks.field_150377_bs && iblockstate1.func_177230_c() != Blocks.field_150424_aL) continue;
            if (l == -1) {
                flag1 = false;
                if (k <= 0) {
                    iblockstate = field_185366_b;
                    iblockstate3 = field_185365_a;
                } else if (j1 >= i2 - 4 && j1 <= i2 + 1) {
                    iblockstate = STAINED_HARDENED_CLAY;
                    iblockstate3 = this.field_76753_B;
                }
                if (j1 < i2 && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = field_185372_h;
                }
                l = k + Math.max(0, j1 - i2);
                if (j1 >= i2 - 1) {
                    if (this.hasForest && j1 > 86 + k * 2) {
                        if (flag) {
                            chunkPrimerIn.func_177855_a(l1, j1, k1, COARSE_DIRT);
                        } else {
                            chunkPrimerIn.func_177855_a(l1, j1, k1, GRASS);
                        }
                    } else if (j1 > i2 + 3 + k) {
                        IBlockState iblockstate2 = j1 >= 64 && j1 <= 127 ? (flag ? HARDENED_CLAY : this.getBand(x, j1, z)) : ORANGE_STAINED_HARDENED_CLAY;
                        chunkPrimerIn.func_177855_a(l1, j1, k1, iblockstate2);
                    } else {
                        chunkPrimerIn.func_177855_a(l1, j1, k1, this.field_76752_A);
                        flag1 = true;
                    }
                } else {
                    chunkPrimerIn.func_177855_a(l1, j1, k1, iblockstate3);
                    if (iblockstate3.func_177230_c() == Blocks.field_150406_ce) {
                        chunkPrimerIn.func_177855_a(l1, j1, k1, ORANGE_STAINED_HARDENED_CLAY);
                    }
                }
            } else if (l > 0) {
                --l;
                if (flag1) {
                    chunkPrimerIn.func_177855_a(l1, j1, k1, ORANGE_STAINED_HARDENED_CLAY);
                } else {
                    chunkPrimerIn.func_177855_a(l1, j1, k1, this.getBand(x, j1, z));
                }
            }
            ++i1;
        }
        this.generateBiomeTerrain2(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public void generateBands(long p_150619_1_) {
        this.clayBands = new IBlockState[64];
        Arrays.fill(this.clayBands, HARDENED_CLAY);
        Random random = new Random(p_150619_1_);
        this.clayBandsOffsetNoise = new NoiseGeneratorPerlin(random, 1);
        for (int l1 = 0; l1 < 64; ++l1) {
            if ((l1 += random.nextInt(5) + 1) >= 64) continue;
            this.clayBands[l1] = ORANGE_STAINED_HARDENED_CLAY;
        }
        int i2 = random.nextInt(4) + 2;
        for (int i = 0; i < i2; ++i) {
            int j = random.nextInt(3) + 1;
            int k = random.nextInt(64);
            for (int l = 0; k + l < 64 && l < j; ++l) {
                this.clayBands[k + l] = STAINED_HARDENED_CLAY.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
            }
        }
        int j2 = random.nextInt(4) + 2;
        for (int k2 = 0; k2 < j2; ++k2) {
            int i3 = random.nextInt(3) + 2;
            int l3 = random.nextInt(64);
            for (int i1 = 0; l3 + i1 < 64 && i1 < i3; ++i1) {
                this.clayBands[l3 + i1] = STAINED_HARDENED_CLAY.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BROWN);
            }
        }
        int l2 = random.nextInt(4) + 2;
        for (int j3 = 0; j3 < l2; ++j3) {
            int i4 = random.nextInt(3) + 1;
            int k4 = random.nextInt(64);
            for (int j1 = 0; k4 + j1 < 64 && j1 < i4; ++j1) {
                this.clayBands[k4 + j1] = STAINED_HARDENED_CLAY.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED);
            }
        }
        int k3 = random.nextInt(3) + 3;
        int j4 = 0;
        for (int l4 = 0; l4 < k3; ++l4) {
            boolean i5 = true;
            j4 += random.nextInt(16) + 4;
            for (int k1 = 0; j4 + k1 < 64 && k1 < 1; ++k1) {
                this.clayBands[j4 + k1] = STAINED_HARDENED_CLAY.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.WHITE);
                if (j4 + k1 > 1 && random.nextBoolean()) {
                    this.clayBands[j4 + k1 - 1] = STAINED_HARDENED_CLAY.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.SILVER);
                }
                if (j4 + k1 >= 63 || !random.nextBoolean()) continue;
                this.clayBands[j4 + k1 + 1] = STAINED_HARDENED_CLAY.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.SILVER);
            }
        }
    }

    public IBlockState getBand(int p_180629_1_, int p_180629_2_, int p_180629_3_) {
        int i = (int)Math.round(this.clayBandsOffsetNoise.func_151601_a((double)p_180629_1_ / 512.0, (double)p_180629_1_ / 512.0) * 2.0);
        return this.clayBands[(p_180629_2_ + i + 64) % 64];
    }
}

