/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.gen.structure;

import java.util.Map;
import java.util.Random;
import net.TelepathicGrunt.UltraAmplified.Config.UAConfig;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class ComponentScatteredFeaturePiecesUA {
    public static void registerScatteredFeaturePieces() {
        MapGenStructureIO.func_143031_a(DesertPyramid.class, (String)"TeDP");
        MapGenStructureIO.func_143031_a(JunglePyramid.class, (String)"TeJP");
        MapGenStructureIO.func_143031_a(SwampHut.class, (String)"TeSH");
        MapGenStructureIO.func_143031_a(Igloo.class, (String)"Iglu");
    }

    public static class SwampHut
    extends Feature {
        private boolean hasWitch;

        public SwampHut() {
        }

        public SwampHut(Random p_i2066_1_, int p_i2066_2_, int p_i2066_3_) {
            super(p_i2066_1_, p_i2066_2_, 220, p_i2066_3_, 7, 7, 9);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Witch", this.hasWitch);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.hasWitch = tagCompound.func_74767_n("Witch");
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            int k;
            int i1;
            int l;
            if (!this.offsetToAverageGroundLevel(worldIn, structureBoundingBoxIn, 0)) {
                return false;
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 5, 1, 7, Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 2, 5, 4, 7, Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 0, 4, 1, 0, Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 2, 2, 3, 3, 2, Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 3, 1, 3, 6, Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 2, 3, 5, 3, 6, Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 2, 7, 4, 3, 7, Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 2, 1, 3, 2, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 0, 2, 5, 3, 2, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 7, 1, 3, 7, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 0, 7, 5, 3, 7, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 2, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 3, 3, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 5, 3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 5, 3, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150457_bL.func_176223_P().func_177226_a((IProperty)BlockFlowerPot.field_176443_b, (Comparable)BlockFlowerPot.EnumFlowerType.MUSHROOM_RED), 1, 3, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150462_ai.func_176223_P(), 2, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150382_bo.func_176223_P(), 2, 3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150383_bp.func_176223_P().func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(2)), 4, 2, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 1, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 5, 2, 1, structureBoundingBoxIn);
            IBlockState iblockstate = Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
            IBlockState iblockstate1 = Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
            IBlockState iblockstate2 = Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
            IBlockState iblockstate3 = Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 1, 6, 4, 1, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 2, 0, 4, 7, iblockstate1, iblockstate1, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 4, 2, 6, 4, 7, iblockstate2, iblockstate2, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 4, 8, 6, 4, 8, iblockstate3, iblockstate3, false);
            for (int i = 2; i <= 7; i += 5) {
                for (int j = 1; j <= 5; j += 4) {
                    this.func_175808_b(worldIn, Blocks.field_150364_r.func_176223_P(), j, -1, i, structureBoundingBoxIn);
                }
            }
            if (!this.hasWitch && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(l = this.func_74865_a(2, 5), i1 = this.func_74862_a(2), k = this.func_74873_b(2, 5)))) {
                this.hasWitch = true;
                EntityWitch entitywitch = new EntityWitch(worldIn);
                entitywitch.func_110163_bv();
                entitywitch.func_70012_b((double)l + 0.5, (double)i1, (double)k + 0.5, 0.0f, 0.0f);
                entitywitch.func_180482_a(worldIn.func_175649_E(new BlockPos(l, i1, k)), (IEntityLivingData)null);
                worldIn.func_72838_d((Entity)entitywitch);
            }
            return true;
        }
    }

    public static class JunglePyramid
    extends Feature {
        private boolean placedMainChest;
        private boolean placedHiddenChest;
        private boolean placedTrap1;
        private boolean placedTrap2;
        private static final Stones junglePyramidsRandomScatteredStones = new Stones();

        public JunglePyramid() {
        }

        public JunglePyramid(Random rand, int x, int z) {
            super(rand, x, 220, z, 12, 10, 15);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("placedMainChest", this.placedMainChest);
            tagCompound.func_74757_a("placedHiddenChest", this.placedHiddenChest);
            tagCompound.func_74757_a("placedTrap1", this.placedTrap1);
            tagCompound.func_74757_a("placedTrap2", this.placedTrap2);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.placedMainChest = tagCompound.func_74767_n("placedMainChest");
            this.placedHiddenChest = tagCompound.func_74767_n("placedHiddenChest");
            this.placedTrap1 = tagCompound.func_74767_n("placedTrap1");
            this.placedTrap2 = tagCompound.func_74767_n("placedTrap2");
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (!this.offsetToAverageGroundLevel(worldIn, structureBoundingBoxIn, 0)) {
                return false;
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 0, -4, 0, this.scatteredFeatureSizeX - 1, 0, this.scatteredFeatureSizeZ - 1, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 1, 2, 9, 2, 2, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 1, 12, 9, 2, 12, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 1, 3, 2, 2, 11, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 9, 1, 3, 9, 2, 11, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 1, 3, 1, 10, 6, 1, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 1, 3, 13, 10, 6, 13, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 1, 3, 2, 1, 6, 12, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 10, 3, 2, 10, 6, 12, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 3, 2, 9, 3, 12, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 6, 2, 9, 6, 12, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 3, 7, 3, 8, 7, 11, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 8, 4, 7, 8, 10, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 3, 1, 3, 8, 2, 11);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 4, 3, 6, 7, 3, 9);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 2, 4, 2, 9, 5, 12);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 4, 6, 5, 7, 6, 9);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 5, 7, 6, 6, 7, 8);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 5, 1, 2, 6, 2, 2);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 5, 2, 12, 6, 2, 12);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 5, 5, 1, 6, 5, 1);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 5, 5, 13, 6, 5, 13);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 5, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 10, 5, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 5, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 10, 5, 9, structureBoundingBoxIn);
            for (int i = 0; i <= 14; i += 14) {
                this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 4, i, 2, 5, i, false, randomIn, junglePyramidsRandomScatteredStones);
                this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 4, i, 4, 5, i, false, randomIn, junglePyramidsRandomScatteredStones);
                this.func_74882_a(worldIn, structureBoundingBoxIn, 7, 4, i, 7, 5, i, false, randomIn, junglePyramidsRandomScatteredStones);
                this.func_74882_a(worldIn, structureBoundingBoxIn, 9, 4, i, 9, 5, i, false, randomIn, junglePyramidsRandomScatteredStones);
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 5, 6, 0, 6, 6, 0, false, randomIn, junglePyramidsRandomScatteredStones);
            for (int l = 0; l <= 11; l += 11) {
                for (int j = 2; j <= 12; j += 2) {
                    this.func_74882_a(worldIn, structureBoundingBoxIn, l, 4, j, l, 5, j, false, randomIn, junglePyramidsRandomScatteredStones);
                }
                this.func_74882_a(worldIn, structureBoundingBoxIn, l, 6, 5, l, 6, 5, false, randomIn, junglePyramidsRandomScatteredStones);
                this.func_74882_a(worldIn, structureBoundingBoxIn, l, 6, 9, l, 6, 9, false, randomIn, junglePyramidsRandomScatteredStones);
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 7, 2, 2, 9, 2, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 9, 7, 2, 9, 9, 2, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, 7, 12, 2, 9, 12, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 9, 7, 12, 9, 9, 12, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 9, 4, 4, 9, 4, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 7, 9, 4, 7, 9, 4, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 9, 10, 4, 9, 10, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 7, 9, 10, 7, 9, 10, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 5, 9, 7, 6, 9, 7, false, randomIn, junglePyramidsRandomScatteredStones);
            IBlockState iblockstate2 = Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
            IBlockState iblockstate3 = Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
            IBlockState iblockstate = Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            IBlockState iblockstate1 = Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
            this.func_175811_a(worldIn, iblockstate1, 5, 9, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 6, 9, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 5, 9, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 6, 9, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 5, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 6, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 7, 0, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 1, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 3, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 7, 1, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 7, 2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 7, 3, 10, structureBoundingBoxIn);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 1, 9, 4, 1, 9, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 7, 1, 9, 7, 1, 9, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 1, 10, 7, 2, 10, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 5, 4, 5, 6, 4, 5, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_175811_a(worldIn, iblockstate2, 4, 4, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 7, 4, 5, structureBoundingBoxIn);
            for (int k = 0; k < 4; ++k) {
                this.func_175811_a(worldIn, iblockstate, 5, 0 - k, 6 + k, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 6, 0 - k, 6 + k, structureBoundingBoxIn);
                this.func_74878_a(worldIn, structureBoundingBoxIn, 5, 0 - k, 7 + k, 6, 0 - k, 9 + k);
            }
            this.func_74878_a(worldIn, structureBoundingBoxIn, 1, -3, 12, 10, -1, 13);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 1, -3, 1, 3, -1, 13);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 1, -3, 1, 9, -1, 5);
            for (int i1 = 1; i1 <= 13; i1 += 2) {
                this.func_74882_a(worldIn, structureBoundingBoxIn, 1, -3, i1, 1, -2, i1, false, randomIn, junglePyramidsRandomScatteredStones);
            }
            for (int j1 = 2; j1 <= 12; j1 += 2) {
                this.func_74882_a(worldIn, structureBoundingBoxIn, 1, -1, j1, 3, -1, j1, false, randomIn, junglePyramidsRandomScatteredStones);
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, -2, 1, 5, -2, 1, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 7, -2, 1, 9, -2, 1, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 6, -3, 1, 6, -3, 1, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 6, -1, 1, 6, -1, 1, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_175811_a(worldIn, Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.valueOf(true)), 1, -3, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.valueOf(true)), 4, -3, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 2, -3, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 3, -3, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 5, -3, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 5, -3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 5, -3, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 5, -3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 5, -3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 5, -3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 5, -3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 4, -3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 3, -3, 1, structureBoundingBoxIn);
            if (!this.placedTrap1) {
                this.placedTrap1 = this.func_189419_a(worldIn, structureBoundingBoxIn, randomIn, 3, -2, 1, EnumFacing.NORTH, LootTableList.field_189420_m);
            }
            this.func_175811_a(worldIn, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(true)), 3, -2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.valueOf(true)), 7, -3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.valueOf(true)), 7, -3, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 7, -3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 7, -3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 7, -3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 8, -3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 9, -3, 6, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 9, -3, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 9, -3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 9, -2, 4, structureBoundingBoxIn);
            if (!this.placedTrap2) {
                this.placedTrap2 = this.func_189419_a(worldIn, structureBoundingBoxIn, randomIn, 9, -2, 3, EnumFacing.WEST, LootTableList.field_189420_m);
            }
            this.func_175811_a(worldIn, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true)), 8, -1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true)), 8, -2, 3, structureBoundingBoxIn);
            if (UAConfig.StructuresOptions.biomeBasedStructuresOptions.chestGeneration && !this.placedMainChest) {
                this.placedMainChest = this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 8, -3, 3, LootTableList.field_186430_l);
            }
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 9, -3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 8, -3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 4, -3, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 5, -2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 5, -1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 6, -3, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 7, -2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 7, -1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 8, -3, 5, structureBoundingBoxIn);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 9, -1, 1, 9, -1, 5, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74878_a(worldIn, structureBoundingBoxIn, 8, -3, 8, 10, -1, 10);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED), 8, -2, 11, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED), 9, -2, 11, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED), 10, -2, 11, structureBoundingBoxIn);
            IBlockState iblockstate4 = Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.NORTH);
            this.func_175811_a(worldIn, iblockstate4, 8, -2, 12, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 9, -2, 12, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4, 10, -2, 12, structureBoundingBoxIn);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 8, -3, 8, 8, -3, 10, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 10, -3, 8, 10, -3, 10, false, randomIn, junglePyramidsRandomScatteredStones);
            this.func_175811_a(worldIn, Blocks.field_150341_Y.func_176223_P(), 10, -2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 8, -2, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 8, -2, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150488_af.func_176223_P(), 10, -1, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)EnumFacing.UP), 9, -2, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)EnumFacing.WEST), 10, -2, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)EnumFacing.WEST), 10, -1, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150413_aR.func_176223_P().func_177226_a((IProperty)BlockRedstoneRepeater.field_185512_D, (Comparable)EnumFacing.NORTH), 10, -2, 10, structureBoundingBoxIn);
            if (UAConfig.StructuresOptions.biomeBasedStructuresOptions.chestGeneration && !this.placedHiddenChest) {
                this.placedHiddenChest = this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 9, -3, 10, LootTableList.field_186430_l);
            }
            return true;
        }

        static class Stones
        extends StructureComponent.BlockSelector {
            private Stones() {
            }

            public void func_75062_a(Random rand, int x, int y, int z, boolean p_75062_5_) {
                this.field_151562_a = rand.nextFloat() < 0.4f ? Blocks.field_150347_e.func_176223_P() : Blocks.field_150341_Y.func_176223_P();
            }
        }
    }

    public static class Igloo
    extends Feature {
        private static final ResourceLocation IGLOO_TOP_ID = new ResourceLocation("igloo/igloo_top");
        private static final ResourceLocation IGLOO_MIDDLE_ID = new ResourceLocation("igloo/igloo_middle");
        private static final ResourceLocation IGLOO_BOTTOM_ID = new ResourceLocation("igloo/igloo_bottom");

        public Igloo() {
        }

        public Igloo(Random rand, int x, int z) {
            super(rand, x, 220, z, 7, 5, 8);
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (!this.offsetToAverageGroundLevel(worldIn, structureBoundingBoxIn, -1)) {
                return false;
            }
            StructureBoundingBox structureboundingbox = this.func_74874_b();
            BlockPos blockpos = new BlockPos(structureboundingbox.field_78897_a, structureboundingbox.field_78895_b, structureboundingbox.field_78896_c);
            Rotation[] arotation = Rotation.values();
            MinecraftServer minecraftserver = worldIn.func_73046_m();
            TemplateManager templatemanager = worldIn.func_72860_G().func_186340_h();
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(arotation[randomIn.nextInt(arotation.length)]).func_186225_a(Blocks.field_189881_dj).func_186223_a(structureboundingbox);
            Template template = templatemanager.func_186237_a(minecraftserver, IGLOO_TOP_ID);
            template.func_186260_a(worldIn, blockpos, placementsettings);
            Template template1 = templatemanager.func_186237_a(minecraftserver, IGLOO_MIDDLE_ID);
            Template template2 = templatemanager.func_186237_a(minecraftserver, IGLOO_BOTTOM_ID);
            int i = randomIn.nextInt(8) + 4;
            for (int j = 0; j < i; ++j) {
                BlockPos blockpos1 = template.func_186262_a(placementsettings, new BlockPos(3, -1 - j * 3, 5), placementsettings, new BlockPos(1, 2, 1));
                template1.func_186260_a(worldIn, blockpos.func_177971_a((Vec3i)blockpos1), placementsettings);
            }
            BlockPos blockpos4 = blockpos.func_177971_a((Vec3i)template.func_186262_a(placementsettings, new BlockPos(3, -1 - i * 3, 5), placementsettings, new BlockPos(3, 5, 7)));
            template2.func_186260_a(worldIn, blockpos4, placementsettings);
            Map map = template2.func_186258_a(blockpos4, placementsettings);
            for (Map.Entry entry : map.entrySet()) {
                if (!"chest".equals(entry.getValue())) continue;
                BlockPos blockpos2 = (BlockPos)entry.getKey();
                worldIn.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 3);
                TileEntity tileentity = worldIn.func_175625_s(blockpos2.func_177977_b());
                if (!UAConfig.StructuresOptions.biomeBasedStructuresOptions.chestGeneration || !(tileentity instanceof TileEntityChest)) continue;
                ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186431_m, randomIn.nextLong());
            }
            return true;
        }
    }

    static abstract class Feature
    extends StructureComponent {
        protected int scatteredFeatureSizeX;
        protected int scatteredFeatureSizeY;
        protected int scatteredFeatureSizeZ;
        protected int horizontalPos = -1;

        public Feature() {
        }

        protected Feature(Random rand, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
            super(0);
            this.scatteredFeatureSizeX = sizeX;
            this.scatteredFeatureSizeY = sizeY;
            this.scatteredFeatureSizeZ = sizeZ;
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
            this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, 120, z, x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1) : new StructureBoundingBox(x, 120, z, x + sizeZ - 1, y + sizeY - 1, z + sizeX - 1);
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            tagCompound.func_74768_a("Width", this.scatteredFeatureSizeX);
            tagCompound.func_74768_a("Height", this.scatteredFeatureSizeY);
            tagCompound.func_74768_a("Depth", this.scatteredFeatureSizeZ);
            tagCompound.func_74768_a("HPos", this.horizontalPos);
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            this.scatteredFeatureSizeX = tagCompound.func_74762_e("Width");
            this.scatteredFeatureSizeY = tagCompound.func_74762_e("Height");
            this.scatteredFeatureSizeZ = tagCompound.func_74762_e("Depth");
            this.horizontalPos = tagCompound.func_74762_e("HPos");
        }

        protected boolean offsetToAverageGroundLevel(World worldIn, StructureBoundingBox structurebb, int yOffset) {
            if (this.horizontalPos >= 0) {
                return true;
            }
            int i = 0;
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
                for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                    blockpos$mutableblockpos.func_181079_c(l, 64, k);
                    if (!structurebb.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                    int height = worldIn.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o();
                    i = height > 244 ? (i += Math.max(244, worldIn.field_73011_w.func_76557_i())) : (i += Math.max(worldIn.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o(), worldIn.field_73011_w.func_76557_i()));
                    ++j;
                }
            }
            if (j == 0) {
                return false;
            }
            this.horizontalPos = i / j;
            this.field_74887_e.func_78886_a(0, this.horizontalPos - this.field_74887_e.field_78895_b + yOffset, 0);
            return true;
        }
    }

    public static class DesertPyramid
    extends Feature {
        private final boolean[] hasPlacedChest = new boolean[4];

        public DesertPyramid() {
        }

        public DesertPyramid(Random p_i2062_1_, int p_i2062_2_, int p_i2062_3_) {
            super(p_i2062_1_, p_i2062_2_, 220, p_i2062_3_, 21, 15, 21);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("hasPlacedChest0", this.hasPlacedChest[0]);
            tagCompound.func_74757_a("hasPlacedChest1", this.hasPlacedChest[1]);
            tagCompound.func_74757_a("hasPlacedChest2", this.hasPlacedChest[2]);
            tagCompound.func_74757_a("hasPlacedChest3", this.hasPlacedChest[3]);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.hasPlacedChest[0] = tagCompound.func_74767_n("hasPlacedChest0");
            this.hasPlacedChest[1] = tagCompound.func_74767_n("hasPlacedChest1");
            this.hasPlacedChest[2] = tagCompound.func_74767_n("hasPlacedChest2");
            this.hasPlacedChest[3] = tagCompound.func_74767_n("hasPlacedChest3");
        }

        @Override
        protected boolean offsetToAverageGroundLevel(World worldIn, StructureBoundingBox structurebb, int yOffset) {
            if (this.horizontalPos >= 0) {
                return true;
            }
            int i = 0;
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
                for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                    blockpos$mutableblockpos.func_181079_c(l, 64, k);
                    if (!structurebb.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                    int height = worldIn.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o();
                    i = height > 244 ? (i += Math.max(244, worldIn.field_73011_w.func_76557_i())) : (i += Math.max(worldIn.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o(), worldIn.field_73011_w.func_76557_i()));
                    ++j;
                }
            }
            if (j == 0) {
                return false;
            }
            this.horizontalPos = i / j;
            this.field_74887_e.func_78886_a(0, this.horizontalPos - this.field_74887_e.field_78895_b + yOffset, 0);
            return true;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (!this.offsetToAverageGroundLevel(worldIn, structureBoundingBoxIn, 0)) {
                return false;
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, -4, 0, this.scatteredFeatureSizeX - 1, 0, this.scatteredFeatureSizeZ - 1, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            for (int i = 1; i <= 9; ++i) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, i, i, i, this.scatteredFeatureSizeX - 1 - i, i, this.scatteredFeatureSizeZ - 1 - i, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, i + 1, i, i + 1, this.scatteredFeatureSizeX - 2 - i, i, this.scatteredFeatureSizeZ - 2 - i, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            for (int i2 = 0; i2 < this.scatteredFeatureSizeX; ++i2) {
                for (int j = 0; j < this.scatteredFeatureSizeZ; ++j) {
                    int k = -5;
                    this.func_175808_b(worldIn, Blocks.field_150322_A.func_176223_P(), i2, -5, j, structureBoundingBoxIn);
                }
            }
            IBlockState iblockstate1 = Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
            IBlockState iblockstate2 = Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            IBlockState iblockstate3 = Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
            IBlockState iblockstate = Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 4, 9, 4, Blocks.field_150322_A.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 10, 1, 3, 10, 3, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate1, 2, 10, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate2, 2, 10, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 0, 10, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 10, 2, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.scatteredFeatureSizeX - 5, 0, 0, this.scatteredFeatureSizeX - 1, 9, 4, Blocks.field_150322_A.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.scatteredFeatureSizeX - 4, 10, 1, this.scatteredFeatureSizeX - 2, 10, 3, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate1, this.scatteredFeatureSizeX - 3, 10, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate2, this.scatteredFeatureSizeX - 3, 10, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, this.scatteredFeatureSizeX - 5, 10, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, this.scatteredFeatureSizeX - 1, 10, 2, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 0, 0, 12, 4, 4, Blocks.field_150322_A.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 1, 0, 11, 3, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), 9, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), 9, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), 9, 3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), 10, 3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), 11, 3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), 11, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), 11, 1, 1, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 1, 8, 3, 3, Blocks.field_150322_A.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 2, 8, 2, 2, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 1, 1, 16, 3, 3, Blocks.field_150322_A.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 1, 2, 16, 2, 2, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 4, 5, this.scatteredFeatureSizeX - 6, 4, this.scatteredFeatureSizeZ - 6, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 4, 9, 11, 4, 11, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 1, 8, 8, 3, 8, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 1, 8, 12, 3, 8, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 1, 12, 8, 3, 12, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 1, 12, 12, 3, 12, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 5, 4, 4, 11, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.scatteredFeatureSizeX - 5, 1, 5, this.scatteredFeatureSizeX - 2, 4, 11, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 7, 9, 6, 7, 11, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.scatteredFeatureSizeX - 7, 7, 9, this.scatteredFeatureSizeX - 7, 7, 11, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 5, 9, 5, 7, 11, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.scatteredFeatureSizeX - 6, 5, 9, this.scatteredFeatureSizeX - 6, 7, 11, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), false);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 5, 5, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 5, 6, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 6, 6, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), this.scatteredFeatureSizeX - 6, 5, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), this.scatteredFeatureSizeX - 6, 6, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), this.scatteredFeatureSizeX - 7, 6, 10, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 4, 4, 2, 6, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.scatteredFeatureSizeX - 3, 4, 4, this.scatteredFeatureSizeX - 3, 6, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate1, 2, 4, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 2, 3, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, this.scatteredFeatureSizeX - 3, 4, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, this.scatteredFeatureSizeX - 3, 3, 4, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 3, 2, 2, 3, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.scatteredFeatureSizeX - 3, 1, 3, this.scatteredFeatureSizeX - 2, 2, 3, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P(), 1, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P(), this.scatteredFeatureSizeX - 2, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SAND), 1, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SAND), this.scatteredFeatureSizeX - 2, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 2, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, this.scatteredFeatureSizeX - 3, 1, 2, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 3, 5, 4, 3, 18, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.scatteredFeatureSizeX - 5, 3, 5, this.scatteredFeatureSizeX - 5, 3, 17, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 5, 4, 2, 16, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, this.scatteredFeatureSizeX - 6, 1, 5, this.scatteredFeatureSizeX - 5, 2, 16, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            for (int j1 = 5; j1 <= 17; j1 += 2) {
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), 4, 1, j1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED), 4, 2, j1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), this.scatteredFeatureSizeX - 5, 1, j1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED), this.scatteredFeatureSizeX - 5, 2, j1, structureBoundingBoxIn);
            }
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 10, 0, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 10, 0, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 9, 0, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 11, 0, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 8, 0, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 12, 0, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 7, 0, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 13, 0, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 9, 0, 11, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 11, 0, 11, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 10, 0, 12, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 10, 0, 13, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLUE), 10, 0, 10, structureBoundingBoxIn);
            for (int j2 = 0; j2 <= this.scatteredFeatureSizeX - 1; j2 += this.scatteredFeatureSizeX - 1) {
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), j2, 2, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), j2, 2, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), j2, 2, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), j2, 3, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), j2, 3, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), j2, 3, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), j2, 4, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED), j2, 4, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), j2, 4, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), j2, 5, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), j2, 5, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), j2, 5, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), j2, 6, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED), j2, 6, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), j2, 6, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), j2, 7, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), j2, 7, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), j2, 7, 3, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), j2, 8, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), j2, 8, 2, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), j2, 8, 3, structureBoundingBoxIn);
            }
            for (int k2 = 2; k2 <= this.scatteredFeatureSizeX - 3; k2 += this.scatteredFeatureSizeX - 3 - 2) {
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), k2 - 1, 2, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), k2, 2, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), k2 + 1, 2, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), k2 - 1, 3, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), k2, 3, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), k2 + 1, 3, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), k2 - 1, 4, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED), k2, 4, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), k2 + 1, 4, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), k2 - 1, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), k2, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), k2 + 1, 5, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), k2 - 1, 6, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED), k2, 6, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), k2 + 1, 6, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), k2 - 1, 7, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), k2, 7, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), k2 + 1, 7, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), k2 - 1, 8, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), k2, 8, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), k2 + 1, 8, 0, structureBoundingBoxIn);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 4, 0, 12, 6, 0, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), false);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 8, 6, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 12, 6, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 9, 5, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED), 10, 5, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE), 11, 5, 0, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, -14, 8, 12, -11, 12, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, -10, 8, 12, -10, 12, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED), Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, -9, 8, 12, -9, 12, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, -8, 8, 12, -1, 12, Blocks.field_150322_A.func_176223_P(), Blocks.field_150322_A.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, -11, 9, 11, -1, 11, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150456_au.func_176223_P(), 10, -11, 10, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, -13, 9, 11, -13, 11, Blocks.field_150335_W.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 8, -11, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 8, -10, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED), 7, -10, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), 7, -11, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 12, -11, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 12, -10, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED), 13, -10, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), 13, -11, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 10, -11, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 10, -10, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED), 10, -10, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), 10, -11, 7, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 10, -11, 12, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 10, -10, 12, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED), 10, -10, 13, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), 10, -11, 13, structureBoundingBoxIn);
            if (UAConfig.StructuresOptions.biomeBasedStructuresOptions.chestGeneration) {
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    if (this.hasPlacedChest[enumfacing.func_176736_b()]) continue;
                    int k1 = enumfacing.func_82601_c() * 2;
                    int l1 = enumfacing.func_82599_e() * 2;
                    this.hasPlacedChest[enumfacing.func_176736_b()] = this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 10 + k1, -11, 10 + l1, LootTableList.field_186429_k);
                }
            }
            return true;
        }
    }
}

