/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.gen.structure;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.TelepathicGrunt.UltraAmplified.World.Biome.BiomeInit;
import net.TelepathicGrunt.UltraAmplified.World.Generation.ChunkGeneratorOverworldUA;
import net.TelepathicGrunt.UltraAmplified.World.gen.structure.StructureVillagePiecesUA;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenVillageUA
extends MapGenStructure {
    public static final List<Biome> VILLAGE_SPAWN_BIOMES = Arrays.asList(BiomeInit.BiomePlains, BiomeInit.BiomeDesert, BiomeInit.BiomeSavanna, BiomeInit.BiomeTaiga, BiomeInit.BiomeIceFlats, BiomeInit.BiomeColdTaiga, BiomeInit.BiomeColdTaigaHills, BiomeInit.BiomeIceMountain, BiomeInit.BiomeIceSpike, BiomeInit.BiomeJungle, BiomeInit.BiomeMesaBryce, BiomeInit.BiomeMesaClearRock, BiomeInit.BiomeEnd, BiomeInit.BiomeStoneBeach);
    private int size;
    private int distance;
    private int separation = 8;

    public MapGenVillageUA() {
        this.distance = 20;
    }

    public MapGenVillageUA(ChunkGeneratorOverworldUA settings) {
        this.distance = settings.settings.villageRarity;
    }

    public String func_143025_a() {
        return "Village";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        boolean flag;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.distance - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.distance - 1;
        }
        int k = chunkX / this.distance;
        int l = chunkZ / this.distance;
        Random random = this.field_75039_c.func_72843_D(k, l, 10387312);
        k *= this.distance;
        l *= this.distance;
        return (k += random.nextInt(this.distance - 8)) == i && (l += random.nextInt(this.distance - 8)) == j && (flag = this.field_75039_c.func_72959_q().func_76940_a(i * 16 + 8, j * 16 + 8, 0, VILLAGE_SPAWN_BIOMES));
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        return MapGenVillageUA.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.distance, (int)this.separation, (int)10387312, (boolean)false, (int)100, (boolean)findUnexplored);
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ, this.size);
    }

    public static class Start
    extends StructureStart {
        private boolean hasMoreThanTwoComponents;

        public Start() {
        }

        public Start(World worldIn, Random rand, int x, int z, int size) {
            super(x, z);
            List<StructureVillagePiecesUA.PieceWeight> list = StructureVillagePiecesUA.getStructureVillageWeightedPieceList(rand, size);
            StructureVillagePiecesUA.Start structurevillagepieces$start = new StructureVillagePiecesUA.Start(worldIn.func_72959_q(), 0, rand, (x << 4) + 2, (z << 4) + 2, list, size);
            this.field_75075_a.add(structurevillagepieces$start);
            structurevillagepieces$start.func_74861_a(structurevillagepieces$start, this.field_75075_a, rand);
            List<StructureComponent> list1 = structurevillagepieces$start.pendingRoads;
            List<StructureComponent> list2 = structurevillagepieces$start.pendingHouses;
            while (!list1.isEmpty() || !list2.isEmpty()) {
                if (list1.isEmpty()) {
                    int i = rand.nextInt(list2.size());
                    StructureComponent structurecomponent = list2.remove(i);
                    structurecomponent.func_74861_a((StructureComponent)structurevillagepieces$start, this.field_75075_a, rand);
                    continue;
                }
                int j = rand.nextInt(list1.size());
                StructureComponent structurecomponent2 = list1.remove(j);
                structurecomponent2.func_74861_a((StructureComponent)structurevillagepieces$start, this.field_75075_a, rand);
            }
            this.func_75072_c();
            int k = 0;
            for (StructureComponent structurecomponent1 : this.field_75075_a) {
                if (structurecomponent1 instanceof StructureVillagePiecesUA.Road) continue;
                ++k;
            }
            this.hasMoreThanTwoComponents = k > 2;
        }

        public boolean func_75069_d() {
            return this.hasMoreThanTwoComponents;
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            tagCompound.func_74757_a("Valid", this.hasMoreThanTwoComponents);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            this.hasMoreThanTwoComponents = tagCompound.func_74767_n("Valid");
        }
    }
}

