/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.gen.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.TelepathicGrunt.UltraAmplified.Config.UAConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureComponentTemplate;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class StructureEndCityPiecesUA {
    private static final PlacementSettings OVERWRITE = new PlacementSettings().func_186222_a(true);
    private static final PlacementSettings INSERT = new PlacementSettings().func_186222_a(true).func_186225_a(Blocks.field_150350_a);
    private static final IGenerator HOUSE_TOWER_GENERATOR = new IGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(TemplateManager p_191086_1_, int p_191086_2_, CityTemplate p_191086_3_, BlockPos p_191086_4_, List<StructureComponent> p_191086_5_, Random p_191086_6_) {
            if (p_191086_2_ > 8) {
                return false;
            }
            Rotation rotation = p_191086_3_.field_186177_b.func_186215_c();
            CityTemplate structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, p_191086_3_, p_191086_4_, "base_floor", rotation, true));
            int i = 2;
            if (i == 0) {
                StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, new BlockPos(-1, 4, -1), "base_roof", rotation, true));
            } else if (i == 1) {
                structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, new BlockPos(-1, 0, -1), "second_floor_2", rotation, false));
                structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, new BlockPos(-1, 8, -1), "second_roof", rotation, false));
                StructureEndCityPiecesUA.recursiveChildren(p_191086_1_, TOWER_GENERATOR, p_191086_2_ + 1, structureendcitypieces$citytemplate, null, p_191086_5_, p_191086_6_);
            } else if (i == 2) {
                structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, new BlockPos(-1, 0, -1), "second_floor_2", rotation, false));
                structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, new BlockPos(-1, 4, -1), "third_floor_c", rotation, false));
                structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, new BlockPos(-1, 8, -1), "third_roof", rotation, true));
                StructureEndCityPiecesUA.recursiveChildren(p_191086_1_, TOWER_GENERATOR, p_191086_2_ + 1, structureendcitypieces$citytemplate, null, p_191086_5_, p_191086_6_);
            }
            return true;
        }
    };
    private static final List<Tuple<Rotation, BlockPos>> TOWER_BRIDGES = Lists.newArrayList((Object[])new Tuple[]{new Tuple((Object)Rotation.NONE, (Object)new BlockPos(1, -1, 0)), new Tuple((Object)Rotation.CLOCKWISE_90, (Object)new BlockPos(6, -1, 1)), new Tuple((Object)Rotation.COUNTERCLOCKWISE_90, (Object)new BlockPos(0, -1, 5)), new Tuple((Object)Rotation.CLOCKWISE_180, (Object)new BlockPos(5, -1, 6))});
    private static final IGenerator TOWER_GENERATOR = new IGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(TemplateManager p_191086_1_, int p_191086_2_, CityTemplate p_191086_3_, BlockPos p_191086_4_, List<StructureComponent> p_191086_5_, Random p_191086_6_) {
            Rotation rotation = p_191086_3_.field_186177_b.func_186215_c();
            CityTemplate lvt_8_1_ = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, p_191086_3_, new BlockPos(3 + p_191086_6_.nextInt(2), -3, 3 + p_191086_6_.nextInt(2)), "tower_base", rotation, true));
            CityTemplate structureendcitypieces$citytemplate1 = lvt_8_1_ = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, lvt_8_1_, new BlockPos(0, 7, 0), "tower_piece", rotation, true));
            int i = 3;
            for (int j = 0; j < i; ++j) {
                lvt_8_1_ = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, lvt_8_1_, new BlockPos(0, 4, 0), "tower_piece", rotation, true));
                if (j >= i - 1) continue;
                structureendcitypieces$citytemplate1 = lvt_8_1_;
            }
            if (structureendcitypieces$citytemplate1 != null) {
                for (Tuple tuple : TOWER_BRIDGES) {
                    CityTemplate structureendcitypieces$citytemplate2 = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate1, (BlockPos)tuple.func_76340_b(), "bridge_end", rotation.func_185830_a((Rotation)tuple.func_76341_a()), true));
                    StructureEndCityPiecesUA.recursiveChildren(p_191086_1_, TOWER_BRIDGE_GENERATOR, p_191086_2_ + 1, structureendcitypieces$citytemplate2, null, p_191086_5_, p_191086_6_);
                }
                StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, lvt_8_1_, new BlockPos(-1, 4, -1), "tower_top", rotation, true));
            } else {
                if (p_191086_2_ != 7) {
                    return StructureEndCityPiecesUA.recursiveChildren(p_191086_1_, FAT_TOWER_GENERATOR, p_191086_2_ + 1, lvt_8_1_, null, p_191086_5_, p_191086_6_);
                }
                StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, lvt_8_1_, new BlockPos(-1, 4, -1), "tower_top", rotation, true));
            }
            return true;
        }
    };
    private static final IGenerator TOWER_BRIDGE_GENERATOR = new IGenerator(){
        public boolean shipCreated;

        @Override
        public void init() {
            this.shipCreated = false;
        }

        @Override
        public boolean generate(TemplateManager p_191086_1_, int p_191086_2_, CityTemplate p_191086_3_, BlockPos p_191086_4_, List<StructureComponent> p_191086_5_, Random p_191086_6_) {
            Rotation rotation = p_191086_3_.field_186177_b.func_186215_c();
            int i = 4;
            CityTemplate structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, p_191086_3_, new BlockPos(0, 0, -4), "bridge_piece", rotation, true));
            structureendcitypieces$citytemplate.field_74886_g = -1;
            int j = 0;
            for (int k = 0; k < i; ++k) {
                if (p_191086_6_.nextBoolean()) {
                    structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, new BlockPos(0, j, -4), "bridge_piece", rotation, true));
                    j = 0;
                    continue;
                }
                structureendcitypieces$citytemplate = p_191086_6_.nextBoolean() ? StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, new BlockPos(0, j, -4), "bridge_steep_stairs", rotation, true)) : StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, new BlockPos(0, j, -8), "bridge_gentle_stairs", rotation, true));
                j = 4;
            }
            if (!this.shipCreated) {
                StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, new BlockPos(-8 + p_191086_6_.nextInt(8), j, -70 + p_191086_6_.nextInt(10)), "ship", rotation, true));
                this.shipCreated = true;
            } else if (!StructureEndCityPiecesUA.recursiveChildren(p_191086_1_, HOUSE_TOWER_GENERATOR, p_191086_2_ + 1, structureendcitypieces$citytemplate, new BlockPos(-3, j + 1, -11), p_191086_5_, p_191086_6_)) {
                return false;
            }
            structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, new BlockPos(4, j, 0), "bridge_end", rotation.func_185830_a(Rotation.CLOCKWISE_180), true));
            structureendcitypieces$citytemplate.field_74886_g = -1;
            return true;
        }
    };
    private static final List<Tuple<Rotation, BlockPos>> FAT_TOWER_BRIDGES = Lists.newArrayList((Object[])new Tuple[]{new Tuple((Object)Rotation.NONE, (Object)new BlockPos(4, -1, 0)), new Tuple((Object)Rotation.CLOCKWISE_90, (Object)new BlockPos(12, -1, 4)), new Tuple((Object)Rotation.COUNTERCLOCKWISE_90, (Object)new BlockPos(0, -1, 8)), new Tuple((Object)Rotation.CLOCKWISE_180, (Object)new BlockPos(8, -1, 12))});
    private static final IGenerator FAT_TOWER_GENERATOR = new IGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(TemplateManager p_191086_1_, int p_191086_2_, CityTemplate p_191086_3_, BlockPos p_191086_4_, List<StructureComponent> p_191086_5_, Random p_191086_6_) {
            Rotation rotation = p_191086_3_.field_186177_b.func_186215_c();
            CityTemplate structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, p_191086_3_, new BlockPos(-3, 4, -3), "fat_tower_base", rotation, true));
            structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, new BlockPos(0, 4, 0), "fat_tower_middle", rotation, true));
            for (int i = 0; i < 4; ++i) {
                structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, new BlockPos(0, 8, 0), "fat_tower_middle", rotation, true));
                for (Tuple tuple : FAT_TOWER_BRIDGES) {
                    CityTemplate structureendcitypieces$citytemplate1 = StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, (BlockPos)tuple.func_76340_b(), "bridge_end", rotation.func_185830_a((Rotation)tuple.func_76341_a()), true));
                    StructureEndCityPiecesUA.recursiveChildren(p_191086_1_, TOWER_BRIDGE_GENERATOR, p_191086_2_ + 1, structureendcitypieces$citytemplate1, null, p_191086_5_, p_191086_6_);
                }
            }
            StructureEndCityPiecesUA.addHelper(p_191086_5_, StructureEndCityPiecesUA.addPiece(p_191086_1_, structureendcitypieces$citytemplate, new BlockPos(-2, 8, -2), "fat_tower_top", rotation, true));
            return true;
        }
    };

    public static void registerPieces() {
        MapGenStructureIO.func_143031_a(CityTemplate.class, (String)"ECP");
    }

    private static CityTemplate addPiece(TemplateManager p_191090_0_, CityTemplate p_191090_1_, BlockPos p_191090_2_, String p_191090_3_, Rotation p_191090_4_, boolean owerwrite) {
        CityTemplate structureendcitypieces$citytemplate = new CityTemplate(p_191090_0_, p_191090_3_, p_191090_1_.field_186178_c, p_191090_4_, owerwrite);
        BlockPos blockpos = p_191090_1_.field_186176_a.func_186262_a(p_191090_1_.field_186177_b, p_191090_2_, structureendcitypieces$citytemplate.field_186177_b, BlockPos.field_177992_a);
        structureendcitypieces$citytemplate.func_181138_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
        return structureendcitypieces$citytemplate;
    }

    public static void startHouseTower(TemplateManager p_191087_0_, BlockPos p_191087_1_, Rotation p_191087_2_, List<StructureComponent> p_191087_3_, Random p_191087_4_) {
        FAT_TOWER_GENERATOR.init();
        HOUSE_TOWER_GENERATOR.init();
        TOWER_BRIDGE_GENERATOR.init();
        TOWER_GENERATOR.init();
        CityTemplate structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191087_3_, new CityTemplate(p_191087_0_, "base_floor", p_191087_1_, p_191087_2_, true));
        structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191087_3_, StructureEndCityPiecesUA.addPiece(p_191087_0_, structureendcitypieces$citytemplate, new BlockPos(-1, 0, -1), "second_floor", p_191087_2_, false));
        structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191087_3_, StructureEndCityPiecesUA.addPiece(p_191087_0_, structureendcitypieces$citytemplate, new BlockPos(-1, 4, -1), "third_floor", p_191087_2_, false));
        structureendcitypieces$citytemplate = StructureEndCityPiecesUA.addHelper(p_191087_3_, StructureEndCityPiecesUA.addPiece(p_191087_0_, structureendcitypieces$citytemplate, new BlockPos(-1, 8, -1), "third_roof", p_191087_2_, true));
        StructureEndCityPiecesUA.recursiveChildren(p_191087_0_, TOWER_GENERATOR, 1, structureendcitypieces$citytemplate, null, p_191087_3_, p_191087_4_);
    }

    private static CityTemplate addHelper(List<StructureComponent> p_189935_0_, CityTemplate p_189935_1_) {
        p_189935_0_.add((StructureComponent)p_189935_1_);
        return p_189935_1_;
    }

    private static boolean recursiveChildren(TemplateManager p_191088_0_, IGenerator p_191088_1_, int p_191088_2_, CityTemplate p_191088_3_, BlockPos p_191088_4_, List<StructureComponent> p_191088_5_, Random p_191088_6_) {
        if (p_191088_2_ > 8) {
            return false;
        }
        ArrayList list = Lists.newArrayList();
        if (p_191088_1_.generate(p_191088_0_, p_191088_2_, p_191088_3_, p_191088_4_, list, p_191088_6_)) {
            boolean flag = false;
            int i = p_191088_6_.nextInt();
            for (StructureComponent structurecomponent : list) {
                structurecomponent.field_74886_g = i;
                StructureComponent structurecomponent1 = StructureComponent.func_74883_a(p_191088_5_, (StructureBoundingBox)structurecomponent.func_74874_b());
                if (structurecomponent1 == null || structurecomponent1.field_74886_g == p_191088_3_.field_74886_g) continue;
                flag = true;
                break;
            }
            if (!flag) {
                p_191088_5_.addAll(list);
                return true;
            }
        }
        return false;
    }

    static interface IGenerator {
        public void init();

        public boolean generate(TemplateManager var1, int var2, CityTemplate var3, BlockPos var4, List<StructureComponent> var5, Random var6);
    }

    public static class CityTemplate
    extends StructureComponentTemplate {
        private String pieceName;
        private Rotation rotation;
        private boolean overwrite;

        public CityTemplate() {
        }

        public CityTemplate(TemplateManager p_i47214_1_, String p_i47214_2_, BlockPos p_i47214_3_, Rotation p_i47214_4_, boolean overwriteIn) {
            super(0);
            this.pieceName = p_i47214_2_;
            this.field_186178_c = p_i47214_3_;
            this.rotation = p_i47214_4_;
            this.overwrite = overwriteIn;
            this.loadTemplate(p_i47214_1_);
        }

        private void loadTemplate(TemplateManager p_191085_1_) {
            Template template = p_191085_1_.func_186237_a((MinecraftServer)null, new ResourceLocation("endcity/" + this.pieceName));
            PlacementSettings placementsettings = (this.overwrite ? OVERWRITE : INSERT).func_186217_a().func_186220_a(this.rotation);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74778_a("Template", this.pieceName);
            tagCompound.func_74778_a("Rot", this.rotation.name());
            tagCompound.func_74757_a("OW", this.overwrite);
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.pieceName = tagCompound.func_74779_i("Template");
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.overwrite = tagCompound.func_74767_n("OW");
            this.loadTemplate(p_143011_2_);
        }

        protected void func_186175_a(String function, BlockPos pos, World worldIn, Random rand, StructureBoundingBox sbb) {
            if (UAConfig.StructuresOptions.biomeBasedStructuresOptions.chestGeneration && function.startsWith("Chest")) {
                TileEntity tileentity;
                BlockPos blockpos = pos.func_177977_b();
                if (sbb.func_175898_b((Vec3i)blockpos) && (tileentity = worldIn.func_175625_s(blockpos)) instanceof TileEntityChest) {
                    ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186421_c, rand.nextLong());
                }
            } else if (function.startsWith("Sentry")) {
                EntityShulker entityshulker = new EntityShulker(worldIn);
                entityshulker.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                entityshulker.func_184694_g(pos);
                worldIn.func_72838_d((Entity)entityshulker);
            } else if (function.startsWith("Elytra")) {
                EntityItemFrame entityitemframe = new EntityItemFrame(worldIn, pos, this.rotation.func_185831_a(EnumFacing.SOUTH));
                entityitemframe.func_82334_a(new ItemStack(Items.field_185160_cR));
                worldIn.func_72838_d((Entity)entityitemframe);
            }
        }
    }
}

