/*
 * Decompiled with CFR 0.152.
 */
package net.TelepathicGrunt.UltraAmplified.World.gen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.TelepathicGrunt.UltraAmplified.Config.UAConfig;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class StructureStrongholdPiecesUA {
    private static final PieceWeight[] PIECE_WEIGHTS = new PieceWeight[]{new PieceWeight(Straight.class, 40, 0), new PieceWeight(Prison.class, 5, 8), new PieceWeight(LeftTurn.class, 20, 0), new PieceWeight(RightTurn.class, 20, 0), new PieceWeight(RoomCrossing.class, 10, 9), new PieceWeight(StairsStraight.class, 5, 7), new PieceWeight(Stairs.class, 5, 7), new PieceWeight(Crossing.class, 5, 7), new PieceWeight(ChestCorridor.class, 5, 16), new PieceWeight(Library.class, 10, 6){

        @Override
        public boolean canSpawnMoreStructuresOfType(int p_75189_1_) {
            return super.canSpawnMoreStructuresOfType(p_75189_1_) && p_75189_1_ > 4;
        }
    }, new PieceWeight(PortalRoom.class, 20, 1){

        @Override
        public boolean canSpawnMoreStructuresOfType(int p_75189_1_) {
            return super.canSpawnMoreStructuresOfType(p_75189_1_) && p_75189_1_ > 5;
        }
    }};
    private static List<PieceWeight> structurePieceList;
    private static Class<? extends Stronghold> strongComponentType;
    static int totalWeight;
    private static final Stones STRONGHOLD_STONES;

    public static void registerStrongholdPieces() {
        MapGenStructureIO.func_143031_a(ChestCorridor.class, (String)"SHCC");
        MapGenStructureIO.func_143031_a(Corridor.class, (String)"SHFC");
        MapGenStructureIO.func_143031_a(Crossing.class, (String)"SH5C");
        MapGenStructureIO.func_143031_a(LeftTurn.class, (String)"SHLT");
        MapGenStructureIO.func_143031_a(Library.class, (String)"SHLi");
        MapGenStructureIO.func_143031_a(PortalRoom.class, (String)"SHPR");
        MapGenStructureIO.func_143031_a(Prison.class, (String)"SHPH");
        MapGenStructureIO.func_143031_a(RightTurn.class, (String)"SHRT");
        MapGenStructureIO.func_143031_a(RoomCrossing.class, (String)"SHRC");
        MapGenStructureIO.func_143031_a(Stairs.class, (String)"SHSD");
        MapGenStructureIO.func_143031_a(Stairs2.class, (String)"SHStart");
        MapGenStructureIO.func_143031_a(Straight.class, (String)"SHS");
        MapGenStructureIO.func_143031_a(StairsStraight.class, (String)"SHSSD");
    }

    public static void prepareStructurePieces() {
        structurePieceList = Lists.newArrayList();
        for (PieceWeight structurestrongholdpieces$pieceweight : PIECE_WEIGHTS) {
            structurestrongholdpieces$pieceweight.instancesSpawned = 0;
            structurePieceList.add(structurestrongholdpieces$pieceweight);
        }
        strongComponentType = null;
    }

    private static boolean canAddStructurePieces() {
        boolean flag = false;
        totalWeight = 0;
        for (PieceWeight structurestrongholdpieces$pieceweight : structurePieceList) {
            if (structurestrongholdpieces$pieceweight.instancesLimit > 0 && structurestrongholdpieces$pieceweight.instancesSpawned < structurestrongholdpieces$pieceweight.instancesLimit) {
                flag = true;
            }
            totalWeight += structurestrongholdpieces$pieceweight.pieceWeight;
        }
        return flag;
    }

    private static Stronghold findAndCreatePieceFactory(Class<? extends Stronghold> clazz, List<StructureComponent> p_175954_1_, Random p_175954_2_, int p_175954_3_, int p_175954_4_, int p_175954_5_, @Nullable EnumFacing p_175954_6_, int p_175954_7_) {
        Stronghold structurestrongholdpieces$stronghold = null;
        if (clazz == Straight.class) {
            structurestrongholdpieces$stronghold = Straight.createPiece(p_175954_1_, p_175954_2_, p_175954_3_, p_175954_4_, p_175954_5_, p_175954_6_, p_175954_7_);
        } else if (clazz == Prison.class) {
            structurestrongholdpieces$stronghold = Prison.createPiece(p_175954_1_, p_175954_2_, p_175954_3_, p_175954_4_, p_175954_5_, p_175954_6_, p_175954_7_);
        } else if (clazz == LeftTurn.class) {
            structurestrongholdpieces$stronghold = LeftTurn.createPiece(p_175954_1_, p_175954_2_, p_175954_3_, p_175954_4_, p_175954_5_, p_175954_6_, p_175954_7_);
        } else if (clazz == RightTurn.class) {
            structurestrongholdpieces$stronghold = RightTurn.createPiece(p_175954_1_, p_175954_2_, p_175954_3_, p_175954_4_, p_175954_5_, p_175954_6_, p_175954_7_);
        } else if (clazz == RoomCrossing.class) {
            structurestrongholdpieces$stronghold = RoomCrossing.createPiece(p_175954_1_, p_175954_2_, p_175954_3_, p_175954_4_, p_175954_5_, p_175954_6_, p_175954_7_);
        } else if (clazz == StairsStraight.class) {
            structurestrongholdpieces$stronghold = StairsStraight.createPiece(p_175954_1_, p_175954_2_, p_175954_3_, p_175954_4_, p_175954_5_, p_175954_6_, p_175954_7_);
        } else if (clazz == Stairs.class) {
            structurestrongholdpieces$stronghold = Stairs.createPiece(p_175954_1_, p_175954_2_, p_175954_3_, p_175954_4_, p_175954_5_, p_175954_6_, p_175954_7_);
        } else if (clazz == Crossing.class) {
            structurestrongholdpieces$stronghold = Crossing.createPiece(p_175954_1_, p_175954_2_, p_175954_3_, p_175954_4_, p_175954_5_, p_175954_6_, p_175954_7_);
        } else if (clazz == ChestCorridor.class) {
            structurestrongholdpieces$stronghold = ChestCorridor.createPiece(p_175954_1_, p_175954_2_, p_175954_3_, p_175954_4_, p_175954_5_, p_175954_6_, p_175954_7_);
        } else if (clazz == Library.class) {
            structurestrongholdpieces$stronghold = Library.createPiece(p_175954_1_, p_175954_2_, p_175954_3_, p_175954_4_, p_175954_5_, p_175954_6_, p_175954_7_);
        } else if (clazz == PortalRoom.class) {
            structurestrongholdpieces$stronghold = PortalRoom.createPiece(p_175954_1_, p_175954_2_, p_175954_3_, p_175954_4_, p_175954_5_, p_175954_6_, p_175954_7_);
        }
        return structurestrongholdpieces$stronghold;
    }

    private static Stronghold generatePieceFromSmallDoor(Stairs2 p_175955_0_, List<StructureComponent> p_175955_1_, Random p_175955_2_, int p_175955_3_, int p_175955_4_, int p_175955_5_, EnumFacing p_175955_6_, int p_175955_7_) {
        if (!StructureStrongholdPiecesUA.canAddStructurePieces()) {
            return null;
        }
        if (strongComponentType != null) {
            Stronghold structurestrongholdpieces$stronghold = StructureStrongholdPiecesUA.findAndCreatePieceFactory(strongComponentType, p_175955_1_, p_175955_2_, p_175955_3_, p_175955_4_, p_175955_5_, p_175955_6_, p_175955_7_);
            strongComponentType = null;
            if (structurestrongholdpieces$stronghold != null) {
                return structurestrongholdpieces$stronghold;
            }
        }
        int j = 0;
        block0: while (j < 5) {
            ++j;
            int i = p_175955_2_.nextInt(totalWeight);
            for (PieceWeight structurestrongholdpieces$pieceweight : structurePieceList) {
                if ((i -= structurestrongholdpieces$pieceweight.pieceWeight) >= 0) continue;
                if (!structurestrongholdpieces$pieceweight.canSpawnMoreStructuresOfType(p_175955_7_) || structurestrongholdpieces$pieceweight == p_175955_0_.strongholdPieceWeight) continue block0;
                Stronghold structurestrongholdpieces$stronghold1 = StructureStrongholdPiecesUA.findAndCreatePieceFactory(structurestrongholdpieces$pieceweight.pieceClass, p_175955_1_, p_175955_2_, p_175955_3_, p_175955_4_, p_175955_5_, p_175955_6_, p_175955_7_);
                if (structurestrongholdpieces$stronghold1 == null) continue;
                ++structurestrongholdpieces$pieceweight.instancesSpawned;
                p_175955_0_.strongholdPieceWeight = structurestrongholdpieces$pieceweight;
                if (!structurestrongholdpieces$pieceweight.canSpawnMoreStructures()) {
                    structurePieceList.remove(structurestrongholdpieces$pieceweight);
                }
                return structurestrongholdpieces$stronghold1;
            }
        }
        StructureBoundingBox structureboundingbox = Corridor.findPieceBox(p_175955_1_, p_175955_2_, p_175955_3_, p_175955_4_, p_175955_5_, p_175955_6_);
        if (structureboundingbox != null && structureboundingbox.field_78895_b > 1) {
            return new Corridor(p_175955_7_, p_175955_2_, structureboundingbox, p_175955_6_);
        }
        return null;
    }

    private static StructureComponent generateAndAddPiece(Stairs2 p_175953_0_, List<StructureComponent> p_175953_1_, Random p_175953_2_, int p_175953_3_, int p_175953_4_, int p_175953_5_, @Nullable EnumFacing p_175953_6_, int p_175953_7_) {
        if (p_175953_7_ > 50) {
            return null;
        }
        if (Math.abs(p_175953_3_ - p_175953_0_.func_74874_b().field_78897_a) <= 112 && Math.abs(p_175953_5_ - p_175953_0_.func_74874_b().field_78896_c) <= 112) {
            Stronghold structurecomponent = StructureStrongholdPiecesUA.generatePieceFromSmallDoor(p_175953_0_, p_175953_1_, p_175953_2_, p_175953_3_, p_175953_4_, p_175953_5_, p_175953_6_, p_175953_7_ + 1);
            if (structurecomponent != null) {
                p_175953_1_.add(structurecomponent);
                p_175953_0_.pendingChildren.add(structurecomponent);
            }
            return structurecomponent;
        }
        return null;
    }

    static {
        STRONGHOLD_STONES = new Stones();
    }

    static abstract class Stronghold
    extends StructureComponent {
        protected Door entryDoor = Door.OPENING;

        public Stronghold() {
        }

        protected Stronghold(int p_i2087_1_) {
            super(p_i2087_1_);
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            tagCompound.func_74778_a("EntryDoor", this.entryDoor.name());
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            this.entryDoor = Door.valueOf(tagCompound.func_74779_i("EntryDoor"));
        }

        protected void placeDoor(World worldIn, Random p_74990_2_, StructureBoundingBox p_74990_3_, Door p_74990_4_, int p_74990_5_, int p_74990_6_, int p_74990_7_) {
            switch (p_74990_4_) {
                case OPENING: {
                    this.func_175804_a(worldIn, p_74990_3_, p_74990_5_, p_74990_6_, p_74990_7_, p_74990_5_ + 3 - 1, p_74990_6_ + 3 - 1, p_74990_7_, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                    break;
                }
                case WOOD_DOOR: {
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), p_74990_5_, p_74990_6_, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), p_74990_5_, p_74990_6_ + 1, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), p_74990_5_, p_74990_6_ + 2, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), p_74990_5_ + 1, p_74990_6_ + 2, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), p_74990_5_ + 2, p_74990_6_ + 2, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), p_74990_5_ + 2, p_74990_6_ + 1, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), p_74990_5_ + 2, p_74990_6_, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_180413_ao.func_176223_P(), p_74990_5_ + 1, p_74990_6_, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), p_74990_5_ + 1, p_74990_6_ + 1, p_74990_7_, p_74990_3_);
                    break;
                }
                case GRATES: {
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), p_74990_5_ + 1, p_74990_6_, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), p_74990_5_ + 1, p_74990_6_ + 1, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), p_74990_5_, p_74990_6_, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), p_74990_5_, p_74990_6_ + 1, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), p_74990_5_, p_74990_6_ + 2, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), p_74990_5_ + 1, p_74990_6_ + 2, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), p_74990_5_ + 2, p_74990_6_ + 2, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), p_74990_5_ + 2, p_74990_6_ + 1, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), p_74990_5_ + 2, p_74990_6_, p_74990_7_, p_74990_3_);
                    break;
                }
                case IRON_DOOR: {
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), p_74990_5_, p_74990_6_, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), p_74990_5_, p_74990_6_ + 1, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), p_74990_5_, p_74990_6_ + 2, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), p_74990_5_ + 1, p_74990_6_ + 2, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), p_74990_5_ + 2, p_74990_6_ + 2, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), p_74990_5_ + 2, p_74990_6_ + 1, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), p_74990_5_ + 2, p_74990_6_, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150454_av.func_176223_P(), p_74990_5_ + 1, p_74990_6_, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), p_74990_5_ + 1, p_74990_6_ + 1, p_74990_7_, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150430_aB.func_176223_P().func_177226_a((IProperty)BlockButton.field_176387_N, (Comparable)EnumFacing.NORTH), p_74990_5_ + 2, p_74990_6_ + 1, p_74990_7_ + 1, p_74990_3_);
                    this.func_175811_a(worldIn, Blocks.field_150430_aB.func_176223_P().func_177226_a((IProperty)BlockButton.field_176387_N, (Comparable)EnumFacing.SOUTH), p_74990_5_ + 2, p_74990_6_ + 1, p_74990_7_ - 1, p_74990_3_);
                }
            }
        }

        protected Door getRandomDoor(Random p_74988_1_) {
            int i = p_74988_1_.nextInt(5);
            switch (i) {
                default: {
                    return Door.OPENING;
                }
                case 2: {
                    return Door.WOOD_DOOR;
                }
                case 3: {
                    return Door.GRATES;
                }
                case 4: 
            }
            return Door.IRON_DOOR;
        }

        @Nullable
        protected StructureComponent getNextComponentNormal(Stairs2 p_74986_1_, List<StructureComponent> p_74986_2_, Random p_74986_3_, int p_74986_4_, int p_74986_5_) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case NORTH: {
                        return StructureStrongholdPiecesUA.generateAndAddPiece(p_74986_1_, p_74986_2_, p_74986_3_, this.field_74887_e.field_78897_a + p_74986_4_, this.field_74887_e.field_78895_b + p_74986_5_, this.field_74887_e.field_78896_c - 1, enumfacing, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StructureStrongholdPiecesUA.generateAndAddPiece(p_74986_1_, p_74986_2_, p_74986_3_, this.field_74887_e.field_78897_a + p_74986_4_, this.field_74887_e.field_78895_b + p_74986_5_, this.field_74887_e.field_78892_f + 1, enumfacing, this.func_74877_c());
                    }
                    case WEST: {
                        return StructureStrongholdPiecesUA.generateAndAddPiece(p_74986_1_, p_74986_2_, p_74986_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74986_5_, this.field_74887_e.field_78896_c + p_74986_4_, enumfacing, this.func_74877_c());
                    }
                    case EAST: {
                        return StructureStrongholdPiecesUA.generateAndAddPiece(p_74986_1_, p_74986_2_, p_74986_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74986_5_, this.field_74887_e.field_78896_c + p_74986_4_, enumfacing, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructureComponent getNextComponentX(Stairs2 p_74989_1_, List<StructureComponent> p_74989_2_, Random p_74989_3_, int p_74989_4_, int p_74989_5_) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case NORTH: {
                        return StructureStrongholdPiecesUA.generateAndAddPiece(p_74989_1_, p_74989_2_, p_74989_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74989_4_, this.field_74887_e.field_78896_c + p_74989_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StructureStrongholdPiecesUA.generateAndAddPiece(p_74989_1_, p_74989_2_, p_74989_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74989_4_, this.field_74887_e.field_78896_c + p_74989_5_, EnumFacing.WEST, this.func_74877_c());
                    }
                    case WEST: {
                        return StructureStrongholdPiecesUA.generateAndAddPiece(p_74989_1_, p_74989_2_, p_74989_3_, this.field_74887_e.field_78897_a + p_74989_5_, this.field_74887_e.field_78895_b + p_74989_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                    case EAST: {
                        return StructureStrongholdPiecesUA.generateAndAddPiece(p_74989_1_, p_74989_2_, p_74989_3_, this.field_74887_e.field_78897_a + p_74989_5_, this.field_74887_e.field_78895_b + p_74989_4_, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructureComponent getNextComponentZ(Stairs2 p_74987_1_, List<StructureComponent> p_74987_2_, Random p_74987_3_, int p_74987_4_, int p_74987_5_) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case NORTH: {
                        return StructureStrongholdPiecesUA.generateAndAddPiece(p_74987_1_, p_74987_2_, p_74987_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74987_4_, this.field_74887_e.field_78896_c + p_74987_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StructureStrongholdPiecesUA.generateAndAddPiece(p_74987_1_, p_74987_2_, p_74987_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74987_4_, this.field_74887_e.field_78896_c + p_74987_5_, EnumFacing.EAST, this.func_74877_c());
                    }
                    case WEST: {
                        return StructureStrongholdPiecesUA.generateAndAddPiece(p_74987_1_, p_74987_2_, p_74987_3_, this.field_74887_e.field_78897_a + p_74987_5_, this.field_74887_e.field_78895_b + p_74987_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                    case EAST: {
                        return StructureStrongholdPiecesUA.generateAndAddPiece(p_74987_1_, p_74987_2_, p_74987_3_, this.field_74887_e.field_78897_a + p_74987_5_, this.field_74887_e.field_78895_b + p_74987_4_, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        protected static boolean canStrongholdGoDeeper(StructureBoundingBox p_74991_0_) {
            return p_74991_0_ != null && p_74991_0_.field_78895_b > 10;
        }

        public static enum Door {
            OPENING,
            WOOD_DOOR,
            GRATES,
            IRON_DOOR;

        }
    }

    public static class Straight
    extends Stronghold {
        private boolean expandsX;
        private boolean expandsZ;

        public Straight() {
        }

        public Straight(int p_i45573_1_, Random p_i45573_2_, StructureBoundingBox p_i45573_3_, EnumFacing p_i45573_4_) {
            super(p_i45573_1_);
            this.func_186164_a(p_i45573_4_);
            this.entryDoor = this.getRandomDoor(p_i45573_2_);
            this.field_74887_e = p_i45573_3_;
            this.expandsX = p_i45573_2_.nextInt(2) == 0;
            this.expandsZ = p_i45573_2_.nextInt(2) == 0;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Left", this.expandsX);
            tagCompound.func_74757_a("Right", this.expandsZ);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.expandsX = tagCompound.func_74767_n("Left");
            this.expandsZ = tagCompound.func_74767_n("Right");
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            this.getNextComponentNormal((Stairs2)componentIn, listIn, rand, 1, 1);
            if (this.expandsX) {
                this.getNextComponentX((Stairs2)componentIn, listIn, rand, 1, 2);
            }
            if (this.expandsZ) {
                this.getNextComponentZ((Stairs2)componentIn, listIn, rand, 1, 2);
            }
        }

        public static Straight createPiece(List<StructureComponent> p_175862_0_, Random p_175862_1_, int p_175862_2_, int p_175862_3_, int p_175862_4_, EnumFacing p_175862_5_, int p_175862_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175862_2_, (int)p_175862_3_, (int)p_175862_4_, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)7, (EnumFacing)p_175862_5_);
            return Straight.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175862_0_, (StructureBoundingBox)structureboundingbox) == null ? new Straight(p_175862_6_, p_175862_1_, structureboundingbox, p_175862_5_) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.func_74860_a(worldIn, structureBoundingBoxIn)) {
                return false;
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 4, 4, 6, false, randomIn, STRONGHOLD_STONES);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, Stronghold.Door.OPENING, 1, 1, 6);
            IBlockState iblockstate = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST);
            IBlockState iblockstate1 = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST);
            this.func_175809_a(worldIn, structureBoundingBoxIn, randomIn, 0.1f, 1, 2, 1, iblockstate);
            this.func_175809_a(worldIn, structureBoundingBoxIn, randomIn, 0.1f, 3, 2, 1, iblockstate1);
            this.func_175809_a(worldIn, structureBoundingBoxIn, randomIn, 0.1f, 1, 2, 5, iblockstate);
            this.func_175809_a(worldIn, structureBoundingBoxIn, randomIn, 0.1f, 3, 2, 5, iblockstate1);
            if (this.expandsX) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 2, 0, 3, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            if (this.expandsZ) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 2, 4, 3, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            return true;
        }
    }

    static class Stones
    extends StructureComponent.BlockSelector {
        private Stones() {
        }

        public void func_75062_a(Random rand, int x, int y, int z, boolean p_75062_5_) {
            float f;
            this.field_151562_a = p_75062_5_ ? ((f = rand.nextFloat()) < (float)Math.pow(UAConfig.oreAndFeatures.silverfishSpawnrate / 500.0, 2.0) ? Blocks.field_150418_aU.func_176223_P().func_177226_a((IProperty)BlockSilverfish.field_176378_a, (Comparable)BlockSilverfish.EnumType.STONEBRICK) : (f < 0.25f ? Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED) : (f < 0.55f ? Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY) : Blocks.field_150417_aV.func_176223_P()))) : Blocks.field_150350_a.func_176223_P();
        }
    }

    public static class StairsStraight
    extends Stronghold {
        public StairsStraight() {
        }

        public StairsStraight(int p_i45572_1_, Random p_i45572_2_, StructureBoundingBox p_i45572_3_, EnumFacing p_i45572_4_) {
            super(p_i45572_1_);
            this.func_186164_a(p_i45572_4_);
            this.entryDoor = this.getRandomDoor(p_i45572_2_);
            this.field_74887_e = p_i45572_3_;
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            this.getNextComponentNormal((Stairs2)componentIn, listIn, rand, 1, 1);
        }

        public static StairsStraight createPiece(List<StructureComponent> p_175861_0_, Random p_175861_1_, int p_175861_2_, int p_175861_3_, int p_175861_4_, EnumFacing p_175861_5_, int p_175861_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175861_2_, (int)p_175861_3_, (int)p_175861_4_, (int)-1, (int)-7, (int)0, (int)5, (int)11, (int)8, (EnumFacing)p_175861_5_);
            return StairsStraight.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175861_0_, (StructureBoundingBox)structureboundingbox) == null ? new StairsStraight(p_175861_6_, p_175861_1_, structureboundingbox, p_175861_5_) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.func_74860_a(worldIn, structureBoundingBoxIn)) {
                return false;
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 4, 10, 7, false, randomIn, STRONGHOLD_STONES);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, this.entryDoor, 1, 7, 0);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, Stronghold.Door.OPENING, 1, 1, 7);
            IBlockState iblockstate = Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            for (int i = 0; i < 6; ++i) {
                this.func_175811_a(worldIn, iblockstate, 1, 6 - i, 1 + i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 2, 6 - i, 1 + i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 3, 6 - i, 1 + i, structureBoundingBoxIn);
                if (i >= 5) continue;
                this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 1, 5 - i, 1 + i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 2, 5 - i, 1 + i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 3, 5 - i, 1 + i, structureBoundingBoxIn);
            }
            return true;
        }
    }

    public static class Stairs2
    extends Stairs {
        public PieceWeight strongholdPieceWeight;
        public PortalRoom strongholdPortalRoom;
        public List<StructureComponent> pendingChildren = Lists.newArrayList();

        public Stairs2() {
        }

        public Stairs2(int p_i2083_1_, Random p_i2083_2_, int p_i2083_3_, int p_i2083_4_) {
            super(0, p_i2083_2_, p_i2083_3_, p_i2083_4_);
        }
    }

    public static class Stairs
    extends Stronghold {
        private boolean source;

        public Stairs() {
        }

        public Stairs(int p_i2081_1_, Random p_i2081_2_, int p_i2081_3_, int p_i2081_4_) {
            super(p_i2081_1_);
            this.source = true;
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(p_i2081_2_));
            this.entryDoor = Stronghold.Door.OPENING;
            this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(p_i2081_3_, 64, p_i2081_4_, p_i2081_3_ + 5 - 1, 74, p_i2081_4_ + 5 - 1) : new StructureBoundingBox(p_i2081_3_, 64, p_i2081_4_, p_i2081_3_ + 5 - 1, 74, p_i2081_4_ + 5 - 1);
            this.field_74887_e.func_78886_a(0, p_i2081_2_.nextInt(80) + 60, 0);
        }

        public Stairs(int p_i45574_1_, Random p_i45574_2_, StructureBoundingBox p_i45574_3_, EnumFacing p_i45574_4_) {
            super(p_i45574_1_);
            this.source = false;
            this.func_186164_a(p_i45574_4_);
            this.entryDoor = this.getRandomDoor(p_i45574_2_);
            this.field_74887_e = p_i45574_3_;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Source", this.source);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.source = tagCompound.func_74767_n("Source");
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            if (this.source) {
                strongComponentType = Crossing.class;
            }
            this.getNextComponentNormal((Stairs2)componentIn, listIn, rand, 1, 1);
        }

        public static Stairs createPiece(List<StructureComponent> p_175863_0_, Random p_175863_1_, int p_175863_2_, int p_175863_3_, int p_175863_4_, EnumFacing p_175863_5_, int p_175863_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175863_2_, (int)p_175863_3_, (int)p_175863_4_, (int)-1, (int)-7, (int)0, (int)5, (int)11, (int)5, (EnumFacing)p_175863_5_);
            return Stairs.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175863_0_, (StructureBoundingBox)structureboundingbox) == null ? new Stairs(p_175863_6_, p_175863_1_, structureboundingbox, p_175863_5_) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.func_74860_a(worldIn, structureBoundingBoxIn)) {
                return false;
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 4, 10, 4, false, randomIn, STRONGHOLD_STONES);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, this.entryDoor, 1, 7, 0);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, Stronghold.Door.OPENING, 1, 1, 4);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 2, 6, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 1, 5, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150333_U.func_176203_a(BlockStoneSlab.EnumType.STONE.func_176624_a()), 1, 6, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 1, 5, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 1, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150333_U.func_176203_a(BlockStoneSlab.EnumType.STONE.func_176624_a()), 1, 5, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 2, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 3, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150333_U.func_176203_a(BlockStoneSlab.EnumType.STONE.func_176624_a()), 3, 4, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 3, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 3, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150333_U.func_176203_a(BlockStoneSlab.EnumType.STONE.func_176624_a()), 3, 3, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 2, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 1, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150333_U.func_176203_a(BlockStoneSlab.EnumType.STONE.func_176624_a()), 1, 2, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 1, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150333_U.func_176203_a(BlockStoneSlab.EnumType.STONE.func_176624_a()), 1, 1, 3, structureBoundingBoxIn);
            return true;
        }
    }

    public static class RoomCrossing
    extends Stronghold {
        protected int roomType;
        private boolean hasSpawner = false;

        public RoomCrossing() {
        }

        public RoomCrossing(int p_i45575_1_, Random p_i45575_2_, StructureBoundingBox p_i45575_3_, EnumFacing p_i45575_4_) {
            super(p_i45575_1_);
            this.func_186164_a(p_i45575_4_);
            this.entryDoor = this.getRandomDoor(p_i45575_2_);
            this.field_74887_e = p_i45575_3_;
            this.roomType = p_i45575_2_.nextInt(4);
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("Type", this.roomType);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.roomType = tagCompound.func_74762_e("Type");
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            this.getNextComponentNormal((Stairs2)componentIn, listIn, rand, 4, 1);
            this.getNextComponentX((Stairs2)componentIn, listIn, rand, 1, 4);
            this.getNextComponentZ((Stairs2)componentIn, listIn, rand, 1, 4);
        }

        public static RoomCrossing createPiece(List<StructureComponent> p_175859_0_, Random p_175859_1_, int p_175859_2_, int p_175859_3_, int p_175859_4_, EnumFacing p_175859_5_, int p_175859_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175859_2_, (int)p_175859_3_, (int)p_175859_4_, (int)-4, (int)-1, (int)0, (int)11, (int)7, (int)11, (EnumFacing)p_175859_5_);
            return RoomCrossing.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175859_0_, (StructureBoundingBox)structureboundingbox) == null ? new RoomCrossing(p_175859_6_, p_175859_1_, structureboundingbox, p_175859_5_) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.func_74860_a(worldIn, structureBoundingBoxIn)) {
                return false;
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 10, 6, 10, false, randomIn, STRONGHOLD_STONES);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, this.entryDoor, 4, 1, 0);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 10, 6, 3, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 4, 0, 3, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 10, 1, 4, 10, 3, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            switch (this.roomType) {
                case 0: {
                    BlockPos blockpos;
                    if (!this.hasSpawner && structureBoundingBoxIn.func_175898_b((Vec3i)(blockpos = new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5))))) {
                        this.hasSpawner = true;
                        worldIn.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                        TileEntity tileentity = worldIn.func_175625_s(blockpos);
                        if (tileentity instanceof TileEntityMobSpawner) {
                            ((TileEntityMobSpawner)tileentity).func_145881_a().func_190894_a(EntityList.func_191306_a(EntitySilverfish.class));
                        }
                    }
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 5, 2, 5, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 5, 3, 5, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST), 4, 3, 5, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST), 6, 3, 5, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH), 5, 3, 4, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH), 5, 3, 6, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150333_U.func_176223_P(), 4, 1, 4, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150333_U.func_176223_P(), 4, 1, 5, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150333_U.func_176223_P(), 4, 1, 6, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150333_U.func_176223_P(), 6, 1, 4, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150333_U.func_176223_P(), 6, 1, 5, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150333_U.func_176223_P(), 6, 1, 6, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150333_U.func_176223_P(), 5, 1, 4, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150333_U.func_176223_P(), 5, 1, 6, structureBoundingBoxIn);
                    break;
                }
                case 1: {
                    BlockPos blockpos;
                    for (int i1 = 0; i1 < 5; ++i1) {
                        this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 3, 1, 3 + i1, structureBoundingBoxIn);
                        this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 7, 1, 3 + i1, structureBoundingBoxIn);
                        this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 3 + i1, 1, 3, structureBoundingBoxIn);
                        this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 3 + i1, 1, 7, structureBoundingBoxIn);
                    }
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 5, 2, 5, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 5, 3, 5, structureBoundingBoxIn);
                    if (!this.hasSpawner && structureBoundingBoxIn.func_175898_b((Vec3i)(blockpos = new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5))))) {
                        this.hasSpawner = true;
                        worldIn.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                        TileEntity tileentity = worldIn.func_175625_s(blockpos);
                        if (tileentity instanceof TileEntityMobSpawner) {
                            ((TileEntityMobSpawner)tileentity).func_145881_a().func_190894_a(EntityList.func_191306_a(EntitySilverfish.class));
                        }
                    }
                    this.func_175811_a(worldIn, Blocks.field_150358_i.func_176223_P(), 5, 4, 5, structureBoundingBoxIn);
                    break;
                }
                case 2: 
                case 3: {
                    BlockPos blockpos;
                    for (int i = 1; i <= 9; ++i) {
                        this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 1, 3, i, structureBoundingBoxIn);
                        this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 9, 3, i, structureBoundingBoxIn);
                    }
                    for (int j = 1; j <= 9; ++j) {
                        this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), j, 3, 1, structureBoundingBoxIn);
                        this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), j, 3, 9, structureBoundingBoxIn);
                    }
                    this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 5, 1, 4, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 5, 1, 6, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 5, 3, 4, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 5, 3, 6, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 4, 1, 5, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 6, 1, 5, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 4, 3, 5, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 6, 3, 5, structureBoundingBoxIn);
                    for (int k = 1; k <= 3; ++k) {
                        this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 4, k, 4, structureBoundingBoxIn);
                        this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 6, k, 4, structureBoundingBoxIn);
                        this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 4, k, 6, structureBoundingBoxIn);
                        this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 6, k, 6, structureBoundingBoxIn);
                    }
                    if (!this.hasSpawner && structureBoundingBoxIn.func_175898_b((Vec3i)(blockpos = new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5))))) {
                        this.hasSpawner = true;
                        worldIn.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                        TileEntity tileentity = worldIn.func_175625_s(blockpos);
                        if (tileentity instanceof TileEntityMobSpawner) {
                            ((TileEntityMobSpawner)tileentity).func_145881_a().func_190894_a(EntityList.func_191306_a(EntitySilverfish.class));
                        }
                    }
                    this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P(), 5, 3, 5, structureBoundingBoxIn);
                    for (int l = 2; l <= 8; ++l) {
                        this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 2, 3, l, structureBoundingBoxIn);
                        this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 3, 3, l, structureBoundingBoxIn);
                        if (l <= 3 || l >= 7) {
                            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 4, 3, l, structureBoundingBoxIn);
                            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 5, 3, l, structureBoundingBoxIn);
                            this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 6, 3, l, structureBoundingBoxIn);
                        }
                        this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 7, 3, l, structureBoundingBoxIn);
                        this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 8, 3, l, structureBoundingBoxIn);
                    }
                    IBlockState iblockstate = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST);
                    this.func_175811_a(worldIn, iblockstate, 9, 1, 3, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, iblockstate, 9, 2, 3, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, iblockstate, 9, 3, 3, structureBoundingBoxIn);
                    if (!UAConfig.StructuresOptions.biomeBasedStructuresOptions.chestGeneration) break;
                    this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 3, 4, 8, LootTableList.field_186427_i);
                    this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 5, 4, 2, LootTableList.field_186427_i);
                    this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 6, 4, 8, LootTableList.field_186427_i);
                    this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 8, 4, 4, LootTableList.field_186427_i);
                }
            }
            return true;
        }
    }

    public static class RightTurn
    extends LeftTurn {
        @Override
        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != EnumFacing.NORTH && enumfacing != EnumFacing.EAST) {
                this.getNextComponentX((Stairs2)componentIn, listIn, rand, 1, 1);
            } else {
                this.getNextComponentZ((Stairs2)componentIn, listIn, rand, 1, 1);
            }
        }

        @Override
        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.func_74860_a(worldIn, structureBoundingBoxIn)) {
                return false;
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 4, 4, 4, false, randomIn, STRONGHOLD_STONES);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != EnumFacing.NORTH && enumfacing != EnumFacing.EAST) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            } else {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 1, 4, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            return true;
        }
    }

    public static class Prison
    extends Stronghold {
        public Prison() {
        }

        public Prison(int p_i45576_1_, Random p_i45576_2_, StructureBoundingBox p_i45576_3_, EnumFacing p_i45576_4_) {
            super(p_i45576_1_);
            this.func_186164_a(p_i45576_4_);
            this.entryDoor = this.getRandomDoor(p_i45576_2_);
            this.field_74887_e = p_i45576_3_;
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            this.getNextComponentNormal((Stairs2)componentIn, listIn, rand, 1, 1);
        }

        public static Prison createPiece(List<StructureComponent> p_175860_0_, Random p_175860_1_, int p_175860_2_, int p_175860_3_, int p_175860_4_, EnumFacing p_175860_5_, int p_175860_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175860_2_, (int)p_175860_3_, (int)p_175860_4_, (int)-1, (int)-1, (int)0, (int)9, (int)5, (int)11, (EnumFacing)p_175860_5_);
            return Prison.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175860_0_, (StructureBoundingBox)structureboundingbox) == null ? new Prison(p_175860_6_, p_175860_1_, structureboundingbox, p_175860_5_) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.func_74860_a(worldIn, structureBoundingBoxIn)) {
                return false;
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 8, 4, 10, false, randomIn, STRONGHOLD_STONES);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 10, 3, 3, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 1, 1, 4, 3, 1, false, randomIn, STRONGHOLD_STONES);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 1, 3, 4, 3, 3, false, randomIn, STRONGHOLD_STONES);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 1, 7, 4, 3, 7, false, randomIn, STRONGHOLD_STONES);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 1, 9, 4, 3, 9, false, randomIn, STRONGHOLD_STONES);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 4, 4, 3, 6, Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 1, 5, 7, 3, 5, Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), 4, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), 4, 3, 8, structureBoundingBoxIn);
            IBlockState iblockstate = Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.WEST);
            IBlockState iblockstate1 = Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
            this.func_175811_a(worldIn, iblockstate, 4, 1, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate, 4, 1, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 2, 8, structureBoundingBoxIn);
            return true;
        }
    }

    public static class PortalRoom
    extends Stronghold {
        private boolean hasSpawner;

        public PortalRoom() {
        }

        public PortalRoom(int p_i45577_1_, Random p_i45577_2_, StructureBoundingBox p_i45577_3_, EnumFacing p_i45577_4_) {
            super(p_i45577_1_);
            this.func_186164_a(p_i45577_4_);
            this.field_74887_e = p_i45577_3_;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Mob", this.hasSpawner);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.hasSpawner = tagCompound.func_74767_n("Mob");
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            if (componentIn != null) {
                ((Stairs2)componentIn).strongholdPortalRoom = this;
            }
        }

        public static PortalRoom createPiece(List<StructureComponent> p_175865_0_, Random p_175865_1_, int p_175865_2_, int p_175865_3_, int p_175865_4_, EnumFacing p_175865_5_, int p_175865_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175865_2_, (int)p_175865_3_, (int)p_175865_4_, (int)-4, (int)-1, (int)0, (int)11, (int)8, (int)16, (EnumFacing)p_175865_5_);
            return PortalRoom.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175865_0_, (StructureBoundingBox)structureboundingbox) == null ? new PortalRoom(p_175865_6_, p_175865_1_, structureboundingbox, p_175865_5_) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            this.func_74882_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 10, 7, 15, false, randomIn, STRONGHOLD_STONES);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, Stronghold.Door.GRATES, 4, 1, 0);
            int i = 6;
            this.func_74882_a(worldIn, structureBoundingBoxIn, 1, i, 1, 1, i, 14, false, randomIn, STRONGHOLD_STONES);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 9, i, 1, 9, i, 14, false, randomIn, STRONGHOLD_STONES);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, i, 1, 8, i, 2, false, randomIn, STRONGHOLD_STONES);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 2, i, 14, 8, i, 14, false, randomIn, STRONGHOLD_STONES);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 2, 1, 4, false, randomIn, STRONGHOLD_STONES);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 8, 1, 1, 9, 1, 4, false, randomIn, STRONGHOLD_STONES);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 1, 1, 3, Blocks.field_150356_k.func_176223_P(), Blocks.field_150356_k.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 1, 1, 9, 1, 3, Blocks.field_150356_k.func_176223_P(), Blocks.field_150356_k.func_176223_P(), false);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 3, 1, 8, 7, 1, 12, false, randomIn, STRONGHOLD_STONES);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 9, 6, 1, 11, Blocks.field_150356_k.func_176223_P(), Blocks.field_150356_k.func_176223_P(), false);
            for (int j = 3; j < 14; j += 2) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 3, j, 0, 4, j, Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 10, 3, j, 10, 4, j, Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            }
            for (int i1 = 2; i1 < 9; i1 += 2) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, i1, 3, 15, i1, 4, 15, Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            }
            IBlockState iblockstate3 = Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 1, 5, 6, 1, 7, false, randomIn, STRONGHOLD_STONES);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 2, 6, 6, 2, 7, false, randomIn, STRONGHOLD_STONES);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 3, 7, 6, 3, 7, false, randomIn, STRONGHOLD_STONES);
            for (int k = 4; k <= 6; ++k) {
                this.func_175811_a(worldIn, iblockstate3, k, 1, 4, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate3, k, 2, 5, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate3, k, 3, 6, structureBoundingBoxIn);
            }
            IBlockState iblockstate4 = Blocks.field_150378_br.func_176223_P().func_177226_a((IProperty)BlockEndPortalFrame.field_176508_a, (Comparable)EnumFacing.NORTH);
            IBlockState iblockstate = Blocks.field_150378_br.func_176223_P().func_177226_a((IProperty)BlockEndPortalFrame.field_176508_a, (Comparable)EnumFacing.SOUTH);
            IBlockState iblockstate1 = Blocks.field_150378_br.func_176223_P().func_177226_a((IProperty)BlockEndPortalFrame.field_176508_a, (Comparable)EnumFacing.EAST);
            IBlockState iblockstate2 = Blocks.field_150378_br.func_176223_P().func_177226_a((IProperty)BlockEndPortalFrame.field_176508_a, (Comparable)EnumFacing.WEST);
            boolean flag = true;
            boolean[] aboolean = new boolean[12];
            for (int l = 0; l < aboolean.length; ++l) {
                aboolean[l] = randomIn.nextFloat() > 0.9f;
                flag &= aboolean[l];
            }
            this.func_175811_a(worldIn, iblockstate4.func_177226_a((IProperty)BlockEndPortalFrame.field_176507_b, (Comparable)Boolean.valueOf(aboolean[0])), 4, 3, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4.func_177226_a((IProperty)BlockEndPortalFrame.field_176507_b, (Comparable)Boolean.valueOf(aboolean[1])), 5, 3, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate4.func_177226_a((IProperty)BlockEndPortalFrame.field_176507_b, (Comparable)Boolean.valueOf(aboolean[2])), 6, 3, 8, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate.func_177226_a((IProperty)BlockEndPortalFrame.field_176507_b, (Comparable)Boolean.valueOf(aboolean[3])), 4, 3, 12, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate.func_177226_a((IProperty)BlockEndPortalFrame.field_176507_b, (Comparable)Boolean.valueOf(aboolean[4])), 5, 3, 12, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate.func_177226_a((IProperty)BlockEndPortalFrame.field_176507_b, (Comparable)Boolean.valueOf(aboolean[5])), 6, 3, 12, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1.func_177226_a((IProperty)BlockEndPortalFrame.field_176507_b, (Comparable)Boolean.valueOf(aboolean[6])), 3, 3, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1.func_177226_a((IProperty)BlockEndPortalFrame.field_176507_b, (Comparable)Boolean.valueOf(aboolean[7])), 3, 3, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1.func_177226_a((IProperty)BlockEndPortalFrame.field_176507_b, (Comparable)Boolean.valueOf(aboolean[8])), 3, 3, 11, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate2.func_177226_a((IProperty)BlockEndPortalFrame.field_176507_b, (Comparable)Boolean.valueOf(aboolean[9])), 7, 3, 9, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate2.func_177226_a((IProperty)BlockEndPortalFrame.field_176507_b, (Comparable)Boolean.valueOf(aboolean[10])), 7, 3, 10, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate2.func_177226_a((IProperty)BlockEndPortalFrame.field_176507_b, (Comparable)Boolean.valueOf(aboolean[11])), 7, 3, 11, structureBoundingBoxIn);
            if (flag) {
                IBlockState iblockstate5 = Blocks.field_150384_bq.func_176223_P();
                this.func_175811_a(worldIn, iblockstate5, 4, 3, 9, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate5, 5, 3, 9, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate5, 6, 3, 9, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate5, 4, 3, 10, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate5, 5, 3, 10, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate5, 6, 3, 10, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate5, 4, 3, 11, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate5, 5, 3, 11, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate5, 6, 3, 11, structureBoundingBoxIn);
            }
            if (!this.hasSpawner) {
                i = this.func_74862_a(3);
                BlockPos blockpos = new BlockPos(this.func_74865_a(5, 6), i, this.func_74873_b(5, 6));
                if (structureBoundingBoxIn.func_175898_b((Vec3i)blockpos)) {
                    this.hasSpawner = true;
                    worldIn.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                    TileEntity tileentity = worldIn.func_175625_s(blockpos);
                    if (tileentity instanceof TileEntityMobSpawner) {
                        ((TileEntityMobSpawner)tileentity).func_145881_a().func_190894_a(EntityList.func_191306_a(EntityEndermite.class));
                    }
                }
            }
            return true;
        }
    }

    static class PieceWeight {
        public Class<? extends Stronghold> pieceClass;
        public final int pieceWeight;
        public int instancesSpawned;
        public int instancesLimit;

        public PieceWeight(Class<? extends Stronghold> p_i2076_1_, int p_i2076_2_, int p_i2076_3_) {
            this.pieceClass = p_i2076_1_;
            this.pieceWeight = p_i2076_2_;
            this.instancesLimit = p_i2076_3_;
        }

        public boolean canSpawnMoreStructuresOfType(int p_75189_1_) {
            return this.instancesLimit == 0 || this.instancesSpawned < this.instancesLimit;
        }

        public boolean canSpawnMoreStructures() {
            return this.instancesLimit == 0 || this.instancesSpawned < this.instancesLimit;
        }
    }

    public static class Library
    extends Stronghold {
        private boolean isLargeRoom;

        public Library() {
        }

        public Library(int p_i45578_1_, Random p_i45578_2_, StructureBoundingBox p_i45578_3_, EnumFacing p_i45578_4_) {
            super(p_i45578_1_);
            this.func_186164_a(p_i45578_4_);
            this.entryDoor = this.getRandomDoor(p_i45578_2_);
            this.field_74887_e = p_i45578_3_;
            this.isLargeRoom = p_i45578_3_.func_78882_c() > 6;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Tall", this.isLargeRoom);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.isLargeRoom = tagCompound.func_74767_n("Tall");
        }

        public static Library createPiece(List<StructureComponent> p_175864_0_, Random p_175864_1_, int p_175864_2_, int p_175864_3_, int p_175864_4_, EnumFacing p_175864_5_, int p_175864_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175864_2_, (int)p_175864_3_, (int)p_175864_4_, (int)-4, (int)-1, (int)0, (int)14, (int)11, (int)15, (EnumFacing)p_175864_5_);
            if (!(Library.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175864_0_, (StructureBoundingBox)structureboundingbox) == null || Library.canStrongholdGoDeeper(structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175864_2_, (int)p_175864_3_, (int)p_175864_4_, (int)-4, (int)-1, (int)0, (int)14, (int)6, (int)15, (EnumFacing)p_175864_5_)) && StructureComponent.func_74883_a(p_175864_0_, (StructureBoundingBox)structureboundingbox) == null)) {
                return null;
            }
            return new Library(p_175864_6_, p_175864_1_, structureboundingbox, p_175864_5_);
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.func_74860_a(worldIn, structureBoundingBoxIn)) {
                return false;
            }
            int i = 11;
            if (!this.isLargeRoom) {
                i = 6;
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 13, i - 1, 14, false, randomIn, STRONGHOLD_STONES);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, this.entryDoor, 4, 1, 0);
            this.func_189914_a(worldIn, structureBoundingBoxIn, randomIn, 0.07f, 2, 1, 1, 11, 4, 13, Blocks.field_150321_G.func_176223_P(), Blocks.field_150321_G.func_176223_P(), false, 0);
            boolean j = true;
            int k = 12;
            for (int l = 1; l <= 13; ++l) {
                if ((l - 1) % 4 == 0) {
                    this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, l, 1, 4, l, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
                    this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 1, l, 12, 4, l, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
                    this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST), 2, 3, l, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST), 11, 3, l, structureBoundingBoxIn);
                    if (!this.isLargeRoom) continue;
                    this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 6, l, 1, 9, l, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
                    this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 6, l, 12, 9, l, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
                    continue;
                }
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, l, 1, 4, l, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 1, l, 12, 4, l, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                if (!this.isLargeRoom) continue;
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 6, l, 1, 9, l, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 6, l, 12, 9, l, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            for (int k1 = 3; k1 < 12; k1 += 2) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, k1, 4, 3, k1, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 1, k1, 7, 3, k1, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 1, k1, 10, 3, k1, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            if (this.isLargeRoom) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 5, 1, 3, 5, 13, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 10, 5, 1, 12, 5, 13, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 5, 1, 9, 5, 2, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 5, 12, 9, 5, 13, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
                this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 9, 5, 11, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 8, 5, 11, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150344_f.func_176223_P(), 9, 5, 10, structureBoundingBoxIn);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 6, 2, 3, 6, 12, Blocks.field_180407_aO.func_176223_P(), Blocks.field_180407_aO.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 10, 6, 2, 10, 6, 10, Blocks.field_180407_aO.func_176223_P(), Blocks.field_180407_aO.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 6, 2, 9, 6, 2, Blocks.field_180407_aO.func_176223_P(), Blocks.field_180407_aO.func_176223_P(), false);
                this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 6, 12, 8, 6, 12, Blocks.field_180407_aO.func_176223_P(), Blocks.field_180407_aO.func_176223_P(), false);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 9, 6, 11, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 8, 6, 11, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 9, 6, 10, structureBoundingBoxIn);
                IBlockState iblockstate1 = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.SOUTH);
                this.func_175811_a(worldIn, iblockstate1, 10, 1, 13, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate1, 10, 2, 13, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate1, 10, 3, 13, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate1, 10, 4, 13, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate1, 10, 5, 13, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate1, 10, 6, 13, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate1, 10, 7, 13, structureBoundingBoxIn);
                int i1 = 7;
                int j1 = 7;
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 6, 9, 7, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 7, 9, 7, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 6, 8, 7, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 7, 8, 7, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 6, 7, 7, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 7, 7, 7, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 5, 7, 7, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 8, 7, 7, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 6, 7, 6, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 6, 7, 8, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 7, 7, 6, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_180407_aO.func_176223_P(), 7, 7, 8, structureBoundingBoxIn);
                IBlockState iblockstate = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.UP);
                this.func_175811_a(worldIn, iblockstate, 5, 8, 7, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 8, 8, 7, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 6, 8, 6, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 6, 8, 8, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 7, 8, 6, structureBoundingBoxIn);
                this.func_175811_a(worldIn, iblockstate, 7, 8, 8, structureBoundingBoxIn);
            }
            if (UAConfig.StructuresOptions.biomeBasedStructuresOptions.chestGeneration) {
                this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 3, 3, 5, LootTableList.field_186426_h);
            }
            if (this.isLargeRoom) {
                this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 12, 9, 1, structureBoundingBoxIn);
                if (UAConfig.StructuresOptions.biomeBasedStructuresOptions.chestGeneration) {
                    this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 12, 8, 1, LootTableList.field_186426_h);
                }
            }
            return true;
        }
    }

    public static class LeftTurn
    extends Stronghold {
        public LeftTurn() {
        }

        public LeftTurn(int p_i45579_1_, Random p_i45579_2_, StructureBoundingBox p_i45579_3_, EnumFacing p_i45579_4_) {
            super(p_i45579_1_);
            this.func_186164_a(p_i45579_4_);
            this.entryDoor = this.getRandomDoor(p_i45579_2_);
            this.field_74887_e = p_i45579_3_;
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != EnumFacing.NORTH && enumfacing != EnumFacing.EAST) {
                this.getNextComponentZ((Stairs2)componentIn, listIn, rand, 1, 1);
            } else {
                this.getNextComponentX((Stairs2)componentIn, listIn, rand, 1, 1);
            }
        }

        public static LeftTurn createPiece(List<StructureComponent> p_175867_0_, Random p_175867_1_, int p_175867_2_, int p_175867_3_, int p_175867_4_, EnumFacing p_175867_5_, int p_175867_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175867_2_, (int)p_175867_3_, (int)p_175867_4_, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)5, (EnumFacing)p_175867_5_);
            return LeftTurn.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175867_0_, (StructureBoundingBox)structureboundingbox) == null ? new LeftTurn(p_175867_6_, p_175867_1_, structureboundingbox, p_175867_5_) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.func_74860_a(worldIn, structureBoundingBoxIn)) {
                return false;
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 4, 4, 4, false, randomIn, STRONGHOLD_STONES);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing != EnumFacing.NORTH && enumfacing != EnumFacing.EAST) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 1, 1, 4, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            } else {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            return true;
        }
    }

    public static class Crossing
    extends Stronghold {
        private boolean leftLow;
        private boolean leftHigh;
        private boolean rightLow;
        private boolean rightHigh;

        public Crossing() {
        }

        public Crossing(int p_i45580_1_, Random p_i45580_2_, StructureBoundingBox p_i45580_3_, EnumFacing p_i45580_4_) {
            super(p_i45580_1_);
            this.func_186164_a(p_i45580_4_);
            this.entryDoor = this.getRandomDoor(p_i45580_2_);
            this.field_74887_e = p_i45580_3_;
            this.leftLow = p_i45580_2_.nextBoolean();
            this.leftHigh = p_i45580_2_.nextBoolean();
            this.rightLow = p_i45580_2_.nextBoolean();
            this.rightHigh = p_i45580_2_.nextInt(3) > 0;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("leftLow", this.leftLow);
            tagCompound.func_74757_a("leftHigh", this.leftHigh);
            tagCompound.func_74757_a("rightLow", this.rightLow);
            tagCompound.func_74757_a("rightHigh", this.rightHigh);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.leftLow = tagCompound.func_74767_n("leftLow");
            this.leftHigh = tagCompound.func_74767_n("leftHigh");
            this.rightLow = tagCompound.func_74767_n("rightLow");
            this.rightHigh = tagCompound.func_74767_n("rightHigh");
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            int i = 3;
            int j = 5;
            EnumFacing enumfacing = this.func_186165_e();
            if (enumfacing == EnumFacing.WEST || enumfacing == EnumFacing.NORTH) {
                i = 8 - i;
                j = 8 - j;
            }
            this.getNextComponentNormal((Stairs2)componentIn, listIn, rand, 5, 1);
            if (this.leftLow) {
                this.getNextComponentX((Stairs2)componentIn, listIn, rand, i, 1);
            }
            if (this.leftHigh) {
                this.getNextComponentX((Stairs2)componentIn, listIn, rand, j, 7);
            }
            if (this.rightLow) {
                this.getNextComponentZ((Stairs2)componentIn, listIn, rand, i, 1);
            }
            if (this.rightHigh) {
                this.getNextComponentZ((Stairs2)componentIn, listIn, rand, j, 7);
            }
        }

        public static Crossing createPiece(List<StructureComponent> p_175866_0_, Random p_175866_1_, int p_175866_2_, int p_175866_3_, int p_175866_4_, EnumFacing p_175866_5_, int p_175866_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175866_2_, (int)p_175866_3_, (int)p_175866_4_, (int)-4, (int)-3, (int)0, (int)10, (int)9, (int)11, (EnumFacing)p_175866_5_);
            return Crossing.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175866_0_, (StructureBoundingBox)structureboundingbox) == null ? new Crossing(p_175866_6_, p_175866_1_, structureboundingbox, p_175866_5_) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.func_74860_a(worldIn, structureBoundingBoxIn)) {
                return false;
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 9, 8, 10, false, randomIn, STRONGHOLD_STONES);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, this.entryDoor, 4, 3, 0);
            if (this.leftLow) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 3, 1, 0, 5, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            if (this.rightLow) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 3, 1, 9, 5, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            if (this.leftHigh) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 7, 0, 7, 9, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            if (this.rightHigh) {
                this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 5, 7, 9, 7, 9, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 1, 10, 7, 3, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 1, 2, 1, 8, 2, 6, false, randomIn, STRONGHOLD_STONES);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 4, 1, 5, 4, 4, 9, false, randomIn, STRONGHOLD_STONES);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 8, 1, 5, 8, 4, 9, false, randomIn, STRONGHOLD_STONES);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 1, 4, 7, 3, 4, 9, false, randomIn, STRONGHOLD_STONES);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 1, 3, 5, 3, 3, 6, false, randomIn, STRONGHOLD_STONES);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 3, 4, 3, 3, 4, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 6, 3, 4, 6, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_74882_a(worldIn, structureBoundingBoxIn, 5, 1, 7, 7, 1, 8, false, randomIn, STRONGHOLD_STONES);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 1, 9, 7, 1, 9, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 2, 7, 7, 2, 7, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 5, 7, 4, 5, 9, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 5, 7, 8, 5, 9, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 5, 5, 7, 7, 5, 9, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH), 6, 5, 6, structureBoundingBoxIn);
            return true;
        }
    }

    public static class Corridor
    extends Stronghold {
        private int steps;

        public Corridor() {
        }

        public Corridor(int p_i45581_1_, Random p_i45581_2_, StructureBoundingBox p_i45581_3_, EnumFacing p_i45581_4_) {
            super(p_i45581_1_);
            this.func_186164_a(p_i45581_4_);
            this.field_74887_e = p_i45581_3_;
            this.steps = p_i45581_4_ != EnumFacing.NORTH && p_i45581_4_ != EnumFacing.SOUTH ? p_i45581_3_.func_78883_b() : p_i45581_3_.func_78880_d();
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("Steps", this.steps);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.steps = tagCompound.func_74762_e("Steps");
        }

        public static StructureBoundingBox findPieceBox(List<StructureComponent> p_175869_0_, Random p_175869_1_, int p_175869_2_, int p_175869_3_, int p_175869_4_, EnumFacing p_175869_5_) {
            int i = 3;
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175869_2_, (int)p_175869_3_, (int)p_175869_4_, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)4, (EnumFacing)p_175869_5_);
            StructureComponent structurecomponent = StructureComponent.func_74883_a(p_175869_0_, (StructureBoundingBox)structureboundingbox);
            if (structurecomponent == null) {
                return null;
            }
            if (structurecomponent.func_74874_b().field_78895_b == structureboundingbox.field_78895_b) {
                for (int j = 3; j >= 1; --j) {
                    structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175869_2_, (int)p_175869_3_, (int)p_175869_4_, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)(j - 1), (EnumFacing)p_175869_5_);
                    if (structurecomponent.func_74874_b().func_78884_a(structureboundingbox)) continue;
                    return StructureBoundingBox.func_175897_a((int)p_175869_2_, (int)p_175869_3_, (int)p_175869_4_, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)j, (EnumFacing)p_175869_5_);
                }
            }
            return null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.func_74860_a(worldIn, structureBoundingBoxIn)) {
                return false;
            }
            for (int i = 0; i < this.steps; ++i) {
                this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 0, 0, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 1, 0, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 2, 0, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 3, 0, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 4, 0, i, structureBoundingBoxIn);
                for (int j = 1; j <= 3; ++j) {
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 0, j, i, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, j, i, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 2, j, i, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 3, j, i, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 4, j, i, structureBoundingBoxIn);
                }
                this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 0, 4, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 1, 4, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 2, 4, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 3, 4, i, structureBoundingBoxIn);
                this.func_175811_a(worldIn, Blocks.field_150417_aV.func_176223_P(), 4, 4, i, structureBoundingBoxIn);
            }
            return true;
        }
    }

    public static class ChestCorridor
    extends Stronghold {
        private boolean hasMadeChest;

        public ChestCorridor() {
        }

        public ChestCorridor(int p_i45582_1_, Random p_i45582_2_, StructureBoundingBox p_i45582_3_, EnumFacing p_i45582_4_) {
            super(p_i45582_1_);
            this.func_186164_a(p_i45582_4_);
            this.entryDoor = this.getRandomDoor(p_i45582_2_);
            this.field_74887_e = p_i45582_3_;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a("Chest", this.hasMadeChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.hasMadeChest = tagCompound.func_74767_n("Chest");
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            this.getNextComponentNormal((Stairs2)componentIn, listIn, rand, 1, 1);
        }

        public static ChestCorridor createPiece(List<StructureComponent> p_175868_0_, Random p_175868_1_, int p_175868_2_, int p_175868_3_, int p_175868_4_, EnumFacing p_175868_5_, int p_175868_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175868_2_, (int)p_175868_3_, (int)p_175868_4_, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)7, (EnumFacing)p_175868_5_);
            return ChestCorridor.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(p_175868_0_, (StructureBoundingBox)structureboundingbox) == null ? new ChestCorridor(p_175868_6_, p_175868_1_, structureboundingbox, p_175868_5_) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.func_74860_a(worldIn, structureBoundingBoxIn)) {
                return false;
            }
            this.func_74882_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 4, 4, 6, false, randomIn, STRONGHOLD_STONES);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, this.entryDoor, 1, 1, 0);
            this.placeDoor(worldIn, randomIn, structureBoundingBoxIn, Stronghold.Door.OPENING, 1, 1, 6);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 1, 2, 3, 1, 4, Blocks.field_150417_aV.func_176223_P(), Blocks.field_150417_aV.func_176223_P(), false);
            this.func_175811_a(worldIn, Blocks.field_150333_U.func_176203_a(BlockStoneSlab.EnumType.SMOOTHBRICK.func_176624_a()), 3, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150333_U.func_176203_a(BlockStoneSlab.EnumType.SMOOTHBRICK.func_176624_a()), 3, 1, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150333_U.func_176203_a(BlockStoneSlab.EnumType.SMOOTHBRICK.func_176624_a()), 3, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150333_U.func_176203_a(BlockStoneSlab.EnumType.SMOOTHBRICK.func_176624_a()), 3, 2, 4, structureBoundingBoxIn);
            for (int i = 2; i <= 4; ++i) {
                this.func_175811_a(worldIn, Blocks.field_150333_U.func_176203_a(BlockStoneSlab.EnumType.SMOOTHBRICK.func_176624_a()), 2, 1, i, structureBoundingBoxIn);
            }
            if (!this.hasMadeChest && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(3, 3), this.func_74862_a(2), this.func_74873_b(3, 3)))) {
                this.hasMadeChest = true;
                if (UAConfig.StructuresOptions.biomeBasedStructuresOptions.chestGeneration) {
                    this.func_186167_a(worldIn, structureBoundingBoxIn, randomIn, 3, 2, 3, LootTableList.field_186428_j);
                }
            }
            return true;
        }
    }
}

