/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.biome;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.ultraamplified.world.biomes.BadlandsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BadlandsPlateauBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BambooJungleBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BambooJungleHillsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.BirchForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ColdOceanBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DarkForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DarkForestHillsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DeepColdOceanBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DeepFrozenOceanBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DeepLukewarmOceanBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DeepOceanBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DeepWarmOceanBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DesertBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DesertHillsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.DesertLakesBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.EndBarrenFieldBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.EndHighlandsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ErodedBadlandsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.FlowerForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.FrozenOceanBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GiantSpruceTaigaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GiantSpruceTaigaHillsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GiantTreeTaigaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GiantTreeTaigaHillsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.GravellyMountainsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.IceMountainsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.IceSpikesBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.JungleBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.JungleEdgeBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.JungleHillsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.LukewarmOceanBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ModifiedBadlandsPlateauBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ModifiedGravellyMountainsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ModifiedJungleBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ModifiedJungleEdgeBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ModifiedWoodedBadlandsPlateauBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.MountainsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.MushroomFieldsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.NetherBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.OceanBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.PlainsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SavannaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SavannaPlateauBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ShatteredSavannaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.ShatteredSavannaPlateauBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SnowyBeachBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SnowyTaigaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SnowyTaigaHillsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SnowyTaigaMountainsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SnowyTundraBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.StoneShoreBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SunflowerPlainsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SwampBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.SwampHillsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TaigaBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TaigaHillsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TaigaMountainsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TallBirchForestBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.TallBirchForestHillsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.WarmOceanBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.WoodedBadlandsPlateauBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.WoodedHillsBiomeUA;
import net.telepathicgrunt.ultraamplified.world.biomes.WoodedMountainsBiomeUA;

public class BiomeInit {
    private static ForgeRegistry<Biome> BiomeRegistry = (ForgeRegistry)ForgeRegistries.BIOMES;
    private static Biome[] biomes;
    public static Biome PLAINS;
    public static Biome DESERT;
    public static Biome FOREST;
    public static Biome TAIGA;
    public static Biome MOUNTAINS;
    public static Biome SWAMP;
    public static Biome NETHER;
    public static Biome END;
    public static Biome SNOWY_TUNDRA;
    public static Biome ICE_MOUNTAIN;
    public static Biome MUSHROOM_FIELDS;
    public static Biome DESERT_HILLS;
    public static Biome WOODED_HILLS;
    public static Biome TAIGA_HILLS;
    public static Biome BAMBOO_JUNGLE;
    public static Biome BAMBOO_JUNGLE_HILLS;
    public static Biome JUNGLE;
    public static Biome JUNGLE_HILLS;
    public static Biome JUNGLE_EDGE;
    public static Biome STONE_SHORE;
    public static Biome SNOWY_BEACH;
    public static Biome BIRCH_FOREST;
    public static Biome BIRCH_FOREST_HILLS;
    public static Biome DARK_FOREST;
    public static Biome SNOWY_TAIGA;
    public static Biome SNOWY_TAIGA_HILLS;
    public static Biome GIANT_TREE_TAIGA;
    public static Biome GIANT_TREE_TAIGA_HILLS;
    public static Biome WOODED_MOUNTAINS;
    public static Biome SAVANNA;
    public static Biome SAVANNA_PLATEAU;
    public static Biome BADLANDS;
    public static Biome WOODED_BADLANDS_PLATEAU;
    public static Biome BADLANDS_PLATEAU;
    public static Biome SUNFLOWER_PLAINS;
    public static Biome DESERT_LAKES;
    public static Biome GRAVELLY_MOUNTAINS;
    public static Biome FLOWER_FOREST;
    public static Biome TAIGA_MOUNTAINS;
    public static Biome SWAMP_HILLS;
    public static Biome ICE_SPIKES;
    public static Biome MODIFIED_JUNGLE;
    public static Biome MODIFIED_JUNGLE_EDGE;
    public static Biome TALL_BIRCH_FOREST;
    public static Biome TALL_BIRCH_FOREST_HILLS;
    public static Biome DARK_FOREST_HILLS;
    public static Biome SNOWY_TAIGA_MOUNTAINS;
    public static Biome GIANT_SPRUCE_TAIGA;
    public static Biome GIANT_SPRUCE_TAIGA_HILLS;
    public static Biome MODIFIED_GRAVELLY_MOUNTAINS;
    public static Biome SHATTERED_SAVANNA;
    public static Biome SHATTERED_SAVANNA_PLATEAU;
    public static Biome ERODED_BADLANDS;
    public static Biome MODIFIED_WOODED_BADLANDS_PLATEAU;
    public static Biome MODIFIED_BADLANDS_PLATEAU;
    public static Biome COLD_OCEAN;
    public static Biome DEEP_COLD_OCEAN;
    public static Biome DEEP_FROZEN_OCEAN;
    public static Biome DEEP_LUKEWARM_OCEAN;
    public static Biome DEEP_OCEAN;
    public static Biome DEEP_WARM_OCEAN;
    public static Biome FROZEN_OCEAN;
    public static Biome LUKEWARM_OCEAN;
    public static Biome OCEAN;
    public static Biome WARM_OCEAN;
    public static Biome BARREN_END_FIELD;
    private static RegistryEvent.Register<Biome> eventIn;
    public static final Map<Biome, Biome> BASE_TO_MUTATION_MAP;
    public static final Map<Integer, Integer> BASE_TO_HILLS_MAP;

    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        eventIn = event;
        BiomeInit.initBiome(PLAINS, "Plains", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.PLAINS);
        BiomeInit.initBiome(DESERT, "Desert", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY);
        BiomeInit.initBiome(FOREST, "Forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST);
        BiomeInit.initBiome(TAIGA, "Taiga", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        BiomeInit.initBiome(MOUNTAINS, "Mountains", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS);
        BiomeInit.initBiome(SWAMP, "Swamp", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        BiomeInit.initBiome(NETHER, "Nether", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        BiomeInit.initBiome(END, "The End", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.END, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY);
        BiomeInit.initBiome(SNOWY_TUNDRA, "Snowy Tundra", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SNOWY);
        BiomeInit.initBiome(ICE_MOUNTAIN, "Ice Mountain", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY);
        BiomeInit.initBiome(MUSHROOM_FIELDS, "Mushroom Field", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(DESERT_HILLS, "Desert Hills", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HILLS);
        BiomeInit.initBiome(WOODED_HILLS, "Wooden Hills", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.HILLS);
        BiomeInit.initBiome(TAIGA_HILLS, "Taiga Hills", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.CONIFEROUS);
        BiomeInit.initBiome(BAMBOO_JUNGLE, "Bamboo Jungle", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE);
        BiomeInit.initBiome(BAMBOO_JUNGLE_HILLS, "Bamboo Jungle Hills", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE);
        BiomeInit.initBiome(JUNGLE, "Jungle", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE);
        BiomeInit.initBiome(JUNGLE_HILLS, "Jungle Hills", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HILLS);
        BiomeInit.initBiome(JUNGLE_EDGE, "Jungle Edge", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(STONE_SHORE, "Stone Shore", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.BEACH);
        BiomeInit.initBiome(SNOWY_BEACH, "Snowy Beach", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD);
        BiomeInit.initBiome(BIRCH_FOREST, "Birch Forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST);
        BiomeInit.initBiome(BIRCH_FOREST_HILLS, "Birch Forest Hills", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        BiomeInit.initBiome(DARK_FOREST, "Dark Forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY);
        BiomeInit.initBiome(SNOWY_TAIGA, "Snowy Taiga", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD);
        BiomeInit.initBiome(SNOWY_TAIGA_HILLS, "Snowy Taiga Hills", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.HILLS);
        BiomeInit.initBiome(GIANT_TREE_TAIGA, "Giant Tree Taiga", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        BiomeInit.initBiome(GIANT_TREE_TAIGA_HILLS, "Giant Tree Taiga Hills", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        BiomeInit.initBiome(WOODED_MOUNTAINS, "Wooden Mountains", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPARSE);
        BiomeInit.initBiome(SAVANNA, "Savanna", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE);
        BiomeInit.initBiome(SAVANNA_PLATEAU, "Savanna Plateau", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(BADLANDS, "Badlands", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SANDY);
        BiomeInit.initBiome(WOODED_BADLANDS_PLATEAU, "Wooded Badlands Plateau", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SPARSE);
        BiomeInit.initBiome(BADLANDS_PLATEAU, "Badlands Plateau", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SANDY);
        BiomeInit.initBiome(SUNFLOWER_PLAINS, "Sunflower Plains", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(DESERT_LAKES, "Desert Lakes", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(GRAVELLY_MOUNTAINS, "Gravelly Mountains", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(FLOWER_FOREST, "Flower Forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(TAIGA_MOUNTAINS, "Taiga Mountains", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(SWAMP_HILLS, "Swampland Hills", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(ICE_SPIKES, "Ice Spikes", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(MODIFIED_JUNGLE, "Modified Jungle", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE, BiomeDictionary.Type.DENSE);
        BiomeInit.initBiome(MODIFIED_JUNGLE_EDGE, "Modified Jungle Edge", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(TALL_BIRCH_FOREST, "Tall Birch Forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(TALL_BIRCH_FOREST_HILLS, "Tall Birch Forest Hills", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(DARK_FOREST_HILLS, "Dark Forest Hills", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(SNOWY_TAIGA_MOUNTAINS, "Snowy Taiga Mountains", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(GIANT_SPRUCE_TAIGA, "Giant Spruce Taiga", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(GIANT_SPRUCE_TAIGA_HILLS, "Giant Spruce Taiga Hills", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(MODIFIED_GRAVELLY_MOUNTAINS, "Modified Gravelly Mountains", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(SHATTERED_SAVANNA, "Shattered Savanna", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(SHATTERED_SAVANNA_PLATEAU, "Shattered Savanna Plateau", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(ERODED_BADLANDS, "Eroded Badlands", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MESA, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(MODIFIED_WOODED_BADLANDS_PLATEAU, "Modified Wooded Badlands Plateau", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MESA, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(MODIFIED_BADLANDS_PLATEAU, "Modified Badlands Plateau", BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MESA, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        BiomeInit.initBiome(COLD_OCEAN, "Cold Ocean", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OCEAN);
        BiomeInit.initBiome(DEEP_COLD_OCEAN, "Deep Cold Ocean", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.COLD);
        BiomeInit.initBiome(DEEP_FROZEN_OCEAN, "Deep Frozen Ocean", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.COLD);
        BiomeInit.initBiome(DEEP_LUKEWARM_OCEAN, "Deep Lukewarm Ocean", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OCEAN);
        BiomeInit.initBiome(DEEP_OCEAN, "Deep Ocean", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OCEAN);
        BiomeInit.initBiome(DEEP_WARM_OCEAN, "Deep Warm Ocean", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.HOT);
        BiomeInit.initBiome(FROZEN_OCEAN, "Frozen Ocean", BiomeManager.BiomeType.ICY, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.COLD);
        BiomeInit.initBiome(LUKEWARM_OCEAN, "Lukewarm Ocean", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OCEAN);
        BiomeInit.initBiome(OCEAN, "Ocean", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OCEAN);
        BiomeInit.initBiome(WARM_OCEAN, "Warm Ocean", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.HOT);
        BiomeInit.initBiome(BARREN_END_FIELD, "Barren End Field", BiomeManager.BiomeType.COOL, BiomeDictionary.Type.END, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY);
        BiomeInit.mapMBiomes();
        BiomeInit.mapHillsBiomes();
        biomes = new Biome[]{PLAINS, DESERT, MOUNTAINS, FOREST, TAIGA, SWAMP, NETHER, END, SNOWY_TUNDRA, ICE_MOUNTAIN, MUSHROOM_FIELDS, DESERT_HILLS, WOODED_HILLS, TAIGA_HILLS, BAMBOO_JUNGLE, BAMBOO_JUNGLE_HILLS, JUNGLE, JUNGLE_HILLS, JUNGLE_EDGE, STONE_SHORE, SNOWY_BEACH, BIRCH_FOREST, BIRCH_FOREST_HILLS, DARK_FOREST, SNOWY_TAIGA, SNOWY_TAIGA_HILLS, GIANT_TREE_TAIGA, GIANT_TREE_TAIGA_HILLS, WOODED_MOUNTAINS, SAVANNA, SAVANNA_PLATEAU, BADLANDS, WOODED_BADLANDS_PLATEAU, BADLANDS_PLATEAU, SUNFLOWER_PLAINS, DESERT_LAKES, GRAVELLY_MOUNTAINS, FLOWER_FOREST, TAIGA_MOUNTAINS, SWAMP_HILLS, ICE_SPIKES, MODIFIED_JUNGLE, MODIFIED_JUNGLE_EDGE, TALL_BIRCH_FOREST, TALL_BIRCH_FOREST_HILLS, DARK_FOREST_HILLS, SNOWY_TAIGA_MOUNTAINS, GIANT_SPRUCE_TAIGA, GIANT_SPRUCE_TAIGA_HILLS, MODIFIED_GRAVELLY_MOUNTAINS, SHATTERED_SAVANNA, SHATTERED_SAVANNA_PLATEAU, ERODED_BADLANDS, MODIFIED_WOODED_BADLANDS_PLATEAU, MODIFIED_BADLANDS_PLATEAU, FROZEN_OCEAN, COLD_OCEAN, OCEAN, LUKEWARM_OCEAN, WARM_OCEAN, DEEP_FROZEN_OCEAN, DEEP_COLD_OCEAN, DEEP_OCEAN, DEEP_LUKEWARM_OCEAN, DEEP_WARM_OCEAN, BARREN_END_FIELD};
    }

    private static Biome initBiome(Biome biome, String name, BiomeManager.BiomeType biomeType, BiomeDictionary.Type ... types) {
        biome.setRegistryName(name.toLowerCase().replace(' ', '_'));
        eventIn.getRegistry().register((IForgeRegistryEntry)biome);
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        return biome;
    }

    public static Biome[] getBiomeArray() {
        return biomes;
    }

    private static void mapMBiomes() {
        BASE_TO_MUTATION_MAP.put(PLAINS, SUNFLOWER_PLAINS);
        BASE_TO_MUTATION_MAP.put(DESERT, DESERT_LAKES);
        BASE_TO_MUTATION_MAP.put(BIRCH_FOREST, TALL_BIRCH_FOREST);
        BASE_TO_MUTATION_MAP.put(BIRCH_FOREST_HILLS, TALL_BIRCH_FOREST_HILLS);
        BASE_TO_MUTATION_MAP.put(SNOWY_TAIGA, SNOWY_TAIGA_MOUNTAINS);
        BASE_TO_MUTATION_MAP.put(MOUNTAINS, GRAVELLY_MOUNTAINS);
        BASE_TO_MUTATION_MAP.put(WOODED_MOUNTAINS, MODIFIED_GRAVELLY_MOUNTAINS);
        BASE_TO_MUTATION_MAP.put(FOREST, FLOWER_FOREST);
        BASE_TO_MUTATION_MAP.put(SNOWY_TUNDRA, ICE_SPIKES);
        BASE_TO_MUTATION_MAP.put(JUNGLE, MODIFIED_JUNGLE);
        BASE_TO_MUTATION_MAP.put(JUNGLE_EDGE, MODIFIED_JUNGLE_EDGE);
        BASE_TO_MUTATION_MAP.put(BADLANDS, ERODED_BADLANDS);
        BASE_TO_MUTATION_MAP.put(BADLANDS_PLATEAU, MODIFIED_BADLANDS_PLATEAU);
        BASE_TO_MUTATION_MAP.put(WOODED_BADLANDS_PLATEAU, MODIFIED_WOODED_BADLANDS_PLATEAU);
        BASE_TO_MUTATION_MAP.put(GIANT_TREE_TAIGA, GIANT_SPRUCE_TAIGA);
        BASE_TO_MUTATION_MAP.put(GIANT_TREE_TAIGA_HILLS, GIANT_SPRUCE_TAIGA_HILLS);
        BASE_TO_MUTATION_MAP.put(DARK_FOREST, DARK_FOREST_HILLS);
        BASE_TO_MUTATION_MAP.put(SAVANNA, SHATTERED_SAVANNA);
        BASE_TO_MUTATION_MAP.put(SAVANNA_PLATEAU, SHATTERED_SAVANNA_PLATEAU);
        BASE_TO_MUTATION_MAP.put(SWAMP, SWAMP_HILLS);
        BASE_TO_MUTATION_MAP.put(TAIGA, TAIGA_MOUNTAINS);
    }

    private static void mapHillsBiomes() {
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)DESERT), BiomeRegistry.getID((IForgeRegistryEntry)DESERT_HILLS));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)FOREST), BiomeRegistry.getID((IForgeRegistryEntry)WOODED_HILLS));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)TAIGA), BiomeRegistry.getID((IForgeRegistryEntry)TAIGA_HILLS));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)BAMBOO_JUNGLE), BiomeRegistry.getID((IForgeRegistryEntry)BAMBOO_JUNGLE_HILLS));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)JUNGLE), BiomeRegistry.getID((IForgeRegistryEntry)JUNGLE_HILLS));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)BIRCH_FOREST), BiomeRegistry.getID((IForgeRegistryEntry)BIRCH_FOREST_HILLS));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)SNOWY_TAIGA), BiomeRegistry.getID((IForgeRegistryEntry)SNOWY_TAIGA_HILLS));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)GIANT_TREE_TAIGA), BiomeRegistry.getID((IForgeRegistryEntry)GIANT_TREE_TAIGA_HILLS));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)MOUNTAINS), BiomeRegistry.getID((IForgeRegistryEntry)WOODED_MOUNTAINS));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)SAVANNA), BiomeRegistry.getID((IForgeRegistryEntry)SAVANNA_PLATEAU));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_OCEAN));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)COLD_OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_COLD_OCEAN));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)FROZEN_OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_FROZEN_OCEAN));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)LUKEWARM_OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_LUKEWARM_OCEAN));
        BASE_TO_HILLS_MAP.put(BiomeRegistry.getID((IForgeRegistryEntry)WARM_OCEAN), BiomeRegistry.getID((IForgeRegistryEntry)DEEP_WARM_OCEAN));
    }

    static {
        PLAINS = new PlainsBiomeUA();
        DESERT = new DesertBiomeUA();
        FOREST = new ForestBiomeUA();
        TAIGA = new TaigaBiomeUA();
        MOUNTAINS = new MountainsBiomeUA();
        SWAMP = new SwampBiomeUA();
        NETHER = new NetherBiomeUA();
        END = new EndHighlandsBiomeUA();
        SNOWY_TUNDRA = new SnowyTundraBiomeUA();
        ICE_MOUNTAIN = new IceMountainsBiomeUA();
        MUSHROOM_FIELDS = new MushroomFieldsBiomeUA();
        DESERT_HILLS = new DesertHillsBiomeUA();
        WOODED_HILLS = new WoodedHillsBiomeUA();
        TAIGA_HILLS = new TaigaHillsBiomeUA();
        BAMBOO_JUNGLE = new BambooJungleBiomeUA();
        BAMBOO_JUNGLE_HILLS = new BambooJungleHillsBiomeUA();
        JUNGLE = new JungleBiomeUA();
        JUNGLE_HILLS = new JungleHillsBiomeUA();
        JUNGLE_EDGE = new JungleEdgeBiomeUA();
        STONE_SHORE = new StoneShoreBiomeUA();
        SNOWY_BEACH = new SnowyBeachBiomeUA();
        BIRCH_FOREST = new BirchForestBiomeUA();
        BIRCH_FOREST_HILLS = new BirchForestBiomeUA();
        DARK_FOREST = new DarkForestBiomeUA();
        SNOWY_TAIGA = new SnowyTaigaBiomeUA();
        SNOWY_TAIGA_HILLS = new SnowyTaigaHillsBiomeUA();
        GIANT_TREE_TAIGA = new GiantTreeTaigaBiomeUA();
        GIANT_TREE_TAIGA_HILLS = new GiantTreeTaigaHillsBiomeUA();
        WOODED_MOUNTAINS = new WoodedMountainsBiomeUA();
        SAVANNA = new SavannaBiomeUA();
        SAVANNA_PLATEAU = new SavannaPlateauBiomeUA();
        BADLANDS = new BadlandsBiomeUA();
        WOODED_BADLANDS_PLATEAU = new WoodedBadlandsPlateauBiomeUA();
        BADLANDS_PLATEAU = new BadlandsPlateauBiomeUA();
        SUNFLOWER_PLAINS = new SunflowerPlainsBiomeUA();
        DESERT_LAKES = new DesertLakesBiomeUA();
        GRAVELLY_MOUNTAINS = new GravellyMountainsBiomeUA();
        FLOWER_FOREST = new FlowerForestBiomeUA();
        TAIGA_MOUNTAINS = new TaigaMountainsBiomeUA();
        SWAMP_HILLS = new SwampHillsBiomeUA();
        ICE_SPIKES = new IceSpikesBiomeUA();
        MODIFIED_JUNGLE = new ModifiedJungleBiomeUA();
        MODIFIED_JUNGLE_EDGE = new ModifiedJungleEdgeBiomeUA();
        TALL_BIRCH_FOREST = new TallBirchForestBiomeUA();
        TALL_BIRCH_FOREST_HILLS = new TallBirchForestHillsBiomeUA();
        DARK_FOREST_HILLS = new DarkForestHillsBiomeUA();
        SNOWY_TAIGA_MOUNTAINS = new SnowyTaigaMountainsBiomeUA();
        GIANT_SPRUCE_TAIGA = new GiantSpruceTaigaBiomeUA();
        GIANT_SPRUCE_TAIGA_HILLS = new GiantSpruceTaigaHillsBiomeUA();
        MODIFIED_GRAVELLY_MOUNTAINS = new ModifiedGravellyMountainsBiomeUA();
        SHATTERED_SAVANNA = new ShatteredSavannaBiomeUA();
        SHATTERED_SAVANNA_PLATEAU = new ShatteredSavannaPlateauBiomeUA();
        ERODED_BADLANDS = new ErodedBadlandsBiomeUA();
        MODIFIED_WOODED_BADLANDS_PLATEAU = new ModifiedWoodedBadlandsPlateauBiomeUA();
        MODIFIED_BADLANDS_PLATEAU = new ModifiedBadlandsPlateauBiomeUA();
        COLD_OCEAN = new ColdOceanBiomeUA();
        DEEP_COLD_OCEAN = new DeepColdOceanBiomeUA();
        DEEP_FROZEN_OCEAN = new DeepFrozenOceanBiomeUA();
        DEEP_LUKEWARM_OCEAN = new DeepLukewarmOceanBiomeUA();
        DEEP_OCEAN = new DeepOceanBiomeUA();
        DEEP_WARM_OCEAN = new DeepWarmOceanBiomeUA();
        FROZEN_OCEAN = new FrozenOceanBiomeUA();
        LUKEWARM_OCEAN = new LukewarmOceanBiomeUA();
        OCEAN = new OceanBiomeUA();
        WARM_OCEAN = new WarmOceanBiomeUA();
        BARREN_END_FIELD = new EndBarrenFieldBiomeUA();
        eventIn = null;
        BASE_TO_MUTATION_MAP = new HashMap<Biome, Biome>();
        BASE_TO_HILLS_MAP = new HashMap<Integer, Integer>();
    }
}

