/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.HugeTreesFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class BirchMTree
extends HugeTreesFeature<NoFeatureConfig> {
    private static final BlockState TRUNK = Blocks.field_196619_M.func_176223_P();
    private static final BlockState LEAF = Blocks.field_196647_Y.func_176223_P();
    private static final int randExtraHeight = 50;

    public BirchMTree(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn, boolean doBlockNotifyOnPlace, boolean useBaseHeightIn) {
        super(configFactoryIn, doBlockNotifyOnPlace, 18, 50, TRUNK, LEAF);
        this.setSapling((IPlantable)Blocks.field_196676_v);
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int height = this.func_150533_a(rand);
        IWorld world = (IWorld)worldIn;
        if (!this.func_203427_a(worldIn, position, height + 8)) {
            return false;
        }
        this.createCrown(worldIn, position.func_177958_n(), position.func_177952_p(), position.func_177956_o() + height - 4, rand, boundingBox, changedBlocks);
        for (int currentHeight = 0; currentHeight < height; ++currentHeight) {
            BlockState iblockstate = world.func_180495_p(position.func_177981_b(currentHeight));
            if (iblockstate.func_185904_a() == Material.field_151579_a || iblockstate.func_185904_a() == Material.field_151584_j) {
                this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177981_b(currentHeight), TRUNK, boundingBox);
            }
            if (currentHeight >= height - 1) continue;
            iblockstate = world.func_180495_p(position.func_177982_a(1, currentHeight, 0));
            if (iblockstate.func_185904_a() == Material.field_151579_a || iblockstate.func_185904_a() == Material.field_151584_j) {
                this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(1, currentHeight, 0), TRUNK, boundingBox);
            }
            if ((iblockstate = world.func_180495_p(position.func_177982_a(1, currentHeight, 1))).func_185904_a() == Material.field_151579_a || iblockstate.func_185904_a() == Material.field_151584_j) {
                this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(1, currentHeight, 1), TRUNK, boundingBox);
            }
            if ((iblockstate = world.func_180495_p(position.func_177982_a(0, currentHeight, 1))).func_185904_a() != Material.field_151579_a && iblockstate.func_185904_a() != Material.field_151584_j) continue;
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(0, currentHeight, 1), TRUNK, boundingBox);
        }
        return true;
    }

    private void createCrown(IWorldGenerationReader worldIn, int x, int z, int y, Random rand, MutableBoundingBox p_214596_7_, Set<BlockPos> p_214596_8_) {
        int depthOfLeaves = this.field_76522_a - (rand.nextInt(5) + 10);
        int currentRadius = 0;
        for (int currentHeight = y - depthOfLeaves; currentHeight <= y + 5; ++currentHeight) {
            int heightDiff = y - currentHeight;
            int radius = MathHelper.func_76141_d((float)((float)heightDiff / (float)depthOfLeaves * 2.0f));
            this.func_222839_a(worldIn, new BlockPos(x, currentHeight, z), radius + (int)((heightDiff > 0 && radius == currentRadius && (currentHeight & 1) == 0 ? 0.5 : 1.0) * 3.7), p_214596_7_, p_214596_8_);
            currentRadius = radius;
        }
    }
}

