/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.placement;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.placement.Placement;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.config.ChanceAndTypeConfig;

public class AtCenterSurfaceMiniFeature
extends Placement<ChanceAndTypeConfig> {
    public AtCenterSurfaceMiniFeature(Function<Dynamic<?>, ? extends ChanceAndTypeConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public Stream<BlockPos> getPositions(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, ChanceAndTypeConfig placementConfig, BlockPos pos) {
        float chance;
        switch (placementConfig.type) {
            case SUNSHRINE: {
                chance = (int)((float)ConfigUA.sunShrineSpawnrate * placementConfig.chanceModifier);
                break;
            }
            case STONEHENGE: {
                chance = (int)((float)ConfigUA.stonehengeSpawnrate * placementConfig.chanceModifier);
                break;
            }
            default: {
                chance = 0.0f;
            }
        }
        if (random.nextFloat() < 1.0f / chance) {
            BlockPos blockpos = worldIn.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos.func_177982_a(8, 0, 8));
            return Stream.of(blockpos);
        }
        return Stream.empty();
    }
}

