/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.FeatureUA;
import net.telepathicgrunt.ultraamplified.world.feature.structure.FortressConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.structure.FortressPiecesUA;

public class FortressUA
extends Structure<FortressConfigUA> {
    private static final List<Biome.SpawnListEntry> NETHER_FORTRESS_ENEMIES = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_200792_f, 10, 2, 3), new Biome.SpawnListEntry(EntityType.field_200785_Y, 5, 4, 4), new Biome.SpawnListEntry(EntityType.field_200722_aA, 8, 5, 5), new Biome.SpawnListEntry(EntityType.field_200741_ag, 2, 5, 5), new Biome.SpawnListEntry(EntityType.field_200771_K, 3, 4, 4)});

    public FortressUA(Function<Dynamic<?>, ? extends FortressConfigUA> p_i51427_1_) {
        super(p_i51427_1_);
    }

    public boolean func_202372_a(ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ) {
        if (ConfigUA.netherFortressAboveground || ConfigUA.netherFortressUnderground) {
            int i = chunkPosX >> 4;
            int j = chunkPosZ >> 4;
            rand.setSeed((long)(i ^ j << 4) ^ chunkGen.func_202089_c());
            if (chunkPosX != (i << 4) + 4 + rand.nextInt(ConfigUA.netherFortressSpawnrate)) {
                return false;
            }
            if (chunkPosZ != (j << 4) + 4 + rand.nextInt(ConfigUA.netherFortressSpawnrate)) {
                return false;
            }
            Biome biome = chunkGen.func_202090_b().func_222364_a(new BlockPos((chunkPosX << 4) + 9, 0, (chunkPosZ << 4) + 9));
            return chunkGen.func_202094_a(biome, FeatureUA.FORTRESS_UA);
        }
        return false;
    }

    protected boolean isEnabledIn(IWorld worldIn) {
        return worldIn.func_72912_H().func_76089_r();
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return "ultra_amplified_mod:fortress";
    }

    public int func_202367_b() {
        return 8;
    }

    public List<Biome.SpawnListEntry> func_202279_e() {
        return NETHER_FORTRESS_ENEMIES;
    }

    public static class Start
    extends StructureStart {
        private boolean genAboveSeaLevel;

        public Start(Structure<?> p_i50437_1_, int p_i50437_2_, int p_i50437_3_, Biome p_i50437_4_, MutableBoundingBox p_i50437_5_, int p_i50437_6_, long p_i50437_7_) {
            super(p_i50437_1_, p_i50437_2_, p_i50437_3_, p_i50437_4_, p_i50437_5_, p_i50437_6_, p_i50437_7_);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            FortressConfigUA fortressconfig = (FortressConfigUA)generator.func_202087_b(biomeIn, FeatureUA.FORTRESS_UA);
            this.genAboveSeaLevel = fortressconfig.surfaceAllow;
            boolean stoneVariant = false;
            stoneVariant = !this.genAboveSeaLevel;
            FortressPiecesUA.Start fortresspieces$start = new FortressPiecesUA.Start((Random)this.field_214631_d, (chunkX << 4) + 2, (chunkZ << 4) + 2, stoneVariant);
            this.field_75075_a.add(fortresspieces$start);
            fortresspieces$start.func_74861_a(fortresspieces$start, this.field_75075_a, (Random)this.field_214631_d);
            List<StructurePiece> list = fortresspieces$start.pendingChildren;
            while (!list.isEmpty()) {
                int i = this.field_214631_d.nextInt(list.size());
                StructurePiece structurepiece = list.remove(i);
                structurepiece.func_74861_a((StructurePiece)fortresspieces$start, this.field_75075_a, (Random)this.field_214631_d);
            }
            this.func_202500_a();
            if (fortressconfig.surfaceAllow) {
                if (this.field_214631_d.nextBoolean()) {
                    this.func_214626_a((Random)this.field_214631_d, 85, 130);
                } else {
                    this.func_214626_a((Random)this.field_214631_d, 15, 30);
                }
            } else {
                this.func_214626_a((Random)this.field_214631_d, 15, 30);
            }
        }
    }
}

