/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.structure.IglooPiecesUA;

public class IglooUA
extends Structure<NoFeatureConfig> {
    public IglooUA(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51427_1_) {
        super(p_i51427_1_);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int maxDistance = ConfigUA.iglooSpawnrate;
        int minDistance = 8;
        if (maxDistance < 9) {
            minDistance = maxDistance - 1;
        }
        int k = x + maxDistance * spacingOffsetsX;
        int l = z + maxDistance * spacingOffsetsZ;
        int i1 = k < 0 ? k - maxDistance + 1 : k;
        int j1 = l < 0 ? l - maxDistance + 1 : l;
        int k1 = i1 / maxDistance;
        int l1 = j1 / maxDistance;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), k1, l1, this.getSeedModifier());
        k1 *= maxDistance;
        l1 *= maxDistance;
        return new ChunkPos(k1 += random.nextInt(maxDistance - minDistance), l1 += random.nextInt(maxDistance - minDistance));
    }

    protected boolean isEnabledIn(IWorld worldIn) {
        return worldIn.func_72912_H().func_76089_r();
    }

    public String func_143025_a() {
        return "ultra_amplified_mod:igloo";
    }

    public int func_202367_b() {
        return 3;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    protected int getSeedModifier() {
        return 14357618;
    }

    public boolean func_202372_a(ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ) {
        ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b) {
            Biome biome = chunkGen.func_202090_b().func_222364_a(new BlockPos(chunkPosX * 16 + 9, 0, chunkPosZ * 16 + 9));
            if (ConfigUA.iglooSpawnrate != 101 && chunkGen.func_202094_a(biome, (Structure)this)) {
                return true;
            }
        }
        return false;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> p_i50437_1_, int p_i50437_2_, int p_i50437_3_, Biome p_i50437_4_, MutableBoundingBox p_i50437_5_, int p_i50437_6_, long p_i50437_7_) {
            super(p_i50437_1_, p_i50437_2_, p_i50437_3_, p_i50437_4_, p_i50437_5_, p_i50437_6_, p_i50437_7_);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            int x = chunkX * 16;
            int z = chunkZ * 16;
            BlockPos blockpos = new BlockPos(x, 90, z);
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            IglooPiecesUA.start(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
        }
    }
}

