/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.FeatureUA;
import net.telepathicgrunt.ultraamplified.world.feature.structure.MineshaftConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.structure.MineshaftPiecesUA;

public class MineshaftUA
extends Structure<MineshaftConfigUA> {
    public MineshaftUA(Function<Dynamic<?>, ? extends MineshaftConfigUA> p_i51427_1_) {
        super(p_i51427_1_);
    }

    public boolean func_202372_a(ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ) {
        ((SharedSeedRandom)rand).func_202425_c(chunkGen.func_202089_c(), chunkPosX, chunkPosZ);
        Biome biome = chunkGen.func_202090_b().func_222364_a(new BlockPos((chunkPosX << 4) + 9, 0, (chunkPosZ << 4) + 9));
        if ((ConfigUA.mineshaftAbovegroundAllowed || ConfigUA.mineshaftUndergroundAllowed) && chunkGen.func_202094_a(biome, FeatureUA.MINESHAFT_UA)) {
            return rand.nextDouble() < (double)ConfigUA.mineshaftSpawnrate / 10000.0;
        }
        return false;
    }

    protected boolean isEnabledIn(IWorld worldIn) {
        return worldIn.func_72912_H().func_76089_r();
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return "ultra_amplified_mod:mineshaft";
    }

    public int func_202367_b() {
        return 8;
    }

    public static enum Type {
        NORMAL,
        MESA,
        ICEY,
        COLDORBIRCH,
        JUNGLE,
        TAIGA,
        DESERT,
        STONE,
        SAVANNA,
        SWAMPORDARKFOREST,
        END,
        HELL,
        OCEAN;


        public static Type byId(int id) {
            return id >= 0 && id < Type.values().length ? Type.values()[id] : NORMAL;
        }
    }

    public static class Start
    extends StructureStart {
        private Type type;

        public Start(Structure<?> p_i50437_1_, int p_i50437_2_, int p_i50437_3_, Biome p_i50437_4_, MutableBoundingBox p_i50437_5_, int p_i50437_6_, long p_i50437_7_) {
            super(p_i50437_1_, p_i50437_2_, p_i50437_3_, p_i50437_4_, p_i50437_5_, p_i50437_6_, p_i50437_7_);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            MineshaftConfigUA mineshaftconfig = (MineshaftConfigUA)generator.func_202087_b(biomeIn, FeatureUA.MINESHAFT_UA);
            this.type = mineshaftconfig.type;
            MineshaftPiecesUA.Room structuremineshaftpiecesua$room = new MineshaftPiecesUA.Room(0, (Random)this.field_214631_d, (chunkX << 4) + 2, (chunkZ << 4) + 2, this.type);
            this.field_75075_a.add(structuremineshaftpiecesua$room);
            structuremineshaftpiecesua$room.func_74861_a(structuremineshaftpiecesua$room, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
            if (structuremineshaftpiecesua$room.func_74874_b().field_78894_e < 100) {
                this.func_214626_a((Random)this.field_214631_d, 150, 151 + this.field_214631_d.nextInt(70));
            } else {
                this.func_214626_a((Random)this.field_214631_d, 10, 11);
            }
        }
    }
}

