/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.structure.StructureInitUA;

public class MushroomTemplePiecesUA {
    private static final ResourceLocation MUSHROOM_TEMPLE = new ResourceLocation("ultra_amplified_mod:mushroom_temple");
    private static final Map<ResourceLocation, BlockPos> OFFSET1 = ImmutableMap.of((Object)MUSHROOM_TEMPLE, (Object)new BlockPos(0, 4, 0));
    private static final Map<ResourceLocation, BlockPos> OFFSET2 = ImmutableMap.of((Object)MUSHROOM_TEMPLE, (Object)new BlockPos(-8, -1, -8));
    private static final ResourceLocation CHESTS_MUSHROOM_TEMPLE_UA = new ResourceLocation("ultra_amplified_mod:chests/mushroom_temple_ua");

    public static void start(TemplateManager templateManagerIn, BlockPos pos, Rotation rotationIn, List<StructurePiece> structurePieceList, Random randomIn) {
        structurePieceList.add((StructurePiece)new Piece(templateManagerIn, MUSHROOM_TEMPLE, pos, rotationIn, 0));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation resourceLocation;
        private Rotation rotation;

        public Piece(TemplateManager templateManager, ResourceLocation resourceLocation, BlockPos pos, Rotation rotation, int downDepth) {
            super(StructureInitUA.MTUA, 0);
            this.resourceLocation = resourceLocation;
            BlockPos blockpos = (BlockPos)OFFSET2.get(resourceLocation);
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o() - downDepth, blockpos.func_177952_p());
            this.rotation = rotation;
            this.setupPiece(templateManager);
        }

        public Piece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(StructureInitUA.MTUA, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.setupPiece(templateManagerIn);
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)OFFSET1.get(this.resourceLocation));
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chest".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                TileEntity tileentity = worldIn.func_175625_s(pos.func_177977_b());
                if (tileentity instanceof ChestTileEntity) {
                    if (ConfigUA.chestGeneration) {
                        ((ChestTileEntity)tileentity).func_189404_a(CHESTS_MUSHROOM_TEMPLE_UA, rand.nextLong());
                    } else {
                        worldIn.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            } else if ("lottery".equals(function)) {
                int lotteryNum = rand.nextInt(100);
                if (lotteryNum == 0) {
                    worldIn.func_180501_a(pos, Blocks.field_222400_eH.func_176223_P(), 2);
                    worldIn.func_180501_a(pos.func_177979_c(2), Blocks.field_203216_jz.func_176223_P(), 2);
                } else if (lotteryNum < 14) {
                    worldIn.func_180501_a(pos, Blocks.field_196756_ey.func_176223_P(), 2);
                    worldIn.func_180501_a(pos.func_177979_c(2), Blocks.field_150451_bX.func_176223_P(), 2);
                } else if (lotteryNum < 26) {
                    worldIn.func_180501_a(pos, Blocks.field_196728_ej.func_176223_P(), 2);
                    worldIn.func_180501_a(pos.func_177979_c(2), Blocks.field_150368_y.func_176223_P(), 2);
                } else if (lotteryNum < 38) {
                    worldIn.func_180501_a(pos, Blocks.field_222399_eG.func_176223_P(), 2);
                    worldIn.func_180501_a(pos.func_177979_c(2), Blocks.field_189880_di.func_176223_P(), 2);
                } else if (lotteryNum < 50) {
                    worldIn.func_180501_a(pos, Blocks.field_196744_er.func_176223_P(), 2);
                    worldIn.func_180501_a(pos.func_177979_c(2), Blocks.field_150407_cf.func_176223_P(), 2);
                } else {
                    worldIn.func_180501_a(pos, Blocks.field_196757_ez.func_176223_P(), 2);
                }
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            BlockPos blockpos;
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)OFFSET1.get(this.resourceLocation));
            BlockPos blockpos1 = this.field_186178_c.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(3 - (blockpos = (BlockPos)OFFSET2.get(this.resourceLocation)).func_177958_n(), 0, 0 - blockpos.func_177952_p())));
            int i = worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, blockpos1.func_177958_n(), blockpos1.func_177952_p());
            if (i > 246) {
                i = 246;
            }
            BlockPos blockpos2 = this.field_186178_c;
            this.field_186178_c = this.field_186178_c.func_177982_a(0, i - 90 - 2, 0);
            boolean flag = super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, chunkPos);
            this.field_186178_c = blockpos2;
            return flag;
        }
    }
}

