/*
 * Decompiled with CFR 0.152.
 */
package com.sixonethree.durabilityshow.handler;

import com.sixonethree.durabilityshow.client.gui.EnumCorner;
import com.sixonethree.durabilityshow.client.gui.GuiItemDurability;
import java.io.File;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration configuration;
    private static EnumChatFormatting tooltipColor;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("DurabilityShow")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        tooltipColor = EnumChatFormatting.func_175744_a((int)configuration.getInt("Durability Tooltip Color", "general", 7, 0, 15, "0 - Black\n1 - Dark Blue\n2 - Dark Green\n3 - Dark Aqua\n4 - Dark Red\n5 - Dark Purple\n6 - Gold\n7 - Gray\n8 - Dark Gray\n9 - Blue\n10 - Green\n11 - Aqua\n12 - Red\n13 - Light Purple\n14 - Yellow\n15 - White"));
        GuiItemDurability.setCorner(EnumCorner.values()[configuration.getInt("Position", "general", 0, 0, 3, "0 - Bottom Right\n1 - Bottom Left\n2 - Top Right\n3 - Top Left")]);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static EnumChatFormatting getTooltipColor() {
        return tooltipColor;
    }

    static {
        tooltipColor = EnumChatFormatting.GRAY;
    }
}

