/*
 * Decompiled with CFR 0.152.
 */
package com.sixonethree.durabilityshow.client.gui;

import com.sixonethree.durabilityshow.client.gui.EnumCorner;
import com.sixonethree.durabilityshow.client.gui.EnumGuiState;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class GuiItemDurability
extends Gui {
    private static Minecraft minecraftInstance;
    private static EnumGuiState guiState;
    private static EnumCorner corner;
    private static int offsetPosition;
    private static int closeSize;
    private static int color_white;
    private static FontRenderer fontRenderer;
    private static RenderItem itemRender;
    private static final int BOOTS = 1;
    private static final int LEGGINGS = 2;
    private static final int CHESTPLATE = 3;
    private static final int HELMET = 4;

    public static EnumGuiState getGuiState() {
        return guiState;
    }

    public static int getOffset() {
        return offsetPosition;
    }

    public static void setOffset(int Offset) {
        offsetPosition = Offset;
    }

    public static void setGuiState(EnumGuiState State) {
        guiState = State;
    }

    public static EnumCorner getCorner() {
        return corner;
    }

    public static void setCorner(EnumCorner newCorner) {
        corner = newCorner;
    }

    public static void lowerOffset() {
        --offsetPosition;
    }

    public static void raiseOffset() {
        ++offsetPosition;
    }

    public static void setCloseSize(int size) {
        closeSize = size;
    }

    public static int getCloseSize() {
        return closeSize;
    }

    public GuiItemDurability(Minecraft MC) {
        minecraftInstance = MC;
        fontRenderer = MC.field_71466_p;
        itemRender = MC.func_175599_af();
    }

    private int getArrowsInInventory() {
        int Arrows = 0;
        for (ItemStack stack : GuiItemDurability.minecraftInstance.field_71439_g.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != Items.field_151032_g) continue;
            Arrows += stack.field_77994_a;
        }
        return Arrows;
    }

    public boolean allNull(ItemStack ... stacks) {
        for (ItemStack s : stacks) {
            if (s == null) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRender(RenderGameOverlayEvent.Post event) {
        Entity spec;
        InventoryPlayer Inventory = GuiItemDurability.minecraftInstance.field_71439_g.field_71071_by;
        if (GuiItemDurability.minecraftInstance.field_71439_g.func_175149_v() && (spec = minecraftInstance.func_175606_aa()) != null && spec instanceof EntityPlayer) {
            EntityPlayer specing = (EntityPlayer)spec;
            Inventory = specing.field_71071_by;
        }
        ItemStack current = Inventory.func_70448_g();
        ItemStack boots = Inventory.field_70460_b[0];
        ItemStack leggings = Inventory.field_70460_b[1];
        ItemStack chestplate = Inventory.field_70460_b[2];
        ItemStack helmet = Inventory.field_70460_b[3];
        if (event.isCanceled() || this.allNull(current, boots, leggings, chestplate, helmet) || GuiItemDurability.minecraftInstance.field_71439_g.field_71075_bZ.field_75098_d || event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        ScaledResolution scaled = new ScaledResolution(minecraftInstance, GuiItemDurability.minecraftInstance.field_71443_c, GuiItemDurability.minecraftInstance.field_71440_d);
        int armorOffset = 16;
        int width = scaled.func_78326_a() + offsetPosition;
        int height = scaled.func_78328_b();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        RenderHelper.func_74520_c();
        boolean armorAllNull = this.allNull(boots, leggings, chestplate, helmet);
        int[] params = new int[]{width, height, armorOffset, armorAllNull ? 1 : 0};
        int[] params2 = new int[]{width, height, 0, armorAllNull ? 1 : 0};
        if (corner.name().contains("RIGHT")) {
            params2 = this.renderItem(current, params, 1);
            if (!armorAllNull) {
                this.renderArmor(boots, 1, params2, 2);
                this.renderArmor(leggings, 2, params2, 2);
                this.renderArmor(chestplate, 3, params2, 2);
                this.renderArmor(helmet, 4, params2, 2);
            }
        } else {
            boolean params2gotten = false;
            if (boots != null) {
                if (!params2gotten) {
                    params2 = this.renderArmor(boots, 1, params, 1);
                    params2gotten = true;
                } else {
                    this.renderArmor(boots, 1, params, 1);
                }
            }
            if (leggings != null) {
                if (!params2gotten) {
                    params2 = this.renderArmor(leggings, 2, params, 1);
                    params2gotten = true;
                } else {
                    this.renderArmor(leggings, 2, params, 1);
                }
            }
            if (chestplate != null) {
                if (!params2gotten) {
                    params2 = this.renderArmor(chestplate, 3, params, 1);
                    params2gotten = true;
                } else {
                    this.renderArmor(chestplate, 3, params, 1);
                }
            }
            if (helmet != null) {
                if (!params2gotten) {
                    params2 = this.renderArmor(helmet, 4, params, 1);
                    params2gotten = true;
                } else {
                    this.renderArmor(helmet, 4, params, 1);
                }
            }
            this.renderItem(current, params2, 2);
        }
        RenderHelper.func_74518_a();
    }

    private void renderItemAndEffectIntoGUI(ItemStack stack, int x, int y) {
        itemRender.func_180450_b(stack, x, y);
    }

    private int[] renderItem(ItemStack stack, int[] params, int turn) {
        int width = params[0];
        int height = params[1];
        boolean armorAllNull = params[3] == 1;
        int[] retStatement = new int[]{params[0], params[1], params[2], params[3]};
        if (stack != null && stack.func_77984_f()) {
            int x;
            int n = corner.name().contains("LEFT") ? params[2] - (armorAllNull ? offsetPosition : 0) : (x = width - 20);
            int y = corner.name().contains("TOP") ? (!armorAllNull ? 16 : 0) : (armorAllNull ? height - 16 : height - 48);
            int y2 = corner.name().contains("BOTTOM") ? y - 16 : y + 16;
            String damage = String.valueOf(stack.func_77958_k() - stack.func_77952_i());
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("InfiTool")) {
                damage = "";
            }
            int damageStringWidth = fontRenderer.func_78256_a(damage) + 2;
            this.renderItemAndEffectIntoGUI(stack, x - (corner.name().contains("LEFT") ? 0 : damageStringWidth - 2), y);
            if (stack.func_77973_b() instanceof ItemBow) {
                int arrows = this.getArrowsInInventory();
                if (arrows > 0) {
                    this.renderItemAndEffectIntoGUI(new ItemStack(Items.field_151032_g), x - (corner.name().contains("LEFT") ? 0 : damageStringWidth - 2), y2);
                    fontRenderer.func_78276_b(String.valueOf(arrows), corner.name().contains("RIGHT") ? x - damageStringWidth + 18 : x + 18, y2 + GuiItemDurability.fontRenderer.field_78288_b / 2, color_white);
                }
                fontRenderer.func_78276_b(String.valueOf(damage), corner.name().contains("RIGHT") ? x - damageStringWidth + 18 : x + 18, y + GuiItemDurability.fontRenderer.field_78288_b / 2, color_white);
            } else {
                fontRenderer.func_78276_b(String.valueOf(damage), corner.name().contains("RIGHT") ? x - damageStringWidth + 18 : x + 18, y + GuiItemDurability.fontRenderer.field_78288_b / 2, color_white);
            }
            retStatement[2] = damageStringWidth + 34;
            if (turn == 1 && armorAllNull) {
                GuiItemDurability.setCloseSize(18 + damageStringWidth);
            }
            if (turn == 2 && armorAllNull) {
                GuiItemDurability.setCloseSize(18 + damageStringWidth);
            }
            if (turn == 2 && !armorAllNull) {
                GuiItemDurability.setCloseSize(fontRenderer.func_78256_a("9999") + 36 + damageStringWidth);
            }
        }
        return retStatement;
    }

    private int[] renderArmor(ItemStack stack, int type, int[] params, int turn) {
        int width = params[0];
        int height = params[1];
        int armorOffset = params[2];
        int[] retStatement = new int[4];
        retStatement[0] = params[0];
        retStatement[1] = params[1];
        retStatement[3] = params[3];
        if (stack != null) {
            int damageStringWidth;
            int x = corner.name().contains("LEFT") ? 0 + (armorOffset - 16) - offsetPosition : width - armorOffset;
            int y = corner.name().contains("TOP") ? (4 - type) * 16 : height - 16 * type;
            String damage = String.valueOf(stack.func_77958_k() - stack.func_77952_i());
            int n = damageStringWidth = corner.name().contains("LEFT") ? Math.max(fontRenderer.func_78256_a(damage) + 2, fontRenderer.func_78256_a("9999") + 2) : fontRenderer.func_78256_a(damage) + 2;
            if (corner.name().contains("LEFT")) {
                x += damageStringWidth;
            }
            this.renderItemAndEffectIntoGUI(stack, x, y);
            fontRenderer.func_78276_b(String.valueOf(damage), x - (corner.name().contains("LEFT") ? damageStringWidth - 2 : damageStringWidth), y + GuiItemDurability.fontRenderer.field_78288_b / 2, color_white);
            retStatement[2] = x + 18;
            if (turn == 2) {
                GuiItemDurability.setCloseSize(16 + damageStringWidth + armorOffset);
            }
        }
        return retStatement;
    }

    static {
        guiState = EnumGuiState.OPEN;
        corner = EnumCorner.BOTTOM_RIGHT;
        offsetPosition = 0;
        closeSize = 16;
        color_white = Color.WHITE.getRGB();
    }
}

